/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.asmdex.encodedValue;

import org.ow2.asmdex.encodedValue.EncodedValue;
import org.ow2.asmdex.encodedValue.EncodedValueUtil;
import org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueInteger
extends EncodedValue {
    private int type = 4;
    private int value;

    public EncodedValueInteger(int value) {
        this.value = value;
    }

    public EncodedValueInteger(Object value) {
        this.value = (Integer)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        return EncodedValueUtil.encodeSignedValue(this.value, this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueInteger) {
            EncodedValueInteger encodedValue = (EncodedValueInteger)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + this.value * 321;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueInteger ei = (EncodedValueInteger)encodedValue;
        int value2 = ei.value;
        return this.value == value2 ? 0 : (this.value > value2 ? 1 : -1);
    }
}

