/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex.tree;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.structureCommon.Label;
import org.ow2.asmdex.tree.AbstractInsnNode;
import org.ow2.asmdex.tree.InsnList;
import org.ow2.asmdex.tree.InsnNode;
import org.ow2.asmdex.tree.LabelNode;

public class InsnListUnitTest
extends TestCase {
    InsnList l1;
    InsnList l2;
    InsnNode in1;
    InsnNode in2;

    protected void setUp() throws Exception {
        super.setUp();
        InsnList.setCheck(true);
        this.l1 = new InsnList();
        this.l2 = new InsnList();
        this.in1 = new InsnNode(0);
        this.in2 = new InsnNode(0);
        this.l2.add(this.in1);
        this.l2.add(this.in2);
    }

    protected void assertEquals(AbstractInsnNode[] expected, AbstractInsnNode[] value) {
        InsnListUnitTest.assertEquals((int)expected.length, (int)value.length);
        int i = 0;
        while (i < value.length) {
            InsnListUnitTest.assertEquals((Object)expected[i], (Object)value[i]);
            ++i;
        }
    }

    public void testSize() {
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.size());
    }

    public void testGetFirst() {
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getFirst());
    }

    public void testGetLast() {
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getLast());
    }

    public void testInvalidGet() {
        try {
            this.l1.get(0);
            InsnListUnitTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testContains() {
        InsnListUnitTest.assertEquals((boolean)false, (boolean)this.l1.contains(new InsnNode(0)));
    }

    public void testIterator() {
        InsnNode insn = new InsnNode(0);
        ListIterator<AbstractInsnNode> it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.next());
        InsnListUnitTest.assertFalse((boolean)it.hasNext());
        InsnListUnitTest.assertTrue((boolean)it.hasPrevious());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.previous());
        InsnListUnitTest.assertTrue((boolean)it.hasPrevious());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.previous());
        InsnListUnitTest.assertFalse((boolean)it.hasPrevious());
        this.l2.add(insn);
        it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        it.remove();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)insn, (Object)it.next());
        InsnListUnitTest.assertFalse((boolean)it.hasNext());
        InsnListUnitTest.assertTrue((boolean)it.hasPrevious());
        it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)insn, (Object)it.next());
        InsnListUnitTest.assertFalse((boolean)it.hasNext());
        this.l2.remove(insn);
        this.l2.insert((AbstractInsnNode)this.in1, this.in2);
        it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        it.add(insn);
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.next());
        this.l2.remove(insn);
        it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        it.add(insn);
        InsnListUnitTest.assertEquals((Object)insn, (Object)it.previous());
        InsnListUnitTest.assertEquals((Object)insn, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.next());
        InsnListUnitTest.assertFalse((boolean)it.hasNext());
        this.l2.remove(insn);
        it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        it.set(insn);
        InsnListUnitTest.assertEquals((Object)insn, (Object)it.previous());
        InsnListUnitTest.assertEquals((Object)insn, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        this.l2.remove(insn);
        this.l2.insertBefore((AbstractInsnNode)this.in2, this.in1);
        it = this.l2.iterator();
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        it.set(insn);
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.next());
    }

    public void testIterator2() {
        ListIterator<AbstractInsnNode> it = this.l2.iterator(this.l2.size());
        InsnListUnitTest.assertFalse((boolean)it.hasNext());
        InsnListUnitTest.assertTrue((boolean)it.hasPrevious());
        InsnListUnitTest.assertEquals((int)1, (int)it.previousIndex());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.previous());
        InsnListUnitTest.assertTrue((boolean)it.hasPrevious());
        InsnListUnitTest.assertEquals((int)0, (int)it.previousIndex());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.previous());
        InsnListUnitTest.assertFalse((boolean)it.hasPrevious());
        InsnListUnitTest.assertEquals((int)-1, (int)it.previousIndex());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((int)0, (int)it.nextIndex());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)it.next());
        InsnListUnitTest.assertTrue((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((int)1, (int)it.nextIndex());
        InsnNode insn = new InsnNode(0);
        it.add(insn);
        InsnListUnitTest.assertEquals((int)2, (int)it.nextIndex());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)it.next());
        InsnListUnitTest.assertFalse((boolean)it.hasNext());
        InsnListUnitTest.assertEquals((int)3, (int)it.nextIndex());
    }

    public void testIterator3() {
        try {
            new InsnList().iterator().next();
            InsnListUnitTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testInvalidIndexOf() {
        try {
            this.l1.indexOf(new InsnNode(0));
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToArray() {
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.toArray().length);
    }

    public void testInvalidSet() {
        try {
            this.l1.set(new InsnNode(0), new InsnNode(0));
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSet() {
        this.l1.add(new InsnNode(0));
        InsnNode insn = new InsnNode(0);
        this.l1.set(this.l1.getFirst(), insn);
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        this.l1.remove(insn);
        this.l1.add(new InsnNode(0));
        this.l1.set(this.l1.get(0), insn);
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        this.l1.remove(insn);
        this.l1.add(new InsnNode(0));
        this.l1.add(new InsnNode(0));
        this.l1.set(this.l1.get(1), insn);
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(1));
    }

    public void testInvalidAdd() {
        try {
            this.l1.add(this.in1);
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddEmpty() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{insn}, this.l1.toArray());
        InsnListUnitTest.assertEquals(null, (Object)insn.getPrevious());
        InsnListUnitTest.assertEquals(null, (Object)insn.getNext());
    }

    public void testAddNonEmpty() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(new InsnNode(0));
        this.l1.add(insn);
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(insn));
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
    }

    public void testAddEmptyList() {
        this.l1.add(new InsnList());
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.size());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getLast());
        this.assertEquals(new AbstractInsnNode[0], this.l1.toArray());
    }

    public void testInvalidAddAll() {
        try {
            this.l1.add(this.l1);
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAllEmpty() {
        this.l1.add(this.l2);
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in2));
        this.assertEquals(new AbstractInsnNode[]{this.in1, this.in2}, this.l1.toArray());
    }

    public void testAddAllNonEmpty() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.add(this.l2);
        InsnListUnitTest.assertEquals((int)3, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(insn));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.indexOf(this.in2));
        this.assertEquals(new AbstractInsnNode[]{insn, this.in1, this.in2}, this.l1.toArray());
    }

    public void testInvalidInsert() {
        try {
            this.l1.insert(this.in1);
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInsertEmpty() {
        InsnNode insn = new InsnNode(0);
        this.l1.insert(insn);
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{insn}, this.l1.toArray());
    }

    public void testInsertNonEmpty() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(new InsnNode(0));
        this.l1.insert(insn);
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(insn));
    }

    public void testInvalidInsertAll() {
        try {
            this.l1.insert(this.l1);
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInsertAllEmptyList() {
        this.l1.insert(new InsnList());
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.size());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getLast());
        this.assertEquals(new AbstractInsnNode[0], this.l1.toArray());
    }

    public void testInsertAllEmpty() {
        this.l1.insert(this.l2);
        InsnListUnitTest.assertEquals((float)2.0f, (float)this.l1.size(), (float)2.0f);
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in2));
        this.assertEquals(new AbstractInsnNode[]{this.in1, this.in2}, this.l1.toArray());
    }

    public void testInsertAllNonEmpty() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.insert(this.l2);
        InsnListUnitTest.assertEquals((int)3, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in2));
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{this.in1, this.in2, insn}, this.l1.toArray());
    }

    public void testInvalidInsert2() {
        try {
            this.l1.insert((AbstractInsnNode)new InsnNode(0), new InsnNode(0));
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInsert2NotLast() {
        InsnNode insn = new InsnNode(0);
        this.l2.insert((AbstractInsnNode)this.in1, insn);
        InsnListUnitTest.assertEquals((int)3, (int)this.l2.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l2.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l2.getLast());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l2.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l2.contains(insn));
        InsnListUnitTest.assertEquals((int)1, (int)this.l2.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{this.in1, insn, this.in2}, this.l2.toArray());
    }

    public void testInsert2Last() {
        InsnNode insn = new InsnNode(0);
        this.l2.insert((AbstractInsnNode)this.in2, insn);
        InsnListUnitTest.assertEquals((int)3, (int)this.l2.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l2.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l2.getLast());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l2.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l2.contains(insn));
        InsnListUnitTest.assertEquals((int)2, (int)this.l2.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{this.in1, this.in2, insn}, this.l2.toArray());
    }

    public void testInsertBefore() {
        InsnNode insn = new InsnNode(0);
        this.l2.insertBefore((AbstractInsnNode)this.in2, insn);
        InsnListUnitTest.assertEquals((int)3, (int)this.l2.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l2.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l2.getLast());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l2.get(1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l2.contains(insn));
        InsnListUnitTest.assertEquals((int)1, (int)this.l2.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{this.in1, insn, this.in2}, this.l2.toArray());
    }

    public void testInsertBeforeFirst() {
        InsnNode insn = new InsnNode(0);
        this.l2.insertBefore((AbstractInsnNode)this.in1, insn);
        InsnListUnitTest.assertEquals((int)3, (int)this.l2.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l2.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l2.getLast());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l2.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l2.contains(insn));
        InsnListUnitTest.assertEquals((int)0, (int)this.l2.indexOf(insn));
        this.assertEquals(new AbstractInsnNode[]{insn, this.in1, this.in2}, this.l2.toArray());
    }

    public void testInvalidInsertBefore() {
        try {
            this.l1.insertBefore((AbstractInsnNode)new InsnNode(0), new InsnNode(0));
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidInsertAll2() {
        try {
            this.l1.insert((AbstractInsnNode)new InsnNode(0), new InsnList());
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInsertAll2EmptyList() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.insert((AbstractInsnNode)insn, new InsnList());
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        this.assertEquals(new AbstractInsnNode[]{insn}, this.l1.toArray());
    }

    public void testInsertAll2NotLast() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.add(new InsnNode(0));
        this.l1.insert((AbstractInsnNode)insn, this.l2);
        InsnListUnitTest.assertEquals((int)4, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(insn));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.indexOf(this.in2));
    }

    public void testInsertAll2Last() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.insert((AbstractInsnNode)insn, this.l2);
        InsnListUnitTest.assertEquals((int)3, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(insn));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.indexOf(this.in2));
        this.assertEquals(new AbstractInsnNode[]{insn, this.in1, this.in2}, this.l1.toArray());
    }

    public void testInvalidInsertBeforeAll() {
        try {
            this.l1.insertBefore((AbstractInsnNode)new InsnNode(0), new InsnList());
            InsnListUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInsertBeforeAll2EmptyList() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.insertBefore((AbstractInsnNode)insn, new InsnList());
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        this.assertEquals(new AbstractInsnNode[]{insn}, this.l1.toArray());
    }

    public void testInsertBeforeAll2NotLast() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(new InsnNode(0));
        this.l1.add(insn);
        this.l1.insertBefore((AbstractInsnNode)insn, this.l2);
        InsnListUnitTest.assertEquals((int)4, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.get(1));
        InsnListUnitTest.assertEquals((Object)this.in2, (Object)this.l1.get(2));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)3, (int)this.l1.indexOf(insn));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.indexOf(this.in2));
    }

    public void testInsertBeforeAll2First() {
        InsnNode insn = new InsnNode(0);
        this.l1.insert(insn);
        this.l1.insertBefore((AbstractInsnNode)insn, this.l2);
        InsnListUnitTest.assertEquals((int)3, (int)this.l1.size());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals((Object)insn, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((Object)this.in1, (Object)this.l1.get(0));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in1));
        InsnListUnitTest.assertEquals((boolean)true, (boolean)this.l1.contains(this.in2));
        InsnListUnitTest.assertEquals((int)2, (int)this.l1.indexOf(insn));
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.indexOf(this.in1));
        InsnListUnitTest.assertEquals((int)1, (int)this.l1.indexOf(this.in2));
        this.assertEquals(new AbstractInsnNode[]{this.in1, this.in2, insn}, this.l1.toArray());
    }

    public void testInvalidRemove() {
        try {
            this.l1.remove(new InsnNode(0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveSingle() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.remove(insn);
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.size());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((boolean)false, (boolean)this.l1.contains(insn));
        this.assertEquals(new AbstractInsnNode[0], this.l1.toArray());
        InsnListUnitTest.assertEquals(null, (Object)insn.getPrevious());
        InsnListUnitTest.assertEquals(null, (Object)insn.getNext());
    }

    public void testRemoveFirst() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(insn);
        this.l1.add(new InsnNode(0));
        this.l1.remove(insn);
        InsnListUnitTest.assertEquals((boolean)false, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals(null, (Object)insn.getPrevious());
        InsnListUnitTest.assertEquals(null, (Object)insn.getNext());
    }

    public void testRemoveMiddle() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(new InsnNode(0));
        this.l1.add(insn);
        this.l1.add(new InsnNode(0));
        this.l1.remove(insn);
        InsnListUnitTest.assertEquals((boolean)false, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals(null, (Object)insn.getPrevious());
        InsnListUnitTest.assertEquals(null, (Object)insn.getNext());
    }

    public void testRemoveLast() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(new InsnNode(0));
        this.l1.add(insn);
        this.l1.remove(insn);
        InsnListUnitTest.assertEquals((boolean)false, (boolean)this.l1.contains(insn));
        InsnListUnitTest.assertEquals(null, (Object)insn.getPrevious());
        InsnListUnitTest.assertEquals(null, (Object)insn.getNext());
    }

    public void testClear() {
        InsnNode insn = new InsnNode(0);
        this.l1.add(new InsnNode(0));
        this.l1.add(insn);
        this.l1.add(new InsnNode(0));
        this.l1.clear();
        InsnListUnitTest.assertEquals((int)0, (int)this.l1.size());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getFirst());
        InsnListUnitTest.assertEquals(null, (Object)this.l1.getLast());
        InsnListUnitTest.assertEquals((boolean)false, (boolean)this.l1.contains(insn));
        this.assertEquals(new AbstractInsnNode[0], this.l1.toArray());
        InsnListUnitTest.assertEquals(null, (Object)insn.getPrevious());
        InsnListUnitTest.assertEquals(null, (Object)insn.getNext());
    }

    public void testAcceptor1() {
        this.l1.add(new InsnNode(55));
        this.l1.add(new InsnNode(77));
        final InsnList lst = new InsnList();
        this.l1.accept(new MethodVisitor(262144){

            @Override
            public void visitInsn(int opcode) {
                lst.add(new InsnNode(opcode));
            }
        });
        InsnListUnitTest.assertEquals((int)55, (int)lst.get(0).getOpcode());
        InsnListUnitTest.assertEquals((int)77, (int)lst.get(1).getOpcode());
    }

    public void testResetLabels() throws Exception {
        LabelNode labelNode = new LabelNode();
        this.l1.add(new InsnNode(55));
        this.l1.add(labelNode);
        this.l1.add(new InsnNode(55));
        Label label = labelNode.getLabel();
        InsnListUnitTest.assertNotNull((Object)label);
        this.l1.resetLabels();
        InsnListUnitTest.assertNotSame((Object)label, (Object)labelNode.getLabel());
    }
}

