/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex.structureCommon;

import org.junit.Assert;
import org.junit.Test;
import org.ow2.asmdex.ApplicationWriter;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.instruction.InstructionFormat10X;
import org.ow2.asmdex.structureCommon.Label;

public class LabelTest {
    @Test
    public void testGetOffset() {
        Label l = new Label();
        ApplicationWriter aw = new ApplicationWriter();
        ClassVisitor cv = aw.visitClass(1, "TestClass", null, null, null);
        MethodVisitor mv = cv.visitMethod(1, "testMethod", "V", null, null);
        mv.visitCode();
        mv.visitLabel(l);
        Assert.assertEquals((long)0L, (long)l.getOffset());
    }

    @Test
    public void testGetOffsetAfterOneInstruction() {
        Label l = new Label();
        ApplicationWriter aw = new ApplicationWriter();
        ClassVisitor cv = aw.visitClass(1, "TestClass", null, null, null);
        MethodVisitor mv = cv.visitMethod(1, "testMethod", "V", null, null);
        mv.visitCode();
        mv.visitInsn(14);
        mv.visitLabel(l);
        Assert.assertEquals((long)2L, (long)l.getOffset());
    }

    @Test
    public void testSetOffset() {
        Label l = new Label();
        int offset = 142;
        l.setOffset(offset);
        Assert.assertEquals((long)offset, (long)l.getOffset());
    }

    @Test
    public void testGetLine() {
        Label l = new Label();
        Assert.assertEquals((long)0L, (long)l.getLine());
    }

    @Test
    public void testSetLine() {
        Label l = new Label();
        int line = 189;
        l.setLine(line);
        Assert.assertEquals((long)line, (long)l.getLine());
    }

    @Test
    public void testReferringInstructionsEmpty() {
        Label l = new Label();
        Assert.assertEquals((long)0L, (long)l.getReferringInstructions().size());
    }

    @Test
    public void testAddReferringInstructions() {
        Label l = new Label();
        InstructionFormat10X i1 = new InstructionFormat10X(0);
        InstructionFormat10X i2 = new InstructionFormat10X(14);
        l.addReferringInstruction(i1);
        l.addReferringInstruction(i2);
        Assert.assertEquals((long)2L, (long)l.getReferringInstructions().size());
    }

    @Test(expected=IllegalStateException.class)
    public void testIllegalGetOffsetState() {
        Label l = new Label();
        l.getOffset();
    }
}

