/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.IOException;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationVisitor;
import org.ow2.asmdex.ApplicationWriter;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.MethodVisitor;
import org.ow2.asmdex.tree.ApplicationNode;

public class GenPerfTest {
    static final int NB_TESTS = 5;
    static final int NB_ITERATIONS_HIGH = 100000;
    static final int NB_ITERATIONS_NORMAL = 10000;
    static final int NB_ITERATIONS_SMALL = 1000;
    static final int NB_ITERATIONS_SMALLER = 100;
    private static final String testFilename = "test/case/skipLineNumbers/apiDemos.dex";

    public static void main(String[] args) throws IOException {
        GenPerfTest.asmDexTestReaderOnly(50);
        GenPerfTest.asmDexTestWriterOnly(50);
        GenPerfTest.asmDexTestReaderWriter();
        GenPerfTest.asmDexTestReaderWriterTree();
        GenPerfTest.asmDexTestReaderWriterShortCut();
        GenPerfTest.asmDexTestReaderWriterLoop(50);
    }

    public static void asmDexTestReaderOnly(int nbClasses) {
        byte[] bytes = GenPerfTest.generateLittleApplication(nbClasses);
        int nbIterations = 100000;
        int nbTests = 0;
        while (nbTests < 5) {
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < nbIterations) {
                ApplicationReader ar = new ApplicationReader(262144, bytes);
                ApplicationVisitor av = new ApplicationVisitor(262144){};
                ar.accept(av, 0);
                ++i;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("AsmDex Reader Only generation time: " + (float)t / (float)nbIterations / (float)nbClasses + " ms/class");
            ++nbTests;
        }
    }

    public static void asmDexTestWriterOnly(int nbClasses) {
        int nbIterations = 10000;
        int nbTests = 0;
        while (nbTests < 5) {
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < nbIterations) {
                GenPerfTest.generateLittleApplication(nbClasses);
                ++i;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("AsmDex Writer Only generation time: " + (float)t / (float)nbIterations / (float)nbClasses + " ms/class");
            ++nbTests;
        }
    }

    public static void asmDexTestReaderWriter() throws IOException {
        int nbIterations = 100;
        int nbTests = 0;
        while (nbTests < 5) {
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < nbIterations) {
                GenPerfTest.asmDexTestReaderWriterPerform();
                ++i;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("AsmDex Reader/Writer generation time: " + (float)t / (float)nbIterations + " ms/application");
            ++nbTests;
        }
    }

    public static void asmDexTestReaderWriterTree() throws IOException {
        int nbIterations = 100;
        int nbTests = 0;
        while (nbTests < 5) {
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < nbIterations) {
                GenPerfTest.asmDexTestReaderWriterTreePerform();
                ++i;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("AsmDex Reader/Writer Tree generation time: " + (float)t / (float)nbIterations + " ms/application");
            ++nbTests;
        }
    }

    public static void asmDexTestReaderWriterShortCut() throws IOException {
        int nbIterations = 100;
        int nbTests = 0;
        while (nbTests < 5) {
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < nbIterations) {
                GenPerfTest.asmDexTestReaderWriterShortCutPerform();
                ++i;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("AsmDex Reader/Writer with ShortCut generation time: " + (float)t / (float)nbIterations + " ms/application");
            ++nbTests;
        }
    }

    public static void asmDexTestReaderWriterLoop(int nbClasses) throws IOException {
        int nbIterations = 10000;
        int nbTests = 0;
        while (nbTests < 5) {
            byte[] bytes = GenPerfTest.generateLittleApplication(nbClasses);
            long t = System.currentTimeMillis();
            int i = 0;
            while (i < nbIterations) {
                ApplicationReader ar = new ApplicationReader(262144, bytes);
                ApplicationWriter aw = new ApplicationWriter();
                ar.accept(aw, 0);
                bytes = aw.toByteArray();
                ++i;
            }
            t = System.currentTimeMillis() - t;
            System.out.println("AsmDex Reader/Writer in Loop with " + nbClasses + " classe(s) generation time: " + (float)t / (float)nbIterations / (float)nbClasses + " ms/class");
            ++nbTests;
        }
    }

    private static byte[] generateLittleApplication(int nbClasses) {
        ApplicationWriter aw = new ApplicationWriter();
        aw.visit();
        int i = 0;
        while (i < nbClasses) {
            ClassVisitor cv = aw.visitClass(1, "HelloWorld" + i, null, "Ljava/lang/Object;", null);
            cv.visit(0, 1, "HelloWorld" + i, null, "Ljava/lang/Object;", null);
            cv.visitSource("HelloWorld.java", null);
            MethodVisitor mv = cv.visitMethod(1, "<init>", "V", null, null);
            mv.visitVarInsn(1, 0, 0);
            mv.visitMethodInsn(112, "Ljava/lang/Object;", "<init>", "V", new int[0]);
            mv.visitInsn(14);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cv.visitMethod(9, "main", "V[Ljava/lang/String;", null, null);
            mv.visitFieldInsn(96, "Ljava/lang/System;", "out", "Ljava/io/PrintStream;", 0, 0);
            mv.visitStringInsn(26, 0, "Hello world!");
            mv.visitMethodInsn(110, "Ljava/io/PrintStream;", "println", "VLjava/lang/String;", new int[0]);
            mv.visitInsn(14);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cv.visitEnd();
            ++i;
        }
        aw.visitEnd();
        return aw.toByteArray();
    }

    private static byte[] asmDexTestReaderWriterPerform() throws IOException {
        ApplicationReader ar = new ApplicationReader(262144, testFilename);
        ApplicationWriter aw = new ApplicationWriter();
        ar.accept(aw, 0);
        return aw.toByteArray();
    }

    private static byte[] asmDexTestReaderWriterTreePerform() throws IOException {
        ApplicationReader ar = new ApplicationReader(262144, testFilename);
        ApplicationNode an = new ApplicationNode(262144);
        ar.accept(an, 0);
        ApplicationWriter aw = new ApplicationWriter();
        an.accept(aw);
        return aw.toByteArray();
    }

    private static byte[] asmDexTestReaderWriterShortCutPerform() throws IOException {
        ApplicationReader ar = new ApplicationReader(262144, testFilename);
        ApplicationWriter aw = new ApplicationWriter(ar);
        ar.accept(aw, 0);
        return aw.toByteArray();
    }
}

