/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asmdex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.objectweb.asmdex.TestUtil;
import org.objectweb.asmdex.applicationReaderTest.ApplicationTestVisitor;
import org.objectweb.asmdex.applicationReaderTest.LogListAllInstructions;
import org.objectweb.asmdex.applicationReaderTest.LogListAnnotationTests;
import org.objectweb.asmdex.applicationReaderTest.LogListExceptions;
import org.objectweb.asmdex.applicationReaderTest.LogListHelloWorld;
import org.objectweb.asmdex.logging.LogList;
import org.objectweb.asmdex.logging.Logger;
import org.ow2.asmdex.ApplicationReader;

public class ApplicationReaderTest {
    private File file;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test(expected=IOException.class)
    public void testIllegalConstructorArgument() throws IOException {
        new ApplicationReader(262144, null);
    }

    @Test
    public void testApplicationReaderByteArray() throws IOException {
        byte[] bytes = TestUtil.readFile("test/case/full/helloWorld.dex");
        if (bytes == null) {
            throw new IOException("Test file not found");
        }
        new ApplicationReader(262144, bytes);
    }

    @Test
    public void testApplicationReaderByteArrayIntInt() throws IOException {
        byte[] bytes = null;
        bytes = TestUtil.readFile("test/case/full/helloWorld.dex");
        if (bytes == null) {
            throw new IOException("Test file not found");
        }
        new ApplicationReader(262144, bytes, 0, bytes.length);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testApplicationReaderByteArrayIntIntFail() throws IOException {
        byte[] bytes = null;
        bytes = TestUtil.readFile("test/case/full/helloWorld.dex");
        if (bytes == null) {
            throw new IOException("Test file not found");
        }
        new ApplicationReader(262144, bytes, 0, bytes.length - 1);
    }

    @Test
    public void testApplicationReaderInputStream() throws IOException {
        this.file = new File("test/case/full/helloWorld.dex");
        FileInputStream is = new FileInputStream(this.file);
        new ApplicationReader(262144, is);
    }

    @Test
    public void testApplicationReaderString() throws IOException {
        FileInputStream is = new FileInputStream("test/case/full/helloWorld.dex");
        new ApplicationReader(262144, is);
    }

    @Test
    public void testApplicationReaderHelloWorld() throws IOException {
        this.testApplicationReader(new LogListHelloWorld());
    }

    @Test
    public void testApplicationReaderAnnotationTests() throws IOException {
        this.testApplicationReader(new LogListAnnotationTests());
    }

    @Test
    public void testApplicationReaderAllInstructions() throws IOException {
        this.testApplicationReader(new LogListAllInstructions());
    }

    @Test
    public void testApplicationReaderExceptions() throws IOException {
        this.testApplicationReader(new LogListExceptions());
    }

    private void testApplicationReader(LogList logList) throws IOException {
        Logger logger = new Logger(logList);
        FileInputStream is = new FileInputStream(logList.getDexFile());
        ApplicationTestVisitor av = new ApplicationTestVisitor(logger);
        ApplicationReader ar = new ApplicationReader(262144, is);
        ar.accept(av, logList.getClassesToParse(), 0);
        logger.logEnd();
    }
}

