/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

import java.io.IOException;
import java.nio.ByteBuffer;
import nl.lxtreme.binutils.elf.ElfClass;
import nl.lxtreme.binutils.elf.SegmentType;

public class ProgramHeader {
    public final SegmentType type;
    public final long flags;
    public final long offset;
    public final long virtualAddress;
    public final long physicalAddress;
    public final long segmentFileSize;
    public final long segmentMemorySize;
    public final long segmentAlignment;

    public ProgramHeader(ElfClass elfClass, ByteBuffer byteBuffer) throws IOException {
        switch (elfClass) {
            case CLASS_32: {
                this.type = SegmentType.valueOf(byteBuffer.getInt() & 0xFFFFFFFF);
                this.offset = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.virtualAddress = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.physicalAddress = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.segmentFileSize = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.segmentMemorySize = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.flags = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.segmentAlignment = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                break;
            }
            case CLASS_64: {
                this.type = SegmentType.valueOf(byteBuffer.getInt() & 0xFFFFFFFF);
                this.flags = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.offset = byteBuffer.getLong();
                this.virtualAddress = byteBuffer.getLong();
                this.physicalAddress = byteBuffer.getLong();
                this.segmentFileSize = byteBuffer.getLong();
                this.segmentMemorySize = byteBuffer.getLong();
                this.segmentAlignment = byteBuffer.getLong();
                break;
            }
            default: {
                throw new IOException("Unhandled ELF-class!");
            }
        }
    }
}

