/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import nl.lxtreme.binutils.elf.AbiType;
import nl.lxtreme.binutils.elf.Elf;
import nl.lxtreme.binutils.elf.ElfClass;
import nl.lxtreme.binutils.elf.MachineType;
import nl.lxtreme.binutils.elf.ObjectFileType;

public class Header {
    private static final int EI_NIDENT = 16;
    public final ElfClass elfClass;
    public final ByteOrder elfByteOrder;
    public final AbiType abiType;
    public final int abiVersion;
    public final ObjectFileType elfType;
    public final MachineType machineType;
    public final int elfVersion;
    public final long entryPoint;
    public final int flags;
    public final long programHeaderOffset;
    public final long sectionHeaderOffset;

    public Header(ReadableByteChannel readableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.clear();
        byteBuffer.limit(16);
        Elf.readFully(readableByteChannel, byteBuffer, "Excepted a valid ELF header!");
        byte[] byArray = byteBuffer.array();
        if (byArray[0] != 127 || byArray[1] != 69 || byArray[2] != 76 || byArray[3] != 70) {
            throw new IOException("Unknown file format! Expected valid ELF header (EI_MAG0..3)!");
        }
        int n = Elf.expectByteInRange(byArray[4], 1, 2, "Invalid ELF file! Invalid ELF class (EI_CLASS)!");
        this.elfClass = ElfClass.values()[n - 1];
        int n2 = Elf.expectByteInRange(byArray[5], 1, 2, "Invalid ELF file! Unknown byte order (EI_DATA)!");
        this.elfByteOrder = n2 == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        Elf.expectByteInRange(byArray[6], 1, 1, "Invalid ELF file! Unknown file version (EI_VERSION)!");
        this.abiType = AbiType.valueOf(byArray[7]);
        this.abiVersion = byArray[8];
        byteBuffer.clear();
        byteBuffer.limit(8);
        byteBuffer.order(this.elfByteOrder);
        Elf.readFully(readableByteChannel, byteBuffer, "Failed to read ELF type, machine and version!");
        this.elfType = ObjectFileType.valueOf(byteBuffer.getShort());
        this.machineType = MachineType.valueOf(byteBuffer.getShort());
        this.elfVersion = byteBuffer.getInt();
        byteBuffer.clear();
        switch (this.elfClass) {
            case CLASS_32: {
                byteBuffer.limit(12);
                Elf.readFully(readableByteChannel, byteBuffer, "Failed to read ELF entry point and offsets!");
                this.entryPoint = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.programHeaderOffset = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                this.sectionHeaderOffset = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                break;
            }
            case CLASS_64: {
                byteBuffer.limit(24);
                Elf.readFully(readableByteChannel, byteBuffer, "Failed to read ELF entry point and offsets!");
                this.entryPoint = byteBuffer.getLong();
                this.programHeaderOffset = byteBuffer.getLong();
                this.sectionHeaderOffset = byteBuffer.getLong();
                break;
            }
            default: {
                throw new IOException("Unhandled ELF-class!");
            }
        }
        byteBuffer.clear();
        byteBuffer.limit(6);
        Elf.readFully(readableByteChannel, byteBuffer, "Failed to read ELF flags and size information!");
        this.flags = byteBuffer.getInt();
        short s = byteBuffer.getShort();
        if (this.programHeaderOffset != 0L && (long)s != this.programHeaderOffset) {
            throw new IOException("Header size and program header do not match?!");
        }
    }

    public boolean is32bit() {
        return this.elfClass == ElfClass.CLASS_32;
    }

    public boolean is64bit() {
        return this.elfClass == ElfClass.CLASS_64;
    }

    public boolean isBigEndian() {
        return this.elfByteOrder == ByteOrder.BIG_ENDIAN;
    }

    public boolean isLittleEndian() {
        return this.elfByteOrder == ByteOrder.LITTLE_ENDIAN;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ELF ");
        switch (this.elfClass) {
            case CLASS_32: {
                stringBuilder.append("32");
                break;
            }
            case CLASS_64: {
                stringBuilder.append("64");
            }
        }
        stringBuilder.append("-bit ");
        if (this.isLittleEndian()) {
            stringBuilder.append("LSB ");
        } else {
            stringBuilder.append("MSB ");
        }
        stringBuilder.append(this.elfType).append(", ").append((Object)this.machineType);
        switch (this.machineType) {
            case ARM: {
                if ((this.flags & 0x5000000) == 0x5000000) {
                    stringBuilder.append(" EABIv5");
                    break;
                }
                if ((this.flags & 0x4000000) == 0x4000000) {
                    stringBuilder.append(" EABIv4");
                    break;
                }
                if ((this.flags & 0x3000000) == 0x3000000) {
                    stringBuilder.append(" EABIv3");
                    break;
                }
                if ((this.flags & 0x2000000) == 0x2000000) {
                    stringBuilder.append(" EABIv2");
                    break;
                }
                if ((this.flags & 0x1000000) == 0x1000000) {
                    stringBuilder.append(" EABIv1");
                    break;
                }
                if ((this.flags & 0) != 0) break;
                stringBuilder.append(" unknown EABI");
                break;
            }
        }
        stringBuilder.append(" version ");
        stringBuilder.append(this.elfVersion).append(" (").append((Object)this.abiType).append(")\n");
        stringBuilder.append("Using entry point = 0x").append(Long.toHexString(this.entryPoint));
        switch (this.machineType) {
            case ARM: {
                if (Elf.isBitSet(this.flags, 1)) {
                    stringBuilder.append(", relocatable executable");
                }
                if (Elf.isBitSet(this.flags, 2)) {
                    stringBuilder.append(", has entry point");
                }
                if (Elf.isBitSet(this.flags, 4)) {
                    stringBuilder.append(", interworking enabled");
                }
                if (Elf.isBitSet(this.flags, 8)) {
                    stringBuilder.append(", APCS-26");
                } else {
                    stringBuilder.append(", APCS-32");
                }
                if (Elf.isBitSet(this.flags, 16)) {
                    stringBuilder.append(", using float registers");
                } else {
                    stringBuilder.append(", using integer registers");
                }
                if (Elf.isBitSet(this.flags, 32)) {
                    stringBuilder.append(", position independent");
                }
                if (Elf.isBitSet(this.flags, 64)) {
                    stringBuilder.append(", 8-bit structure alignment");
                }
                if (Elf.isBitSet(this.flags, 128)) {
                    stringBuilder.append(", new ABI");
                }
                if (Elf.isBitSet(this.flags, 256)) {
                    stringBuilder.append(", old ABI");
                }
                if (Elf.isBitSet(this.flags, 512)) {
                    stringBuilder.append(", using software FP");
                }
                if (Elf.isBitSet(this.flags, 1024)) {
                    stringBuilder.append(", using VFP FP");
                }
                if (!Elf.isBitSet(this.flags, 2048)) break;
                stringBuilder.append(", using maverick FP");
                break;
            }
            default: {
                if (this.flags == 0) break;
                stringBuilder.append("0x").append(Integer.toHexString(this.flags));
            }
        }
        return stringBuilder.toString();
    }
}

