/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.coff;

import java.io.IOException;
import java.nio.ByteBuffer;
import nl.lxtreme.binutils.coff.SectionType;

public class SectionHeader {
    public static final int FLAG_REG = 0;
    public static final int FLAG_DSECT = 1;
    public static final int FLAG_NOLOAD = 2;
    public static final int FLAG_GROUP = 4;
    public static final int FLAG_PAD = 8;
    public static final int FLAG_COPY = 16;
    public static final int FLAG_TEXT = 32;
    public static final int FLAG_DATA = 64;
    public static final int FLAG_BSS = 128;
    public static final int FLAG_INFO = 512;
    public static final int FLAG_OVER = 1024;
    public static final int FLAG_LIB = 2048;
    public final SectionType type;
    public final int physicalAddress;
    public final int virtualAddress;
    public final int size;
    public final int dataOffset;
    public final int relocTableOffset;
    public final int relocTableSize;
    public final int lineNumberOffset;
    public final int lineNumberSize;
    public final int flags;

    public SectionHeader(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[8];
        byteBuffer.get(byArray);
        this.type = SectionType.valueOf(byArray);
        this.physicalAddress = byteBuffer.getInt();
        this.virtualAddress = byteBuffer.getInt();
        this.size = byteBuffer.getInt();
        this.dataOffset = byteBuffer.getInt();
        this.relocTableOffset = byteBuffer.getInt();
        this.lineNumberOffset = byteBuffer.getInt();
        this.relocTableSize = byteBuffer.getShort();
        this.lineNumberSize = byteBuffer.getShort();
        this.flags = byteBuffer.getInt();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type);
        stringBuilder.append(", size = ").append(this.size);
        if (this.physicalAddress != this.virtualAddress) {
            stringBuilder.append(", address (p/v) = 0x").append(Integer.toHexString(this.physicalAddress)).append("/0x").append(Integer.toHexString(this.virtualAddress));
        } else {
            stringBuilder.append(", address = 0x").append(Integer.toHexString(this.physicalAddress));
        }
        stringBuilder.append(", flags = ").append(this.flags);
        return stringBuilder.toString();
    }
}

