/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.ar;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import nl.lxtreme.binutils.ar.AREntry;

public class AR {
    private final String path;
    private RandomAccessFile efile;
    private long stringTableOffset;
    private Collection<AREntry> headers;

    public AR(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter File cannot be null!");
        }
        this.path = file.getAbsolutePath();
        this.efile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[7];
        this.efile.readFully(byArray);
        if (!AREntry.isARHeader(byArray)) {
            this.efile.close();
            this.efile = null;
            throw new IOException("Invalid AR archive! No header found.");
        }
        this.efile.readLine();
    }

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void extractFiles(File file, String ... stringArray) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter OutputDir cannot be null!");
        }
        for (AREntry aREntry : this.getEntries()) {
            String string = aREntry.getFileName();
            if (stringArray != null && !this.stringInStrings(stringArray, string)) continue;
            this.efile.seek(aREntry.getFileOffset());
            this.extractFile(aREntry, new File(file, string));
        }
    }

    public String getArchiveName() {
        return this.path;
    }

    public Collection<AREntry> getEntries() throws IOException {
        if (this.headers == null) {
            this.headers = this.loadEntries();
        }
        return Collections.unmodifiableCollection(this.headers);
    }

    public Collection<String> getEntryNames() throws IOException {
        Collection<AREntry> collection = this.getEntries();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (AREntry aREntry : collection) {
            arrayList.add(aREntry.getFileName());
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public boolean readFile(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Parameter Writer cannot be null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter Name cannot be null!");
        }
        for (AREntry aREntry : this.getEntries()) {
            String string2 = aREntry.getFileName();
            if (!string.equals(string2)) continue;
            this.efile.seek(aREntry.getFileOffset());
            this.extractFile(aREntry, writer);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String nameFromStringTable(long l) throws IOException {
        if (this.stringTableOffset < 0L) {
            throw new IOException("Invalid AR archive! No string table read yet?!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = this.efile.getFilePointer();
        try {
            byte by;
            this.efile.seek(this.stringTableOffset + l);
            while ((by = this.efile.readByte()) != 10) {
                stringBuilder.append((char)by);
            }
        }
        finally {
            this.efile.seek(l2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFile(AREntry aREntry, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            this.extractFile(aREntry, fileWriter);
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFile(AREntry aREntry, Writer writer) throws IOException {
        try {
            for (long i = aREntry.getSize(); i > 0L; --i) {
                int n = this.efile.read();
                if (n < 0 && i != 0L) {
                    throw new IOException("Invalid AR archive! Premature end of archive?!");
                }
                writer.write(n);
            }
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    private Collection<AREntry> loadEntries() throws IOException {
        ArrayList<AREntry> arrayList = new ArrayList<AREntry>();
        while (this.efile.getFilePointer() < this.efile.length()) {
            AREntry aREntry = AREntry.create(this, this.efile);
            if (!aREntry.isSpecial()) {
                arrayList.add(aREntry);
            }
            long l = this.efile.getFilePointer();
            if (aREntry.isStringTableSection()) {
                this.stringTableOffset = l;
            }
            if ((l += aREntry.getSize()) % 2L != 0L) {
                ++l;
            }
            this.efile.seek(l);
        }
        return arrayList;
    }

    private boolean stringInStrings(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }
}

