/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.jar;

import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.translator.Translator;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class JarInfoTranslator
implements Translator {
    private final File jarArchive;
    private final List<String> allClassNames;
    private List<Translator.ELEMENT> elements = new ArrayList<Translator.ELEMENT>();

    public JarInfoTranslator(File file, List<String> list) {
        this.jarArchive = file;
        this.allClassNames = list;
    }

    @Override
    public String getClassName() {
        return this.jarArchive.getName();
    }

    @Override
    public void addMapper(TokensMapper tokensMapper) {
    }

    @Override
    public void apply() {
        Translator.ELEMENT eLEMENT = new Translator.ELEMENT("\nclasses: " + this.allClassNames.size(), Translator.TAG.ANNOTATION);
        this.elements.add(eLEMENT);
        eLEMENT = new Translator.ELEMENT("\nsize: " + JarInfoTranslator.readableFileSize(this.jarArchive.length()), Translator.TAG.ANNOTATION);
        this.elements.add(eLEMENT);
    }

    @Override
    public List<Translator.ELEMENT> getElementsList() {
        return this.elements;
    }

    @Override
    public List<String> getDependencies() {
        return new LinkedList<String>();
    }

    public static String readableFileSize(long l) {
        if (l <= 0L) {
            return "0";
        }
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB"};
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)l / Math.pow(1024.0, n)) + " " + stringArray[n];
    }
}

