/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.dex;

import com.google.classyshark.silverghost.translator.java.dex.DexlibAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.Type;
import org.ow2.asmdex.ApplicationReader;
import org.ow2.asmdex.ApplicationVisitor;
import org.ow2.asmdex.ClassVisitor;
import org.ow2.asmdex.MethodVisitor;

public class DexMethodsDumper {
    public static List<String> dumpMethods(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (!zipEntry.getName().endsWith(".dex")) continue;
                int n2 = Character.getNumericValue(zipEntry.getName().charAt(zipEntry.getName().length() - 5));
                String string = "DUMPER_METHODS_classes";
                if (n2 != 28) {
                    string = string + n2;
                } else {
                    n2 = 0;
                }
                File file2 = File.createTempFile(string, "dex");
                file2.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while ((n = zipInputStream.read(byArray)) >= 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                List<String> list = DexMethodsDumper.fillAnalysis(n2, file2);
                arrayList.addAll(list);
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static List<String> fillAnalysis(int n, File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileInputStream fileInputStream = new FileInputStream(file);
        ApkInspectVisitor apkInspectVisitor = new ApkInspectVisitor(arrayList);
        ApplicationReader applicationReader = new ApplicationReader(262144, fileInputStream);
        applicationReader.accept(apkInspectVisitor, 0);
        return arrayList;
    }

    private static class ApkInspectVisitor
    extends ApplicationVisitor {
        private List<String> methodsList;

        public ApkInspectVisitor(List<String> list) {
            super(262144);
            this.methodsList = list;
        }

        static String getDecName(String string) {
            if (string.startsWith("[")) {
                return ApkInspectVisitor.getDecName(string.substring(1)) + "[]";
            }
            if (string.startsWith("L")) {
                String string2 = string.substring(1, string.length() - 1);
                return string2.replace('/', '.');
            }
            if (DexlibAdapter.primitiveTypes.containsKey(string)) {
                return DexlibAdapter.primitiveTypes.get(string);
            }
            return "void";
        }

        static String popType(String string) {
            return string.substring(ApkInspectVisitor.nextTypePosition(string, 0));
        }

        static String popReturn(String string) {
            return string.substring(0, string.indexOf(ApkInspectVisitor.popType(string)));
        }

        static int nextTypePosition(String string, int n) {
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                n = string.indexOf(59, n);
            }
            return ++n;
        }

        @Override
        public ClassVisitor visitClass(int n, String string, String[] stringArray, String string2, String[] stringArray2) {
            return new ClassVisitor(262144){

                @Override
                public void visit(int n, int n2, String string, String[] stringArray, String string2, String[] stringArray2) {
                    super.visit(n, n2, string, stringArray, string2, stringArray2);
                }

                @Override
                public MethodVisitor visitMethod(int n, String string, String string2, String[] stringArray, String[] stringArray2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(Modifier.toString(n));
                    stringBuilder.append(" " + ApkInspectVisitor.getDecName(ApkInspectVisitor.popReturn(string2)));
                    stringBuilder.append(" " + string);
                    Type[] typeArray = Type.getArgumentTypes("(" + ApkInspectVisitor.popType(string2) + ")");
                    stringBuilder.append("(");
                    String string3 = "";
                    for (Type type : typeArray) {
                        stringBuilder.append(string3);
                        string3 = ",";
                        stringBuilder.append(ApkInspectVisitor.getDecName(type.toString()));
                    }
                    stringBuilder.append(")");
                    ApkInspectVisitor.this.methodsList.add(stringBuilder.toString());
                    return super.visitMethod(n, string, string2, stringArray, stringArray2);
                }
            };
        }
    }
}

