/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.exporter;

import com.google.classyshark.silverghost.exporter.MethodCountExporter;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import java.io.PrintWriter;
import java.util.Iterator;

public class FlatMethodCountExporter
implements MethodCountExporter {
    private PrintWriter pw;

    public FlatMethodCountExporter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    @Override
    public void exportMethodCounts(ClassNode classNode) {
        this.printNode(classNode, new String[0]);
        this.pw.flush();
    }

    private void printNode(ClassNode classNode, String[] stringArray) {
        for (String string : stringArray) {
            this.pw.print(string);
            this.pw.print('.');
        }
        this.pw.println(classNode.getKey() + " - " + classNode.getMethodCount());
        Iterator<ClassNode> iterator = classNode.getChildNodes().values().iterator();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = classNode.getKey();
        while (iterator.hasNext()) {
            ClassNode classNode2 = (ClassNode)iterator.next();
            this.printNode(classNode2, stringArray2);
        }
    }
}

