/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.contentreader;

import com.google.classyshark.silverghost.contentreader.BinaryContentReader;
import com.google.classyshark.silverghost.contentreader.aar.AarReader;
import com.google.classyshark.silverghost.contentreader.apk.ApkReader;
import com.google.classyshark.silverghost.contentreader.clazz.ClazzReader;
import com.google.classyshark.silverghost.contentreader.dex.DexReader;
import com.google.classyshark.silverghost.contentreader.jar.JarReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentReader {
    private BinaryContentReader formatReader;
    private List<String> allClassNames = new ArrayList<String>();

    public ContentReader(File file) {
        this.formatReader = file.getName().toLowerCase().endsWith(".jar") ? new JarReader(file) : (file.getName().toLowerCase().endsWith(".dex") ? new DexReader(file) : (file.getName().toLowerCase().endsWith(".apk") ? new ApkReader(file) : (file.getName().toLowerCase().endsWith(".aar") ? new AarReader(file) : new ClazzReader(file))));
    }

    public void load() {
        try {
            if (this.allClassNames.isEmpty()) {
                this.formatReader.read();
                this.allClassNames = this.formatReader.getClassNames();
            }
        }
        catch (Exception exception) {
            this.allClassNames = new ArrayList<String>();
        }
    }

    public List<String> getAllClassNames() {
        return Collections.unmodifiableList(this.allClassNames);
    }

    public List<Component> getAllComponents() {
        return this.formatReader.getComponents();
    }

    public static class Component {
        public String name;
        public ARCHIVE_COMPONENT component;

        public Component(String string, ARCHIVE_COMPONENT aRCHIVE_COMPONENT) {
            this.name = string;
            this.component = aRCHIVE_COMPONENT;
        }
    }

    public static enum ARCHIVE_COMPONENT {
        ANDROID_MANIFEST,
        NATIVE_LIBRARY;

    }
}

