/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.settings;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.settings.ThemeChosenListener;
import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.gui.theme.ThemeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SettingsFrame
extends JFrame {
    private final Theme theme = GuiMode.getTheme();
    private final String[] themes = new String[]{"Light", "Dark"};

    public SettingsFrame() throws HeadlessException {
        super("Settings");
        this.initUI();
        JPanel jPanel = this.buildThemeUI();
        this.getContentPane().add(jPanel);
    }

    private JPanel buildThemeUI() {
        JPanel jPanel = this.buildOutPanel();
        JLabel jLabel = this.buildThemeLabel();
        jPanel.add((Component)jLabel, "North");
        JComboBox<String> jComboBox = this.buildComboBox();
        jPanel.add(jComboBox, "Center");
        return jPanel;
    }

    private JComboBox<String> buildComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>(ThemeManager.getThemes());
        jComboBox.setSelectedIndex(ThemeManager.getThemeIndexFrom(this.theme));
        jComboBox.addActionListener(new ThemeChosenListener(this, jComboBox));
        return jComboBox;
    }

    private JLabel buildThemeLabel() {
        JLabel jLabel = new JLabel("Theme:");
        jLabel.setToolTipText("It will be applied the next time ClassyShark is started");
        this.theme.applyTo(jLabel);
        return jLabel;
    }

    private JPanel buildOutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        this.theme.applyTo(jPanel);
        return jPanel;
    }

    private void initUI() {
        this.setVisible(true);
        this.setSize(200, 80);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
    }
}

