/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.methodscount;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.FileTransferHandler;
import com.google.classyshark.gui.panel.ViewerController;
import com.google.classyshark.gui.panel.tree.CellRenderer;
import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import com.google.classyshark.silverghost.methodscounter.RootBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class MethodsCountPanel
extends JPanel {
    private DefaultTreeModel treeModel;
    private JTree jTree;
    private ViewerController viewerController;
    private final Theme theme = GuiMode.getTheme();

    public MethodsCountPanel(ViewerController viewerController, File file) throws HeadlessException {
        this(viewerController);
        this.loadFile(file);
        this.theme.applyTo(this);
    }

    public MethodsCountPanel(ViewerController viewerController) throws HeadlessException {
        this.viewerController = viewerController;
        this.setup();
        this.theme.applyTo(this);
    }

    public void loadFile(File file) {
        new NodeWorker(file).execute();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(null));
        this.jTree = new JTree(this.treeModel);
        this.jTree.setRootVisible(false);
        this.jTree.setCellRenderer(new CellRenderer());
        this.theme.applyTo(this.jTree);
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.jTree.getCellRenderer();
        defaultTreeCellRenderer.setFont(new Font("Menlo", 0, 18));
        this.jTree.setCellRenderer(defaultTreeCellRenderer);
        this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = MethodsCountPanel.this.jTree.getLastSelectedPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                ClassNode classNode = (ClassNode)defaultMutableTreeNode.getUserObject();
                MethodsCountPanel.this.viewerController.onSelectedMethodCount(classNode);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.jTree);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)jScrollPane, "Center");
        this.theme.applyTo(jScrollPane);
        this.jTree.setDragEnabled(true);
        this.jTree.setTransferHandler(new FileTransferHandler(this.viewerController));
    }

    private void addNodes(ClassNode classNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        for (ClassNode classNode2 : classNode.getChildNodes().values()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(classNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.addNodes(classNode2, defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode createDefaultMutableTreeNode(ClassNode classNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(classNode);
        this.addNodes(classNode, defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    class NodeWorker
    extends SwingWorker<ClassNode, Void> {
        private File file;

        public NodeWorker(File file) {
            this.file = file;
        }

        @Override
        protected ClassNode doInBackground() throws Exception {
            RootBuilder rootBuilder = new RootBuilder();
            return rootBuilder.fillClassesWithMethods(this.file);
        }

        @Override
        protected void done() {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = MethodsCountPanel.this.createDefaultMutableTreeNode((ClassNode)this.get());
                MethodsCountPanel.this.treeModel.setRoot(defaultMutableTreeNode);
                MethodsCountPanel.this.jTree.setRootVisible(true);
                MethodsCountPanel.this.viewerController.onSelectedMethodCount((ClassNode)defaultMutableTreeNode.getUserObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

