/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.cli;

import com.google.classyshark.silverghost.SilverGhostFacade;
import com.google.classyshark.updater.UpdateManager;
import java.io.File;
import java.util.List;

public class CliMode {
    private static final String ERROR_MESSAGE = "Usage: java -jar ClassyShark.jar [-options] <archive> [args...]\n           (to execute a ClassyShark on binary archive jar/apk/dex/class)\nwhere options include:\n    -open\t  open an archive with GUI \n    -export\t  export to file \n    -methodcounts\t  packages with method counts \n    -inspect  experimental prints apk analysis\n    -update\tupdates ClassyShark\nwhere args is an optional classname\n";

    private CliMode() {
    }

    public static void with(List<String> list) {
        String string;
        if (list.size() < 2) {
            System.err.println("missing command line arguments \n\n\nUsage: java -jar ClassyShark.jar [-options] <archive> [args...]\n           (to execute a ClassyShark on binary archive jar/apk/dex/class)\nwhere options include:\n    -open\t  open an archive with GUI \n    -export\t  export to file \n    -methodcounts\t  packages with method counts \n    -inspect  experimental prints apk analysis\n    -update\tupdates ClassyShark\nwhere args is an optional classname\n");
            return;
        }
        File file = new File(list.get(1));
        if (!file.exists()) {
            System.err.println("File doesn't exist ==> " + file + "\n\n\n" + ERROR_MESSAGE);
            return;
        }
        switch (string = list.get(0).toLowerCase()) {
            case "-export": {
                if (list.size() == 2) {
                    SilverGhostFacade.exportArchive(list);
                    break;
                }
                SilverGhostFacade.exportClassFromApk(list);
                break;
            }
            case "-inspect": {
                SilverGhostFacade.inspectApk(list);
                break;
            }
            case "-methodcounts": {
                SilverGhostFacade.inspectPackages(list);
                break;
            }
            case "-update": {
                UpdateManager.getInstance().checkVersionConsole();
                break;
            }
            default: {
                System.err.println("wrong operand ==> " + string + "\n\n\n" + ERROR_MESSAGE);
            }
        }
    }
}

