/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.SideEffectOperation;
import com.android.jack.ir.ast.JAbsentArrayDimension;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.ir.types.JNumericType;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.config.ThreadConfig;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Check that there are no more implicit casts and boxing/unboxing between numeric types.")
@Constraint(no={SideEffectOperation.class, InitInNewArray.class, JCastOperation.WithIntersectionType.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class NumericConversionChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    static class Visitor
    extends JVisitor {
        @Nonnull
        private static final String MISSING_UNBOXING_ERROR = "Missing unboxing";
        @Nonnull
        private static final String MISSING_BOXING_ERROR = "Missing boxing";
        @Nonnull
        private static final String MISSING_CAST_ERROR = "Missing numeric cast";

        Visitor() {
        }

        @Override
        public void endVisit(@Nonnull JReturnStatement returnStatement) {
            JExpression returnExpr = returnStatement.getExpr();
            if (returnExpr != null) {
                JType expectedType = returnStatement.getParent(JMethod.class).getType();
                this.checkBoxingOrUnboxing(returnExpr, expectedType);
                this.checkCast(returnExpr, expectedType);
            }
            super.endVisit(returnStatement);
        }

        @Override
        public void endVisit(@Nonnull JForStatement forStmt) {
            this.checkUnboxing(forStmt.getTestExpr());
            super.endVisit(forStmt);
        }

        @Override
        public void endVisit(@Nonnull JWhileStatement whileStmt) {
            this.checkUnboxing(whileStmt.getTestExpr());
            super.endVisit(whileStmt);
        }

        @Override
        public void endVisit(@Nonnull JDoStatement doStmt) {
            this.checkUnboxing(doStmt.getTestExpr());
            super.endVisit(doStmt);
        }

        @Override
        public void endVisit(@Nonnull JConditionalExpression conditional) {
            this.checkUnboxing(conditional.getIfTest());
            JExpression thenExpr = conditional.getThenExpr();
            JExpression elseExpr = conditional.getElseExpr();
            JType conditionalType = conditional.getType();
            this.checkBoxingOrUnboxing(thenExpr, conditionalType);
            this.checkBoxingOrUnboxing(elseExpr, conditionalType);
            this.checkCast(thenExpr, conditionalType);
            this.checkCast(elseExpr, conditionalType);
            super.endVisit(conditional);
        }

        @Override
        public void endVisit(@Nonnull JIfStatement ifStmt) {
            this.checkUnboxing(ifStmt.getIfExpr());
            super.endVisit(ifStmt);
        }

        @Override
        public void endVisit(@Nonnull JSwitchStatement switchStmt) {
            this.checkUnboxing(switchStmt.getExpr());
            super.endVisit(switchStmt);
        }

        @Override
        public void endVisit(@Nonnull JDynamicCastOperation cast) {
            this.checkBoxingOrUnboxing(cast.getExpr(), cast.getType());
            super.endVisit(cast);
        }

        @Override
        public void endVisit(@Nonnull JBinaryOperation binary) {
            JExpression lhs = binary.getLhs();
            JType lhsType = lhs.getType();
            JExpression rhs = binary.getRhs();
            JType rhsType = rhs.getType();
            switch (binary.getOp()) {
                case CONCAT: 
                case ASG_CONCAT: 
                case ASG_ADD: 
                case ASG_DIV: 
                case ASG_MOD: 
                case ASG_MUL: 
                case ASG_SUB: 
                case ASG_BIT_AND: 
                case ASG_BIT_OR: 
                case ASG_BIT_XOR: 
                case ASG_SHL: 
                case ASG_SHR: 
                case ASG_SHRU: {
                    break;
                }
                case ASG: {
                    this.checkBoxingOrUnboxing(rhs, lhsType);
                    if (!(lhsType instanceof JNumericType)) break;
                    this.checkCast(rhs, lhsType);
                    break;
                }
                case SHL: 
                case SHR: 
                case SHRU: {
                    this.checkUnboxing(lhs);
                    this.checkUnboxing(rhs);
                    this.checkCast(lhs, binary.getType());
                    this.checkCast(rhs, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                    break;
                }
                case BIT_AND: 
                case BIT_OR: 
                case BIT_XOR: 
                case AND: 
                case OR: 
                case ADD: 
                case DIV: 
                case MOD: 
                case MUL: 
                case SUB: {
                    JType expectedType = binary.getType();
                    this.checkUnboxing(lhs);
                    this.checkUnboxing(rhs);
                    this.checkCast(lhs, expectedType);
                    this.checkCast(rhs, expectedType);
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    JType expectedType = JPrimitiveType.getBinaryPromotionType(lhsType, rhsType);
                    this.checkUnboxing(lhs);
                    this.checkUnboxing(rhs);
                    this.checkCast(lhs, expectedType);
                    this.checkCast(rhs, expectedType);
                    break;
                }
                case EQ: 
                case NEQ: {
                    if (lhsType instanceof JNumericType || rhsType instanceof JNumericType) {
                        JType expectedType = JPrimitiveType.getBinaryPromotionType(lhsType, rhsType);
                        this.checkUnboxing(lhs);
                        this.checkUnboxing(rhs);
                        this.checkCast(lhs, expectedType);
                        this.checkCast(rhs, expectedType);
                        break;
                    }
                    if (rhsType != JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType() && lhsType != JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType()) break;
                    this.checkUnboxing(lhs);
                    this.checkUnboxing(rhs);
                }
            }
            super.endVisit(binary);
        }

        @Override
        public void endVisit(@Nonnull JFieldInitializer init) {
            JExpression initializer = init.getInitializer();
            JType expectedType = init.getFieldRef().getType();
            this.checkBoxingOrUnboxing(initializer, expectedType);
            this.checkCast(initializer, expectedType);
            super.endVisit(init);
        }

        @Override
        public void endVisit(@Nonnull JPolymorphicMethodCall polymorphicMethodCall) {
        }

        @Override
        public void endVisit(@Nonnull JMethodCall call) {
            List<JExpression> args = call.getArgs();
            List<JType> parameterTypes = call.getMethodId().getParamTypes();
            assert (args.size() == parameterTypes.size());
            Iterator<JType> paramTypeIterator = parameterTypes.iterator();
            for (JExpression jExpression : args) {
                JType expectedType = paramTypeIterator.next();
                this.checkBoxingOrUnboxing(jExpression, expectedType);
                this.checkCast(jExpression, expectedType);
            }
            super.endVisit(call);
        }

        @Override
        public void endVisit(@Nonnull JNewArray newArray) {
            for (JExpression dimension : newArray.getDims()) {
                if (dimension instanceof JAbsentArrayDimension) continue;
                if (dimension.getType() instanceof JPrimitiveType) {
                    this.checkCast(dimension, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                    continue;
                }
                throw new AssertionError((Object)MISSING_UNBOXING_ERROR);
            }
            assert (newArray.getInitializers().isEmpty() || newArray.hasConstantInitializer());
            super.endVisit(newArray);
        }

        @Override
        public void endVisit(@Nonnull JArrayRef arrayRef) {
            JExpression indexExpr = arrayRef.getIndexExpr();
            this.checkUnboxing(indexExpr);
            this.checkCast(indexExpr, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
            super.endVisit(arrayRef);
        }

        @Override
        public void endVisit(@Nonnull JUnaryOperation unary) {
            switch (unary.getOp()) {
                case DEC: 
                case INC: 
                case NOT: 
                case BIT_NOT: 
                case NEG: {
                    this.checkUnboxing(unary.getArg());
                    this.checkCast(unary.getArg(), unary.getType());
                }
            }
            super.endVisit(unary);
        }

        private void checkUnboxing(@Nonnull JExpression expr) {
            if (!(expr.getType() instanceof JPrimitiveType)) {
                throw new AssertionError((Object)MISSING_UNBOXING_ERROR);
            }
        }

        private void checkBoxingOrUnboxing(@Nonnull JExpression expr, @Nonnull JType expectedType) {
            JType type = expr.getType();
            if (!(expectedType instanceof JPrimitiveType) && type instanceof JPrimitiveType) {
                throw new AssertionError((Object)MISSING_BOXING_ERROR);
            }
            if (expectedType instanceof JPrimitiveType && !(type instanceof JPrimitiveType)) {
                throw new AssertionError((Object)MISSING_UNBOXING_ERROR);
            }
        }

        private void checkCast(@Nonnull JExpression exprToCast, @Nonnull JType expectedType) {
            if (expectedType instanceof JNumericType && !exprToCast.getType().isSameType(expectedType)) {
                throw new AssertionError((Object)MISSING_CAST_ERROR);
            }
        }
    }
}

