/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.ir.ast.JField;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.spec.AnnotationSpecification;
import com.android.jack.shrob.spec.ModifierSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.shrob.spec.Specification;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class FieldSpecification
implements Specification<JField> {
    @CheckForNull
    private final AnnotationSpecification annotationType;
    @CheckForNull
    private final ModifierSpecification modifier;
    @Nonnull
    private final NameSpecification name;
    @CheckForNull
    private final NameSpecification type;

    public FieldSpecification(@Nonnull NameSpecification name, @CheckForNull ModifierSpecification modifier, @CheckForNull NameSpecification type, @CheckForNull AnnotationSpecification annotationType) {
        this.name = name;
        this.modifier = modifier;
        this.type = type;
        this.annotationType = annotationType;
    }

    @Override
    public boolean matches(@Nonnull JField f) {
        if (this.modifier != null && !this.modifier.matches(f)) {
            return false;
        }
        if (this.annotationType != null && !this.annotationType.matches(f.getAnnotations())) {
            return false;
        }
        if (!this.name.matches(f.getName())) {
            return false;
        }
        return this.type == null || this.type.matches(GrammarActions.getSignatureFormatter().getName(f.getType()));
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("field: ");
        if (this.annotationType != null) {
            sb.append(this.annotationType);
            sb.append(' ');
        }
        if (this.modifier != null) {
            sb.append(this.modifier);
            sb.append(' ');
        }
        if (this.type != null) {
            sb.append(this.type);
            sb.append(' ');
        }
        sb.append(this.name);
        sb.append(';');
        return sb.toString();
    }
}

