/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.JackIOException;
import com.android.jack.frontend.MethodIdDuplicateRemover;
import com.android.jack.google.common.primitives.Chars;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.lookup.JLookupException;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.lookup.JNodeLookup;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.obfuscation.FieldInHierarchyFinderVisitor;
import com.android.jack.shrob.obfuscation.KeepNameMarker;
import com.android.jack.shrob.obfuscation.MethodInHierarchyFinder;
import com.android.jack.shrob.obfuscation.NewFieldNameMarker;
import com.android.jack.shrob.obfuscation.NewMethodSignatureMarker;
import com.android.jack.shrob.obfuscation.OriginalNameMarker;
import com.android.jack.shrob.obfuscation.OriginalPackageMarker;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.shrob.shrink.MappingCollisionException;
import com.android.jack.shrob.shrink.MappingCollisionPolicy;
import com.android.jack.shrob.shrink.MappingContextException;
import com.android.jack.shrob.shrink.MappingContextInfo;
import com.android.jack.transformations.request.ChangeEnclosingPackage;
import com.android.jack.transformations.request.Rename;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.marker.MarkerManager;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.log.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@HasKeyId
@Transform(add={OriginalNameMarker.class, OriginalPackageMarker.class, KeepNameMarker.class})
@Constraint(need={MethodIdDuplicateRemover.UniqMethodIds.class})
public class MappingApplier {
    @Nonnull
    private static final char[] EMPTY_STOP_CHARS = new char[0];
    @Nonnull
    private static final char[] CLASSINFO_STOP_CHARS = new char[]{':'};
    @Nonnull
    private static final char[] BEGIN_PARAMETER_STOP_CHARS = new char[]{'('};
    @Nonnull
    private static final char[] END_PARAMETER_STOP_CHARS = new char[]{',', ')'};
    @Nonnull
    protected static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final TransformationRequest request;
    @Nonnull
    public static final PropertyId<MappingCollisionPolicy> COLLISION_POLICY = BooleanPropertyId.create("jack.obfuscation.mapping.collision-policy", "Abort obfuscation when a mapping collision is detected", new EnumCodec(MappingCollisionPolicy.class, (Enum[])MappingCollisionPolicy.values()).ignoreCase()).addDefaultValue(MappingCollisionPolicy.FAIL);
    @Nonnull
    private final MappingCollisionPolicy collisionPolicy = ThreadConfig.get(COLLISION_POLICY);

    public MappingApplier(@Nonnull TransformationRequest request) {
        this.request = request;
    }

    private static boolean isClassInfo(@Nonnull String line) {
        return line.charAt(line.length() - 1) == ':';
    }

    private static boolean isMethodInfo(@Nonnull String line) {
        return line.indexOf(40) != -1;
    }

    private void throwException(@Nonnull File mappingFile, int lineNumber, @Nonnull String message) throws JackIOException {
        throw new JackIOException(mappingFile.getPath() + ":" + lineNumber + ":" + message);
    }

    @CheckForNull
    private JDefinedClassOrInterface createMappingForType(@Nonnull String oldName, @Nonnull String newName, @Nonnull JSession session, @Nonnull File mappingFile, int lineNumber) {
        JClassOrInterface type = null;
        JNodeLookup lookup = session.getLookup();
        try {
            String typeSignature = NamingTools.getTypeSignatureName(oldName);
            type = (JClassOrInterface)lookup.getType(typeSignature);
        }
        catch (JLookupException e) {
            logger.log(Level.WARNING, "{0}:{1}: Type {2} not found", new Object[]{mappingFile.getPath(), lineNumber, oldName});
        }
        if (type instanceof JDefinedClassOrInterface) {
            JPackage newEnclosingPackage;
            String newSimpleName;
            String newPackageName;
            JDefinedClassOrInterface clOrI = (JDefinedClassOrInterface)type;
            int indexOfNewSimpleName = newName.lastIndexOf(46);
            if (indexOfNewSimpleName == -1) {
                newPackageName = "";
                newSimpleName = newName;
            } else {
                newPackageName = newName.substring(0, indexOfNewSimpleName).replace('.', '/');
                newSimpleName = newName.substring(indexOfNewSimpleName + 1, newName.length());
            }
            clOrI.addMarker(new OriginalPackageMarker(clOrI.getEnclosingPackage()));
            this.request.append(new ChangeEnclosingPackage(clOrI, newEnclosingPackage));
            for (newEnclosingPackage = lookup.getOrCreatePackage(newPackageName); newEnclosingPackage != null; newEnclosingPackage = newEnclosingPackage.getEnclosingPackage()) {
                if (newEnclosingPackage.containsMarker(KeepNameMarker.class)) continue;
                newEnclosingPackage.addMarker(KeepNameMarker.INSTANCE);
            }
            this.rename(clOrI, newSimpleName);
            return clOrI;
        }
        return null;
    }

    private int readLineInfo(@Nonnull String line, int index) {
        char c = line.charAt(index);
        while (Character.isDigit(c) || c == ':') {
            c = line.charAt(++index);
        }
        return index;
    }

    private int readName(@Nonnull String line, int index, @Nonnull char[] stopChars) {
        int length = line.length();
        char c = line.charAt(index);
        while (!Character.isWhitespace(c) && Chars.indexOf(stopChars, c) == -1 && ++index < length) {
            c = line.charAt(index);
        }
        return index;
    }

    private int readNameUntilSeparatorOrWhitespace(@Nonnull String line, int index) {
        int length = line.length();
        char c = line.charAt(index);
        while (!(Character.isWhitespace(c) || c == '-' && line.charAt(index + 1) == '>' || ++index >= length)) {
            c = line.charAt(index);
        }
        return index;
    }

    private int readWhiteSpaces(@Nonnull String line, int index) {
        char c = line.charAt(index);
        while (Character.isWhitespace(c)) {
            c = line.charAt(++index);
        }
        return index;
    }

    private int readSeparator(@Nonnull String line, int index, @Nonnull File mappingFile, int lineNumber) {
        if (line.charAt(index) != '-' || line.charAt(index + 1) != '>') {
            this.throwException(mappingFile, lineNumber, "The mapping file is badly formatted (separator \"->\" expected)");
        }
        return index + 2;
    }

    @CheckForNull
    private JDefinedClassOrInterface readClassInfo(@Nonnull String line, @Nonnull JSession session, @Nonnull File mappingFile, int lineNumber) {
        try {
            int startIndex = this.readWhiteSpaces(line, 0);
            int endIndex = this.readNameUntilSeparatorOrWhitespace(line, startIndex);
            String qualifiedOldClassName = line.substring(startIndex, endIndex);
            startIndex = this.readWhiteSpaces(line, endIndex);
            startIndex = this.readSeparator(line, startIndex, mappingFile, lineNumber);
            startIndex = this.readWhiteSpaces(line, startIndex);
            endIndex = this.readName(line, startIndex, CLASSINFO_STOP_CHARS);
            String newClassName = line.substring(startIndex, endIndex);
            return this.createMappingForType(qualifiedOldClassName, newClassName, session, mappingFile, lineNumber);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwException(mappingFile, lineNumber, "The mapping file is badly formatted (class mapping expected)");
            return null;
        }
    }

    @CheckForNull
    private JField findField(@Nonnull JDefinedClassOrInterface currentType, @Nonnull String oldName, @Nonnull String typeSignature) {
        List<JField> fields = currentType.getFields(oldName);
        for (JField field : fields) {
            if (!GrammarActions.getSignatureFormatter().getName(field.getType()).equals(typeSignature)) continue;
            return field;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFieldInfo(@Nonnull String line, @Nonnull JDefinedClassOrInterface currentType, @Nonnull File mappingFile, int lineNumber) {
        try {
            int startIndex = this.readWhiteSpaces(line, 0);
            int endIndex = this.readName(line, startIndex, EMPTY_STOP_CHARS);
            String typeSignature = GrammarActions.getSignature(line.substring(startIndex, endIndex));
            startIndex = this.readWhiteSpaces(line, endIndex);
            endIndex = this.readNameUntilSeparatorOrWhitespace(line, startIndex);
            String oldName = line.substring(startIndex, endIndex);
            int index = this.readWhiteSpaces(line, endIndex);
            index = this.readSeparator(line, index, mappingFile, lineNumber);
            startIndex = this.readWhiteSpaces(line, index);
            endIndex = this.readName(line, startIndex, EMPTY_STOP_CHARS);
            String newName = line.substring(startIndex, endIndex);
            JField field = this.findField(currentType, oldName, typeSignature);
            if (field != null) {
                if (!newName.equals(oldName) && FieldInHierarchyFinderVisitor.containsFieldKey(newName, field)) throw new MappingCollisionException(new ColumnAndLineLocation(new FileLocation(mappingFile), lineNumber), field, newName);
                this.renameField(field, mappingFile, lineNumber, newName);
                NewFieldNameMarker marker = currentType.getMarker(NewFieldNameMarker.class);
                if (marker == null) {
                    marker = new NewFieldNameMarker();
                }
                assert (marker != null);
                marker.add(newName);
                return;
            } else {
                logger.log(Level.WARNING, "{0}:{1}: Field {2} not found in {3}", new Object[]{mappingFile.getPath(), lineNumber, oldName, Jack.getUserFriendlyFormatter().getName(currentType)});
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwException(mappingFile, lineNumber, "The mapping file is badly formatted (field mapping expected)");
            return;
        }
        catch (MappingCollisionException e) {
            if (this.collisionPolicy.equals((Object)MappingCollisionPolicy.FAIL)) {
                MappingContextException mappingReportableExn = new MappingContextException(e);
                Jack.getSession().getReporter().report(Reporter.Severity.FATAL, mappingReportableExn);
                throw new JackAbortException(mappingReportableExn);
            }
            Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new MappingContextInfo(e));
        }
    }

    private void rename(@Nonnull CanBeRenamed renamable, @Nonnull String newName) {
        MarkerManager markerManager = (MarkerManager)((Object)renamable);
        if (!markerManager.containsMarker(OriginalNameMarker.class)) {
            markerManager.addMarker(new OriginalNameMarker(renamable.getName()));
            this.request.append(new Rename(renamable, newName));
        }
    }

    protected void renameField(@Nonnull JField field, @Nonnull File mappingFile, int lineNumber, @Nonnull String newName) {
        this.rename(field.getId(), newName);
    }

    private int readChar(@Nonnull String line, int index, char expectedChar, @Nonnull File mappingFile, int lineNumber) {
        if (line.charAt(index) != expectedChar) {
            this.throwException(mappingFile, lineNumber, "The mapping file is badly formatted ('" + expectedChar + "' expected)");
        }
        return index + 1;
    }

    @CheckForNull
    private String getPreviousNewSignature(@Nonnull JMethod method) {
        NewMethodSignatureMarker marker = method.getEnclosingType().getMarker(NewMethodSignatureMarker.class);
        if (marker != null) {
            return marker.getNewSignature(method.getMethodId().getMethodIdWide());
        }
        return null;
    }

    private void readMethodInfo(@Nonnull String line, @Nonnull JDefinedClassOrInterface currentType, @Nonnull File mappingFile, int lineNumber, @Nonnull JNodeLookup lookup) {
        block14: {
            try {
                int startIndex = this.readWhiteSpaces(line, 0);
                startIndex = this.readLineInfo(line, startIndex);
                startIndex = this.readWhiteSpaces(line, startIndex);
                int endIndex = this.readName(line, startIndex, EMPTY_STOP_CHARS);
                String typeSignature = GrammarActions.getSignature(line.substring(startIndex, endIndex));
                JType returnType = lookup.getType(typeSignature);
                startIndex = this.readWhiteSpaces(line, endIndex);
                endIndex = this.readName(line, startIndex, BEGIN_PARAMETER_STOP_CHARS);
                String oldName = line.substring(startIndex, endIndex);
                startIndex = this.readChar(line, endIndex, '(', mappingFile, lineNumber);
                ArrayList<JType> args = new ArrayList<JType>();
                startIndex = this.readWhiteSpaces(line, startIndex);
                while (line.charAt(startIndex) != ')') {
                    endIndex = this.readName(line, startIndex, END_PARAMETER_STOP_CHARS);
                    String parameterType = GrammarActions.getSignature(line.substring(startIndex, endIndex));
                    args.add(lookup.getType(parameterType));
                    startIndex = this.readWhiteSpaces(line, endIndex);
                    if (line.charAt(startIndex) == ')') break;
                    startIndex = this.readChar(line, startIndex, ',', mappingFile, lineNumber);
                    startIndex = this.readWhiteSpaces(line, startIndex);
                }
                ++startIndex;
                startIndex = this.readWhiteSpaces(line, startIndex);
                startIndex = this.readSeparator(line, startIndex, mappingFile, lineNumber);
                startIndex = this.readWhiteSpaces(line, startIndex);
                endIndex = this.readName(line, startIndex, EMPTY_STOP_CHARS);
                String newName = line.substring(startIndex, endIndex);
                try {
                    JMethod method = currentType.getMethod(oldName, returnType, args);
                    String newSignature = GrammarActions.getSignatureFormatter().getNameWithoutReturnType(newName, args);
                    JMethodIdWide methodId = method.getMethodId().getMethodIdWide();
                    String previousNewSignature = this.getPreviousNewSignature(method);
                    if (previousNewSignature != null) {
                        if (!previousNewSignature.equals(newSignature)) {
                            throw new MappingCollisionException(new ColumnAndLineLocation(new FileLocation(mappingFile), lineNumber), method, newName);
                        }
                        break block14;
                    }
                    if (newSignature.equals(Jack.getUserFriendlyFormatter().getNameWithoutReturnType(methodId)) || !MethodInHierarchyFinder.containsMethodKey(newSignature, methodId)) {
                        this.renameMethod(method, mappingFile, lineNumber, newName);
                        for (JMethod methodWithSameId : methodId.getMethods()) {
                            NewMethodSignatureMarker newMarker;
                            JDefinedClassOrInterface methodWithSameIdEnclosingType = methodWithSameId.getEnclosingType();
                            NewMethodSignatureMarker marker = methodWithSameIdEnclosingType.getMarker(NewMethodSignatureMarker.class);
                            if (marker == null && (marker = methodWithSameIdEnclosingType.addMarker(newMarker = new NewMethodSignatureMarker())) == null) {
                                marker = newMarker;
                            }
                            assert (marker != null);
                            marker.add(methodId, newSignature);
                        }
                        break block14;
                    }
                    throw new MappingCollisionException(new ColumnAndLineLocation(new FileLocation(mappingFile), lineNumber), method, newName);
                }
                catch (JMethodLookupException e) {
                    logger.log(Level.WARNING, "{0}:{1}: Method {2} not found in {3}", new Object[]{mappingFile.getPath(), lineNumber, oldName, Jack.getUserFriendlyFormatter().getName(currentType)});
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.throwException(mappingFile, lineNumber, "The mapping file is badly formatted (method mapping expected)");
            }
            catch (JTypeLookupException e) {
                logger.log(Level.WARNING, "{0}:{1}: {2}", new Object[]{mappingFile.getPath(), lineNumber, e.getMessage()});
            }
            catch (MappingCollisionException e) {
                if (this.collisionPolicy.equals((Object)MappingCollisionPolicy.FAIL)) {
                    MappingContextException mappingReportableExn = new MappingContextException(e);
                    Jack.getSession().getReporter().report(Reporter.Severity.FATAL, mappingReportableExn);
                    throw new JackAbortException(mappingReportableExn);
                }
                Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new MappingContextInfo(e));
            }
        }
    }

    protected void renameMethod(@Nonnull JMethod method, @Nonnull File mappingFile, int lineNumber, @Nonnull String newName) {
        String oldName = method.getName();
        if (oldName.equals("<init>")) {
            logger.log(Level.WARNING, "{0}:{1}: Constructors cannot be renamed", new Object[]{mappingFile.getPath(), lineNumber});
        } else if (oldName.equals("<clinit>")) {
            logger.log(Level.WARNING, "{0}:{1}: Static initializers cannot be renamed", new Object[]{mappingFile.getPath(), lineNumber});
        } else {
            this.rename(method.getMethodIdWide(), newName);
        }
    }

    public void applyMapping(@Nonnull File mappingFile, @Nonnull JSession session) throws JackIOException {
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(mappingFile));
            String line = ((LineNumberReader)reader).readLine();
            JDefinedClassOrInterface currentType = null;
            while (line != null) {
                if (MappingApplier.isClassInfo(line)) {
                    currentType = this.readClassInfo(line, session, mappingFile, ((LineNumberReader)reader).getLineNumber());
                } else if (currentType != null) {
                    if (MappingApplier.isMethodInfo(line)) {
                        this.readMethodInfo(line, currentType, mappingFile, ((LineNumberReader)reader).getLineNumber(), session.getLookup());
                    } else {
                        this.readFieldInfo(line, currentType, mappingFile, ((LineNumberReader)reader).getLineNumber());
                    }
                }
                line = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException e) {
            throw new JackIOException("Error while reading mapping " + mappingFile.getPath(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close reader while reading mapping {0}", mappingFile.getPath());
                }
            }
        }
    }
}

