/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.preprocessor;

import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JType;
import com.android.jack.preprocessor.BooleanExpression;
import com.android.jack.preprocessor.Context;
import com.android.jack.preprocessor.Expression;
import com.android.jack.preprocessor.NamePattern;
import com.android.jack.preprocessor.Scope;
import com.android.jack.preprocessor.SingleTypeScope;
import com.android.jack.preprocessor.SubContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class FieldFilter
implements Expression<Collection<JField>, Scope> {
    @Nonnull
    private final NamePattern name;
    @Nonnull
    private Expression<Boolean, HasModifier> modifierExpression = BooleanExpression.getTrue();
    @Nonnull
    private final Expression<Collection<? extends JType>, Scope> type;

    public FieldFilter(@Nonnull NamePattern name, @Nonnull Expression<Collection<? extends JType>, Scope> type) {
        this.name = name;
        this.type = type;
    }

    @Override
    @Nonnull
    public Collection<JField> eval(@Nonnull Scope scope, @Nonnull Context context) {
        ArrayList<JField> nodes = new ArrayList<JField>();
        for (JField field : scope.getNodesByName(JField.class, this.name)) {
            SingleTypeScope returnTypeContext;
            SubContext subContext;
            if (!this.modifierExpression.eval(field, subContext = new SubContext(context)).booleanValue() || this.type.eval(returnTypeContext = new SingleTypeScope(field.getType()), subContext).isEmpty()) continue;
            nodes.add(field);
            subContext.push();
        }
        return nodes;
    }

    public void setModifierExpression(@Nonnull Expression<Boolean, HasModifier> expression) {
        this.modifierExpression = expression;
    }
}

