/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.sched.item.Description;
import com.android.sched.item.Feature;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.id.BooleanPropertyId;
import javax.annotation.Nonnull;

@HasKeyId
public class Optimizations {
    @Nonnull
    public static final BooleanPropertyId ENABLE_NULL_INSTANCEOF = ((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.null-instanceof-simplifier", "Optimize null instanceof").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    @Nonnull
    public static final BooleanPropertyId REMOVE_UNUSED_NON_SYNTHETIC_DEFINITION = ((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.remove-unused-non-synthetic-definition", "Allow to remove unused non synthetic definitions").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);

    @HasKeyId
    @Description(value="Apply write-only field removal optimization")
    public static class WriteOnlyFieldRemoval
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.write-only-field-removal", "Apply write-only field removal optimization").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId PRESERVE_NULL_CHECKS = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.write-only-field-removal.preserve-null-checks", "Preserves null checks when a field assignment is removed").addDefaultValue(Boolean.FALSE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId PRESERVE_OBJECT_LIFETIME = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.write-only-field-removal.preserve-object-lifetime", "Prevents field writes removal of object values that can affect object lifetime").addDefaultValue(Boolean.FALSE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId ENSURE_TYPE_INITIALIZERS = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.write-only-field-removal.ensure-type-initializers", "Ensures type initializers are called if caused by field access").addDefaultValue(Boolean.FALSE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId REMOVE_UNUSED_FIELDS = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.write-only-field-removal.remove-unused-fields", "Remove fields without reads or writes").addDefaultValue(Boolean.TRUE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    }

    @HasKeyId
    @Description(value="Apply method argument value propagation optimization")
    public static class ArgumentValuePropagation
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.argument-value-propagation", "Apply method argument value propagation optimization").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    }

    @HasKeyId
    @Description(value="Apply field value propagation optimization")
    public static class FieldValuePropagation
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.field-value-propagation", "Apply field value propagation optimization").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId PRESERVE_NULL_CHECKS = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.field-value-propagation.preserve-null-checks", "Preserves null checks when a value of the instance field is propagated").addDefaultValue(Boolean.FALSE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId ENSURE_TYPE_INITIALIZERS = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.field-value-propagation.ensure-type-initializers", "Ensures type initializers are called if caused by field access").addDefaultValue(Boolean.FALSE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    }

    @HasKeyId
    @Description(value="Detect effectively final fields, add modifiers when possible")
    public static class FieldFinalizer
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.field-finalizer", "Detect effectively final fields, add modifiers when possible").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId ENFORCE_INIT_SEMANTIC = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.field-finalizer.enforce-initialization-semantic", "Ensure initialization semantic for final field").addDefaultValue(Boolean.TRUE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId ADD_FINAL_MODIFIER = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.field-finalizer.add-final-modifier", "Set final modifier to all effectively final fields").addDefaultValue(Boolean.TRUE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    }

    @HasKeyId
    @Description(value="Detect effectively final methods, add modifiers when possible")
    public static class MethodFinalizer
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.method-finalizer", "Detect effectively final methods, add modifiers when possible").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId ADD_FINAL_MODIFIER = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.method-finalizer.add-final-modifier", "Set final modifier to all effectively final methods").addDefaultValue(Boolean.TRUE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    }

    @HasKeyId
    @Description(value="Detect effectively final classes, add modifiers when possible")
    public static class ClassFinalizer
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.class-finalizer", "Detect effectively final classes, add modifiers when possible").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
        @Nonnull
        public static final BooleanPropertyId ADD_FINAL_MODIFIER = ((BooleanPropertyId)((BooleanPropertyId)BooleanPropertyId.create("jack.optimization.class-finalizer.add-final-modifier", "Set final modifier to all effectively final classes").addDefaultValue(Boolean.TRUE).requiredIf(ENABLE.getValue().isTrue()).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class)).addCategory(Private.class);
    }

    @HasKeyId
    @Description(value="Optimize '!' operator")
    public static class NotSimplifier
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = BooleanPropertyId.create("jack.optimization.not-simplifier", "Optimize '!' operator").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    }

    @HasKeyId
    @Description(value="Optimize 'if' expressions using a boolean constant")
    public static class IfSimplifier
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = BooleanPropertyId.create("jack.optimization.if-simplifier", "Optimize 'if' expressions using a boolean constant").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    }

    @HasKeyId
    @Description(value="Optimize expressions using constants")
    public static class ExpressionSimplifier
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = BooleanPropertyId.create("jack.optimization.expression-simplifier", "Optimize expressions using constants").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    }

    @HasKeyId
    @Description(value="Optimize use/def chain")
    public static class UseDefSimplifier
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = BooleanPropertyId.create("jack.optimization.use-def-simplifier", "Optimize use/def chain").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    }

    @HasKeyId
    @Description(value="Optimize def/use chain")
    public static class DefUseSimplifier
    implements Feature {
        @Nonnull
        public static final BooleanPropertyId ENABLE = BooleanPropertyId.create("jack.optimization.def-use-simplifier", "Optimize def/use chain").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class);
    }
}

