/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NAbstractMethodBody;
import com.android.jack.jayce.v0003.nodes.NBlock;
import com.android.jack.jayce.v0003.nodes.NLocal;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NMethodBody
extends NAbstractMethodBody {
    @Nonnull
    public static final Token TOKEN = Token.METHOD_BODY;
    @Nonnull
    private List<NLocal> locals = Collections.emptyList();
    @CheckForNull
    private NBlock block;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object jElement) {
        JMethodBody jMethodBody = (JMethodBody)jElement;
        this.locals = loader.load(NLocal.class, jMethodBody.getLocals());
        this.block = (NBlock)loader.load(jMethodBody.getBlock());
        this.sourceInfo = loader.load(jMethodBody.getSourceInfo());
    }

    @Override
    @Nonnull
    public JMethodBody exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.block != null);
        assert (this.sourceInfo != null);
        JMethodBody jMethodBody = new JMethodBody(this.sourceInfo.exportAsJast(exportSession), this.block.exportAsJast(exportSession));
        for (NLocal local : this.locals) {
            JLocal jLocal = local.exportAsJast(exportSession);
            jLocal.setEnclosingMethodBody(jMethodBody);
            jMethodBody.addLocal(jLocal);
        }
        return jMethodBody;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNodes(this.locals);
        out.writeNode(this.block);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.locals = in.readNodes(NLocal.class);
        this.block = in.readNode(NBlock.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

