/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.types.JFloatingPointType;
import com.android.jack.ir.types.JIntegralType32;
import com.android.jack.ir.types.JIntegralType64;
import com.android.jack.lookup.CommonTypes;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java primitive types")
public abstract class JPrimitiveType
extends JNode
implements JType {
    @Nonnull
    protected final String name;

    private JPrimitiveType(@Nonnull String name) {
        super(SourceInfo.UNKNOWN);
        this.name = StringInterner.get().intern(name);
    }

    @Override
    public final boolean isSameType(@Nonnull JType type) {
        return this == type;
    }

    @Nonnull
    public static JType getUnaryPromotion(@Nonnull JType argType) {
        JPrimitiveType promotedType;
        if (JPrimitiveTypeEnum.BYTE.getType().isEquivalent(argType) || JPrimitiveTypeEnum.CHAR.getType().isEquivalent(argType) || JPrimitiveTypeEnum.SHORT.getType().isEquivalent(argType) || JPrimitiveTypeEnum.INT.getType().isEquivalent(argType)) {
            promotedType = JPrimitiveTypeEnum.INT.getType();
        } else if (JPrimitiveTypeEnum.FLOAT.getType().isEquivalent(argType)) {
            promotedType = JPrimitiveTypeEnum.FLOAT.getType();
        } else if (JPrimitiveTypeEnum.LONG.getType().isEquivalent(argType)) {
            promotedType = JPrimitiveTypeEnum.LONG.getType();
        } else if (JPrimitiveTypeEnum.DOUBLE.getType().isEquivalent(argType)) {
            promotedType = JPrimitiveTypeEnum.DOUBLE.getType();
        } else {
            throw new AssertionError();
        }
        return promotedType;
    }

    @Nonnull
    public static JType getBinaryPromotionType(@Nonnull JType lhsType, @Nonnull JType rhsType) {
        assert (JPrimitiveTypeEnum.BYTE.getType().isEquivalent(lhsType) || JPrimitiveTypeEnum.CHAR.getType().isEquivalent(lhsType) || JPrimitiveTypeEnum.SHORT.getType().isEquivalent(lhsType) || JPrimitiveTypeEnum.INT.getType().isEquivalent(lhsType) || JPrimitiveTypeEnum.FLOAT.getType().isEquivalent(lhsType) || JPrimitiveTypeEnum.LONG.getType().isEquivalent(lhsType) || JPrimitiveTypeEnum.DOUBLE.getType().isEquivalent(lhsType));
        assert (JPrimitiveTypeEnum.BYTE.getType().isEquivalent(rhsType) || JPrimitiveTypeEnum.CHAR.getType().isEquivalent(rhsType) || JPrimitiveTypeEnum.SHORT.getType().isEquivalent(rhsType) || JPrimitiveTypeEnum.INT.getType().isEquivalent(rhsType) || JPrimitiveTypeEnum.FLOAT.getType().isEquivalent(rhsType) || JPrimitiveTypeEnum.LONG.getType().isEquivalent(rhsType) || JPrimitiveTypeEnum.DOUBLE.getType().isEquivalent(rhsType));
        JPrimitiveType promotedType = lhsType == JPrimitiveTypeEnum.DOUBLE.getType() || rhsType == JPrimitiveTypeEnum.DOUBLE.getType() || CommonTypes.isCommonType(CommonTypes.JAVA_LANG_DOUBLE, lhsType) || CommonTypes.isCommonType(CommonTypes.JAVA_LANG_DOUBLE, rhsType) ? JPrimitiveTypeEnum.DOUBLE.getType() : (lhsType == JPrimitiveTypeEnum.FLOAT.getType() || rhsType == JPrimitiveTypeEnum.FLOAT.getType() || CommonTypes.isCommonType(CommonTypes.JAVA_LANG_FLOAT, lhsType) || CommonTypes.isCommonType(CommonTypes.JAVA_LANG_FLOAT, rhsType) ? JPrimitiveTypeEnum.FLOAT.getType() : (lhsType == JPrimitiveTypeEnum.LONG.getType() || rhsType == JPrimitiveTypeEnum.LONG.getType() || CommonTypes.isCommonType(CommonTypes.JAVA_LANG_LONG, lhsType) || CommonTypes.isCommonType(CommonTypes.JAVA_LANG_LONG, rhsType) ? JPrimitiveTypeEnum.LONG.getType() : JPrimitiveTypeEnum.INT.getType()));
        return promotedType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nonnull
    public final JClass getWrapperType() {
        return Jack.getSession().getPhantomLookup().getClass(this.getWrapperCommonType());
    }

    public boolean isWrapperType(@Nonnull JType candidate) {
        return Jack.getSession().getPhantomLookup().getClass(this.getWrapperCommonType()).isSameType(candidate);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JLocal || this.parent instanceof JParameter || this.parent instanceof JMethod || this.parent instanceof JField || this.parent instanceof JCastOperation)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Nonnull
    public abstract JPrimitiveTypeEnum getPrimitiveTypeEnum();

    public boolean isEquivalent(JType type) {
        return this == type || this.isWrapperType(type);
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    @Nonnull
    public JArrayType getArray() {
        return Jack.getSession().getArrayOf(this.getPrimitiveTypeEnum());
    }

    @Nonnull
    abstract CommonTypes.CommonType getWrapperCommonType();

    @Description(value="Java void type")
    public static class JVoidType
    extends JPrimitiveType {
        private JVoidType() {
            super("void");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.VOID;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            throw new AssertionError();
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_VOID;
        }

        @Override
        @Nonnull
        public JArrayType getArray() {
            throw new AssertionError();
        }
    }

    @Description(value="Java short type")
    public static class JShortType
    extends JPrimitiveType
    implements JIntegralType32 {
        private JShortType() {
            super("short");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.SHORT;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JShortLiteral(sourceInfo, 0);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_SHORT;
        }

        @Override
        public boolean isValidValue(int value) {
            return Short.MIN_VALUE <= value && value <= Short.MAX_VALUE;
        }

        @Override
        @Nonnull
        public JShortLiteral createLiteral(@Nonnull SourceInfo sourceInfo, int value) {
            assert (this.isValidValue(value));
            return new JShortLiteral(sourceInfo, (short)value);
        }
    }

    @Description(value="Java long type")
    public static class JLongType
    extends JPrimitiveType
    implements JIntegralType64 {
        private JLongType() {
            super("long");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.LONG;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JLongLiteral(sourceInfo, 0L);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_LONG;
        }
    }

    @Description(value="Java int type")
    public static class JIntType
    extends JPrimitiveType
    implements JIntegralType32 {
        private JIntType() {
            super("int");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.INT;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JIntLiteral(sourceInfo, 0);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_INTEGER;
        }

        @Override
        public boolean isValidValue(int value) {
            return true;
        }

        @Override
        @Nonnull
        public JIntLiteral createLiteral(@Nonnull SourceInfo sourceInfo, int value) {
            return new JIntLiteral(sourceInfo, value);
        }
    }

    @Description(value="Java float type")
    public static class JFloatType
    extends JPrimitiveType
    implements JFloatingPointType {
        private JFloatType() {
            super("float");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.FLOAT;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JFloatLiteral(sourceInfo, 0.0f);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_FLOAT;
        }
    }

    @Description(value="Java double type")
    public static class JDoubleType
    extends JPrimitiveType
    implements JFloatingPointType {
        private JDoubleType() {
            super("double");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.DOUBLE;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JDoubleLiteral(sourceInfo, 0.0);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_DOUBLE;
        }
    }

    @Description(value="Java char type")
    public static class JCharType
    extends JPrimitiveType
    implements JIntegralType32 {
        private JCharType() {
            super("char");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.CHAR;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JCharLiteral(sourceInfo, '\u0000');
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_CHAR;
        }

        @Override
        public boolean isValidValue(int value) {
            return 0 <= value && value <= 65535;
        }

        @Override
        @Nonnull
        public JCharLiteral createLiteral(@Nonnull SourceInfo sourceInfo, int value) {
            assert (this.isValidValue(value));
            return new JCharLiteral(sourceInfo, (char)value);
        }
    }

    @Description(value="Java byte type")
    public static class JByteType
    extends JPrimitiveType
    implements JIntegralType32 {
        private JByteType() {
            super("byte");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.BYTE;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JByteLiteral(sourceInfo, 0);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_BYTE;
        }

        @Override
        public boolean isValidValue(int value) {
            return -128 <= value && value <= 127;
        }

        @Override
        @Nonnull
        public JByteLiteral createLiteral(@Nonnull SourceInfo sourceInfo, int value) {
            assert (this.isValidValue(value));
            return new JByteLiteral(sourceInfo, (byte)value);
        }
    }

    @Description(value="Java boolean type")
    public static class JBooleanType
    extends JPrimitiveType {
        private JBooleanType() {
            super("boolean");
        }

        @Override
        @Nonnull
        public JPrimitiveTypeEnum getPrimitiveTypeEnum() {
            return JPrimitiveTypeEnum.BOOLEAN;
        }

        @Override
        public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
            visitor.visit(this, transformRequest);
        }

        @Override
        @Nonnull
        public JExpression createDefaultValue(@Nonnull SourceInfo sourceInfo) {
            return new JBooleanLiteral(sourceInfo, false);
        }

        @Override
        @Nonnull
        CommonTypes.CommonType getWrapperCommonType() {
            return CommonTypes.JAVA_LANG_BOOLEAN;
        }
    }

    public static enum JPrimitiveTypeEnum {
        BOOLEAN(new JBooleanType()),
        BYTE(new JByteType()),
        CHAR(new JCharType()),
        DOUBLE(new JDoubleType()),
        FLOAT(new JFloatType()),
        INT(new JIntType()),
        LONG(new JLongType()),
        SHORT(new JShortType()),
        VOID(new JVoidType());

        @Nonnull
        private final JPrimitiveType type;

        private JPrimitiveTypeEnum(JPrimitiveType type) {
            this.type = type;
        }

        @Nonnull
        public JPrimitiveType getType() {
            return this.type;
        }
    }
}

