/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.template.utility;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.ext.util.WrapperTemplateModel;
import com.android.jack.freemarker.template.AdapterTemplateModel;
import com.android.jack.freemarker.template.ObjectWrapper;
import com.android.jack.freemarker.template.TemplateBooleanModel;
import com.android.jack.freemarker.template.TemplateCollectionModel;
import com.android.jack.freemarker.template.TemplateDateModel;
import com.android.jack.freemarker.template.TemplateHashModelEx;
import com.android.jack.freemarker.template.TemplateModel;
import com.android.jack.freemarker.template.TemplateModelException;
import com.android.jack.freemarker.template.TemplateModelIterator;
import com.android.jack.freemarker.template.TemplateNumberModel;
import com.android.jack.freemarker.template.TemplateScalarModel;
import com.android.jack.freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.HashMap;

public class DeepUnwrap {
    private static final Class OBJECT_CLASS = Object.class;

    public static Object unwrap(TemplateModel model) throws TemplateModelException {
        return DeepUnwrap.unwrap(model, false);
    }

    public static Object permissiveUnwrap(TemplateModel model) throws TemplateModelException {
        return DeepUnwrap.unwrap(model, true);
    }

    @Deprecated
    public static Object premissiveUnwrap(TemplateModel model) throws TemplateModelException {
        return DeepUnwrap.unwrap(model, true);
    }

    private static Object unwrap(TemplateModel model, boolean permissive) throws TemplateModelException {
        ObjectWrapper wrapper;
        Environment env = Environment.getCurrentEnvironment();
        TemplateModel nullModel = null;
        if (env != null && (wrapper = env.getObjectWrapper()) != null) {
            nullModel = wrapper.wrap(null);
        }
        return DeepUnwrap.unwrap(model, nullModel, permissive);
    }

    private static Object unwrap(TemplateModel model, TemplateModel nullModel, boolean permissive) throws TemplateModelException {
        if (model instanceof AdapterTemplateModel) {
            return ((AdapterTemplateModel)model).getAdaptedObject(OBJECT_CLASS);
        }
        if (model instanceof WrapperTemplateModel) {
            return ((WrapperTemplateModel)model).getWrappedObject();
        }
        if (model == nullModel) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber();
        }
        if (model instanceof TemplateDateModel) {
            return ((TemplateDateModel)model).getAsDate();
        }
        if (model instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model).getAsBoolean();
        }
        if (model instanceof TemplateSequenceModel) {
            TemplateSequenceModel seq = (TemplateSequenceModel)model;
            ArrayList<Object> list = new ArrayList<Object>(seq.size());
            for (int i = 0; i < seq.size(); ++i) {
                list.add(DeepUnwrap.unwrap(seq.get(i), nullModel, permissive));
            }
            return list;
        }
        if (model instanceof TemplateCollectionModel) {
            TemplateCollectionModel coll = (TemplateCollectionModel)model;
            ArrayList<Object> list = new ArrayList<Object>();
            TemplateModelIterator it = coll.iterator();
            while (it.hasNext()) {
                list.add(DeepUnwrap.unwrap(it.next(), nullModel, permissive));
            }
            return list;
        }
        if (model instanceof TemplateHashModelEx) {
            TemplateHashModelEx hash = (TemplateHashModelEx)model;
            HashMap<String, Object> map = new HashMap<String, Object>();
            TemplateModelIterator keys = hash.keys().iterator();
            while (keys.hasNext()) {
                String key = (String)DeepUnwrap.unwrap(keys.next(), nullModel, permissive);
                map.put(key, DeepUnwrap.unwrap(hash.get(key), nullModel, permissive));
            }
            return map;
        }
        if (permissive) {
            return model;
        }
        throw new TemplateModelException("Cannot deep-unwrap model of type " + model.getClass().getName());
    }
}

