/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.backend.dex.AnnotationBuilder;
import com.android.jack.backend.dex.annotations.AnnotationMethodDefaultValue;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.rop.annotation.Annotations;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.Collection;
import javax.annotation.Nonnull;

@Description(value="Builds the rop annotations of a JDeclaredType.")
@Constraint(need={ClassDefItemMarker.class}, no={AnnotationMethodDefaultValue.class})
@Transform(add={ClassDefItemMarker.ClassAnnotation.class}, modify={ClassDefItemMarker.class})
@Use(value={AnnotationBuilder.class})
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(no={JAnnotation.RepeatedAnnotation.class})})})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class ClassAnnotationBuilder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface declaredType) {
        Annotations classAnnotations;
        Collection<JAnnotation> annotations = declaredType.getAnnotations();
        if (!annotations.isEmpty() && (classAnnotations = new AnnotationBuilder().createAnnotations(annotations)).size() > 0) {
            ClassDefItemMarker marker = declaredType.getMarker(ClassDefItemMarker.class);
            assert (marker != null);
            ClassDefItem item = marker.getClassDefItem();
            item.setClassAnnotations(classAnnotations);
        }
    }
}

