/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.api.v01.impl;

import com.android.jack.Options;
import com.android.jack.api.impl.ApiFeature;
import com.android.jack.api.impl.JackConfigImpl;
import com.android.jack.api.v01.Cli01CompilationTask;
import com.android.jack.api.v01.Cli01Config;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.impl.Cli01CompilationTaskImpl;
import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.ParserProperties;
import com.android.sched.util.config.cli.TokenIterator;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.NoLocation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class Cli01ConfigImpl
implements Cli01Config,
JackConfigImpl {
    @Nonnull
    private PrintStream standardOutput = System.out;
    @Nonnull
    private PrintStream standardError = System.err;
    @Nonnull
    private File workingDirectory = new File(".");

    @Override
    @Nonnull
    public Cli01CompilationTask getTask(@Nonnull String[] args) throws ConfigurationException {
        Options options = new Options();
        options.setWorkingDirectory(this.workingDirectory);
        options.setStandardError(this.standardError);
        options.setStandardOutput(this.standardOutput);
        try {
            TokenIterator iterator = new TokenIterator(new NoLocation(), args);
            iterator = iterator.withFileRelativeTo(this.workingDirectory);
            ArrayList<String> list = new ArrayList<String>();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            CmdLineParser parser = new CmdLineParser(options, ParserProperties.defaults().withUsageWidth(100));
            parser.parseArgument(list);
            parser.stopOptionParsing();
        }
        catch (CmdLineException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (CannotReadException | NoSuchFileException | NotFileOrDirectoryException | WrongPermissionException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        return new Cli01CompilationTaskImpl(this, options, args);
    }

    @Override
    public void setStandardError(@Nonnull PrintStream standardError) {
        this.standardError = standardError;
    }

    @Nonnull
    public PrintStream getStandardError() {
        return this.standardError;
    }

    @Override
    public void setStandardOutput(@Nonnull PrintStream standardOutput) {
        this.standardOutput = standardOutput;
    }

    @Nonnull
    public PrintStream getStandardOutput() {
        return this.standardOutput;
    }

    @Override
    public void setWorkingDirectory(@Nonnull File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Nonnull
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setApi(Class<? extends ApiFeature> api) {
    }
}

