/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader.io;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.reader.io.DataIn;
import java.io.DataInput;
import java.io.IOException;
import java.util.Stack;

public abstract class DataInputDataIn
implements DataIn {
    protected DataInput in;
    private boolean isLE;
    private Stack<Integer> stack = new Stack();

    public DataInputDataIn(DataInput in, boolean isLE) {
        this.in = in;
        this.isLE = isLE;
    }

    @Override
    public void pop() {
        this.move(this.stack.pop());
    }

    @Override
    public void push() {
        this.stack.push(this.getCurrentPosition());
    }

    @Override
    public void pushMove(int absOffset) {
        this.push();
        this.move(absOffset);
    }

    @Override
    public int readByte() {
        try {
            return this.in.readByte();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public byte[] readBytes(int size) {
        byte[] data = new byte[size];
        try {
            this.in.readFully(data);
        }
        catch (IOException e) {
            throw new DexException(e);
        }
        return data;
    }

    @Override
    public int readIntx() {
        return this.readUIntx();
    }

    @Override
    public long readLeb128() {
        int inp;
        int bitpos = 0;
        long vln = 0L;
        do {
            inp = this.readUByte();
            vln |= (long)(inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & vln) != 0L) {
            vln -= 1L << bitpos;
        }
        return vln;
    }

    @Override
    public int readShortx() {
        try {
            return this.in.readShort();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public int readUByte() {
        try {
            return this.in.readUnsignedByte();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public int readUIntx() {
        if (this.isLE) {
            return this.readUByte() | this.readUByte() << 8 | this.readUByte() << 16 | this.readUByte() << 24;
        }
        return this.readUByte() << 24 | this.readUByte() << 16 | this.readUByte() << 8 | this.readUByte();
    }

    @Override
    public long readULeb128() {
        long value = 0L;
        int count = 0;
        int b = this.readUByte();
        while ((b & 0x80) != 0) {
            value |= (long)((b & 0x7F) << count);
            count += 7;
            b = this.readUByte();
        }
        return value |= (long)((b & 0x7F) << count);
    }

    @Override
    public int readUShortx() {
        if (this.isLE) {
            return this.readUByte() | this.readUByte() << 8;
        }
        return this.readUByte() << 8 | this.readUByte();
    }

    @Override
    public void skip(int bytes) {
        try {
            this.in.skipBytes(bytes);
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }
}

