/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodes;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.DexDebugInfoReader;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.DexOpcodeAdapter;
import com.googlecode.dex2jar.reader.OpcodeFormat;
import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class DexCodeReader
implements DexOpcodes {
    private DexFileReader dex;
    private DataIn in;
    Map<Integer, DexLabel> labels = new TreeMap<Integer, DexLabel>();
    private boolean isStatic;
    private Method method;

    DexCodeReader(DexFileReader dex, DataIn in, boolean isStatic, Method method) {
        this.dex = dex;
        this.in = in;
        this.method = method;
        this.isStatic = isStatic;
    }

    private void findLabels(DataIn in, int instruction_size) {
        int baseOffset = in.getCurrentPosition();
        this.fixIssue130(in, instruction_size);
        int currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        while (currentOffset < instruction_size) {
            int opcode = in.readUShortx();
            int uOpcodeH = opcode >> 8;
            int uOpcodeL = opcode & 0xFF;
            if (uOpcodeL != 255) {
                opcode = uOpcodeL;
            }
            OpcodeFormat format = OpcodeFormat.get(opcode, this.dex.apiLevel);
            try {
                block2 : switch (opcode) {
                    case 40: {
                        this.order(currentOffset + (byte)uOpcodeH);
                        break;
                    }
                    case 41: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: {
                        this.order(currentOffset + in.readShortx());
                        break;
                    }
                    case 42: {
                        this.order(currentOffset + DexCodeReader.xInt(in));
                        break;
                    }
                    case 43: 
                    case 44: {
                        int offset = DexCodeReader.xInt(in);
                        in.push();
                        try {
                            in.skip((offset - 3) * 2);
                            switch (opcode) {
                                case 44: {
                                    in.skip(2);
                                    int switch_size = in.readUShortx();
                                    in.skip(4 * switch_size);
                                    int j = 0;
                                    while (j < switch_size) {
                                        this.order(currentOffset + in.readIntx());
                                        ++j;
                                    }
                                    this.order(currentOffset + 3);
                                    break;
                                }
                                case 43: {
                                    in.skip(2);
                                    int switch_size = in.readUShortx();
                                    in.skip(4);
                                    int j = 0;
                                    while (j < switch_size) {
                                        int targetOffset = in.readIntx();
                                        this.order(currentOffset + targetOffset);
                                        ++j;
                                    }
                                    this.order(currentOffset + 3);
                                }
                            }
                            break;
                        }
                        finally {
                            in.pop();
                        }
                    }
                    case 0: {
                        switch (uOpcodeH) {
                            case 0: {
                                break block2;
                            }
                            case 1: {
                                int switch_size = in.readUShortx();
                                in.skip(switch_size * 4 + 4);
                                break block2;
                            }
                            case 2: {
                                int switch_size = in.readUShortx();
                                in.skip(switch_size * 8);
                                break block2;
                            }
                            case 3: {
                                int element_width = in.readUShortx();
                                int size = in.readUIntx();
                                in.skip(size * element_width + 1 & 0xFFFFFFFE);
                            }
                        }
                        break;
                    }
                    default: {
                        in.skip(2 * format.getSize() - 2);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new DexException(e, String.format("while scan for label, Posotion :%04x", currentOffset), new Object[0]);
            }
            currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        }
    }

    private void fixIssue130(DataIn in, int instruction_size) {
        if (instruction_size < 4) {
            return;
        }
        int base = in.getCurrentPosition();
        int opcode = in.readUShortx();
        int uOpcodeH = opcode >> 8;
        int uOpcodeL = opcode & 0xFF;
        if (uOpcodeL != 255) {
            opcode = uOpcodeL;
        }
        if (opcode == 50 && (uOpcodeH & 0xF) == uOpcodeH >> 4) {
            int offset = in.readShortx();
            in.skip(offset * 2 - 4);
        } else {
            in.move(base);
        }
    }

    private void findTryCatch(DataIn in, DexCodeVisitor dcv, int tries_size, int insn_size) {
        int encoded_catch_handler_list = in.getCurrentPosition() + tries_size * 8;
        int i = 0;
        while (i < tries_size) {
            int start_addr = in.readUIntx();
            int insn_count = in.readUShortx();
            int handler_offset = in.readUShortx();
            if (start_addr <= insn_size) {
                this.order(start_addr);
                int end = start_addr + insn_count;
                this.order(end);
                in.pushMove(encoded_catch_handler_list + handler_offset);
                try {
                    int listSize;
                    boolean catchAll = false;
                    int handlerCount = listSize = (int)in.readLeb128();
                    if (listSize <= 0) {
                        listSize = -listSize;
                        handlerCount = listSize + 1;
                        catchAll = true;
                    }
                    DexLabel[] labels = new DexLabel[handlerCount];
                    String[] types = new String[handlerCount];
                    int k = 0;
                    while (k < listSize) {
                        int type_id = (int)in.readULeb128();
                        int handler = (int)in.readULeb128();
                        this.order(handler);
                        types[k] = this.dex.getType(type_id);
                        labels[k] = this.labels.get(handler);
                        ++k;
                    }
                    if (catchAll) {
                        int handler = (int)in.readULeb128();
                        this.order(handler);
                        labels[listSize] = this.labels.get(handler);
                    }
                    dcv.visitTryCatch(this.labels.get(start_addr), this.labels.get(end), labels, types);
                }
                finally {
                    in.pop();
                }
            }
            ++i;
        }
    }

    public void accept(DexCodeVisitor dcv, int config) {
        int args_index;
        int[] args;
        DataIn in = this.in;
        int total_registers_size = in.readUShortx();
        int in_register_size = in.readUShortx();
        in.skip(2);
        int tries_size = in.readUShortx();
        int debug_off = in.readUIntx();
        int instruction_size = in.readUIntx();
        DexDebugInfoReader.LocalVariable[] localVariables = new DexDebugInfoReader.LocalVariable[total_registers_size];
        int i = total_registers_size - in_register_size;
        String[] parameterTypes = this.method.getParameterTypes();
        if (!this.isStatic) {
            args = new int[parameterTypes.length + 1];
            localVariables[i] = new DexDebugInfoReader.LocalVariable(i, 0, -1, "this", this.method.getOwner(), null);
            args[0] = i++;
            args_index = 1;
        } else {
            args = new int[parameterTypes.length];
            args_index = 0;
        }
        String[] stringArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            localVariables[i] = new DexDebugInfoReader.LocalVariable(i, 0, -1, "arg" + args_index, type, null);
            args[args_index++] = i++;
            if ("D".equals(type) || "J".equals(type)) {
                ++i;
            }
            ++n2;
        }
        dcv.visitArguments(total_registers_size, args);
        if (tries_size > 0) {
            in.push();
            try {
                in.skip(instruction_size * 2);
                if ((instruction_size & 1) != 0) {
                    in.skip(2);
                }
                this.findTryCatch(in, dcv, tries_size, instruction_size);
            }
            finally {
                in.pop();
            }
        }
        if (debug_off != 0 && (config & 1) == 0) {
            in.pushMove(debug_off);
            try {
                new DexDebugInfoReader(in, this.dex, instruction_size, this, localVariables, args).accept(dcv);
            }
            finally {
                in.pop();
            }
        }
        in.push();
        try {
            this.findLabels(in, instruction_size);
        }
        finally {
            in.pop();
        }
        DexOpcodeAdapter n3 = new DexOpcodeAdapter(this.dex, this.labels, dcv);
        this.acceptInsn(in, instruction_size, n3);
        dcv.visitEnd();
    }

    private void acceptInsn(DataIn in, int instruction_size, DexOpcodeAdapter n) {
        Iterator<Integer> labelOffsetIterator = this.labels.keySet().iterator();
        Integer nextLabelOffset = labelOffsetIterator.hasNext() ? labelOffsetIterator.next() : null;
        int baseOffset = in.getCurrentPosition();
        this.fixIssue130(in, instruction_size);
        int currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        while (currentOffset < instruction_size) {
            boolean currentOffsetVisited = false;
            while (nextLabelOffset != null) {
                int _intNextLabelOffset = nextLabelOffset;
                if (_intNextLabelOffset > currentOffset) break;
                if (_intNextLabelOffset == currentOffset) {
                    currentOffsetVisited = true;
                    n.offset(currentOffset);
                    nextLabelOffset = labelOffsetIterator.hasNext() ? labelOffsetIterator.next() : null;
                    break;
                }
                n.offset(_intNextLabelOffset);
                Integer n2 = nextLabelOffset = labelOffsetIterator.hasNext() ? labelOffsetIterator.next() : null;
            }
            if (!currentOffsetVisited) {
                n.offset(currentOffset);
            }
            int opcode = in.readUShortx();
            int uOpcodeH = opcode >> 8;
            int uOpcodeL = opcode & 0xFF;
            if (uOpcodeL != 255) {
                opcode = uOpcodeL;
            }
            OpcodeFormat format = OpcodeFormat.get(opcode, this.dex.apiLevel);
            block1 : switch (format) {
                case F10t: {
                    n.x0t(opcode, (byte)uOpcodeH);
                    break;
                }
                case F10x: {
                    block39 : switch (opcode) {
                        case 0: {
                            switch (uOpcodeH) {
                                case 0: {
                                    break block39;
                                }
                                case 1: {
                                    int switch_size = in.readUShortx();
                                    in.skip(switch_size * 4 + 4);
                                    break block39;
                                }
                                case 2: {
                                    int switch_size = in.readUShortx();
                                    in.skip(switch_size * 8);
                                    break block39;
                                }
                                case 3: {
                                    int element_width = in.readUShortx();
                                    int size = in.readUIntx();
                                    in.skip(size * element_width + 1 & 0xFFFFFFFE);
                                }
                            }
                        }
                    }
                    n.x0x(opcode);
                    break;
                }
                case F11n: {
                    byte VV = (byte)uOpcodeH;
                    int B = VV >> 4;
                    n.x1n(opcode, VV & 0xF, B);
                    break;
                }
                case F11x: {
                    n.x1x(opcode, uOpcodeH);
                    break;
                }
                case F12x: {
                    n.x2x(opcode, uOpcodeH & 0xF, uOpcodeH >> 4);
                    break;
                }
                case F20bc: {
                    n.x0bc(opcode, uOpcodeH, in.readUShortx());
                    break;
                }
                case F20t: {
                    n.x0t(opcode, in.readShortx());
                    break;
                }
                case F21c: {
                    n.x1c(opcode, uOpcodeH, in.readUShortx());
                    break;
                }
                case F21h: {
                    n.x1h(opcode, uOpcodeH, in.readShortx());
                    break;
                }
                case F21s: {
                    n.x1s(opcode, uOpcodeH, in.readShortx());
                    break;
                }
                case F21t: {
                    n.x1t(opcode, uOpcodeH, in.readShortx());
                    break;
                }
                case F22b: {
                    int tmp = in.readShortx();
                    n.x2b(opcode, uOpcodeH, tmp & 0xFF, tmp >> 8);
                    break;
                }
                case F22c: {
                    n.x2c(opcode, uOpcodeH & 0xF, uOpcodeH >> 4, in.readUShortx());
                    break;
                }
                case F22cs: {
                    n.x2cs(opcode, uOpcodeH & 0xF, uOpcodeH >> 4, in.readUShortx());
                    break;
                }
                case F22s: {
                    n.x2s(opcode, uOpcodeH & 0xF, uOpcodeH >> 4, in.readShortx());
                    break;
                }
                case F22t: {
                    n.x2t(opcode, uOpcodeH & 0xF, uOpcodeH >> 4, in.readShortx());
                    break;
                }
                case F22x: {
                    n.x2x(opcode, uOpcodeH, in.readUShortx());
                    break;
                }
                case F23x: {
                    int tmp = in.readUShortx();
                    n.x3x(opcode, uOpcodeH, tmp & 0xFF, tmp >> 8);
                    break;
                }
                case F30t: {
                    n.x0t(opcode, DexCodeReader.xUint(in));
                    break;
                }
                case F31c: {
                    n.x1c(opcode, uOpcodeH, DexCodeReader.xUint(in));
                    break;
                }
                case F31i: {
                    n.x1i(opcode, uOpcodeH, DexCodeReader.xInt(in));
                    break;
                }
                case F31t: {
                    int BBBBBBBB = DexCodeReader.xInt(in);
                    switch (opcode) {
                        case 38: 
                        case 43: 
                        case 44: {
                            in.push();
                            try {
                                in.skip((BBBBBBBB - 3) * 2);
                                switch (opcode) {
                                    case 44: {
                                        in.skip(2);
                                        int switch_size = in.readUShortx();
                                        int[] cases = new int[switch_size];
                                        int[] label = new int[switch_size];
                                        int j = 0;
                                        while (j < switch_size) {
                                            cases[j] = in.readIntx();
                                            ++j;
                                        }
                                        j = 0;
                                        while (j < switch_size) {
                                            label[j] = in.readIntx();
                                            ++j;
                                        }
                                        n.visitLookupSwitchStmt(opcode, uOpcodeH, 3, cases, label);
                                        break;
                                    }
                                    case 43: {
                                        in.skip(2);
                                        int switch_size = in.readUShortx();
                                        int first_case = in.readIntx();
                                        int last_case = first_case - 1 + switch_size;
                                        int[] _labels = new int[switch_size];
                                        int j = 0;
                                        while (j < switch_size) {
                                            int targetOffset;
                                            _labels[j] = targetOffset = in.readIntx();
                                            ++j;
                                        }
                                        n.visitTableSwitchStmt(opcode, uOpcodeH, 3, first_case, last_case, _labels);
                                        break;
                                    }
                                    case 38: {
                                        in.skip(2);
                                        int elemWidth = in.readUShortx();
                                        int initLength = in.readUIntx();
                                        Object[] values = new Object[initLength];
                                        switch (elemWidth) {
                                            case 1: {
                                                int j = 0;
                                                while (j < initLength) {
                                                    values[j] = (byte)in.readByte();
                                                    ++j;
                                                }
                                                break;
                                            }
                                            case 2: {
                                                int j = 0;
                                                while (j < initLength) {
                                                    values[j] = (short)in.readShortx();
                                                    ++j;
                                                }
                                                break;
                                            }
                                            case 4: {
                                                int j = 0;
                                                while (j < initLength) {
                                                    values[j] = in.readIntx();
                                                    ++j;
                                                }
                                                break;
                                            }
                                            case 8: {
                                                int j = 0;
                                                while (j < initLength) {
                                                    values[j] = (long)in.readIntx() & 0xFFFFFFFFL | (long)in.readIntx() << 32;
                                                    ++j;
                                                }
                                                break;
                                            }
                                        }
                                        n.visitFillArrayStmt(opcode, uOpcodeH, elemWidth, initLength, values);
                                    }
                                }
                                break block1;
                            }
                            finally {
                                in.pop();
                            }
                        }
                    }
                    n.x1t(opcode, uOpcodeH, BBBBBBBB);
                    break;
                }
                case F32s: {
                    n.x2s(opcode, uOpcodeH, in.readUByte(), in.readShortx());
                    break;
                }
                case F32x: {
                    n.x2x(opcode, in.readUShortx(), in.readUShortx());
                    break;
                }
                case F33x: {
                    int tmp = in.readUShortx();
                    n.x3x(opcode, tmp & 0xFF, tmp >> 8, in.readUShortx());
                    break;
                }
                case F35c: {
                    int g = uOpcodeH & 0xF;
                    int a = uOpcodeH >> 4;
                    int bbbb = in.readUShortx();
                    int vvvv = in.readUShortx();
                    int c = vvvv & 0xF;
                    int d = vvvv >> 4 & 0xF;
                    int e = vvvv >> 8 & 0xF;
                    int f = vvvv >> 12;
                    n.x5c(opcode, a, c, d, e, f, g, bbbb);
                    break;
                }
                case F35mi: {
                    int g = uOpcodeH & 0xF;
                    int a = uOpcodeH >> 4;
                    int bbbb = in.readUShortx();
                    int vvvv = in.readUShortx();
                    int c = vvvv & 0xF;
                    int d = vvvv >> 4 & 0xF;
                    int e = vvvv >> 8 & 0xF;
                    int f = vvvv >> 12;
                    n.x5mi(opcode, a, c, d, e, f, g, bbbb);
                    break;
                }
                case F35ms: {
                    int g = uOpcodeH & 0xF;
                    int a = uOpcodeH >> 4;
                    int bbbb = in.readUShortx();
                    int vvvv = in.readUShortx();
                    int c = vvvv & 0xF;
                    int d = vvvv >> 4 & 0xF;
                    int e = vvvv >> 8 & 0xF;
                    int f = vvvv >> 12;
                    n.x5ms(opcode, a, c, d, e, f, g, bbbb);
                    break;
                }
                case F3rc: {
                    n.xrc(opcode, uOpcodeH, in.readUShortx(), in.readUShortx());
                    break;
                }
                case F3rmi: {
                    n.xrmi(opcode, uOpcodeH, in.readUShortx(), in.readUShortx());
                    break;
                }
                case F3rms: {
                    n.xrms(opcode, uOpcodeH, in.readUShortx(), in.readUShortx());
                    break;
                }
                case F40sc: {
                    int bbbb_bbbb = DexCodeReader.xUint(in);
                    int aaaa = in.readUShortx();
                    n.x0sc(opcode, aaaa, bbbb_bbbb);
                    break;
                }
                case F41c: {
                    int bbbb_bbbb = DexCodeReader.xUint(in);
                    int aaaa = in.readUShortx();
                    n.x1c(opcode, aaaa, bbbb_bbbb);
                    break;
                }
                case F51l: {
                    n.x1l(opcode, uOpcodeH, DexCodeReader.xLong(in));
                    break;
                }
                case F52c: {
                    int cccc_cccc = DexCodeReader.xUint(in);
                    int aaaa = in.readUShortx();
                    int bbbb = in.readUShortx();
                    n.x2c(opcode, aaaa, bbbb, cccc_cccc);
                    break;
                }
                case F5rc: {
                    int bbbb_bbbb = DexCodeReader.xUint(in);
                    int aaaa = in.readUShortx();
                    int cccc = in.readUShortx();
                    n.xrc(opcode, aaaa, bbbb_bbbb, cccc);
                }
            }
            currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        }
        while (nextLabelOffset != null) {
            n.offset(nextLabelOffset);
            if (!labelOffsetIterator.hasNext()) break;
            nextLabelOffset = labelOffsetIterator.next();
        }
    }

    private static long xLong(DataIn in) {
        long rs = in.readUShortx();
        rs |= (long)in.readUShortx() << 16;
        rs |= (long)in.readUShortx() << 32;
        return rs |= (long)in.readUShortx() << 48;
    }

    private static int xInt(DataIn in) {
        return in.readUShortx() | in.readUShortx() << 16;
    }

    private static int xUint(DataIn in) {
        return in.readUShortx() | in.readUShortx() << 16;
    }

    void order(int offset) {
        if (!this.labels.containsKey(offset)) {
            this.labels.put(offset, new DexLabel(offset));
        }
    }
}

