/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.DexType;
import com.googlecode.dex2jar.reader.Annotation;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.io.DataIn;

class Constant {
    private static final int VALUE_BYTE = 0;
    private static final int VALUE_SHORT = 2;
    private static final int VALUE_CHAR = 3;
    private static final int VALUE_INT = 4;
    private static final int VALUE_LONG = 6;
    private static final int VALUE_FLOAT = 16;
    private static final int VALUE_DOUBLE = 17;
    private static final int VALUE_STRING = 23;
    private static final int VALUE_TYPE = 24;
    private static final int VALUE_FIELD = 25;
    private static final int VALUE_METHOD = 26;
    private static final int VALUE_ENUM = 27;
    private static final int VALUE_ARRAY = 28;
    private static final int VALUE_ANNOTATION = 29;
    private static final int VALUE_NULL = 30;
    private static final int VALUE_BOOLEAN = 31;

    Constant() {
    }

    public static Object ReadConstant(DexFileReader dex, DataIn in) {
        int b = in.readUByte();
        int type = b & 0x1F;
        switch (type) {
            case 0: {
                return new Byte((byte)Constant.readIntBits(in, b));
            }
            case 2: {
                return new Short((short)Constant.readIntBits(in, b));
            }
            case 4: {
                return new Integer((int)Constant.readIntBits(in, b));
            }
            case 6: {
                return new Long(Constant.readIntBits(in, b));
            }
            case 3: {
                return new Character((char)Constant.readUIntBits(in, b));
            }
            case 23: {
                return dex.getString((int)Constant.readUIntBits(in, b));
            }
            case 16: {
                return Float.valueOf(Float.intBitsToFloat((int)(Constant.readFloatBits(in, b) >> 32)));
            }
            case 17: {
                return Double.longBitsToDouble(Constant.readFloatBits(in, b));
            }
            case 30: {
                return null;
            }
            case 31: {
                return new Boolean((b >> 5 & 3) != 0);
            }
            case 24: {
                int type_id = (int)Constant.readUIntBits(in, b);
                return new DexType(dex.getType(type_id));
            }
            case 27: {
                return dex.getField((int)Constant.readUIntBits(in, b));
            }
            case 26: {
                int method_id = (int)Constant.readUIntBits(in, b);
                return dex.getMethod(method_id);
            }
            case 25: {
                int field_id = (int)Constant.readUIntBits(in, b);
                return dex.getField(field_id);
            }
            case 28: {
                int size = (int)in.readULeb128();
                Object[] array = new Object[size];
                int i = 0;
                while (i < size) {
                    array[i] = Constant.ReadConstant(dex, in);
                    ++i;
                }
                return array;
            }
            case 29: {
                int _type = (int)in.readULeb128();
                String _typeString = dex.getType(_type);
                int size = (int)in.readULeb128();
                Annotation ann = new Annotation(_typeString, true);
                int i = 0;
                while (i < size) {
                    int nameid = (int)in.readULeb128();
                    String nameString = dex.getString(nameid);
                    Object o = Constant.ReadConstant(dex, in);
                    ann.items.add(new Annotation.Item(nameString, o));
                    ++i;
                }
                return ann;
            }
        }
        throw new DexException("Not support yet.");
    }

    public static long readIntBits(DataIn in, int before) {
        int length = (before >> 5 & 7) + 1;
        long value = 0L;
        int j = 0;
        while (j < length) {
            value |= (long)in.readUByte() << j * 8;
            ++j;
        }
        int shift = (8 - length) * 8;
        return value << shift >> shift;
    }

    public static long readUIntBits(DataIn in, int before) {
        int length = (before >> 5 & 7) + 1;
        long value = 0L;
        int j = 0;
        while (j < length) {
            value |= (long)in.readUByte() << j * 8;
            ++j;
        }
        return value;
    }

    public static long readFloatBits(DataIn in, int before) {
        int bytes = (before >> 5 & 7) + 1;
        long result = 0L;
        int i = 0;
        while (i < bytes) {
            result |= (long)in.readUByte() << i * 8;
            ++i;
        }
        return result <<= (8 - bytes) * 8;
    }
}

