/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.TypeAnalyze;
import java.util.List;
import org.objectweb.asm.Type;

public class LocalType
implements Transformer {
    public static Type typeOf(Value local) {
        return local.typeRef == null ? null : local.typeRef.get();
    }

    @Override
    public void transform(IrMethod irMethod) {
        TypeAnalyze ta = new TypeAnalyze(irMethod);
        List<TypeAnalyze.DefTypeRef> refs = ta.analyze();
        for (TypeAnalyze.DefTypeRef ref : refs) {
            Type type = null;
            if (ref.providerAs.size() > 0) {
                type = ref.providerAs.iterator().next();
            }
            if (ref.useAs.size() > 0) {
                Type useType = ref.useAs.iterator().next();
                if (type == null) {
                    type = useType;
                } else {
                    switch (useType.getSort()) {
                        case 9: 
                        case 10: {
                            if (type.getSort() == 9) break;
                            type = useType;
                            break;
                        }
                        case 6: 
                        case 8: {
                            type = useType;
                        }
                    }
                }
            }
            if (type == null) {
                System.err.println(ref);
                continue;
            }
            ref.type = type;
            if (ref.value.vt == Value.VT.CONSTANT) {
                Constant cst = (Constant)ref.value;
                switch (type.getSort()) {
                    case 9: 
                    case 10: {
                        if (!Integer.valueOf(0).equals(cst.value)) break;
                        cst.value = Constant.Null;
                        break;
                    }
                    case 6: {
                        if (cst.value instanceof Float) break;
                        cst.value = Float.valueOf(Float.intBitsToFloat(((Number)cst.value).intValue()));
                        break;
                    }
                    case 8: {
                        if (cst.value instanceof Double) break;
                        cst.value = Double.longBitsToDouble(((Number)cst.value).longValue());
                    }
                }
            }
            ref.arrayValues = null;
            ref.arryRoots = null;
            ref.froms = null;
            ref.tos = null;
            ref.providerAs = null;
            ref.tos = null;
            ref.useAs = null;
            ref.value = null;
            ref.sameValues = null;
        }
    }
}

