/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicates;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IntroduceOuterClassReferencesTransform
extends ContextTrackingVisitor<Void> {
    private final List<AstNode> _nodesToRemove = new ArrayList<AstNode>();
    private final Set<String> _outerClassFields;
    private final Set<ParameterReference> _parametersToRemove = new HashSet<ParameterReference>();

    public IntroduceOuterClassReferencesTransform(DecompilerContext context) {
        super(context);
        this._outerClassFields = new HashSet<String>();
    }

    @Override
    public void run(AstNode compilationUnit) {
        new PhaseOneVisitor().run(compilationUnit);
        super.run(compilationUnit);
        for (AstNode node : this._nodesToRemove) {
            node.remove();
        }
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, Void data) {
        super.visitInvocationExpression(node, data);
        Expression target = node.getTarget();
        AstNodeCollection<Expression> arguments = node.getArguments();
        if (target instanceof MemberReferenceExpression && arguments.size() == 1) {
            TypeDefinition declaringType;
            MethodDefinition resolvedMethod;
            MethodReference method;
            MemberReferenceExpression memberReference = (MemberReferenceExpression)target;
            MemberReference reference = memberReference.getUserData(Keys.MEMBER_REFERENCE);
            if (reference == null) {
                reference = node.getUserData(Keys.MEMBER_REFERENCE);
            }
            if (reference instanceof MethodReference && (method = (MethodReference)reference).isConstructor() && (resolvedMethod = method.resolve()) != null && ((declaringType = resolvedMethod.getDeclaringType()).isInnerClass() || declaringType.isLocalClass())) {
                for (ParameterDefinition p : resolvedMethod.getParameters()) {
                    int parameterIndex;
                    Expression argumentToRemove;
                    if (!this._parametersToRemove.contains(p) || (argumentToRemove = CollectionUtilities.getOrDefault(arguments, parameterIndex = p.getPosition())) == null) continue;
                    this._nodesToRemove.add(argumentToRemove);
                }
            }
        }
        return null;
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void data) {
        this.tryIntroduceOuterClassReference(node, node.getTarget() instanceof ThisReferenceExpression);
        return (Void)super.visitMemberReferenceExpression(node, data);
    }

    private boolean tryIntroduceOuterClassReference(MemberReferenceExpression node, boolean hasThisOnLeft) {
        SimpleType outerType;
        FieldDefinition resolvedField;
        FieldReference field;
        TypeDefinition currentType = this.context.getCurrentType();
        if (!currentType.isInnerClass()) {
            return false;
        }
        MemberReference reference = node.getUserData(Keys.MEMBER_REFERENCE);
        if (reference instanceof FieldReference) {
            field = (FieldReference)reference;
            resolvedField = field.resolve();
        } else {
            field = null;
            resolvedField = null;
        }
        if (resolvedField != null && !this._outerClassFields.contains(resolvedField.getFullName())) {
            return false;
        }
        if (!hasThisOnLeft || currentType.isStatic() || node.getParent() instanceof AssignmentExpression && node.getRole() == AssignmentExpression.LEFT_ROLE || resolvedField == null || !resolvedField.isSynthetic()) {
            return this.tryInsertOuterClassReference(node, reference);
        }
        if (node.getParent() instanceof MemberReferenceExpression && this.tryIntroduceOuterClassReference((MemberReferenceExpression)node.getParent(), hasThisOnLeft)) {
            return true;
        }
        TypeReference outerTypeReference = field.getFieldType();
        TypeDefinition resolvedOuterType = outerTypeReference.resolve();
        if (resolvedOuterType != null && resolvedOuterType.isAnonymous()) {
            if (resolvedOuterType.getExplicitInterfaces().isEmpty()) {
                outerType = new SimpleType(resolvedOuterType.getBaseType().getSimpleName());
                outerType.putUserData(Keys.ANONYMOUS_BASE_TYPE_REFERENCE, resolvedOuterType.getBaseType());
            } else {
                outerType = new SimpleType(resolvedOuterType.getExplicitInterfaces().get(0).getSimpleName());
                outerType.putUserData(Keys.ANONYMOUS_BASE_TYPE_REFERENCE, resolvedOuterType.getExplicitInterfaces().get(0));
            }
        } else {
            outerType = resolvedOuterType != null ? new SimpleType(resolvedOuterType.getSimpleName()) : new SimpleType(outerTypeReference.getSimpleName());
        }
        outerType.putUserData(Keys.TYPE_REFERENCE, outerTypeReference);
        ThisReferenceExpression replacement = new ThisReferenceExpression(node.getOffset());
        replacement.setTarget(new TypeReferenceExpression(node.getOffset(), outerType));
        replacement.putUserData(Keys.TYPE_REFERENCE, outerTypeReference);
        node.replaceWith(replacement);
        return true;
    }

    @Override
    public Void visitIdentifierExpression(IdentifierExpression node, Void data) {
        Variable variable = node.getUserData(Keys.VARIABLE);
        if (variable != null && variable.isParameter() && this._parametersToRemove.contains(variable.getOriginalParameter())) {
            TypeReference parameterType = variable.getOriginalParameter().getParameterType();
            if (!MetadataResolver.areEquivalent(this.context.getCurrentType(), parameterType) && this.isContextWithinTypeInstance(parameterType)) {
                TypeDefinition resolvedType = parameterType.resolve();
                TypeReference declaredType = resolvedType != null && resolvedType.isAnonymous() ? (resolvedType.getExplicitInterfaces().isEmpty() ? resolvedType.getBaseType() : resolvedType.getExplicitInterfaces().get(0)) : parameterType;
                SimpleType outerType = new SimpleType(declaredType.getSimpleName());
                outerType.putUserData(Keys.TYPE_REFERENCE, declaredType);
                ThisReferenceExpression thisReference = new ThisReferenceExpression(node.getOffset());
                thisReference.setTarget(new TypeReferenceExpression(node.getOffset(), outerType));
                node.replaceWith(thisReference);
                return null;
            }
        }
        return (Void)super.visitIdentifierExpression(node, data);
    }

    private boolean tryInsertOuterClassReference(MemberReferenceExpression node, MemberReference reference) {
        if (node == null || reference == null) {
            return false;
        }
        if (!(node.getTarget() instanceof ThisReferenceExpression)) {
            return false;
        }
        if (!node.getChildByRole(Roles.TARGET_EXPRESSION).isNull()) {
            return false;
        }
        TypeReference declaringType = reference.getDeclaringType();
        if (MetadataResolver.areEquivalent(this.context.getCurrentType(), declaringType) || !this.isContextWithinTypeInstance(declaringType)) {
            return false;
        }
        TypeDefinition resolvedType = declaringType.resolve();
        TypeReference declaredType = resolvedType != null && resolvedType.isAnonymous() ? (resolvedType.getExplicitInterfaces().isEmpty() ? resolvedType.getBaseType() : resolvedType.getExplicitInterfaces().get(0)) : declaringType;
        SimpleType outerType = new SimpleType(declaredType.getSimpleName());
        outerType.putUserData(Keys.TYPE_REFERENCE, declaredType);
        if (node.getTarget() instanceof ThisReferenceExpression) {
            ThisReferenceExpression thisReference = (ThisReferenceExpression)node.getTarget();
            thisReference.setTarget(new TypeReferenceExpression(node.getOffset(), outerType));
        }
        return true;
    }

    private boolean isContextWithinTypeInstance(TypeReference type) {
        TypeDefinition scope;
        MethodDefinition resolvedMethod;
        MethodDefinition method = this.context.getCurrentMethod();
        if (method != null && (resolvedMethod = method.resolve()) != null && resolvedMethod.isStatic()) {
            return false;
        }
        for (TypeReference current = scope = this.context.getCurrentType(); current != null; current = current.getDeclaringType()) {
            MethodDefinition resolvedDeclaringMethod;
            MethodReference declaringMethod;
            if (MetadataResolver.areEquivalent(current, type)) {
                return true;
            }
            TypeDefinition resolved = ((TypeReference)current).resolve();
            if (resolved != null && resolved.isLocalClass() && (declaringMethod = resolved.getDeclaringMethod()) != null && (resolvedDeclaringMethod = declaringMethod.resolve()) != null && resolvedDeclaringMethod.isStatic()) break;
        }
        return false;
    }

    private class PhaseOneVisitor
    extends ContextTrackingVisitor<Void> {
        private PhaseOneVisitor() {
            super(IntroduceOuterClassReferencesTransform.this.context);
        }

        @Override
        public Void visitAssignmentExpression(AssignmentExpression node, Void _) {
            super.visitAssignmentExpression(node, _);
            TypeDefinition currentType = this.context.getCurrentType();
            if (this.context.getSettings().getShowSyntheticMembers() || this.context.getCurrentMethod() == null || !this.context.getCurrentMethod().isConstructor() || !currentType.isInnerClass() && !currentType.isLocalClass()) {
                return null;
            }
            Expression left = node.getLeft();
            Expression right = node.getRight();
            if (left instanceof MemberReferenceExpression && right instanceof IdentifierExpression) {
                FieldDefinition resolvedField;
                Variable variable = right.getUserData(Keys.VARIABLE);
                if (variable == null || !variable.isParameter()) {
                    return null;
                }
                MemberReferenceExpression memberReference = (MemberReferenceExpression)left;
                MemberReference member = memberReference.getUserData(Keys.MEMBER_REFERENCE);
                if (member instanceof FieldReference && memberReference.getTarget() instanceof ThisReferenceExpression && (resolvedField = ((FieldReference)member).resolve()) != null && resolvedField.isSynthetic() && MetadataResolver.areEquivalent(resolvedField.getFieldType(), currentType.getDeclaringType())) {
                    ParameterDeclaration parameterToRemove;
                    ParameterDefinition parameter = variable.getOriginalParameter();
                    IntroduceOuterClassReferencesTransform.this._outerClassFields.add(resolvedField.getFullName());
                    IntroduceOuterClassReferencesTransform.this._parametersToRemove.add(parameter);
                    ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)CollectionUtilities.firstOrDefault(node.getAncestorsAndSelf(), Predicates.instanceOf(ConstructorDeclaration.class));
                    if (constructorDeclaration != null && !constructorDeclaration.isNull() && (parameterToRemove = CollectionUtilities.getOrDefault(constructorDeclaration.getParameters(), parameter.getPosition())) != null) {
                        IntroduceOuterClassReferencesTransform.this._nodesToRemove.add(parameterToRemove);
                    }
                    if (node.getParent() instanceof ExpressionStatement) {
                        IntroduceOuterClassReferencesTransform.this._nodesToRemove.add(node.getParent());
                    } else {
                        TypeReference fieldType = resolvedField.getFieldType();
                        ThisReferenceExpression replacement = new ThisReferenceExpression(left.getOffset());
                        SimpleType type = new SimpleType(fieldType.getSimpleName());
                        type.putUserData(Keys.TYPE_REFERENCE, fieldType);
                        replacement.putUserData(Keys.TYPE_REFERENCE, fieldType);
                        replacement.setTarget(new TypeReferenceExpression(left.getOffset(), type));
                        right.replaceWith(replacement);
                    }
                }
            }
            return null;
        }
    }
}

