# Simple Malware Check Tool v1.2
# Author: Mert SARICA
# E-mail: mert [ . ] sarica [ @ ] gmail [ . ] com
# URL: http://www.mertsarica.com
#
# v1.2: New Virustotal changes implemented.
# v1.1: Wrong implementation of md5 calculation fixed. (Credit goes to roynal [.] smith [@] gmail [.] com)

import urllib, urllib2
import re
import os
import sys
import time
import hashlib

proxy_info = {
'user' : '', # proxy username
'pass' : '', # proxy password
'host' : "", # proxy host (leave it empty if no proxy is in use)
'port' : 8080 # proxy port
}

# build a new opener that uses a proxy requiring authorization
proxy_support = urllib2.ProxyHandler({"http" : \
"http://%(user)s:%(pass)s@%(host)s:%(port)d" % proxy_info})

if proxy_info['host'] != "":
	opener = urllib2.build_opener(proxy_support, urllib2.HTTPHandler)
else:
	opener = urllib2.build_opener(urllib2.HTTPHandler)
	
# install it
urllib2.install_opener(opener)

if sys.platform == 'linux-i386' or sys.platform == 'linux2':
        os.system("clear")
elif sys.platform == 'win32':
        os.system("cls")
else:
        os.system("cls")

counter = 0

def check_latest_threat():
	latest = ""
	
	url = "http://www.avira.ro/en/threats/section/details/id_vir/"
	response = opener.open(url)
	html = response.read()
	retup = re.findall(r"(id_vir/)(\S+)/", html)

	if len(retup) > 0:
		for element in retup:
			latest = element[1]
		return latest

def offline_check(binary_md5):
	number = ""
	md5 = ""
	virustype = ""
	severity = ""
	virusname = ""
	date = ""
	
	filename = "hashset.txt"
	
	try:
		FILE  = open (filename,"r" )   
		entries = FILE.readlines()
		FILE.close()
	except IOError:
		print "[+] hashset.txt file not found, try update command!\n"
		sys.exit(1)
		
	for entry in entries:
		if (entry.find(binary_md5) > 0):
			number , md5 , virusname , virustype , severity , date = entry.split("|")
			print "[+] Malware detected!"
			print "\t[*] Malware name:", virusname
			print "\t[*] Type:", virustype
			print "\t[*] Severity:", severity
			print "\t[*] Date discovered:", date[:len(date)-1]			
			sys.exit(1)
	print "[+] No malware detected"

def online_check(binary_md5):
	data = ""
	url = "http://www.virustotal.com/search.html"
	data = urllib.urlencode([('chain', binary_md5)])
	req = urllib2.Request(url)
	fd = opener.open(req, data)
	
	digit1 = ""
	digit2 = ""
	perc = ""
	while 1:
		data = fd.read(65536)
		# print data
		if (len(data) > 0):
			if data.find("The item you searched for was not") > 0:
				print "[+] No malware detected"
				sys.exit(1)

			retup = re.findall('(color: red">)(\\d+)(<\\/span>)', data)
			if len(retup) > 0:
				for element in retup:
					digit1 = element[1]

                                retup = re.findall('(\\/)(\\d+)( ).*?([+-]?\\d*\\.\\d+)(?![-+0-9\\.])', data)
                                if len(retup) > 0:
                                        for element in retup:
                                                digit2 = element[1]
                                                perc = element[3]

                                        print "[+] Malware detected! [" + digit1 + "/" + digit2 + "] (" + perc + "%)"
                                        print "\t[*] Malware names:"
				
                                        retup = re.findall(r"(positive).*?(>)(\S+)(<)", data)
                                        if len(retup) > 0:
                                                for element in retup:
                                                        print "\t\t" + element[2]

                                                print "\n[+] For more information you may visit:", fd.url
			
		
                if not len(data):
                        break
	
def update(counter):	
	i = 1048
	updated = 0
	md5 = ""
	virustype = ""
	severity = ""
	virusname = ""
	date = ""
	line = ""
	filename = "hashset.txt"
	
	try:
		FILE  = open (filename,"r" )   
		entries = FILE.readlines()
		FILE.close()
		lastentry = entries[-1].split("|")
		i = int(lastentry[0]) + 1
	except IOError:
		print "[+] hashset.txt file not found but do not worry I will create it right now :)\n"
		time.sleep(3)
	
	while int(i) < int(counter):
                updated = 1
                
		url = "http://www.avira.ro/en/threats/section/details/id_vir/" + str(i)
		response = opener.open(url)
		html = response.read()
	
		retup = re.findall(r"(MD5 checksum:).*?([a-fA-F\d]{32})", html)
		# print retup	
		if len(retup) > 0:
			for element in retup:
				md5 = element[1]
			
			retup = re.findall(r"(Type:).*?(av_head_left).*?([a-zA-Z0-9 ]+)<", html)
			for element in retup:
				virustype = element[2]
	
			retup = re.findall(r"(Damage Potential:).*?(av_head_left).*?([a-zA-Z ]+)<", html)
			for element in retup:
				severity = element[2]
				
			retup = re.findall(r"(Virus:).*?(av_head_left).*?([a-zA-Z0-9 .]+)<", html)
			for element in retup:
				virusname = element[2]
				
			retup = re.findall(r"(Date discovered:).*?(av_head_left).*?([0-9/]+)", html)
			for element in retup:
				date = element[2]
				
			line = str(i) + "|" + md5 + "|" + virusname + "|" + virustype + "|" + severity + "|" + date + "\n"
			FILE = open(filename,"a+")
			FILE.writelines(line)
			FILE.close()

                if sys.platform == 'linux-i386' or sys.platform == 'linux2':
                        os.system("clear")
                elif sys.platform == 'win32':
                        os.system("cls")
                else:
                        os.system("cls")
        
		print "=========================================================="
		print u"Simple Malware Check Tool v1.2 [http://www.mertsarica.com]"
		print "=========================================================="
		print "[+] Please wait, checking & updating hash set: %d hash left" % (int(counter) - int(i)) 
		i = i + 1
		
	if (updated > 0):
                print "[+] Update completed, ready to serve"
        else:
                print "[+] No need to update"

if __name__ == '__main__': 	
	print "=========================================================="
	print u"Simple Malware Check Tool v1.2 [http://www.mertsarica.com]"
	print "=========================================================="
	if len(sys.argv) < 2:
		print "Usage: python malware_check.py [update/offline/online] [binary]\n"
		sys.exit(1)
		
	filename = "hashset.txt"	
	binary_md5 = ""
	
	if len(sys.argv) > 2:
		md5 = hashlib.md5(open(sys.argv[2],'rb').read())
		binary_md5 = md5.hexdigest()
		# print binary_md5
	
	try:
		if (sys.argv[1].lower() == "update"):
			try:
				counter = check_latest_threat()
				update(counter)
                        except KeyboardInterrupt:
                                if sys.platform == 'linux-i386' or sys.platform == 'linux2':
                                        os.system("clear")
                                elif sys.platform == 'win32':
                                        os.system("cls")
                                else:
                                        os.system("cls")
                                print "=========================================================="
                                print u"Simple Malware Check Tool v1.2 [http://www.mertsarica.com]"
                                print "=========================================================="		
                                print "[+] Bye..."				
                        except Exception, (message):
                                print "[+] Error: Check your internet connection or proxy configuration"
                                sys.exit(1)			
		elif (sys.argv[1].lower() == "offline") and len(sys.argv) > 2:
       			print "[+] Offline md5 check: %s (%s)" % (sys.argv[2], binary_md5)
                        print "[+] Loaded %d md5 hashes" % len(open(filename).readlines())
                        # For testing purposes you may comment out the line below (md5 of Mydoom worm)
                        # binary_md5 = "eda0ab20b95a3722b04101490D340E2"
			offline_check(binary_md5)
		elif (sys.argv[1].lower() == "online") and len(sys.argv) > 2:
                        # For testing purposes you may comment out the line below (md5 of EICAR virus)
                        # binary_md5 = "44d88612fea8a8f36de82e1278abb02f"
			print "[+] Online md5 check: %s (%s)" % (sys.argv[2], binary_md5)
			try:
                                online_check(binary_md5)
                        except KeyboardInterrupt:
                                if sys.platform == 'linux-i386' or sys.platform == 'linux2':
                                        os.system("clear")
                                elif sys.platform == 'win32':
                                        os.system("cls")
                                else:
                                        os.system("cls")
                                print "=========================================================="
                                print u"Simple Malware Check Tool v1.2 [http://www.mertsarica.com]"
                                print "=========================================================="		
                                print "[+] Bye..."                                
                        except Exception, (message):
                                print "[+] Error: Check your internet connection or proxy configuration"
                                sys.exit(1)
		else:
			print "Usage: python malware_check.py [update/offline/online] [binary]\n"
			sys.exit(1)
	except KeyboardInterrupt:
                if sys.platform == 'linux-i386' or sys.platform == 'linux2':
                        os.system("clear")
                elif sys.platform == 'win32':
                        os.system("cls")
                else:
                        os.system("cls")
		print "=========================================================="
		print u"Simple Malware Check Tool v1.2 [http://www.mertsarica.com]"
		print "=========================================================="		
		print "[+] Bye..."
