<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
        <webapp><xsl:value-of select="/w3afrun/scaninfo/@target" />
        <xsl:for-each select="/w3afrun/vulnerability">
        <url>
           <xsl:variable name="url">
               <xsl:choose>
                  <xsl:when test="@url!='None'">
                        <xsl:value-of select="@url" />
                  </xsl:when>
                  <xsl:otherwise>
                        <xsl:value-of select="/w3afrun/scaninfo/@target" />
                  </xsl:otherwise>
               </xsl:choose>
           </xsl:variable>
            <xsl:value-of select="$url" />
           <finding class="MtTextObject" status="new">
                <xsl:attribute name="title">
                    <xsl:value-of select="@name" />
                </xsl:attribute>
            <xsl:attribute name="mergeID" >
                <xsl:value-of select="@id" />
            </xsl:attribute>
            <xsl:value-of select="normalize-space(text())" />
            <source>w3af</source>
            <location><xsl:value-of select="$url" /></location>
            <source-severity>
                <xsl:value-of select="lower-case(@severity)" />
                <numeric>
                <xsl:choose>
                    <xsl:when test="lower-case(@severity)='high'">3</xsl:when>
                    <xsl:when test="lower-case(@severity)='medium'">2</xsl:when>
                    <xsl:when test="lower-case(@severity)='low'">1</xsl:when>
                    <xsl:when test="lower-case(@severity)='info'">0</xsl:when>
                    <xsl:otherwise>-1</xsl:otherwise>
                </xsl:choose>
                </numeric>
            </source-severity>
            <plugin><xsl:value-of select="@plugin" /></plugin>
            <httpmethod><xsl:value-of select="@method" /></httpmethod>
            <affects>
            <xsl:choose>
            <xsl:when test="@var='None'">
                <xsl:value-of select="$url" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat($url, ' [', @var, ']')" />
            </xsl:otherwise>
            </xsl:choose>
            </affects>
            </finding>
        </url>
        </xsl:for-each>
        </webapp>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
