﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:key name="service-map" match="xlat/@to" use="../@from"/>
  <xsl:template name="mapped-service">
    <xsl:param name="service-name"/>
    <xsl:variable name="mapped-service">
      <xsl:for-each select="document('service-map.xml')">
        <xsl:value-of select="key('service-map', $service-name)"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string-length($mapped-service)&gt;0">
        <xsl:value-of select="$mapped-service"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$service-name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="nexpose-software">
    <xsl:param name="software"/>
    <software status="new">
      <xsl:value-of select="concat(@vendor,' ',@product,' ',@version)"/>
      <accuracy status="new">
        <xsl:value-of select="@certainty"/>
      </accuracy>
      <xsl:if test="@vendor">
      <vendor status="new">
        <xsl:value-of select="@vendor"/>
      </vendor>
      </xsl:if>
      <product status="new">
        <xsl:value-of select="@product"/>
      </product>
      <xsl:if test="@version">
        <version status="new">
          <xsl:value-of select="@version"/>
        </version>
      </xsl:if>
      <xsl:if test="@software-class">
        <softwareclass status="new">
          <xsl:value-of select="@software-class"/>
        </softwareclass>
      </xsl:if>
    </software>
  </xsl:template>
  <xsl:template name="nexpose-service">
    <xsl:param name="service-data"/>
    <xsl:param name="affects"/>
    <xsl:for-each select="$service-data/services/service">
    <xsl:variable name="mapped-service">
      <xsl:call-template name="mapped-service">
        <xsl:with-param name="service-name" select="lower-case(@name)"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="document('service-map.xml')/service-map/xlat[@from=@name]">
        <tunnel status="new">ssl
           <service status="new"><xsl:value-of select="$mapped-service"/>
              <xsl:for-each select="fingerprints/fingerprint">
                <xsl:call-template name="nexpose-software">
                  <xsl:with-param name="software" select="."/>
                </xsl:call-template>
              </xsl:for-each>
              <xsl:for-each select="tests/test[starts-with(@status,'vulnerable-')]">
                <xsl:call-template name="nexpose-finding">
                  <xsl:with-param name="test" select="."/>
                  <xsl:with-param name="affects" select="$affects"/>
                  <xsl:with-param name="mergeID" select="position()"/>
                </xsl:call-template>
              </xsl:for-each>
           </service>
        </tunnel>
      </xsl:when>
      <xsl:otherwise>
           <service status="new"><xsl:value-of select="$mapped-service"/>
              <xsl:for-each select="fingerprints/fingerprint">
                <xsl:call-template name="nexpose-software">
                  <xsl:with-param name="software" select="."/>
                </xsl:call-template>
              </xsl:for-each>
              <xsl:for-each select="tests/test[starts-with(@status,'vulnerable-')]">
                <xsl:call-template name="nexpose-finding">
                  <xsl:with-param name="test" select="."/>
                  <xsl:with-param name="affects" select="$affects"/>
                  <xsl:with-param name="mergeID" select="position()"/>
                </xsl:call-template>
              </xsl:for-each>
           </service>
      </xsl:otherwise>
    </xsl:choose>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="nexpose-severity">
    <xsl:param name="severity"/>
      <source-severity status="new">
       <xsl:choose>
        <xsl:when test="$severity=1 or $severity=2 or $severity=3">
	low
	<numeric status="new">1</numeric>
        </xsl:when>
        <xsl:when test="$severity=4 or $severity=5 or $severity=6">
        medium
        <numeric status="new">2</numeric>
        </xsl:when>
        <xsl:when test="$severity=7 or $severity=8 or $severity=9 or $severity=10">
        high
        <numeric status="new">3</numeric>
        </xsl:when>
       </xsl:choose>
      </source-severity>
  </xsl:template>

  <xsl:template name="nexpose-finding">
    <xsl:param name="test"/>
    <xsl:param name="affects"/>
    <xsl:param name="mergeID"/>
    <xsl:variable name="vulnerability" select="/NexposeReport/VulnerabilityDefinitions/vulnerability[lower-case(@id)=lower-case($test/@id)]"/>
    <finding status="new" class="MtTextObject">
      <xsl:attribute name="mergeID">
        <xsl:value-of select="$mergeID"/>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:value-of select="$vulnerability/@title"/>
      </xsl:attribute>
      <id status="new"><xsl:value-of select="$test/@id"/></id>
      <xsl:apply-templates select="$vulnerability/description"/>
      <source status="new">nexpose</source>
      <affects status="new">
        <xsl:value-of select="$affects"/>
      </affects>
      <xsl:call-template name="nexpose-severity">
	<xsl:with-param name="severity"><xsl:value-of select="$vulnerability/@severity"/></xsl:with-param>
      </xsl:call-template>
      <output title="Details" status="new" class="MtTextObject"><xsl:apply-templates select="$test"/></output>
      <solution title="Solution" class="MtTextObject" status="new"><xsl:apply-templates select="$vulnerability/solution"/></solution>
      <cvss_vector status="new"><xsl:value-of select="$vulnerability/@cvssVector"/></cvss_vector>
      <cvss_score status="new"><xsl:value-of select="$vulnerability/@cvssScore"/></cvss_score>
        <xsl:for-each select="$vulnerability/references/reference">
          <xsl:choose>
            <xsl:when test="@source='CVE'">
              <cve status="new">
                <xsl:value-of select="."/>
                <url status="new">http://cve.mitre.org/cgi-bin/cvename.cgi?name=<xsl:value-of select="."/></url>
              </cve>
            </xsl:when>
            <xsl:when test="@source='BID'">
              <bid status="new">
                <xsl:value-of select="."/>
                <url status="new">http://www.securityfocus.com/bid/<xsl:value-of select="."/></url>
              </bid>
            </xsl:when>
            <xsl:when test="@source='OSVDB'">
              <osvdb status="new">
                <xsl:value-of select="."/>
                <url status="new">http://osvdb.org/show/osvdb/<xsl:value-of select="."/></url>
              </osvdb>
            </xsl:when>
            <xsl:when test="@source='SECUNIA'">
              <reference status="new">Secunia Advisory SA<xsl:value-of select="."/>
               <url status="new">http://secunia.com/advisories/<xsl:value-of select="."/></url>
               </reference>
            </xsl:when>
            <xsl:when test="@type='URL'">
              <reference status="new">
                <xsl:value-of select="."/>
                <url status="new">http://secunia.com/advisories/<xsl:value-of select="."/></url>
              </reference>
            </xsl:when>
            <xsl:when test="@source='MSKB'">
              <reference status="new">Microsoft Knowledge Base Article <xsl:value-of select="."/>
               <url status="new">http://support.microsoft.com/kb/<xsl:value-of select="."/></url>
               </reference>
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>
    </finding>
  </xsl:template>

  <xsl:template match="/">
    <magictree xmlns:mt="http://www.gremwell.com/magictree" class="MtBranchObject">
      <testdata class="MtBranchObject">
        <xsl:for-each select="/NexposeReport/nodes/node">
          <host status="new">
           <xsl:variable name="host">
             <xsl:value-of select="@address"/>
           </xsl:variable>
           <xsl:value-of select="$host"/>
           <xsl:if test="@hardware-address">
           <mac><xsl:value-of select="@hardware-address"/></mac>
           </xsl:if>
           <xsl:for-each select="fingerprints/os">
            <os status="new"><xsl:value-of select="concat(@vendor,' ',@product,' ',@version)"/>
            <accuracy status="new"><xsl:value-of select="@certainty"/></accuracy>
            <vendor status="new"><xsl:value-of select="@vendor"/></vendor>
            <xsl:if test="@family">
              <family status="new"><xsl:value-of select="@family"/></family>
            </xsl:if>
               <product status="new"><xsl:value-of select="@product"/></product>
            <xsl:if test="@version">
               <version status="new"><xsl:value-of select="@version"/></version>
             </xsl:if>
             <xsl:if test="@arch">
               <arch status="new"><xsl:value-of select="@arch"/></arch>
             </xsl:if>
             <xsl:if test="@device-class">
               <deviceclass status="new"><xsl:value-of select="@device-class"/></deviceclass>
             </xsl:if></os></xsl:for-each>
             <xsl:for-each select="fingerprints/software">
               <xsl:call-template name="nexpose-software">
                 <xsl:with-param name="software" select="."/>
               </xsl:call-template>
              </xsl:for-each>
            <xsl:for-each select="tests/test[starts-with(@status,'vulnerable-')]">
              <xsl:call-template name="nexpose-finding">
                <xsl:with-param name="test" select="."/>
                <xsl:with-param name="affects" select="$host"/>
		<xsl:with-param name="mergeID" select="position()"/>
             </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="endpoints/endpoint">
              <ipproto status="new"><xsl:value-of select="@protocol"/>
                <port status="new"><xsl:value-of select="@port"/>
                  <state status="new"><xsl:value-of select="@status"/></state>
                  <xsl:call-template name="nexpose-service">
                    <xsl:with-param name="service-data" select="."/>
                    <xsl:with-param name="affects" select="concat($host, ':', @port, ' (', @protocol,')')"/>
                 </xsl:call-template>
                </port>
              </ipproto>
            </xsl:for-each>
          </host>
        </xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>

  <xsl:template match="ContainerBlockElement">
    <xsl:value-of select="normalize-space(text())"/>
    <xsl:apply-templates select="*"/>
  </xsl:template>
  <xsl:template match="Paragraph">
    <xsl:if test="@preformat">
      <![CDATA[<pre>]]>
    </xsl:if>
    <xsl:value-of select="normalize-space(text())"/>
    <xsl:apply-templates select="*"/>
    <xsl:if test="@preformat">
      <![CDATA[</pre>]]>
    </xsl:if>
    <![CDATA[<br/>]]>
  </xsl:template>
  <xsl:template match="OrderedList">
    <![CDATA[<ol>]]>
      <xsl:value-of select="normalize-space(text())"/><xsl:apply-templates select="*"/>
    <![CDATA[</ol>]]>
  </xsl:template>
  <xsl:template match="UnorderedList">
    <![CDATA[<ul>]]>
    <xsl:value-of select="normalize-space(text())"/><xsl:apply-templates select="*"/>
    <![CDATA[</ul>]]>
  </xsl:template>
  <xsl:template match="ListItem">
    <![CDATA[<li>]]><xsl:value-of select="normalize-space(text())"/><xsl:apply-templates select="*"/><![CDATA[</li>]]>
  </xsl:template>
  <xsl:template match="URLLink">
    <![CDATA[<a href="]]><xsl:value-of select="@LinkURL"/><![CDATA[">]]>
     <xsl:if test="string-length(normalize-space(text()))=0">
	<xsl:value-of select="@LinkURL"/>
     </xsl:if>
     <xsl:value-of select="normalize-space(text())"/>
    <![CDATA[</a>]]>
  </xsl:template>

</xsl:stylesheet>
