/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.Languages;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.DecompilerLinkProvider;
import us.deathmarine.luyten.JFontChooser;
import us.deathmarine.luyten.LinkProvider;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;
import us.deathmarine.luyten.MainWindow;
import us.deathmarine.luyten.Selection;

public class OpenFile
implements SyntaxConstants {
    public static final HashSet<String> WELL_KNOWN_TEXT_FILE_EXTENSIONS = new HashSet<String>(Arrays.asList(".java", ".xml", ".rss", ".project", ".classpath", ".h", ".c", ".cpp", ".yaml", ".yml", ".ini", ".sql", ".js", ".php", ".php5", ".phtml", ".html", ".htm", ".xhtm", ".xhtml", ".lua", ".bat", ".pl", ".sh", ".css", ".json", ".txt", ".rb", ".make", ".mak", ".py", ".properties", ".prop"));
    private TreeMap<Selection, String> selectionToUniqueStrTreeMap = new TreeMap();
    private Map<String, Boolean> isNavigableCache = new ConcurrentHashMap<String, Boolean>();
    private Map<String, String> readableLinksCache = new ConcurrentHashMap<String, String>();
    private volatile boolean isContentValid = false;
    private volatile boolean isNavigationLinksValid = false;
    private volatile boolean isWaitForLinksCursor = false;
    private volatile Double lastScrollPercent = null;
    private LinkProvider linkProvider;
    private String initialNavigationLink;
    private boolean isFirstTimeRun = true;
    MainWindow mainWindow;
    RTextScrollPane scrollPane;
    Panel image_pane;
    RSyntaxTextArea textArea;
    String name;
    String path;
    private ConfigSaver configSaver;
    private LuytenPreferences luytenPrefs;
    private MetadataSystem metadataSystem;
    private DecompilerSettings settings;
    private DecompilationOptions decompilationOptions;
    private TypeDefinition type;

    public OpenFile(String name, String path, Theme theme, final MainWindow mainWindow) {
        this.name = name;
        this.path = path;
        this.mainWindow = mainWindow;
        this.configSaver = ConfigSaver.getLoadedInstance();
        this.luytenPrefs = this.configSaver.getLuytenPreferences();
        this.textArea = new RSyntaxTextArea(25, 70);
        this.textArea.setCaretPosition(0);
        this.textArea.requestFocusInWindow();
        this.textArea.setMarkOccurrences(true);
        this.textArea.setClearWhitespaceLinesEnabled(false);
        this.textArea.setEditable(false);
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setCodeFoldingEnabled(true);
        if (name.toLowerCase().endsWith(".class") || name.toLowerCase().endsWith(".java")) {
            this.textArea.setSyntaxEditingStyle("text/java");
        } else if (name.toLowerCase().endsWith(".xml") || name.toLowerCase().endsWith(".rss") || name.toLowerCase().endsWith(".project") || name.toLowerCase().endsWith(".classpath")) {
            this.textArea.setSyntaxEditingStyle("text/xml");
        } else if (name.toLowerCase().endsWith(".h") || name.toLowerCase().endsWith(".c")) {
            this.textArea.setSyntaxEditingStyle("text/c");
        } else if (name.toLowerCase().endsWith(".cpp")) {
            this.textArea.setSyntaxEditingStyle("text/cpp");
        } else if (name.toLowerCase().endsWith(".sql")) {
            this.textArea.setSyntaxEditingStyle("text/sql");
        } else if (name.toLowerCase().endsWith(".js")) {
            this.textArea.setSyntaxEditingStyle("text/javascript");
        } else if (name.toLowerCase().endsWith(".php") || name.toLowerCase().endsWith(".php5") || name.toLowerCase().endsWith(".phtml")) {
            this.textArea.setSyntaxEditingStyle("text/php");
        } else if (name.toLowerCase().endsWith(".html") || name.toLowerCase().endsWith(".htm") || name.toLowerCase().endsWith(".xhtm") || name.toLowerCase().endsWith(".xhtml")) {
            this.textArea.setSyntaxEditingStyle("text/html");
        } else if (name.toLowerCase().endsWith(".js")) {
            this.textArea.setSyntaxEditingStyle("text/javascript");
        } else if (name.toLowerCase().endsWith(".lua")) {
            this.textArea.setSyntaxEditingStyle("text/lua");
        } else if (name.toLowerCase().endsWith(".bat")) {
            this.textArea.setSyntaxEditingStyle("text/bat");
        } else if (name.toLowerCase().endsWith(".pl")) {
            this.textArea.setSyntaxEditingStyle("text/perl");
        } else if (name.toLowerCase().endsWith(".sh")) {
            this.textArea.setSyntaxEditingStyle("text/unix");
        } else if (name.toLowerCase().endsWith(".css")) {
            this.textArea.setSyntaxEditingStyle("text/css");
        } else if (name.toLowerCase().endsWith(".json")) {
            this.textArea.setSyntaxEditingStyle("text/json");
        } else if (name.toLowerCase().endsWith(".ini")) {
            this.textArea.setSyntaxEditingStyle("text/ini");
        } else if (name.toLowerCase().endsWith(".yaml") || name.toLowerCase().endsWith(".yml")) {
            this.textArea.setSyntaxEditingStyle("text/yaml");
        } else if (name.toLowerCase().endsWith(".rb")) {
            this.textArea.setSyntaxEditingStyle("text/ruby");
        } else if (name.toLowerCase().endsWith(".make") || name.toLowerCase().endsWith(".mak")) {
            this.textArea.setSyntaxEditingStyle("text/makefile");
        } else if (name.toLowerCase().endsWith(".py")) {
            this.textArea.setSyntaxEditingStyle("text/python");
        } else {
            this.textArea.setSyntaxEditingStyle("text/plain");
        }
        this.scrollPane = new RTextScrollPane(this.textArea, true);
        this.scrollPane.setIconRowHeaderEnabled(true);
        this.textArea.setText("");
        JPopupMenu pop = this.textArea.getPopupMenu();
        pop.addSeparator();
        JMenuItem item = new JMenuItem("Font");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFontChooser fontChooser = new JFontChooser();
                fontChooser.setSelectedFont(OpenFile.this.textArea.getFont());
                fontChooser.setSelectedFontSize(OpenFile.this.textArea.getFont().getSize());
                int result = fontChooser.showDialog(mainWindow);
                if (result == 0) {
                    OpenFile.this.textArea.setFont(fontChooser.getSelectedFont());
                    OpenFile.this.luytenPrefs.setFont_size(fontChooser.getSelectedFontSize());
                }
            }
        });
        pop.add(item);
        this.textArea.setPopupMenu(pop);
        theme.apply(this.textArea);
        this.textArea.setFont(new Font(this.textArea.getFont().getName(), this.textArea.getFont().getStyle(), this.luytenPrefs.getFont_size()));
        this.scrollPane.setVerticalScrollBarPolicy(22);
        final JScrollBar verticalScrollbar = this.scrollPane.getVerticalScrollBar();
        if (verticalScrollbar != null) {
            verticalScrollbar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    String content = OpenFile.this.textArea.getText();
                    if (content == null || content.length() == 0) {
                        return;
                    }
                    int scrollValue = verticalScrollbar.getValue() - verticalScrollbar.getMinimum();
                    int scrollMax = verticalScrollbar.getMaximum() - verticalScrollbar.getMinimum();
                    if (scrollMax < 1 || scrollValue < 0 || scrollValue > scrollMax) {
                        return;
                    }
                    OpenFile.this.lastScrollPercent = (double)scrollValue / (double)scrollMax;
                }
            });
        }
        this.textArea.setHyperlinksEnabled(true);
        this.textArea.setLinkScanningMask(128);
        this.textArea.setLinkGenerator(new LinkGenerator(){

            @Override
            public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, final int offs) {
                final String uniqueStr = OpenFile.this.getUniqueStrForOffset(offs);
                final Integer selectionFrom = OpenFile.this.getSelectionFromForOffset(offs);
                if (uniqueStr != null && selectionFrom != null) {
                    return new LinkGeneratorResult(){

                        @Override
                        public HyperlinkEvent execute() {
                            if (OpenFile.this.isNavigationLinksValid) {
                                OpenFile.this.onNavigationClicked(uniqueStr);
                            }
                            return null;
                        }

                        @Override
                        public int getSourceOffset() {
                            if (OpenFile.this.isNavigationLinksValid) {
                                return selectionFrom;
                            }
                            return offs;
                        }
                    };
                }
                return null;
            }
        });
        for (MouseWheelListener listeners : this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(listeners);
        }
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() == 0) {
                    return;
                }
                if ((e.getModifiersEx() & 0x80) != 0) {
                    Font font = OpenFile.this.textArea.getFont();
                    int size = font.getSize();
                    if (e.getWheelRotation() > 0) {
                        OpenFile.this.textArea.setFont(new Font(font.getName(), font.getStyle(), --size >= 8 ? --size : 8));
                    } else {
                        OpenFile.this.textArea.setFont(new Font(font.getName(), font.getStyle(), ++size));
                    }
                    OpenFile.this.luytenPrefs.setFont_size(size);
                } else if (OpenFile.this.scrollPane.isWheelScrollingEnabled() && e.getWheelRotation() != 0) {
                    JScrollBar toScroll = OpenFile.this.scrollPane.getVerticalScrollBar();
                    int direction = e.getWheelRotation() < 0 ? -1 : 1;
                    int orientation = 1;
                    if (toScroll == null || !toScroll.isVisible()) {
                        toScroll = OpenFile.this.scrollPane.getHorizontalScrollBar();
                        if (toScroll == null || !toScroll.isVisible()) {
                            return;
                        }
                        orientation = 0;
                    }
                    e.consume();
                    if (e.getScrollType() == 0) {
                        JViewport vp = OpenFile.this.scrollPane.getViewport();
                        if (vp == null) {
                            return;
                        }
                        Component comp = vp.getView();
                        int units = Math.abs(e.getUnitsToScroll());
                        boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
                        Object fastWheelScroll = toScroll.getClientProperty("JScrollBar.fastWheelScrolling");
                        if (Boolean.TRUE == fastWheelScroll && comp instanceof Scrollable) {
                            Scrollable scrollComp = (Scrollable)((Object)comp);
                            Rectangle viewRect = vp.getViewRect();
                            int startingX = viewRect.x;
                            boolean leftToRight = comp.getComponentOrientation().isLeftToRight();
                            int scrollMin = toScroll.getMinimum();
                            int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                            if (limitScroll) {
                                int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                                if (direction < 0) {
                                    scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                                } else {
                                    scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                                }
                            }
                            for (int i = 0; i < units; ++i) {
                                int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                                if (orientation == 1) {
                                    if (direction < 0) {
                                        viewRect.y -= unitIncr;
                                        if (viewRect.y > scrollMin) continue;
                                        viewRect.y = scrollMin;
                                        break;
                                    }
                                    viewRect.y += unitIncr;
                                    if (viewRect.y < scrollMax) continue;
                                    viewRect.y = scrollMax;
                                    break;
                                }
                                if (leftToRight && direction < 0 || !leftToRight && direction > 0) {
                                    viewRect.x -= unitIncr;
                                    if (!leftToRight || viewRect.x >= scrollMin) continue;
                                    viewRect.x = scrollMin;
                                    break;
                                }
                                if (leftToRight && direction > 0 || !leftToRight && direction < 0) {
                                    viewRect.x += unitIncr;
                                    if (!leftToRight || viewRect.x <= scrollMax) continue;
                                    viewRect.x = scrollMax;
                                    break;
                                }
                                assert (false) : "Non-sensical ComponentOrientation / scroll direction";
                            }
                            if (orientation == 1) {
                                toScroll.setValue(viewRect.y);
                            } else if (leftToRight) {
                                toScroll.setValue(viewRect.x);
                            } else {
                                int newPos = toScroll.getValue() - (viewRect.x - startingX);
                                if (newPos < scrollMin) {
                                    newPos = scrollMin;
                                } else if (newPos > scrollMax) {
                                    newPos = scrollMax;
                                }
                                toScroll.setValue(newPos);
                            }
                        } else {
                            int limit = -1;
                            if (limitScroll) {
                                limit = direction < 0 ? toScroll.getValue() - toScroll.getBlockIncrement(direction) : toScroll.getValue() + toScroll.getBlockIncrement(direction);
                            }
                            for (int i = 0; i < units; ++i) {
                                int delta = direction > 0 ? toScroll.getUnitIncrement(direction) : -toScroll.getUnitIncrement(direction);
                                int oldValue = toScroll.getValue();
                                int newValue = oldValue + delta;
                                if (delta > 0 && newValue < oldValue) {
                                    newValue = toScroll.getMaximum();
                                } else if (delta < 0 && newValue > oldValue) {
                                    newValue = toScroll.getMinimum();
                                }
                                if (oldValue == newValue) break;
                                if (limitScroll && i > 0) {
                                    assert (limit != -1);
                                    if (direction < 0 && newValue < limit || direction > 0 && newValue > limit) break;
                                }
                                toScroll.setValue(newValue);
                            }
                        }
                    } else if (e.getScrollType() == 1) {
                        int oldValue = toScroll.getValue();
                        int blockIncrement = toScroll.getBlockIncrement(direction);
                        int delta = blockIncrement * (direction > 0 ? 1 : -1);
                        int newValue = oldValue + delta;
                        if (delta > 0 && newValue < oldValue) {
                            newValue = toScroll.getMaximum();
                        } else if (delta < 0 && newValue > oldValue) {
                            newValue = toScroll.getMinimum();
                        }
                        toScroll.setValue(newValue);
                    }
                }
                e.consume();
            }
        });
        this.textArea.addMouseMotionListener(new MouseMotionAdapter(){
            private boolean isLinkLabelPrev = false;
            private String prevLinkText = null;

            @Override
            public synchronized void mouseMoved(MouseEvent e) {
                boolean isCtrlDown;
                String linkText = null;
                boolean isLinkLabel = false;
                boolean bl = isCtrlDown = (e.getModifiersEx() & 0x80) != 0;
                if (isCtrlDown) {
                    linkText = this.createLinkLabel(e);
                    boolean bl2 = isLinkLabel = linkText != null;
                }
                if (isCtrlDown && OpenFile.this.isWaitForLinksCursor) {
                    OpenFile.this.textArea.setCursor(new Cursor(3));
                } else if (OpenFile.this.textArea.getCursor().getType() == 3) {
                    OpenFile.this.textArea.setCursor(new Cursor(0));
                }
                JLabel label = OpenFile.this.mainWindow.getLabel();
                if (isLinkLabel && this.isLinkLabelPrev) {
                    if (!linkText.equals(this.prevLinkText)) {
                        this.setLinkLabel(label, linkText);
                    }
                } else if (isLinkLabel && !this.isLinkLabelPrev) {
                    this.setLinkLabel(label, linkText);
                } else if (!isLinkLabel && this.isLinkLabelPrev) {
                    this.setLinkLabel(label, null);
                }
                this.isLinkLabelPrev = isLinkLabel;
                this.prevLinkText = linkText;
            }

            private void setLinkLabel(JLabel label, String text) {
                String current = label.getText();
                if (text == null && current != null && (current.startsWith("Navigating:") || current.startsWith("Cannot navigate:"))) {
                    return;
                }
                label.setText(text != null ? text : "Complete");
            }

            private String createLinkLabel(MouseEvent e) {
                int offs = OpenFile.this.textArea.viewToModel(e.getPoint());
                if (OpenFile.this.isNavigationLinksValid) {
                    return OpenFile.this.getLinkDescriptionForOffset(offs);
                }
                return null;
            }
        });
    }

    public void setContent(String content) {
        this.textArea.setText(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompile() {
        this.invalidateContent();
        DecompilerSettings decompilerSettings = this.settings;
        synchronized (decompilerSettings) {
            if (Languages.java().getName().equals(this.settings.getLanguage().getName())) {
                this.decompileWithNavigationLinks();
            } else {
                this.decompileWithoutLinks();
            }
        }
    }

    private void decompileWithoutLinks() {
        this.invalidateContent();
        this.isNavigationLinksValid = false;
        this.textArea.setHyperlinksEnabled(false);
        StringWriter stringwriter = new StringWriter();
        PlainTextOutput plainTextOutput = new PlainTextOutput(stringwriter);
        plainTextOutput.setUnicodeOutputEnabled(this.decompilationOptions.getSettings().isUnicodeOutputEnabled());
        this.settings.getLanguage().decompileType(this.type, plainTextOutput, this.decompilationOptions);
        this.setContentPreserveLastScrollPosition(stringwriter.toString());
        this.isContentValid = true;
    }

    private void decompileWithNavigationLinks() {
        this.invalidateContent();
        DecompilerLinkProvider newLinkProvider = new DecompilerLinkProvider();
        newLinkProvider.setDecompilerReferences(this.metadataSystem, this.settings, this.decompilationOptions);
        newLinkProvider.setType(this.type);
        this.linkProvider = newLinkProvider;
        this.linkProvider.generateContent();
        this.setContentPreserveLastScrollPosition(this.linkProvider.getTextContent());
        this.isContentValid = true;
        this.enableLinks();
    }

    private void setContentPreserveLastScrollPosition(final String content) {
        final Double scrollPercent = this.lastScrollPercent;
        if (scrollPercent != null && this.initialNavigationLink == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpenFile.this.textArea.setText(content);
                    OpenFile.this.restoreScrollPosition(scrollPercent);
                }
            });
        } else {
            this.textArea.setText(content);
        }
    }

    private void restoreScrollPosition(final double position) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JScrollBar verticalScrollbar = OpenFile.this.scrollPane.getVerticalScrollBar();
                if (verticalScrollbar == null) {
                    return;
                }
                int scrollMax = verticalScrollbar.getMaximum() - verticalScrollbar.getMinimum();
                long newScrollValue = Math.round(position * (double)scrollMax) + (long)verticalScrollbar.getMinimum();
                if (newScrollValue < (long)verticalScrollbar.getMinimum()) {
                    newScrollValue = verticalScrollbar.getMinimum();
                }
                if (newScrollValue > (long)verticalScrollbar.getMaximum()) {
                    newScrollValue = verticalScrollbar.getMaximum();
                }
                verticalScrollbar.setValue((int)newScrollValue);
            }
        });
    }

    private void enableLinks() {
        if (this.initialNavigationLink != null) {
            this.doEnableLinks();
        } else {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        OpenFile.this.isWaitForLinksCursor = true;
                        OpenFile.this.doEnableLinks();
                    }
                    finally {
                        OpenFile.this.isWaitForLinksCursor = false;
                        OpenFile.this.resetCursor();
                    }
                }
            }).start();
        }
    }

    private void resetCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenFile.this.textArea.setCursor(new Cursor(0));
            }
        });
    }

    private void doEnableLinks() {
        this.isNavigationLinksValid = false;
        this.linkProvider.processLinks();
        this.buildSelectionToUniqueStrTreeMap();
        this.clearLinksCache();
        this.isNavigationLinksValid = true;
        this.textArea.setHyperlinksEnabled(true);
        this.warmUpWithFirstLink();
    }

    private void warmUpWithFirstLink() {
        if (this.selectionToUniqueStrTreeMap.keySet().size() > 0) {
            Selection selection = this.selectionToUniqueStrTreeMap.keySet().iterator().next();
            this.getLinkDescriptionForOffset(selection.from);
        }
    }

    public void clearLinksCache() {
        try {
            this.isNavigableCache.clear();
            this.readableLinksCache.clear();
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void buildSelectionToUniqueStrTreeMap() {
        TreeMap<Selection, String> treeMap = new TreeMap<Selection, String>();
        Map<String, Selection> definitionToSelectionMap = this.linkProvider.getDefinitionToSelectionMap();
        Map<String, Set<Selection>> referenceToSelectionsMap = this.linkProvider.getReferenceToSelectionsMap();
        for (String key : definitionToSelectionMap.keySet()) {
            Selection selection = definitionToSelectionMap.get(key);
            treeMap.put(selection, key);
        }
        for (String key : referenceToSelectionsMap.keySet()) {
            for (Selection selection : referenceToSelectionsMap.get(key)) {
                treeMap.put(selection, key);
            }
        }
        this.selectionToUniqueStrTreeMap = treeMap;
    }

    private Selection getSelectionForOffset(int offset) {
        Selection offsetSelection;
        Selection floorSelection;
        if (this.isNavigationLinksValid && (floorSelection = this.selectionToUniqueStrTreeMap.floorKey(offsetSelection = new Selection(offset, offset))) != null && floorSelection.from <= offset && floorSelection.to > offset) {
            return floorSelection;
        }
        return null;
    }

    private String getUniqueStrForOffset(int offset) {
        String uniqueStr;
        Selection selection = this.getSelectionForOffset(offset);
        if (selection != null && this.isLinkNavigable(uniqueStr = this.selectionToUniqueStrTreeMap.get(selection)) && this.getLinkDescription(uniqueStr) != null) {
            return uniqueStr;
        }
        return null;
    }

    private Integer getSelectionFromForOffset(int offset) {
        Selection selection = this.getSelectionForOffset(offset);
        if (selection != null) {
            return selection.from;
        }
        return null;
    }

    private String getLinkDescriptionForOffset(int offset) {
        String description;
        String uniqueStr = this.getUniqueStrForOffset(offset);
        if (uniqueStr != null && (description = this.getLinkDescription(uniqueStr)) != null) {
            return description;
        }
        return null;
    }

    private boolean isLinkNavigable(String uniqueStr) {
        try {
            Boolean isNavigableCached = this.isNavigableCache.get(uniqueStr);
            if (isNavigableCached != null) {
                return isNavigableCached;
            }
            boolean isNavigable = this.linkProvider.isLinkNavigable(uniqueStr);
            this.isNavigableCache.put(uniqueStr, isNavigable);
            return isNavigable;
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
            return false;
        }
    }

    private String getLinkDescription(String uniqueStr) {
        try {
            String descriptionCached = this.readableLinksCache.get(uniqueStr);
            if (descriptionCached != null) {
                return descriptionCached;
            }
            String description = this.linkProvider.getLinkDescription(uniqueStr);
            if (description != null && description.trim().length() > 0) {
                this.readableLinksCache.put(uniqueStr, description);
                return description;
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
        return null;
    }

    private void onNavigationClicked(String clickedReferenceUniqueStr) {
        if (this.isLocallyNavigable(clickedReferenceUniqueStr)) {
            this.onLocalNavigationRequest(clickedReferenceUniqueStr);
        } else if (this.linkProvider.isLinkNavigable(clickedReferenceUniqueStr)) {
            this.onOutboundNavigationRequest(clickedReferenceUniqueStr);
        } else {
            JLabel label = this.mainWindow.getLabel();
            if (label == null) {
                return;
            }
            String[] linkParts = clickedReferenceUniqueStr.split("\\|");
            if (linkParts.length <= 1) {
                label.setText("Cannot navigate: " + clickedReferenceUniqueStr);
                return;
            }
            String destinationTypeStr = linkParts[1];
            label.setText("Cannot navigate: " + destinationTypeStr.replaceAll("/", "."));
        }
    }

    private boolean isLocallyNavigable(String uniqueStr) {
        return this.linkProvider.getDefinitionToSelectionMap().keySet().contains(uniqueStr);
    }

    private void onLocalNavigationRequest(String uniqueStr) {
        try {
            Selection selection = this.linkProvider.getDefinitionToSelectionMap().get(uniqueStr);
            this.doLocalNavigation(selection);
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void doLocalNavigation(Selection selection) {
        try {
            this.textArea.requestFocusInWindow();
            if (selection != null) {
                this.textArea.setSelectionStart(selection.from);
                this.textArea.setSelectionEnd(selection.to);
                this.scrollToSelection(selection.from);
            } else {
                this.textArea.setSelectionStart(0);
                this.textArea.setSelectionEnd(0);
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void scrollToSelection(final int selectionBeginningOffset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int fullHeight = OpenFile.this.textArea.getBounds().height;
                    int viewportHeight = OpenFile.this.textArea.getVisibleRect().height;
                    int viewportLineCount = viewportHeight / OpenFile.this.textArea.getLineHeight();
                    int selectionLineNum = OpenFile.this.textArea.getLineOfOffset(selectionBeginningOffset);
                    int upperMarginToScroll = Math.round((float)viewportLineCount * 0.29f);
                    int upperLineToSet = selectionLineNum - upperMarginToScroll;
                    int currentUpperLine = OpenFile.this.textArea.getVisibleRect().y / OpenFile.this.textArea.getLineHeight();
                    if (selectionLineNum <= currentUpperLine + 2 || selectionLineNum >= currentUpperLine + viewportLineCount - 4) {
                        Rectangle rectToScroll = new Rectangle();
                        rectToScroll.x = 0;
                        rectToScroll.width = 1;
                        rectToScroll.y = Math.max(upperLineToSet * OpenFile.this.textArea.getLineHeight(), 0);
                        rectToScroll.height = Math.min(viewportHeight, fullHeight - rectToScroll.y);
                        OpenFile.this.textArea.scrollRectToVisible(rectToScroll);
                    }
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        });
    }

    private void onOutboundNavigationRequest(String uniqueStr) {
        this.mainWindow.onNavigationRequest(uniqueStr);
    }

    public void setDecompilerReferences(MetadataSystem metadataSystem, DecompilerSettings settings, DecompilationOptions decompilationOptions) {
        this.metadataSystem = metadataSystem;
        this.settings = settings;
        this.decompilationOptions = decompilationOptions;
    }

    public TypeDefinition getType() {
        return this.type;
    }

    public void setType(TypeDefinition type) {
        this.type = type;
    }

    public boolean isContentValid() {
        return this.isContentValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateContent() {
        try {
            this.setContent("");
        }
        finally {
            this.isContentValid = false;
            this.isNavigationLinksValid = false;
        }
    }

    public void resetScrollPosition() {
        this.lastScrollPercent = null;
    }

    public void setInitialNavigationLink(String initialNavigationLink) {
        this.initialNavigationLink = initialNavigationLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddedToScreen() {
        try {
            if (this.initialNavigationLink != null) {
                this.onLocalNavigationRequest(this.initialNavigationLink);
            } else if (this.isFirstTimeRun) {
                this.isFirstTimeRun = false;
                this.doLocalNavigation(new Selection(0, 0));
            }
        }
        finally {
            this.initialNavigationLink = null;
        }
    }

    public void close() {
        this.linkProvider = null;
        this.type = null;
        this.invalidateContent();
        this.clearLinksCache();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenFile other = (OpenFile)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

