/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.PlainTextOutput;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.MainWindow;
import us.deathmarine.luyten.Model;
import us.deathmarine.luyten.WindowPosition;

public class FindAllBox
extends JDialog {
    private static final long serialVersionUID = -4125409760166690462L;
    private static final int MIN_WIDTH = 640;
    private boolean searching;
    private JButton findButton;
    private JTextField textField;
    private JCheckBox mcase;
    private JCheckBox regex;
    private JCheckBox wholew;
    private JCheckBox classname;
    private JList<String> list;
    private JProgressBar progressBar;
    boolean locked;
    private JLabel statusLabel = new JLabel("");
    private DefaultListModel<String> classesList = new DefaultListModel();
    private Thread tmp_thread;

    public FindAllBox(final MainWindow mainWindow) {
        this.setDefaultCloseOperation(1);
        this.setHideOnEscapeButton();
        this.progressBar = new JProgressBar(0, 100);
        JLabel label = new JLabel("Find What:");
        this.textField = new JTextField();
        this.findButton = new JButton("Find");
        this.findButton.addActionListener(new FindButton());
        this.mcase = new JCheckBox("Match Case");
        this.regex = new JCheckBox("Regex");
        this.wholew = new JCheckBox("Whole Words");
        this.classname = new JCheckBox("Classnames");
        this.getRootPane().setDefaultButton(this.findButton);
        this.list = new JList<String>(this.classesList);
        this.list.setSelectionMode(1);
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    String entryName = (String)list.getModel().getElementAt(index);
                    String[] array = entryName.split("/");
                    if (entryName.toLowerCase().endsWith(".class")) {
                        String internalName = StringUtilities.removeRight(entryName, ".class");
                        TypeReference type = Model.metadataSystem.lookupType(internalName);
                        try {
                            mainWindow.getModel().extractClassToTextPane(type, array[array.length - 1], entryName, null);
                        }
                        catch (Exception e) {
                            Luyten.showExceptionDialog("Exception!", e);
                        }
                    } else {
                        try {
                            JarFile jfile = new JarFile(MainWindow.model.getOpenedFile());
                            mainWindow.getModel().extractSimpleFileEntryToTextPane(jfile.getInputStream(jfile.getEntry(entryName)), array[array.length - 1], entryName);
                            jfile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        this.list.setLayoutOrientation(0);
        JScrollPane listScroller = new JScrollPane(this.list, 22, 30);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)((double)screenSize.width * 0.35);
        if (width < 640) {
            width = 640;
        }
        Dimension center = new Dimension(width, 500);
        int x = (int)((double)center.width * 0.2);
        int y = (int)((double)center.height * 0.2);
        this.setBounds(x, y, center.width, center.height);
        this.setResizable(false);
        GroupLayout layout = new GroupLayout(this.getRootPane());
        this.getRootPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(label).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel).addComponent(this.textField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mcase)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wholew)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regex)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classname))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(listScroller).addComponent(this.progressBar)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findButton)));
        layout.linkSize(0, this.findButton);
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.textField).addComponent(this.findButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mcase).addComponent(this.wholew).addComponent(this.regex).addComponent(this.classname)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(listScroller)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)).addComponent(this.statusLabel).addComponent(this.progressBar));
        this.adjustWindowPositionBySavedState();
        this.setSaveWindowPositionOnClosing();
        this.setName("Find All");
        this.setTitle("Find All");
    }

    private boolean search(String bulk) {
        String a = this.textField.getText();
        String b = bulk;
        if (this.regex.isSelected()) {
            return Pattern.matches(a, b);
        }
        if (this.wholew.isSelected()) {
            a = " " + a + " ";
        }
        if (!this.mcase.isSelected()) {
            a = a.toLowerCase();
            b = b.toLowerCase();
        }
        return b.contains(a);
    }

    private void setHideOnEscapeButton() {
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 6846566740472934801L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAllBox.this.setVisible(false);
            }
        };
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void adjustWindowPositionBySavedState() {
        WindowPosition windowPosition = ConfigSaver.getLoadedInstance().getFindWindowPosition();
        if (windowPosition.isSavedWindowPositionValid()) {
            this.setLocation(windowPosition.getWindowX(), windowPosition.getWindowY());
        }
    }

    private void setSaveWindowPositionOnClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                WindowPosition windowPosition = ConfigSaver.getLoadedInstance().getFindWindowPosition();
                windowPosition.readPositionFromDialog(FindAllBox.this);
            }
        });
    }

    public void showFindBox() {
        this.setVisible(true);
        this.textField.requestFocus();
    }

    public void hideFindBox() {
        this.setVisible(false);
    }

    public void setStatus(String text) {
        if (text.length() > 25) {
            this.statusLabel.setText("Searching in file: ..." + text.substring(text.length() - 25));
        } else {
            this.statusLabel.setText("Searching in file: " + text);
        }
        this.progressBar.setValue(this.progressBar.getValue() + 1);
    }

    public void addClassName(String className) {
        this.classesList.addElement(className);
    }

    public void initProgressBar(Integer length) {
        this.progressBar.setMaximum(length);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
    }

    public boolean isSearching() {
        return this.searching;
    }

    public void setSearching(boolean searching) {
        this.searching = searching;
    }

    private class FindButton
    extends AbstractAction {
        private static final long serialVersionUID = 75954129199541874L;

        private FindButton() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FindAllBox.this.tmp_thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (FindAllBox.this.findButton.getText().equals("Stop")) {
                        if (FindAllBox.this.tmp_thread != null) {
                            FindAllBox.this.tmp_thread.interrupt();
                        }
                        FindAllBox.this.setStatus("Stopped.");
                        FindAllBox.this.findButton.setText("Find");
                        FindAllBox.this.locked = false;
                    } else {
                        FindAllBox.this.findButton.setText("Stop");
                        FindAllBox.this.classesList.clear();
                        ConfigSaver configSaver = ConfigSaver.getLoadedInstance();
                        DecompilerSettings settings = configSaver.getDecompilerSettings();
                        File inFile = MainWindow.model.getOpenedFile();
                        boolean filter = ConfigSaver.getLoadedInstance().getLuytenPreferences().isFilterOutInnerClassEntries();
                        try {
                            JarFile jfile = new JarFile(inFile);
                            Enumeration<JarEntry> entLength = jfile.entries();
                            FindAllBox.this.initProgressBar(Collections.list(entLength).size());
                            Enumeration<JarEntry> ent = jfile.entries();
                            while (ent.hasMoreElements() && FindAllBox.this.findButton.getText().equals("Stop")) {
                                JarEntry entry = ent.nextElement();
                                String name = entry.getName();
                                FindAllBox.this.setStatus(name);
                                if (filter && name.contains("$")) continue;
                                if (FindAllBox.this.locked || FindAllBox.this.classname.isSelected()) {
                                    FindAllBox.this.locked = true;
                                    if (!FindAllBox.this.search(entry.getName())) continue;
                                    FindAllBox.this.addClassName(entry.getName());
                                    continue;
                                }
                                if (entry.getName().endsWith(".class")) {
                                    DecompilerSettings decompilerSettings = settings;
                                    synchronized (decompilerSettings) {
                                        String internalName = StringUtilities.removeRight(entry.getName(), ".class");
                                        TypeReference type = Model.metadataSystem.lookupType(internalName);
                                        TypeDefinition resolvedType = null;
                                        if (type == null || (resolvedType = type.resolve()) == null) {
                                            throw new Exception("Unable to resolve type.");
                                        }
                                        StringWriter stringwriter = new StringWriter();
                                        DecompilationOptions decompilationOptions = new DecompilationOptions();
                                        decompilationOptions.setSettings(settings);
                                        decompilationOptions.setFullDecompilation(true);
                                        PlainTextOutput plainTextOutput = new PlainTextOutput(stringwriter);
                                        plainTextOutput.setUnicodeOutputEnabled(decompilationOptions.getSettings().isUnicodeOutputEnabled());
                                        settings.getLanguage().decompileType(resolvedType, plainTextOutput, decompilationOptions);
                                        if (FindAllBox.this.search(stringwriter.toString())) {
                                            FindAllBox.this.addClassName(entry.getName());
                                        }
                                        continue;
                                    }
                                }
                                StringBuilder sb = new StringBuilder();
                                long nonprintableCharactersCount = 0L;
                                try (InputStreamReader inputStreamReader = new InputStreamReader(jfile.getInputStream(entry));
                                     BufferedReader reader = new BufferedReader(inputStreamReader);){
                                    String line;
                                    while ((line = reader.readLine()) != null) {
                                        sb.append(line).append("\n");
                                        for (byte nextByte : line.getBytes()) {
                                            if (nextByte > 0) continue;
                                            ++nonprintableCharactersCount;
                                        }
                                    }
                                }
                                if (nonprintableCharactersCount >= 5L || !FindAllBox.this.search(sb.toString())) continue;
                                FindAllBox.this.addClassName(entry.getName());
                            }
                            FindAllBox.this.setSearching(false);
                            if (FindAllBox.this.findButton.getText().equals("Stop")) {
                                FindAllBox.this.setStatus("Done.");
                                FindAllBox.this.findButton.setText("Find");
                                FindAllBox.this.locked = false;
                            }
                            jfile.close();
                            FindAllBox.this.locked = false;
                        }
                        catch (Exception e) {
                            Luyten.showExceptionDialog("Exception!", e);
                        }
                    }
                }
            };
            FindAllBox.this.tmp_thread.start();
        }
    }
}

