/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;

public class FileDialog {
    private ConfigSaver configSaver;
    private LuytenPreferences luytenPrefs;
    private Component parent;
    private JFileChooser fcOpen;
    private JFileChooser fcSave;
    private JFileChooser fcSaveAll;

    public FileDialog(Component parent) {
        this.parent = parent;
        this.configSaver = ConfigSaver.getLoadedInstance();
        this.luytenPrefs = this.configSaver.getLuytenPreferences();
        new Thread(){

            @Override
            public void run() {
                try {
                    FileDialog.this.initOpenDialog();
                    Thread.sleep(500L);
                    FileDialog.this.initSaveAllDialog();
                    Thread.sleep(500L);
                    FileDialog.this.initSaveDialog();
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        }.start();
    }

    public File doOpenDialog() {
        File selectedFile = null;
        this.initOpenDialog();
        this.retrieveOpenDialogDir(this.fcOpen);
        int returnVal = this.fcOpen.showOpenDialog(this.parent);
        this.saveOpenDialogDir(this.fcOpen);
        if (returnVal == 0) {
            selectedFile = this.fcOpen.getSelectedFile();
        }
        return selectedFile;
    }

    public File doSaveDialog(String recommendedFileName) {
        File selectedFile = null;
        this.initSaveDialog();
        this.retrieveSaveDialogDir(this.fcSave);
        this.fcSave.setSelectedFile(new File(recommendedFileName));
        int returnVal = this.fcSave.showSaveDialog(this.parent);
        this.saveSaveDialogDir(this.fcSave);
        if (returnVal == 0) {
            selectedFile = this.fcSave.getSelectedFile();
        }
        return selectedFile;
    }

    public File doSaveAllDialog(String recommendedFileName) {
        File selectedFile = null;
        this.initSaveAllDialog();
        this.retrieveSaveDialogDir(this.fcSaveAll);
        this.fcSaveAll.setSelectedFile(new File(recommendedFileName));
        int returnVal = this.fcSaveAll.showSaveDialog(this.parent);
        this.saveSaveDialogDir(this.fcSaveAll);
        if (returnVal == 0) {
            selectedFile = this.fcSaveAll.getSelectedFile();
        }
        return selectedFile;
    }

    public synchronized void initOpenDialog() {
        if (this.fcOpen == null) {
            this.fcOpen = this.createFileChooser("*.jar", "*.zip", "*.class");
            this.retrieveOpenDialogDir(this.fcOpen);
        }
    }

    public synchronized void initSaveDialog() {
        if (this.fcSave == null) {
            this.fcSave = this.createFileChooser("*.txt", "*.java");
            this.retrieveSaveDialogDir(this.fcSave);
        }
    }

    public synchronized void initSaveAllDialog() {
        if (this.fcSaveAll == null) {
            this.fcSaveAll = this.createFileChooser("*.jar", "*.zip");
            this.retrieveSaveDialogDir(this.fcSaveAll);
        }
    }

    private JFileChooser createFileChooser(String ... fileFilters) {
        JFileChooser fc = new JFileChooser();
        for (String fileFilter : fileFilters) {
            fc.addChoosableFileFilter(new FileChooserFileFilter(fileFilter));
        }
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        return fc;
    }

    private void retrieveOpenDialogDir(JFileChooser fc) {
        try {
            File currentDir;
            String currentDirStr = this.luytenPrefs.getFileOpenCurrentDirectory();
            if (currentDirStr != null && currentDirStr.trim().length() > 0 && (currentDir = new File(currentDirStr)).exists() && currentDir.isDirectory()) {
                fc.setCurrentDirectory(currentDir);
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void saveOpenDialogDir(JFileChooser fc) {
        try {
            File currentDir = fc.getCurrentDirectory();
            if (currentDir != null && currentDir.exists() && currentDir.isDirectory()) {
                this.luytenPrefs.setFileOpenCurrentDirectory(currentDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void retrieveSaveDialogDir(JFileChooser fc) {
        try {
            File currentDir;
            String currentDirStr = this.luytenPrefs.getFileSaveCurrentDirectory();
            if (currentDirStr != null && currentDirStr.trim().length() > 0 && (currentDir = new File(currentDirStr)).exists() && currentDir.isDirectory()) {
                fc.setCurrentDirectory(currentDir);
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    private void saveSaveDialogDir(JFileChooser fc) {
        try {
            File currentDir = fc.getCurrentDirectory();
            if (currentDir != null && currentDir.exists() && currentDir.isDirectory()) {
                this.luytenPrefs.setFileSaveCurrentDirectory(currentDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    public class FileChooserFileFilter
    extends FileFilter {
        String objType;

        public FileChooserFileFilter(String string) {
            this.objType = string;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(this.objType.substring(1));
        }

        @Override
        public String getDescription() {
            return this.objType;
        }
    }
}

