/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.compilerservices.CallerResolver;
import com.strobel.compilerservices.DebugInfoGenerator;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.expressions.CustomDelegateTypeCache;
import com.strobel.expressions.Delegate;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionType;
import com.strobel.expressions.ExpressionVisitor;
import com.strobel.expressions.LambdaCompiler;
import com.strobel.expressions.ParameterExpressionList;
import com.strobel.expressions.StackSpiller;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.Type;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import java.lang.invoke.MethodHandle;

public final class LambdaExpression<T>
extends Expression {
    private final String _name;
    private final Expression _body;
    private final ParameterExpressionList _parameters;
    private final Type<T> _interfaceType;
    private final boolean _tailCall;
    private final Type _returnType;
    private Class<?> _creationContext;

    LambdaExpression(Type<T> interfaceType, String name, Expression body, boolean tailCall, ParameterExpressionList parameters) {
        this._interfaceType = interfaceType != null ? interfaceType : LambdaExpression.resolveDelegateType(body, parameters);
        this._name = name;
        this._body = body;
        this._tailCall = tailCall;
        this._parameters = parameters;
        this._returnType = Expression.getInvokeMethod(this._interfaceType, true).getReturnType();
        this._creationContext = CallerResolver.getCallerClass(2);
    }

    private static <T> Type<T> resolveDelegateType(Expression body, ParameterExpressionList parameters) {
        return CustomDelegateTypeCache.get(body.getType(), parameters.getParameterTypes());
    }

    public final Type<T> getType() {
        return this._interfaceType;
    }

    @Override
    public ExpressionType getNodeType() {
        return ExpressionType.Lambda;
    }

    public final String getName() {
        return this._name;
    }

    public final Expression getBody() {
        return this._body;
    }

    public final ParameterExpressionList getParameters() {
        return this._parameters;
    }

    public final Type getReturnType() {
        return this._returnType;
    }

    public final boolean isTailCall() {
        return this._tailCall;
    }

    public final LambdaExpression<T> update(Expression body, ParameterExpressionList parameters) {
        if (body == this._body && parameters == this._parameters) {
            return this;
        }
        LambdaExpression updatedLambda = Expression.lambda(this._interfaceType, this.getName(), body, this.isTailCall(), parameters);
        updatedLambda._creationContext = this._creationContext;
        return updatedLambda;
    }

    @Override
    protected Expression accept(ExpressionVisitor visitor) {
        return visitor.visitLambda(this);
    }

    final LambdaExpression<T> accept(StackSpiller spiller) {
        return spiller.rewrite(this);
    }

    final Class<?> getCreationContext() {
        return this._creationContext;
    }

    public final T compile() {
        return this.compileDelegate().getInstance();
    }

    public final Delegate<T> compileDelegate() {
        return LambdaCompiler.compile(this, DebugInfoGenerator.empty());
    }

    public final MethodHandle compileHandle() {
        return LambdaCompiler.compile(this, DebugInfoGenerator.empty()).getMethodHandle();
    }

    public final void compileToMethod(MethodBuilder methodBuilder) {
        LambdaCompiler.compile(this, methodBuilder, DebugInfoGenerator.empty());
    }

    public final MethodInfo compileToMethod(TypeBuilder<?> typeBuilder) {
        String name = this.getName();
        return this.compileToMethod(typeBuilder, StringUtilities.isNullOrWhitespace(name) ? LambdaCompiler.getUniqueMethodName() : name, 1);
    }

    public final MethodInfo compileToMethod(TypeBuilder<?> typeBuilder, String name) {
        return this.compileToMethod(typeBuilder, name, 1);
    }

    public final MethodInfo compileToMethod(TypeBuilder<?> typeBuilder, String name, int modifiers) {
        VerifyArgument.notNull(typeBuilder, "typeBuilder");
        VerifyArgument.notNullOrWhitespace(name, "name");
        MethodInfo invokeMethod = Expression.getInvokeMethod(this);
        MethodBuilder methodBuilder = typeBuilder.defineMethod(name, modifiers, invokeMethod.getReturnType(), invokeMethod.getParameters().getParameterTypes());
        LambdaCompiler.compile(this, methodBuilder, DebugInfoGenerator.empty());
        return methodBuilder;
    }
}

