/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.VerifyArgument;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.TargetInvocationException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

public final class Delegate<T> {
    private final T _instance;
    private final MethodInfo _method;
    private MethodHandle _methodHandle;
    private MethodHandle _spreadInvoker;

    Delegate(T instance, MethodInfo method) {
        this._instance = VerifyArgument.notNull(instance, "instance");
        this._method = VerifyArgument.notNull(method, "method");
    }

    public final T getInstance() {
        return this._instance;
    }

    public final MethodInfo getMethod() {
        return this._method;
    }

    public final MethodHandle getMethodHandle() {
        if (this._methodHandle == null) {
            try {
                this._methodHandle = MethodHandles.lookup().unreflect(this._method.getRawMethod()).bindTo(this._instance);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not resolve method handle.");
            }
        }
        return this._methodHandle;
    }

    public final Object invokeDynamic(Object ... args) throws TargetInvocationException {
        try {
            if (this._spreadInvoker == null) {
                MethodHandle methodHandle = this.getMethodHandle();
                this._spreadInvoker = methodHandle.asSpreader(Object[].class, this._method.getParameters().size());
            }
            return this._spreadInvoker.invoke(args);
        }
        catch (Throwable t) {
            throw new TargetInvocationException(t);
        }
    }
}

