#!/usr/bin/env python3
"""
This module ensures exploits in local database are up to date.
"""

from source.modules._generic_module import *

class Module(GenericModule):
    def __init__(self):
        super().__init__()
        self.authors = [
            Author(name='Vitezslav Grygar', email='vitezslav.grygar@gmail.com', web='https://badsulog.blogspot.com'),
        ]
        
        self.name = 'locasploit.update.exploit'
        self.short_description = 'Updates CVE-exploit relationships.'
        self.references = [
            '',
        ]
        
        self.date = '2017-02-02'
        self.license = 'GNU GPLv2'
        self.version = '1.0'
        self.tags = [
            'locasploit',
            'update',
            'exploit',
            'exploitdb', 'exploit-db',
        ]
        self.description = """
This module parses http://cve.mitre.org/data/refs/refmap/source-EXPLOIT-DB.html and updates vuln.db database.

"""
        
        self.dependencies = {
        }
        self.changelog = """
"""

        self.reset_parameters()

    def reset_parameters(self):
        self.parameters = {
            'SILENT': Parameter(value='no', mandatory=True, description='Suppress the output'),
            'BACKGROUND' : Parameter(value='yes', mandatory=True, description='yes = run in background, no = wait for it...'),

        }

    def check(self, silent=None):
        if silent is None:
            silent = positive(self.parameters['SILENT'].value)
        result = CHECK_PROBABLY
        # check parameters
        silent = positive(self.parameters['SILENT'].value)
        if not positive(self.parameters['BACKGROUND'].value) and not negative(self.parameters['BACKGROUND'].value):
            if not silent:
                log.err('Bad %s value: %s.', 'BACKGROUND', self.parameters['BACKGROUND'].value)
            result = CHECK_FAILURE

        # can import urlib and html.parser?
        try:
            from urllib.request import urlretrieve
        except:
            if not silent:
                log.err('Cannot import urllib.request library (urllib5).')
            # TODO other ways?
            result = CHECK_FAILURE
        try:
            from html.parser import HTMLParser
        except:
            if not silent:
                log.err('Cannot import html.parser.')
            result = CHECK_FAILURE
        return result
    
    def run(self):
        silent = positive(self.parameters['SILENT'].value) 
        t = Thread(silent)
        if positive(self.parameters['BACKGROUND'].value):
            return t
        t.start()
        t.join()
        return None
    
        
class Thread(threading.Thread):
    def __init__(self, silent):
        threading.Thread.__init__(self)
        self.silent = silent
        self.terminate = False
    
    def run(self):
        from urllib.request import urlretrieve
        from urllib.error import HTTPError
        from html.parser import HTMLParser

        # HTML Parser
        class HTMLP(HTMLParser):
            def __init__(self):
                super().__init__()
                self.intable = False
                self.tmpkey = ''
                self.tmpvalue = []
                self.result = {}

            def error(self, message):
                pass

            def handle_starttag(self, tag, attrs):
                if tag == 'table':
                    self.intable = True
                    self.tmpkey = ''

            def handle_endtag(self, tag):
                if self.intable and tag == 'table':
                    self.add_previous_to_result()
                    self.intable = False
                    self.tmpkey = ''

            def add_previous_to_result(self):
                if self.tmpkey != '':
                    self.result[self.tmpkey] = self.tmpvalue

            def handle_data(self, data):
                if self.intable and len(data.strip())>0:
                    if data.startswith('EXPLOIT-DB:'):
                        self.add_previous_to_result()
                        self.tmpkey = data
                        self.tmpvalue = []
                    elif data.startswith('CVE-') and len(self.tmpkey)>0:
                        self.tmpvalue.append(data)
                        
           # END OF HTML PARSER
        
        # download page
        localfile = './vulnerabilities/exploit.html'
        try:
            urlretrieve('http://cve.mitre.org/data/refs/refmap/source-EXPLOIT-DB.html', localfile)
        except HTTPError:
            log.warn('Cannot get exploit data.')

        if self.terminate:
            return
        data = io.read_file('/', localfile)
        
        if data == IO_ERROR:
            log.err('Cannot read exploit data.')
            return
        
        # parse HTML
        parser = HTMLP()
        parser.feed(data) 
        if self.terminate:
            return
        db['vuln'].add_exploits(parser.result)
        if not self.silent:
            log.ok('Exploits updated.')
        
    # terminates the thread
    def stop(self):
        self.terminate = True
    

lib.module_objects.append(Module())
