#ifndef __STREAMBUFFER_H
#define __STREAMBUFFER_H
#pragma once
#pragma pack(push, 1)

enum {
    STREAM_ATTRIBUTE_INVALID = 0,
    STREAM_ATTRIBUTE_SKIPBMNOTIFICATION = 1,
    STREAM_ATTRIBUTE_BMDATA = 2,
    STREAM_ATTRIBUTE_FILECOPYPERFHINT = 3,
    STREAM_ATTRIBUTE_FILECOPYSOURCEPATH = 4,
    STREAM_ATTRIBUTE_FILECHANGEPERFHINT = 5,
    STREAM_ATTRIBUTE_FILEOPPROCESSID = 6,
    STREAM_ATTRIBUTE_FILEBACKUPWRITEPERFHINT = 7,
    STREAM_ATTRIBUTE_DONOTCACHESCANRESULT = 8,
    STREAM_ATTRIBUTE_SCANREASON = 9,
    STREAM_ATTRIBUTE_FILEID = 10,
    STREAM_ATTRIBUTE_FILEVOLUMESERIALNUMBER = 11,
    STREAM_ATTRIBUTE_FILEUSN = 12,
    STREAM_ATTRIBUTE_SCRIPTTYPE = 13,
    STREAM_ATTRIBUTE_PRIVATE = 14,
    STREAM_ATTRIBUTE_URL = 15,
    STREAM_ATTRIBUTE_REFERRALURL = 16,
    STREAM_ATTRIBUTE_SCRIPTID = 17,
    STREAM_ATTRIBUTE_HOSTAPPVERSION = 18,
    STREAM_ATTRIBUTE_THREAT_ID = 19,
    STREAM_ATTRIBUTE_THREAT_STATUS = 21,
    STREAM_ATTRIBUTE_LOFI = 22,
    STREAM_ATTRIBUTE_THREAT_RESOURCES = 25,
    STREAM_ATTRIBUTE_LOFI_RESOURCES = 26,
    STREAM_ATTRIBUTE_VOLATILE = 29,
    STREAM_ATTRIBUTE_REFERRERURL = 30,
    STREAM_ATTRIBUTE_REQUESTORMODE = 31,
    STREAM_ATTRIBUTE_CI_EA = 33,
    STREAM_ATTRIBUTE_CURRENT_FILEUSN = 34,
    STREAM_ATTRIBUTE_AVAILABLE_DSS_THREADS = 35,
    STREAM_ATTRIBUTE_IO_STATUS_BLOCK_FOR_NEW_FILE = 36,
    STREAM_ATTRIBUTE_DESIRED_ACCESS = 37,
    STREAM_ATTRIBUTE_FILEOPPROCESSNAME = 38,
    STREAM_ATTRIBUTE_DETAILED_SCAN_NEEDED = 39,
    STREAM_ATTRIBUTE_URL_HAS_GOOD_REPUTATION = 40,
    STREAM_ATTRIBUTE_SITE_HAS_GOOD_REPUTATION = 41,
    STREAM_ATTRIBUTE_URL_ZONE = 42,
    STREAM_ATTRIBUTE_CONTROL_GUID = 43,
    STREAM_ATTRIBUTE_CONTROL_VERSION = 44,
    STREAM_ATTRIBUTE_CONTROL_PATH = 45,
    STREAM_ATTRIBUTE_CONTROL_HTML = 46,
    STREAM_ATTRIBUTE_PAGE_CONTEXT = 47,
    STREAM_ATTRIBUTE_FRAME_URL = 48,
    STREAM_ATTRIBUTE_FRAME_HTML = 49,
    STREAM_ATTRIBUTE_ACTION_IE_BLOCK_PAGE = 50,
    STREAM_ATTRIBUTE_ACTION_IE_BLOCK_CONTROL = 51,
    STREAM_ATTRIBUTE_SHARE_ACCESS = 52,
    STREAM_ATTRIBUTE_OPEN_OPTIONS = 53,
    STREAM_ATTRIBUTE_DEVICE_CHARACTERISTICS = 54,
    STREAM_ATTRIBUTE_FILE_ATTRIBUTES = 55,
    STREAM_ATTRIBUTE_HAS_MOTW_ADS = 56,
    STREAM_ATTRIBUTE_SE_SIGNING_LEVEL = 57,
    STREAM_ATTRIBUTE_SESSION_ID = 58,
    STREAM_ATTRIBUTE_AMSI_APP_ID = 59,
    STREAM_ATTRIBUTE_AMSI_SESSION_ID = 60,
    STREAM_ATTRIBUTE_FILE_OPERATION_PPID = 61,
    STREAM_ATTRIBUTE_SECTOR_NUMBER = 62,
    STREAM_ATTRIBUTE_AMSI_CONTENT_NAME = 63,
    STREAM_ATTRIBUTE_AMSI_UAC_REQUEST_CONTEXT = 64,
    STREAM_ATTRIBUTE_RESOURCE_CONTEXT = 65,
    STREAM_ATTRIBUTE_OPEN_CREATEPROCESS_HINT = 66,
    STREAM_ATTRIBUTE_GENSTREAM_APP_NAME = 67,
    STREAM_ATTRIBUTE_GENSTREAM_SESSION_ID = 68,
    STREAM_ATTRIBUTE_GENSTREAM_CONTENT_NAME = 69,
    STREAM_ATTRIBUTE_OPEN_ACCESS_STATE_FLAGS = 70,
    STREAM_ATTRIBUTE_GENSTREAM_EXTERN_GUID = 71,
    STREAM_ATTRIBUTE_IS_CONTAINER_FILE = 72,
    STREAM_ATTRIBUTE_AMSI_REDIRECT_CHAIN = 75,
};

enum {
    SCANREASON_UNKNOWN = 0,
    SCANREASON_ONMOUNT = 1,
    SCANREASON_ONOPEN = 2,
    SCANREASON_ONFIRSTREAD = 3,
    SCANREASON_ONWRITE = 4,
    SCANREASON_ONMODIFIEDHANDLECLOSE = 5,
    SCANREASON_INMEMORY = 8,
    SCANREASON_VALIDATION_PRESCAN = 9,
    SCANREASON_VALIDATION_CONTENTSCAN = 0x0A,
    SCANREASON_ONVOLUMECLEANUP = 0x0B,
    SCANREASON_AMSI = 0x0C,
    SCANREASON_AMSI_UAC = 0x0D,
    SCANREASON_GENERICSTREAM = 0x0E,
    SCANREASON_IOAVSTREAM = 0x0F,
};

typedef struct _STREAMBUFFER_DESCRIPTOR {
    PVOID  UserPtr;
    DWORD  (* Read)(PVOID this, uint64_t Offset, PVOID Buffer, DWORD Size, PDWORD SizeRead);
    DWORD  (* Write)(PVOID this, uint64_t Offset, PVOID Buffer, DWORD Size, PDWORD TotalWritten);
    DWORD  (* GetSize)(PVOID this, uint64_t *FileSize);
    DWORD  (* SetSize)(PVOID this, uint64_t *FileSize);
    PWCHAR (* GetName)(PVOID this);
    DWORD  (* SetAttributes)(PVOID this, DWORD Attribute, PVOID Data, DWORD DataSize);
    DWORD  (* GetAttributes)(PVOID this, DWORD Attribute, PVOID Data, DWORD DataSize, PDWORD DataSizeWritten);
} STREAMBUFFER_DESCRIPTOR, *PSTREAMBUFFER_DESCRIPTOR;

typedef struct _SCANSTREAM_PARAMS {
    PSTREAMBUFFER_DESCRIPTOR    Descriptor;
    PSCAN_REPLY                 ScanReply;
    DWORD                       UnknownB;
    DWORD                       UnknownC;
} SCANSTREAM_PARAMS, *PSCANSTREAM_PARAMS;

#pragma pack(pop)
#endif // __STREAMBUFFER_H
