# LinkedInt
# Scrapes LinkedIn without using LinkedIn API
# Original scraper by @DisK0nn3cT (https://github.com/DisK0nn3cT/linkedin-gatherer)
# Modified by @vysecurity
# - Additions:
# --- UI Updates
# --- Constrain to company filters
# --- Addition of Hunter for e-mail prediction

#!/usr/bin/python3

import sys
import re
import time
import requests
import subprocess
import json
import argparse
import http.cookiejar
import configparser
import os
import base64
import urllib
import math
from urllib.request import urlopen
import string
from bs4 import BeautifulSoup
import urllib.parse

baseDir = os.path.dirname(os.path.realpath(sys.argv[0])) + os.path.sep

""" Setup Argument Parameters """
parser = argparse.ArgumentParser(description='Discovery LinkedIn')
parser.add_argument('-u', '--keywords', help='Keywords to search')
parser.add_argument('-o', '--output', help='Output file (do not include extensions)')
args = parser.parse_args()
config = configparser.RawConfigParser()
config.read(baseDir + 'LinkedInt.cfg')
api_key = config.get('API_KEYS', 'hunter')
username = config.get('CREDS', 'linkedin_username')
password = config.get('CREDS', 'linkedin_password')


def getCookies(cookie_jar, domain):
    cookie_dict = cookie_jar.get_dict(domain=domain)
    found = ['%s=%s' % (name, value) for (name, value) in cookie_dict.items()]
    return '; '.join(found)

def login():
    URL = 'https://www.linkedin.com'
    s = requests.Session()
    rv = s.get(URL + '/uas/login?trk=guest_homepage-basic_nav-header-signin')
    p = BeautifulSoup(rv.content, "html.parser")


    ac = p.find(attrs={'name' : 'ac'})['value']
    parentPageKey = p.find(attrs={'name' : 'parentPageKey'})['value']
    pageInstance = "urn:li:page:d_checkpoint_lg_consumerLogin;"
    trk = p.find(attrs={'name' : 'trk'})['value']
    authUUID = p.find(attrs={'name' : 'authUUID'})['value']
    session_redirect = p.find(attrs={'name' : 'session_redirect'})['value']
    fp_data = p.find(attrs={'name' : 'fp_data'})['value']
    apfc = p.find(attrs={'name' : 'apfc'})['value']
    dval = p.find(attrs={'name' : '_d'})['value']
    showGoogleOneTapLogin = p.find(attrs={'name' : 'showGoogleOneTapLogin'})['value']


    csrf = p.find(attrs={'name' : 'loginCsrfParam'})['value']
    csrf_token = p.find(attrs={'name':'csrfToken'})['value']
    sid_str = p.find(attrs={'name':'sIdString'})['value']

    postdata = {'csrfToken':csrf_token,
         'session_key':username, 'ac':ac,
         'sIdString':sid_str, 'parentPageKey':parentPageKey, 'pageInstance':pageInstance, 'trk':trk, 'authUUID':authUUID, 'session_redirect':session_redirect,
         'loginCsrfParam':csrf, 'fp_data':fp_data, 'apfc':apfc, '_d':dval, 'showGoogleOneTapLogin':showGoogleOneTapLogin, 'controlId': 'd_checkpoint_lg_consumerLogin-login_submit_button', 
         'session_password':password, 'loginFlow':'REMEMBER_ME_OPTIN'
        }
    #print(postdata)
    rv = s.post(URL + '/checkpoint/lg/login-submit', data=postdata)
    #print(rv.text)
    if ("behaviour that can result in restriction" in rv.text):
        print("[!] Your account is restricted, fix it before continuing")
        sys.exit(0)
    try:
        #print(s.cookies)
        cookie = getCookies(s.cookies, ".www.linkedin.com")
        
    except:
        print("[!] Cannot login")
        sys.exit(0)
    return cookie

def get_search():

    body = ""
    csv = []
    css = """<style>
    #employees {
        font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
        border-collapse: collapse;
        width: 100%;
    }

    #employees td, #employees th {
        border: 1px solid #ddd;
        padding: 8px;
    }

    #employees tr:nth-child(even){background-color: #f2f2f2;}

    #employees tr:hover {background-color: #ddd;}

    #employees th {
        padding-top: 12px;
        padding-bottom: 12px;
        text-align: left;
        background-color: #1F42B4;
        color: white;
    }
    </style>

    """

    header = """
    <center><p>
    <img src="data:image/png;base64,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" width=500 height=200>
    <p>LinkedInt Version 1.1 - Developed by Vincent Yiu (@vysecurity)<br>
    The tool is developed for testing and educational purposes only.<br>
    GitHub Sponsor Link (to support educational content): <a href="https://github.com/sponsors/vysecurity">https://github.com/sponsors/vysecurity</a>
    <p><table id=\"employees\">
             <tr>
             <th>Photo</th>
             <th>Name</th>
             <th>Possible Email:</th>
             <th>Job</th>
             <th>Location</th>
             </tr>
             """

    if bCompany:
	    if bAuto:
	        companyID = 0
	        url = "https://www.linkedin.com/voyager/api/typeahead/hits?q=blended&query=%s" % search
	        headers = {'Csrf-Token':'ajax:0397788525211216810', 'X-RestLi-Protocol-Version':'2.0.0'}
	        cookies['JSESSIONID'] = 'ajax:0397788525211216810'
	        r = requests.get(url, cookies=cookies, headers=headers)
	        content = json.loads(r.text)
	        firstID = 0
	        for i in range(0,len(content['elements'])):
	        	try:
	        		companyID = content['elements'][i]['hitInfo']['com.linkedin.voyager.typeahead.TypeaheadCompany']['id']
	        		if firstID == 0:
	        			firstID = companyID
	        		print("[Notice] Found company ID: %s" % companyID)
	        	except:
	        		continue
	        companyID = firstID
	        if companyID == 0:
	        	print("[WARNING] No valid company ID found in auto, please restart and find your own")
	    else:
	        companyID = bSpecific

	    print("")
	    
	    print("[*] Using company ID: %s" % companyID)

    if bCompany == False:
        url = "https://www.linkedin.com/voyager/api/search/cluster?count=40&guides=List()&keywords=%s&origin=OTHER&q=guided&start=0" % search
    else:
        url = "https://www.linkedin.com/voyager/api/search/cluster?count=40&guides=List(v->PEOPLE,facetCurrentCompany->%s)&origin=OTHER&q=guided&start=0" % (companyID)
    
    print(url)
    
    headers = {'Csrf-Token':'ajax:0397788525211216808', 'X-RestLi-Protocol-Version':'2.0.0'}
    cookies['JSESSIONID'] = 'ajax:0397788525211216808'
    r = requests.get(url, cookies=cookies, headers=headers)
    content = json.loads(r.text)
    data_total = content['elements'][0]['total']

    pages = int(math.ceil(data_total / 40.0))

    if pages == 0:
    	pages = 1

    if data_total % 40 == 0:
        pages = pages - 1 

    if pages == 0: 
    	print("[!] Try to use quotes in the search name")
    	sys.exit(0)
    
    print("[*] %i Results Found" % data_total)
    if data_total > 1000:
        pages = 25
        print("[*] LinkedIn only allows 1000 results. Refine keywords to capture all data")
    print("[*] Fetching %i Pages" % pages)
    print("")

    for p in range(pages):
        if bCompany == False:
            url = "https://www.linkedin.com/voyager/api/search/cluster?count=40&guides=List()&keywords=%s&origin=OTHER&q=guided&start=%i" % (search, p*40)
        else:
            url = "https://www.linkedin.com/voyager/api/search/cluster?count=40&guides=List(v->PEOPLE,facetCurrentCompany->%s)&origin=OTHER&q=guided&start=%i" % (companyID, p*40)
        r = requests.get(url, cookies=cookies, headers=headers)
        content = r.text.encode('UTF-8')
        content = json.loads(content)
        print("[*] Fetching page %i with %i results" % ((p),len(content['elements'][0]['elements'])))
        for c in content['elements'][0]['elements']:
            if 'com.linkedin.voyager.search.SearchProfile' in c['hitInfo'] and c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['headless'] == False:
                try:
                    data_industry = c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['industry']
                except:
                    data_industry = ""    
                data_firstname = c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['miniProfile']['firstName']
                data_lastname = c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['miniProfile']['lastName']
                data_slug = "https://www.linkedin.com/in/%s" % c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['miniProfile']['publicIdentifier']
                data_occupation = c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['miniProfile']['occupation']
                data_location = "" #c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['location']
                try:
                    data_picture = "%s%s" % (c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['miniProfile']['picture']['com.linkedin.common.VectorImage']['rootUrl'],c['hitInfo']['com.linkedin.voyager.search.SearchProfile']['miniProfile']['picture']['com.linkedin.common.VectorImage']['artifacts'][2]['fileIdentifyingUrlPathSegment'])
                except:
                    print("[*] No picture found for %s %s, %s" % (data_firstname, data_lastname, data_occupation))
                    data_picture = ""

               

                parts = data_lastname.split()

                name = data_firstname + " " + data_lastname
                fname = ""
                mname = ""
                lname = ""

                if len(parts) == 1:
                    fname = data_firstname
                    mname = '?'
                    lname = parts[0]
                elif len(parts) == 2:
                    fname = data_firstname
                    mname = parts[0]
                    lname = parts[1]
                elif len(parts) >= 3:
                    fname = data_firstname
                    lname = parts[0]
                else:
                    fname = data_firstname
                    lname = '?'

                fname = re.sub('[^A-Za-z]+', '', fname)
                mname = re.sub('[^A-Za-z]+', '', mname)
                lname = re.sub('[^A-Za-z]+', '', lname)

                if len(fname) == 0 or len(lname) == 0:
                    continue

              

                if prefix == 'full':
                    user = '{}{}{}'.format(fname, mname, lname)
                if prefix == 'firstlast':
                    user = '{}{}'.format(fname, lname)
                if prefix == 'firstmlast':
                    if len(mname) == 0:
                        user = '{}{}{}'.format(fname, mname, lname)
                    else:
                        user = '{}{}{}'.format(fname, mname[0], lname)
                if prefix == 'flast':
                    user = '{}{}'.format(fname[0], lname)
                if prefix == 'firstl':
                    user = '{}{}'.format(fname,lname[0])
                if prefix == 'first.last':
                    user = '{}.{}'.format(fname, lname)
                if prefix == 'first_last':
                    user = '{}_{}'.format(fname, lname)    
                if prefix == 'fmlast':
                    if len(mname) == 0:
                        user = '{}{}{}'.format(fname[0], mname, lname)
                    else:
                        user = '{}{}{}'.format(fname[0], mname[0], lname)
                if prefix == 'lastfirst':
                	user = '{}{}'.format(lname, fname)
                if prefix == 'first':
                	user = '{}'.format(fname)
	

                email = '{}@{}'.format(user, suffix)
                ct = ""
                if ("http" in data_picture):

                    data = requests.get(data_picture)
                    b64data = base64.b64encode(data.content).decode('ascii')
                    ct = data.headers['Content-Type']
                else:
                    b64data = "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"
                    ct = "image/jpeg"
                body += "<tr>" \
                    "<td><a href=\"%s\"><img src=\"data:%s;base64,%s\" width=200 height=200></a></td>" \
                    "<td><a href=\"%s\">%s</a></td>" \
                    "<td>%s</td>" \
                    "<td>%s</td>" \
                    "<td>%s</td>" \
                    "<a>" % (data_slug, ct ,b64data, data_slug, name, email, data_occupation, data_location)
                
                csv.append('"%s","%s","%s","%s","%s", "%s"' % (data_firstname, data_lastname, name, email, data_occupation, data_location.replace(",",";")))
                foot = "</table></center>"
                f = open(baseDir + '{}.html'.format(outfile), 'wb')
                f.write(css.encode())
                f.write(header.encode())
                f.write(body.encode())
                f.write(foot.encode())
                f.close()
                f = open(baseDir + '{}.csv'.format(outfile), 'wb')
                newcsv='\n'.join(csv)
                f.write(newcsv.encode())
                for x in csv:
                    f.write(x.join('\n').encode())
                f.close()
            else:
                print("[!] Headless profile found. Skipping")
        print("")
def authenticate():
    try:
    	a = login()
    	session = a
    	if len(session) == 0:
    		sys.exit("[!] Unable to login to LinkedIn.com")
    	print("[*] Obtained new session")
    	cookies = dict(li_at=session)
    except Exception:
        sys.exit("[!] Could not authenticate to linkedin. %s" % e)
    return cookies

if __name__ == '__main__':
    print("")
    a = open(baseDir + "banner.txt","r")
    print(a.read())
    a.close()
    print("")
    print("Version: 1.1 FIXED - March 27, 2021")
    print("Author: Vincent Yiu @vysecurity")
    print("")
    search = args.keywords if args.keywords!=None else input("[*] Enter search Keywords (use quotes for more precise results)\n")
    print("")
    outfile = args.output if args.output!=None else input("[*] Enter filename for output (exclude file extension)\n")
    print("") 
    while True:
        bCompany = input("[*] Filter by Company? (Y/N): \n")
        if bCompany.lower() == "y" or bCompany.lower() == "n":
            break
        else:
            print("[!] Incorrect choice")

    if bCompany.lower() == "y":
        bCompany = True
    else:
        bCompany = False

    bAuto = True
    bSpecific = 0
    prefix = ""
    suffix = ""

    print("")

    if bCompany:
	    while True:
	        bSpecific = input("[*] Specify a Company ID (Provide ID or leave blank to automate): \n")
	        if bSpecific != "":
	            bAuto = False
	            if bSpecific != 0:
	                try:
	                    int(bSpecific)
	                    break
	                except:
	                    print("[!] Incorrect choice, the ID either has to be a number or blank")
	                
	            else:
	                print("[!] Incorrect choice, the ID either has to be a number or blank")
	        else:
	            bAuto = True
	            break

    print("")

    
    while True:
        suffix = input("[*] Enter e-mail domain suffix (eg. contoso.com): \n")
        suffix = suffix.lower()
        if "." in suffix:
            break
        else:
            print("[!] Incorrect e-mail? There's no dot")

    print("")

    while True:
        prefix = input("[*] Select a prefix for e-mail generation (auto,full,firstlast,firstmlast,flast,firstl,first.last,fmlast,lastfirst,first): \n")
        prefix = prefix.lower()
        print("")
        if prefix == "full" or prefix == "firstlast" or prefix == "firstmlast" or prefix == "flast" or prefix == "firstl" or prefix =="first" or prefix == "first_last"or prefix == "first.last" or prefix == "fmlast" or prefix == "lastfirst":
            break
        elif prefix == "auto":
            print("[*] Automatically using Hunter IO to determine best Prefix")
            url = "https://api.hunter.io/v2/domain-search?domain=%s&api_key=%s" % (suffix, api_key)
            r = requests.get(url)
            content = json.loads(r.text)
            if "status" in content:
                print("[!] Rate limited by Hunter IO Key")
                continue
            prefix = content['data']['pattern']
            print("[!] %s" % prefix)
            if prefix:
                prefix = prefix.replace("{","").replace("}", "")
                if prefix == "full" or prefix == "firstlast" or prefix == "firstmlast" or prefix == "flast" or prefix == "firstl" or prefix =="first" or prefix == "first.last" or prefix == "fmlast" or prefix == "lastfirst":
                    print("[+] Found %s prefix" % prefix)
                    break
                else:
                    print("[!] Automatic prefix search failed, please insert a manual choice")
                    continue
            else:
                print("[!] Automatic prefix search failed, please insert a manual choice")
                continue
        else:
            print("[!] Incorrect choice, please select a value from (auto,full,firstlast,firstmlast,flast,firstl,first.last,fmlast)")

    print("")

    search = urllib.parse.quote_plus(search)
    cookies = authenticate()
  
    get_search()

    print("[+] Complete")
