"use strict";
var path = require('path');
var esprima = require('esprima');
var CoverageObject = require('./coverage/coverage-object');
var utils = require('../utils');
var JSFile = (function () {
    function JSFile(fileInfo, leenaConfig, cb) {
        this.pathFile = path.normalize(fileInfo.pathFile);
        this.fileName = path.basename(this.pathFile);
        this.pathTempFile = path.normalize(fileInfo.pathTempFile);
        this.tempFileName = path.basename(this.pathTempFile);
        this.leenaConfig = leenaConfig;
        this.initializeAttributes();
        this.coverageObject = new CoverageObject(this.coverageObjectName, this.pathTempFile, this.leenaConfig, this.originalAST, cb);
    }
    JSFile.prototype.containsFunction = function (functionName) {
        return this.coverageObject.containsFunction(functionName);
    };
    JSFile.prototype.executeFunction = function (functionName, cb) {
        this.coverageObject.executeFunction(functionName, cb);
    };
    JSFile.prototype.updateFunctionInstance = function (functionName, functionI) {
        this.coverageObject.updateFunctionInstance(functionName, functionI);
    };
    JSFile.prototype.getFunctionInstance = function (functionName) {
        return this.coverageObject.getFunctionInstance(functionName);
    };
    JSFile.prototype.initializeAttributes = function () {
        if ((this.content = utils.readFile(this.pathFile)) === null) {
            throw new Error('JSFile, unable to initialize content');
        }
        try {
            this.originalAST = esprima.parse(this.content, {
                loc: true
            });
        }
        catch (e) {
            throw e;
        }
        if ((this.instrumentedContent = utils.readFile(this.pathTempFile)) === null) {
            throw new Error('JSFile, unable to initialize instrumentedContent');
        }
        try {
            this.instrumentedAST = esprima.parse(this.instrumentedContent);
        }
        catch (e) {
            throw e;
        }
        this.coverageObjectName = this.getCoverageObjectName();
        if (this.coverageObjectName === null) {
            throw new Error('Unable to get coverage object name');
        }
    };
    JSFile.prototype.update = function () {
        this.initializeAttributes();
        this.coverageObject.update();
    };
    JSFile.prototype.getCoverageObjectName = function () {
        var coverageObjName;
        try {
            if (this.instrumentedAST.body.length > 0 &&
                this.instrumentedAST.body[0].declarations.length > 0) {
                coverageObjName = this.instrumentedAST.body[0].declarations[0].id.name;
            }
        }
        catch (e) {
            coverageObjName = null;
        }
        return coverageObjName;
    };
    return JSFile;
}());
module.exports = JSFile;
