"use strict";
var estraverse = require('estraverse');
var BRANCH_NODES = [
    'ConditionalExpression',
    'IfStatement',
    'SwitchStatement'
];
var LOOP_NODES = [
    'DoWhileStatement',
    'WhileStatement',
    'ForStatement'
];
function nodeIsBranch(nodeType) {
    var isBranch = (BRANCH_NODES.indexOf(nodeType) !== -1);
    return isBranch;
}
exports.nodeIsBranch = nodeIsBranch;
function nodeIsLoop(nodeType) {
    var isLoop = (LOOP_NODES.indexOf(nodeType) !== -1);
    return isLoop;
}
exports.nodeIsLoop = nodeIsLoop;
function getExpressionNodeNameOfBranch(nodeType) {
    var expressionNodeName = (nodeType === 'IfStatement' ||
        nodeType === 'ConditionalExpression')
        ? 'test'
        : (nodeType === 'SwitchStatement')
            ? 'discriminant'
            : null;
    return expressionNodeName;
}
exports.getExpressionNodeNameOfBranch = getExpressionNodeNameOfBranch;
function breakInTheLastNode(node) {
    var lastNode;
    var thereIsBreak;
    if (node === null || node.length === 0) {
        return false;
    }
    lastNode = node[node.length - 1];
    thereIsBreak = (lastNode.hasOwnProperty('type') &&
        lastNode.type === 'BreakStatement');
    return thereIsBreak;
}
exports.breakInTheLastNode = breakInTheLastNode;
function getNumberOfStatementsOfLoop(loopNode) {
    if (!loopNode.hasOwnProperty('type') || !loopNode.hasOwnProperty('body') || !nodeIsLoop(loopNode.type)) {
        return -1;
    }
    var nStatements = 0;
    estraverse.traverse(loopNode.body, {
        enter: function (node) {
            if (node.hasOwnProperty('type') && node.type.match(/.*Statement$/g) !== null) {
                if (node.type !== 'BlockStatement') {
                    nStatements++;
                }
            }
        }
    });
    return nStatements;
}
exports.getNumberOfStatementsOfLoop = getNumberOfStatementsOfLoop;
