import unittest
from exploits.linux.CVE20080600 import CVE20080600
from src.kernelpop import kernelpop
from constants import *


class TestExploitSetup(unittest.TestCase):
	def test_write_exploit_source(self):
		test_exploit = CVE20080600()
		kernelpop(mode="dump", exploit=test_exploit.name, digest=None)
		self.assertTrue(os.path.exists(test_exploit.source_c_path))
		if os.path.exists(test_exploit.source_c_path):
			os.remove(test_exploit.source_c_path)

	def test_modifying_playground_path(self):
		test_location = "/tmp/testdir"
		try:
			os.mkdir(test_location)
		except:
			pass
		test_exploit = CVE20080600(playground_path=test_location)
		test_exploit.write_exploit_source()
		self.assertTrue(test_location in test_exploit.source_c_path)
		if os.path.exists(test_exploit.source_c_path):
			os.remove(test_exploit.source_c_path)
		os.rmdir(test_location)

