/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractManagerList
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String PRIVILEGE_TOOLTIP = "PRIVILEGE_TOOLTIP";
    protected final transient List<ItemList> itemsList = new ArrayList<ItemList>();
    protected final JPanel lastLine = new JPanel();
    protected DnDList listPaths;
    protected final JScrollPane scrollListPaths;
    protected JButtonStateful run;
    protected JLabel privilege;
    protected String labelI18nRunButton;
    protected String tooltipI18nRunButton;
    protected final JProgressBar progressBar = new JProgressBar();
    protected final Component horizontalGlue = Box.createHorizontalGlue();

    protected AbstractManagerList(String nameFile) {
        this.setLayout(new BorderLayout());
        this.buildList(nameFile);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.lastLine.setLayout(new BoxLayout(this.lastLine, 0));
        this.scrollListPaths = new JScrollPane(this.listPaths);
        this.add((Component)this.scrollListPaths, "Center");
    }

    public void buildRunButton(String labelI18n, String tooltipI18n) {
        this.labelI18nRunButton = labelI18n;
        this.tooltipI18nRunButton = tooltipI18n;
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(this.tooltipI18nRunButton)));
        this.run = new JButtonStateful(this.labelI18nRunButton){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        I18nViewUtil.addComponentForKey(this.labelI18nRunButton, this.run);
        I18nViewUtil.addComponentForKey(this.tooltipI18nRunButton, tooltip.get());
        this.run.setToolTipText(I18nUtil.valueByKey(this.tooltipI18nRunButton));
    }

    public void buildList(String nameFile) {
        try (InputStream inputStream = UiUtil.class.getClassLoader().getResourceAsStream(nameFile);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                this.itemsList.add(new ItemList(line));
            }
            this.listPaths = new DnDList(this.itemsList);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void buildPrivilege() {
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(PRIVILEGE_TOOLTIP)));
        this.privilege = new JLabel(I18nUtil.valueByKey("PRIVILEGE_LABEL"), UiUtil.SQUARE.getIcon(), 2){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        I18nViewUtil.addComponentForKey("PRIVILEGE_LABEL", this.privilege);
        I18nViewUtil.addComponentForKey(PRIVILEGE_TOOLTIP, tooltip.get());
        this.privilege.setToolTipText(I18nUtil.valueByKey(PRIVILEGE_TOOLTIP));
        this.lastLine.add(Box.createHorizontalStrut(5));
        this.lastLine.add(this.privilege);
        this.lastLine.add(this.horizontalGlue);
        this.lastLine.add(this.progressBar);
        this.lastLine.add(this.run);
    }

    public void addToList(String element) {
        AtomicBoolean isFound = new AtomicBoolean(false);
        DefaultListModel listModel = (DefaultListModel)this.listPaths.getModel();
        Iterable iterable = () -> listModel.elements().asIterator();
        StreamSupport.stream(iterable.spliterator(), false).filter(itemList -> itemList.toString().equals(element)).forEach(itemList -> isFound.set(true));
        if (!isFound.get()) {
            listModel.add(0, new ItemList(element));
        }
    }

    public void highlight(String url, String tag) {
        String itemLabel = String.format(" [%s]", tag);
        DefaultListModel listModel = (DefaultListModel)this.listPaths.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ItemList itemList = (ItemList)listModel.getElementAt(i);
            if (!url.contains(itemList.getOriginalString())) continue;
            itemList.setVulnerable(true);
            itemList.setInternalString(itemList.getInternalString().replace(itemLabel, "") + itemLabel);
            listModel.setElementAt(itemList, i);
        }
    }

    public void endProcess() {
        SwingUtilities.invokeLater(() -> {
            this.run.setText(I18nViewUtil.valueByKey(this.labelI18nRunButton));
            this.setButtonEnable(true);
            this.progressBar.setVisible(false);
            this.horizontalGlue.setVisible(true);
            this.run.setState(StateButton.STARTABLE);
        });
    }

    public void setButtonEnable(boolean isEnable) {
        this.run.setEnabled(isEnable);
    }

    public void changePrivilegeIcon(Icon icon) {
        this.privilege.setIcon(icon);
    }
}

