/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IndexSubTableFormat1
extends IndexSubTable {
    private IndexSubTableFormat1(ReadableFontData readableFontData, int n, int n2) {
        super(readableFontData, n, n2);
    }

    @Override
    public int numGlyphs() {
        return this.lastGlyphIndex() - this.firstGlyphIndex() + 1;
    }

    @Override
    public int glyphStartOffset(int n) {
        int n2 = this.checkGlyphRange(n);
        return this.loca(n2);
    }

    @Override
    public int glyphLength(int n) {
        int n2 = this.checkGlyphRange(n);
        return this.loca(n2 + 1) - this.loca(n2);
    }

    private int loca(int n) {
        return this.imageDataOffset() + this.data.readULongAsInt(EblcTable.Offset.indexSubTable1_offsetArray.offset + n * FontData.DataSize.ULONG.size());
    }

    public static final class Builder
    extends IndexSubTable.Builder<IndexSubTableFormat1> {
        private List<Integer> offsetArray;

        public static Builder createBuilder() {
            return new Builder();
        }

        static Builder createBuilder(ReadableFontData readableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(readableFontData, n, n2, n3);
            return new Builder(readableFontData.slice(n, n4), n2, n3);
        }

        static Builder createBuilder(WritableFontData writableFontData, int n, int n2, int n3) {
            int n4 = Builder.dataLength(writableFontData, n, n2, n3);
            return new Builder(writableFontData.slice(n, n4), n2, n3);
        }

        private static int dataLength(ReadableFontData readableFontData, int n, int n2, int n3) {
            return EblcTable.Offset.indexSubHeaderLength.offset + (n3 - n2 + 1 + 1) * FontData.DataSize.ULONG.size();
        }

        private Builder() {
            super(EblcTable.Offset.indexSubTable1_builderDataSize.offset, 1);
        }

        private Builder(WritableFontData writableFontData, int n, int n2) {
            super(writableFontData, n, n2);
        }

        private Builder(ReadableFontData readableFontData, int n, int n2) {
            super(readableFontData, n, n2);
        }

        @Override
        public int numGlyphs() {
            return this.getOffsetArray().size() - 1;
        }

        @Override
        public int glyphLength(int n) {
            int n2 = this.checkGlyphRange(n);
            List<Integer> list = this.getOffsetArray();
            return list.get(n2 + 1) - list.get(n2);
        }

        @Override
        public int glyphStartOffset(int n) {
            int n2 = this.checkGlyphRange(n);
            List<Integer> list = this.getOffsetArray();
            return list.get(n2);
        }

        public List<Integer> offsetArray() {
            return this.getOffsetArray();
        }

        private List<Integer> getOffsetArray() {
            if (this.offsetArray == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.offsetArray;
        }

        private void initialize(ReadableFontData readableFontData) {
            if (this.offsetArray == null) {
                this.offsetArray = new ArrayList<Integer>();
            } else {
                this.offsetArray.clear();
            }
            if (readableFontData != null) {
                int n = this.lastGlyphIndex() - this.firstGlyphIndex() + 1 + 1;
                for (int i = 0; i < n; ++i) {
                    this.offsetArray.add(readableFontData.readULongAsInt(EblcTable.Offset.indexSubTable1_offsetArray.offset + i * FontData.DataSize.ULONG.size()));
                }
            }
        }

        public void setOffsetArray(List<Integer> list) {
            this.offsetArray = list;
            this.setModelChanged();
        }

        @Override
        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        @Override
        protected void revert() {
            super.revert();
            this.offsetArray = null;
        }

        @Override
        protected IndexSubTableFormat1 subBuildTable(ReadableFontData readableFontData) {
            return new IndexSubTableFormat1(readableFontData, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.offsetArray == null) {
                return this.internalReadData().length();
            }
            return EblcTable.Offset.indexSubHeaderLength.offset + this.offsetArray.size() * FontData.DataSize.ULONG.size();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.offsetArray != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = super.serializeIndexSubHeader(writableFontData);
            if (!this.modelChanged()) {
                n += this.internalReadData().slice(EblcTable.Offset.indexSubTable1_offsetArray.offset).copyTo(writableFontData.slice(EblcTable.Offset.indexSubTable1_offsetArray.offset));
            } else {
                for (Integer n2 : this.offsetArray) {
                    n += writableFontData.writeULong(n, n2.intValue());
                }
            }
            return n;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            private int glyphId;

            public BitmapGlyphInfoIterator() {
                this.glyphId = Builder.this.firstGlyphIndex();
            }

            @Override
            public boolean hasNext() {
                return this.glyphId <= Builder.this.lastGlyphIndex();
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                BitmapGlyphInfo bitmapGlyphInfo = new BitmapGlyphInfo(this.glyphId, Builder.this.imageDataOffset(), Builder.this.glyphStartOffset(this.glyphId), Builder.this.glyphLength(this.glyphId), Builder.this.imageFormat());
                ++this.glyphId;
                return bitmapGlyphInfo;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }
}

