/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.process.win32;

import com.jpexs.helpers.ProgressListener;
import com.jpexs.process.Process;
import com.jpexs.process.ProcessTools;
import com.jpexs.process.win32.Win32Process;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.BITMAP;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Gdi32;
import com.sun.jna.platform.win32.ICONINFO;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.MEMORY_BASIC_INFORMATION;
import com.sun.jna.platform.win32.PROCESSENTRY32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.SHFILEINFO;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Win32ProcessTools
extends ProcessTools {
    private static final Map<String, Character> driveMappings = Win32ProcessTools.getDriveMappings();
    private static boolean privAdjusted = false;

    private static long pointerToAddress(Pointer p) {
        String s = p.toString();
        s = s.replace("native@0x", "");
        return Long.parseLong(s, 16);
    }

    public static List<MEMORY_BASIC_INFORMATION> getPageRanges(WinNT.HANDLE hOtherProcess) {
        ArrayList<MEMORY_BASIC_INFORMATION> ret = new ArrayList<MEMORY_BASIC_INFORMATION>();
        WinBase.SYSTEM_INFO si = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(si);
        Pointer lpMem = si.lpMinimumApplicationAddress;
        while (Win32ProcessTools.pointerToAddress(lpMem) < Win32ProcessTools.pointerToAddress(si.lpMaximumApplicationAddress)) {
            MEMORY_BASIC_INFORMATION mbi = new MEMORY_BASIC_INFORMATION();
            BaseTSD.SIZE_T t = Kernel32.INSTANCE.VirtualQueryEx(hOtherProcess, lpMem, mbi, new BaseTSD.SIZE_T(mbi.size()));
            if (t.longValue() == 0L) {
                Logger.getLogger(Win32ProcessTools.class.getName()).log(Level.SEVERE, "Cannot get page ranges. Last error:{0}", Kernel32.INSTANCE.GetLastError());
                break;
            }
            ret.add(mbi);
            lpMem = new Pointer(Win32ProcessTools.pointerToAddress(mbi.baseAddress) + mbi.regionSize.longValue());
        }
        return ret;
    }

    public static void printMemInfo(MEMORY_BASIC_INFORMATION mbi) {
        System.out.println("Region size:" + (Object)((Object)mbi.regionSize));
        String stateStr = "";
        if ((mbi.state.intValue() & 0x1000) == 4096) {
            stateStr = stateStr + " commit";
        }
        if ((mbi.state.intValue() & 0x10000) == 65536) {
            stateStr = stateStr + " free";
        }
        if ((mbi.state.intValue() & 0x2000) == 8192) {
            stateStr = stateStr + " reserve";
        }
        stateStr = stateStr.trim();
        String typeStr = "";
        if ((mbi.type.intValue() & 0x1000000) == 0x1000000) {
            typeStr = typeStr + " image";
        }
        if ((mbi.type.intValue() & 0x40000) == 262144) {
            typeStr = typeStr + " mapped";
        }
        if ((mbi.type.intValue() & 0x20000) == 131072) {
            typeStr = typeStr + " private";
        }
        typeStr = typeStr.trim();
        String protStr = "";
        if ((mbi.allocationProtect.intValue() & 0x10) == 16) {
            protStr = protStr + " execute";
        }
        if ((mbi.allocationProtect.intValue() & 0x20) == 32) {
            protStr = protStr + " execute_read";
        }
        if ((mbi.allocationProtect.intValue() & 0x40) == 64) {
            protStr = protStr + " execute_readwrite";
        }
        if ((mbi.allocationProtect.intValue() & 2) == 2) {
            protStr = protStr + " readonly";
        }
        if ((mbi.allocationProtect.intValue() & 4) == 4) {
            protStr = protStr + " readwrite";
        }
        if ((mbi.allocationProtect.intValue() & 8) == 8) {
            protStr = protStr + " writecopy";
        }
        protStr = protStr.trim();
        System.out.println("State:" + stateStr);
        System.out.println("Type:" + typeStr);
        System.out.println("Protect:" + protStr);
        System.out.println("baseAddress:" + mbi.baseAddress);
        System.out.println("========================");
    }

    private static byte[] mergeArrays(byte[] one, byte[] two) {
        byte[] combined = new byte[one.length + two.length];
        System.arraycopy(one, 0, combined, 0, one.length);
        System.arraycopy(two, 0, combined, one.length, two.length);
        return combined;
    }

    public static Map<String, Character> getDriveMappings() {
        HashMap<String, Character> ret = new HashMap<String, Character>();
        for (char d = 'A'; d <= 'Z'; d = (char)(d + '\u0001')) {
            char[] buf = new char[1024];
            int len = Kernel32.INSTANCE.QueryDosDevice(d + ":", buf, buf.length).intValue();
            String tar = new String(buf, 0, len);
            if ("".equals(tar = tar.trim())) continue;
            ret.put(tar, Character.valueOf(d));
        }
        return ret;
    }

    public static String ntPathToWin32(String path) {
        for (String dp : driveMappings.keySet()) {
            if (!path.startsWith(dp)) continue;
            return driveMappings.get(dp) + ":" + path.substring(dp.length());
        }
        return path;
    }

    public static boolean drawIcon(BufferedImage ret, WinDef.HICON hIcon, int diFlags) {
        WinDef.HDC hdcScreen = User32.INSTANCE.GetDC(null);
        WinDef.HDC hdcMem = Gdi32.INSTANCE.CreateCompatibleDC(hdcScreen);
        WinDef.HBITMAP bitmap = Gdi32.INSTANCE.CreateCompatibleBitmap(hdcScreen, ret.getWidth(), ret.getHeight());
        WinNT.HANDLE hbmOld = Gdi32.INSTANCE.SelectObject(hdcMem, bitmap);
        WinNT.HANDLE hBrush = Gdi32.INSTANCE.CreateSolidBrush(new WinDef.DWORD(0xFFFFFFL));
        WinDef.RECT rect = new WinDef.RECT();
        rect.left = 0;
        rect.top = 0;
        rect.right = ret.getWidth();
        rect.bottom = ret.getHeight();
        User32.INSTANCE.FillRect(hdcMem, rect, hBrush);
        Gdi32.INSTANCE.DeleteObject(hBrush);
        boolean ok = User32.INSTANCE.DrawIconEx(hdcMem, 0, 0, hIcon, ret.getWidth(), ret.getHeight(), new WinDef.UINT(0L), new WinDef.HBRUSH(Pointer.NULL), diFlags);
        if (!ok) {
            return false;
        }
        for (int x = 0; x < ret.getWidth(); ++x) {
            for (int y = 0; y < ret.getHeight(); ++y) {
                int rgb = Gdi32.INSTANCE.GetPixel(hdcMem, x, y).intValue();
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                rgb = (b << 16) + (g << 8) + r;
                ret.setRGB(x, y, rgb);
            }
        }
        Gdi32.INSTANCE.SelectObject(hdcMem, hbmOld);
        Gdi32.INSTANCE.DeleteObject(bitmap);
        Gdi32.INSTANCE.DeleteDC(hdcMem);
        User32.INSTANCE.ReleaseDC(null, hdcScreen);
        return true;
    }

    private static void applyMask(BufferedImage image, BufferedImage mask) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int masked = mask.getRGB(x, y);
                int alpha = 255 - (masked & 0xFF);
                if (alpha != 0 && alpha != 255) {
                    System.out.println("a=" + alpha);
                }
                int rgb = image.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                r = r * alpha / 255;
                g = g * alpha / 255;
                b = b * alpha / 255;
                rgb = (r << 16) + (g << 8) + b;
                rgb = alpha << 24 | rgb;
                image.setRGB(x, y, rgb);
            }
        }
    }

    public static BufferedImage iconToImage(WinDef.HICON hIcon) {
        int nWrittenBytes;
        ICONINFO info = new ICONINFO();
        boolean ok = User32.INSTANCE.GetIconInfo(hIcon, info);
        if (!ok) {
            return null;
        }
        BufferedImage ret = null;
        BITMAP bmp = new BITMAP();
        if (info.hbmColor != null) {
            nWrittenBytes = Gdi32.INSTANCE.GetObject(info.hbmColor, bmp.size(), bmp);
            if (nWrittenBytes > 0) {
                ret = new BufferedImage(bmp.bmWidth.intValue(), bmp.bmHeight.intValue(), 2);
            }
        } else if (info.hbmMask != null && (nWrittenBytes = Gdi32.INSTANCE.GetObject(info.hbmMask, bmp.size(), bmp)) > 0) {
            ret = new BufferedImage(bmp.bmWidth.intValue(), bmp.bmHeight.intValue() / 2, 2);
        }
        if (ret == null) {
            return ret;
        }
        if (info.hbmColor != null) {
            Gdi32.INSTANCE.DeleteObject(info.hbmColor);
        }
        if (info.hbmMask != null) {
            Gdi32.INSTANCE.DeleteObject(info.hbmMask);
        }
        Win32ProcessTools.drawIcon(ret, hIcon, 3);
        BufferedImage mask = new BufferedImage(ret.getWidth(), ret.getHeight(), 1);
        Win32ProcessTools.drawIcon(mask, hIcon, 1);
        Win32ProcessTools.applyMask(ret, mask);
        return ret;
    }

    public static BufferedImage getShellIcon(String path) {
        SHFILEINFO fi = new SHFILEINFO();
        BaseTSD.DWORD_PTR r = Shell32.INSTANCE.SHGetFileInfo(path, 0, fi, fi.size(), 257);
        if (r.intValue() == 0) {
            return null;
        }
        return Win32ProcessTools.iconToImage(fi.hIcon);
    }

    public static BufferedImage extractExeIcon(String fullExeFile, int index, boolean large) {
        PointerByReference iconsLargeRef = new PointerByReference();
        PointerByReference iconsSmallRef = new PointerByReference();
        int cnt = Shell32.INSTANCE.ExtractIconEx(fullExeFile, index, iconsLargeRef, iconsSmallRef, new WinDef.UINT(1L)).intValue();
        if (cnt == 0) {
            return null;
        }
        Pointer iconsLarge = iconsLargeRef.getPointer();
        Pointer iconsSmall = iconsSmallRef.getPointer();
        WinDef.HICON icon = large ? new WinDef.HICON(iconsLarge.getPointer(0L)) : new WinDef.HICON(iconsSmall.getPointer(0L));
        BufferedImage ic = Win32ProcessTools.iconToImage(icon);
        User32.INSTANCE.DestroyIcon(icon);
        return ic;
    }

    public static List<Process> listProcesses() {
        PROCESSENTRY32 pe;
        if (!privAdjusted) {
            Win32ProcessTools.adjustPrivileges();
        }
        ArrayList<Process> ret = new ArrayList<Process>();
        WinNT.HANDLE hSnapShot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(new WinDef.DWORD(2L), new WinDef.DWORD(0L));
        if (Kernel32.INSTANCE.Process32First(hSnapShot, pe = new PROCESSENTRY32())) {
            do {
                int rn2;
                int i;
                for (i = 0; i < pe.szExeFile.length && pe.szExeFile[i] != '\u0000'; ++i) {
                }
                String exeFile = new String(pe.szExeFile, 0, i);
                char[] outputnames = new char[1024];
                WinNT.HANDLE tempProcess = Kernel32.INSTANCE.OpenProcess(1024, false, pe.th32ProcessID);
                if (tempProcess == null) continue;
                try {
                    rn2 = Psapi.INSTANCE.GetProcessImageFileNameW(tempProcess, outputnames, 1024);
                    if (rn2 == 0) {
                        Logger.getLogger(Win32ProcessTools.class.getName()).log(Level.SEVERE, "Can't get EXE path");
                    }
                }
                catch (Exception | UnsatisfiedLinkError rn2) {
                    // empty catch block
                }
                try {
                    rn2 = Kernel32.INSTANCE.GetProcessImageFileNameW(tempProcess, outputnames, 1024);
                    if (rn2 == 0) {
                        Logger.getLogger(Win32ProcessTools.class.getName()).log(Level.SEVERE, "Can't get EXE path");
                    }
                }
                catch (Exception | UnsatisfiedLinkError rn3) {
                    // empty catch block
                }
                for (i = 0; i < outputnames.length && outputnames[i] != '\u0000'; ++i) {
                }
                String fullExeFile = new String(outputnames, 0, i);
                fullExeFile = Win32ProcessTools.ntPathToWin32(fullExeFile);
                ret.add(new Win32Process(fullExeFile, exeFile, Win32ProcessTools.getShellIcon(fullExeFile), pe.th32ProcessID));
            } while (Kernel32.INSTANCE.Process32Next(hSnapShot, pe));
        }
        return ret;
    }

    private static boolean pageReadable(MEMORY_BASIC_INFORMATION mbi) {
        int iUnReadable = 0;
        iUnReadable |= mbi.state.intValue() == 65536 ? 1 : 0;
        iUnReadable |= mbi.state.intValue() == 8192 ? 1 : 0;
        iUnReadable |= mbi.protect.intValue() & 8;
        iUnReadable |= mbi.protect.intValue() & 0x10;
        iUnReadable |= mbi.protect.intValue() & 0x100;
        return (iUnReadable |= mbi.protect.intValue() & 1) == 0;
    }

    public static Map<Long, InputStream> findBytesInProcessMemory(ProgressListener progListener, WinDef.DWORD dwProcessID, byte[][] findBytesAll) {
        int maxFindLen = 0;
        for (int i = 0; i < findBytesAll.length; ++i) {
            if (findBytesAll[i].length <= maxFindLen) continue;
            maxFindLen = findBytesAll[i].length;
        }
        HashMap<Long, InputStream> ret = new HashMap<Long, InputStream>();
        WinNT.HANDLE hOtherProcess = Kernel32.INSTANCE.OpenProcess(1080, false, dwProcessID);
        List<MEMORY_BASIC_INFORMATION> pages = Win32ProcessTools.getPageRanges(hOtherProcess);
        long totalMemLen = 0L;
        int progress = 0;
        for (int pg = 0; pg < pages.size(); ++pg) {
            totalMemLen += pages.get((int)pg).regionSize.longValue();
        }
        long actualPos = 0L;
        ArrayList<Integer> guardedPages = new ArrayList<Integer>();
        for (int pg = 0; pg < pages.size(); ++pg) {
            MEMORY_BASIC_INFORMATION mbi = pages.get(pg);
            if (Win32ProcessTools.pageReadable(mbi)) {
                NativeLongByReference bytesReadRef;
                Memory buf;
                boolean ok;
                long addr = Win32ProcessTools.pointerToAddress(mbi.baseAddress);
                int maxsize = mbi.regionSize.intValue();
                long pos = 0L;
                long bufSize = 524288L;
                while ((ok = Kernel32.INSTANCE.ReadProcessMemory(hOtherProcess, new Pointer(addr + pos), (Pointer)(buf = new Memory(bufSize)), new NativeLong(bufSize), bytesReadRef = new NativeLongByReference())) && bytesReadRef.getValue().longValue() != 0L) {
                    int newprogress;
                    byte[] data = buf.getByteArray(0L, bytesReadRef.getValue().intValue());
                    byte[] prevBytes = Arrays.copyOfRange(data, data.length - maxFindLen, data.length);
                    byte[] dataPlusPrev = Win32ProcessTools.mergeArrays(prevBytes, data);
                    for (int i = 0; i < dataPlusPrev.length - maxFindLen; ++i) {
                        block5: for (int k = 0; k < findBytesAll.length; ++k) {
                            if (dataPlusPrev[i] != findBytesAll[k][0]) continue;
                            for (int p = 1; p < findBytesAll[k].length; ++p) {
                                if (dataPlusPrev[i + p] != findBytesAll[k][p]) continue block5;
                            }
                            long dataAddr = addr + pos - (long)prevBytes.length + (long)i;
                            ret.put(dataAddr, new ProcessMemoryInputStream(pages, hOtherProcess, pg, pos - (long)prevBytes.length + (long)i));
                        }
                    }
                    if (progListener != null && (newprogress = Math.round((actualPos + (pos += bytesReadRef.getValue().longValue())) * 100L / totalMemLen)) != progress) {
                        progress = newprogress;
                        progListener.progress(progress);
                    }
                    if (pos + bufSize >= (long)maxsize) {
                        bufSize = (long)maxsize - pos;
                    }
                    if (bufSize > 0L) continue;
                    break;
                }
            } else if (Win32ProcessTools.hasGuard(mbi) && Win32ProcessTools.unsetGuard(hOtherProcess, mbi)) {
                guardedPages.add(pg);
                --pg;
                continue;
            }
            int newprogress = Math.round((actualPos += mbi.regionSize.longValue()) * 100L / totalMemLen);
            if (newprogress == progress) continue;
            progress = newprogress;
            progListener.progress(progress);
        }
        Iterator iterator = guardedPages.iterator();
        while (iterator.hasNext()) {
            int pg = (Integer)iterator.next();
            Win32ProcessTools.setGuard(hOtherProcess, pages.get(pg));
        }
        return ret;
    }

    private static boolean hasGuard(MEMORY_BASIC_INFORMATION mbi) {
        return (mbi.protect.intValue() & 0x100) == 256;
    }

    private static boolean unsetGuard(WinNT.HANDLE hOtherProcess, MEMORY_BASIC_INFORMATION mbi) {
        if (!Win32ProcessTools.hasGuard(mbi)) {
            return true;
        }
        int oldProt = mbi.protect.intValue();
        int newProt = oldProt - 256;
        IntByReference oldProtRef = new IntByReference();
        boolean ok = Kernel32.INSTANCE.VirtualProtectEx(hOtherProcess, new WinDef.LPVOID(Win32ProcessTools.pointerToAddress(mbi.baseAddress)), mbi.regionSize, newProt, oldProtRef);
        if (ok) {
            mbi.protect = new NativeLong((long)newProt);
            return true;
        }
        return false;
    }

    private static boolean setGuard(WinNT.HANDLE hOtherProcess, MEMORY_BASIC_INFORMATION mbi) {
        if (Win32ProcessTools.hasGuard(mbi)) {
            return true;
        }
        int oldProt = mbi.protect.intValue();
        int newProt = oldProt | 0x100;
        IntByReference oldProtRef = new IntByReference();
        boolean ok = Kernel32.INSTANCE.VirtualProtectEx(hOtherProcess, new WinDef.LPVOID(Win32ProcessTools.pointerToAddress(mbi.baseAddress)), mbi.regionSize, newProt, oldProtRef);
        if (ok) {
            mbi.protect = new NativeLong((long)newProt);
            return true;
        }
        return false;
    }

    public static boolean adjustPrivileges() {
        WinNT.TOKEN_PRIVILEGES tp = new WinNT.TOKEN_PRIVILEGES(1);
        WinNT.TOKEN_PRIVILEGES oldtp = new WinNT.TOKEN_PRIVILEGES(1);
        WinNT.LUID luid = new WinNT.LUID();
        WinNT.HANDLEByReference hTokenRef = new WinNT.HANDLEByReference();
        if (!Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hTokenRef)) {
            return false;
        }
        WinNT.HANDLE hToken = hTokenRef.getValue();
        if (!Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid)) {
            Kernel32.INSTANCE.CloseHandle(hToken);
            return false;
        }
        tp.PrivilegeCount = new WinDef.DWORD(1L);
        tp.Privileges = new WinNT.LUID_AND_ATTRIBUTES[1];
        tp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        IntByReference retSize = new IntByReference(0);
        if (!Advapi32.INSTANCE.AdjustTokenPrivileges(hToken, false, tp, tp.size(), oldtp, retSize)) {
            Kernel32.INSTANCE.CloseHandle(hToken);
            return false;
        }
        Kernel32.INSTANCE.CloseHandle(hToken);
        privAdjusted = true;
        return true;
    }

    private static class ProcessMemoryInputStream
    extends InputStream {
        private final List<MEMORY_BASIC_INFORMATION> pages;
        private int currentPage = 0;
        private long pagePos = 0L;
        private static final int BUFFER_SIZE = 524288;
        private byte[] buf;
        private int bufPos;
        private final WinNT.HANDLE hOtherProcess;

        public ProcessMemoryInputStream(List<MEMORY_BASIC_INFORMATION> pages, WinNT.HANDLE hOtherProcess, int currentPage, long pagePos) {
            this.pages = pages;
            this.hOtherProcess = hOtherProcess;
            this.currentPage = currentPage;
            this.pagePos = pagePos;
        }

        private boolean readNext() throws IOException {
            MEMORY_BASIC_INFORMATION mbi = this.pages.get(this.currentPage);
            if (!Win32ProcessTools.pageReadable(mbi)) {
                if (Win32ProcessTools.hasGuard(mbi) && Win32ProcessTools.unsetGuard(this.hOtherProcess, mbi)) {
                    boolean ret = this.readNext();
                    Win32ProcessTools.setGuard(this.hOtherProcess, mbi);
                    return ret;
                }
                if (this.currentPage + 1 < this.pages.size()) {
                    this.pagePos = 0L;
                    ++this.currentPage;
                    return this.readNext();
                }
                return false;
            }
            long addr = Win32ProcessTools.pointerToAddress(mbi.baseAddress);
            int maxsize = mbi.regionSize.intValue();
            NativeLongByReference bytesReadRef = new NativeLongByReference();
            Memory membuf = new Memory(524288L);
            NativeLong bufSize = new NativeLong(524288L);
            if (this.pagePos + bufSize.longValue() > (long)maxsize) {
                bufSize.setValue((long)maxsize - this.pagePos);
            }
            if (bufSize.longValue() == 0L) {
                if (this.currentPage + 1 < this.pages.size()) {
                    this.pagePos = 0L;
                    ++this.currentPage;
                    return this.readNext();
                }
                return false;
            }
            boolean ok = Kernel32.INSTANCE.ReadProcessMemory(this.hOtherProcess, new Pointer(addr + this.pagePos), (Pointer)membuf, bufSize, bytesReadRef);
            if (!ok) {
                throw new IOException("Cannot read memory");
            }
            if (bytesReadRef.getValue().longValue() == 0L) {
                return this.readNext();
            }
            this.pagePos += bytesReadRef.getValue().longValue();
            this.buf = membuf.getByteArray(0L, bytesReadRef.getValue().intValue());
            return true;
        }

        @Override
        public int read() throws IOException {
            if (this.buf == null || this.bufPos >= this.buf.length) {
                if (this.buf != null) {
                    this.bufPos = 0;
                }
                if (!this.readNext()) {
                    return -1;
                }
            }
            return this.buf[this.bufPos++] & 0xFF;
        }
    }
}

