/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.action;

import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraph;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.deobfuscation.BrokenScriptDetector;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParser;
import com.jpexs.decompiler.flash.action.parser.script.ActionScript2Parser;
import com.jpexs.decompiler.flash.action.parser.script.ActionScriptLexer;
import com.jpexs.decompiler.flash.action.parser.script.ParsedSymbol;
import com.jpexs.decompiler.flash.action.parser.script.SymbolType;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebugPanel;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.GraphDialog;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.SearchPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.controls.NoneSelectedButtonGroup;
import com.jpexs.decompiler.flash.gui.editor.DebuggableEditorPane;
import com.jpexs.decompiler.flash.gui.editor.LinkHandler;
import com.jpexs.decompiler.flash.gui.tagtree.TagTreeModel;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.search.ActionScriptSearch;
import com.jpexs.decompiler.flash.search.ActionSearchResult;
import com.jpexs.decompiler.flash.search.ScriptSearchListener;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;

public class ActionPanel
extends JPanel
implements SearchListener<ScriptSearchResult>,
TagEditorPanel {
    private static final Logger logger = Logger.getLogger(ActionPanel.class.getName());
    private JPanel brokenHintPanel;
    private MainPanel mainPanel;
    public DebuggableEditorPane editor;
    public DebuggableEditorPane decompiledEditor;
    public JPersistentSplitPane splitPane;
    public JButton saveButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    public JButton editButton = new JButton(AppStrings.translate("button.edit.script.disassembled"), View.getIcon("edit16"));
    public JButton cancelButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    public JButton editDecompiledButton = new JButton(AppStrings.translate("button.edit.script.decompiled"), View.getIcon("edit16"));
    public JButton saveDecompiledButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    public JButton cancelDecompiledButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    public JToggleButton hexButton;
    public JToggleButton hexOnlyButton;
    public JToggleButton constantsViewButton;
    public JToggleButton resolveConstantsButton;
    public JToggleButton showFileOffsetInPcodeHexButton;
    public JToggleButton showOriginalBytesInPcodeHexButton;
    public JLabel asmLabel = new HeaderLabel(AppStrings.translate("panel.disassembled"));
    public JLabel decLabel = new HeaderLabel(AppStrings.translate("panel.decompiled"));
    private boolean ignoreCarret = false;
    private boolean editMode = false;
    private boolean editDecompiledMode = false;
    private ActionList lastCode;
    private ASMSource src;
    public JPanel topButtonsPan;
    private HighlightedText srcWithHex;
    private HighlightedText srcNoHex;
    private HighlightedText srcHexOnly;
    private HighlightedText srcConstants;
    private HighlightedText disassembledText = HighlightedText.EMPTY;
    private HighlightedText lastDecompiled = HighlightedText.EMPTY;
    private ASMSource lastASM;
    public SearchPanel<ScriptSearchResult> searchPanel;
    private CancellableWorker setSourceWorker;
    private List<Runnable> scriptListeners = new ArrayList<Runnable>();

    public void addScriptListener(Runnable listener) {
        this.scriptListeners.add(listener);
    }

    public void removeScriptListener(Runnable listener) {
        this.scriptListeners.remove(listener);
    }

    private void fireScript() {
        ArrayList<Runnable> list = new ArrayList<Runnable>(this.scriptListeners);
        for (Runnable r : list) {
            r.run();
        }
    }

    public void clearSource() {
        View.checkAccess();
        this.lastCode = null;
        this.lastASM = null;
        this.lastDecompiled = HighlightedText.EMPTY;
        this.searchPanel.clear();
        this.src = null;
        this.srcWithHex = null;
        this.srcNoHex = null;
        this.srcHexOnly = null;
        this.srcConstants = null;
    }

    public String getStringUnderCursor() {
        View.checkAccess();
        int pos = this.decompiledEditor.getCaretPosition();
        return this.getStringUnderPosition(pos, this.decompiledEditor);
    }

    public String getStringUnderPosition(int pos, JTextComponent component) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument((JTextComponent)component);
        if (sDoc != null) {
            Token t = sDoc.getTokenAt(pos + 1);
            String ident = null;
            if (t != null && (t.type == TokenType.IDENTIFIER || t.type == TokenType.REGEX)) {
                CharSequence tData = t.getText((Document)sDoc);
                ident = tData.toString();
                ActionScriptLexer lex = new ActionScriptLexer((Reader)new StringReader(ident));
                try {
                    ParsedSymbol symb = lex.lex();
                    ident = symb.type == SymbolType.IDENTIFIER ? (String)symb.value : null;
                }
                catch (ActionParseException | IOException ex) {
                    ident = null;
                }
            }
            if (ident == null) {
                Highlighting h = Highlighting.searchPos((List)this.lastDecompiled.getInstructionHighlights(), (long)pos);
                if (h != null) {
                    ActionList list = this.lastCode;
                    Action lastIns = null;
                    int inspos = 0;
                    Action selIns = null;
                    for (Action ins : list) {
                        if (h.getProperties().offset == ins.getAddress()) {
                            selIns = ins;
                            break;
                        }
                        if (ins.getAddress() > h.getProperties().offset && lastIns != null) {
                            inspos = (int)(h.getProperties().offset - lastIns.getAddress());
                            selIns = lastIns;
                            break;
                        }
                        lastIns = ins;
                    }
                    if (selIns != null && selIns instanceof ActionPush) {
                        ActionPush ap = (ActionPush)selIns;
                        Object var = ap.values.get(inspos - 1);
                        String identifier = null;
                        if (var instanceof String) {
                            identifier = (String)var;
                        }
                        if (var instanceof ConstantIndex) {
                            identifier = (String)ap.constantPool.get(((ConstantIndex)var).index);
                        }
                        return identifier;
                    }
                }
            } else {
                return ident;
            }
        }
        return null;
    }

    public List<ActionSearchResult> search(SWF swf, final String txt, boolean ignoreCase, boolean regexp, boolean pcode, final CancellableWorker<Void> worker, Map<String, ASMSource> scope) {
        if (txt != null && !txt.isEmpty()) {
            this.searchPanel.setOptions(ignoreCase, regexp);
            final String workText = AppStrings.translate("work.searching");
            final String decAdd = AppStrings.translate("work.decompiling");
            return new ActionScriptSearch().searchAs2(swf, txt, ignoreCase, regexp, pcode, new ScriptSearchListener(){

                public void onDecompile(int pos, int total, String name) {
                    Main.startWork(workText + " \"" + txt + "\", " + decAdd + " - (" + pos + "/" + total + ") " + name + "... ", worker);
                }

                public void onSearch(int pos, int total, String name) {
                    Main.startWork(workText + " \"" + txt + "\" - (" + pos + "/" + total + ") " + name + "... ", worker);
                }
            }, scope);
        }
        return null;
    }

    private void setDecompiledText(String scriptName, String text) {
        View.checkAccess();
        this.ignoreCarret = true;
        this.decompiledEditor.setScriptName(scriptName);
        this.decompiledEditor.setText(text);
        BrokenScriptDetector det = new BrokenScriptDetector();
        if (det.codeIsBroken(text)) {
            this.brokenHintPanel.setVisible(true);
        } else {
            this.brokenHintPanel.setVisible(false);
        }
        this.ignoreCarret = false;
    }

    private void setEditorText(String scriptName, String text, String contentType) {
        View.checkAccess();
        this.ignoreCarret = true;
        this.editor.setScriptName("#PCODE " + scriptName);
        this.editor.changeContentType(contentType);
        this.editor.setText(text);
        this.ignoreCarret = false;
    }

    private void setText(HighlightedText text, String contentType, String scriptName) {
        Highlighting h2;
        View.checkAccess();
        int pos = this.editor.getCaretPosition();
        Highlighting lastH = null;
        for (Highlighting h2 : this.disassembledText.getInstructionHighlights()) {
            if (pos < h2.startPos) break;
            lastH = h2;
        }
        Long offset = lastH == null ? 0L : lastH.getProperties().offset;
        this.disassembledText = text;
        this.setEditorText(scriptName, text.text, contentType);
        h2 = Highlighting.searchOffset((List)this.disassembledText.getInstructionHighlights(), (long)offset);
        if (h2 != null && h2.startPos <= this.editor.getDocument().getLength()) {
            this.editor.setCaretPosition(h2.startPos);
        }
    }

    private HighlightedText getHighlightedText(ScriptExportMode exportMode, ActionList actions) {
        if (actions == null) {
            logger.log(Level.WARNING, "Action list is null");
            return HighlightedText.EMPTY;
        }
        ASMSource asm = this.src;
        DisassemblyListener listener = this.getDisassemblyListener();
        asm.addDisassemblyListener(listener);
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        try {
            asm.getASMSource(exportMode, (GraphTextWriter)writer, actions);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        asm.removeDisassemblyListener(listener);
        return new HighlightedText(writer);
    }

    private void updateHexButtons(ScriptExportMode exportMode) {
        View.checkAccess();
        this.showFileOffsetInPcodeHexButton.setVisible(exportMode == ScriptExportMode.PCODE_HEX);
        this.showOriginalBytesInPcodeHexButton.setVisible(exportMode == ScriptExportMode.PCODE_HEX);
        this.resolveConstantsButton.setVisible(exportMode != ScriptExportMode.CONSTANTS && exportMode != ScriptExportMode.HEX);
    }

    private void setHex(ScriptExportMode exportMode, String scriptName, ActionList actions) {
        View.checkAccess();
        this.updateHexButtons(exportMode);
        switch (exportMode) {
            case PCODE: {
                if (this.srcNoHex == null) {
                    this.srcNoHex = this.getHighlightedText(exportMode, actions);
                }
                this.setText(this.srcNoHex, "text/flasm", scriptName);
                break;
            }
            case PCODE_HEX: {
                if (this.srcWithHex == null) {
                    this.srcWithHex = this.getHighlightedText(exportMode, actions);
                }
                this.setText(this.srcWithHex, "text/flasm", scriptName);
                break;
            }
            case HEX: {
                if (this.srcHexOnly == null) {
                    HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
                    Helper.byteArrayToHexWithHeader((GraphTextWriter)writer, (byte[])this.src.getActionBytes().getRangeData());
                    this.srcHexOnly = new HighlightedText(writer);
                }
                this.setText(this.srcHexOnly, "text/plain", scriptName);
                break;
            }
            case CONSTANTS: {
                if (this.srcConstants == null) {
                    this.srcConstants = this.getHighlightedText(exportMode, actions);
                }
                this.setText(this.srcConstants, "text/plain", scriptName);
                break;
            }
            default: {
                throw new Error("Export mode not supported: " + exportMode);
            }
        }
    }

    private DisassemblyListener getDisassemblyListener() {
        DisassemblyListener listener = new DisassemblyListener(){
            int percent = 0;
            String phase = "";

            private void progress(String phase, long pos, long total) {
                if (total < 1L) {
                    return;
                }
                int newpercent = (int)(pos * 100L / total);
                if (!(newpercent <= this.percent && this.phase.equals(phase) || newpercent > 100)) {
                    this.percent = newpercent;
                    this.phase = phase;
                    View.execInEventDispatch(() -> ActionPanel.this.setEditorText("-", "; " + AppStrings.translate("work.disassembling") + " - " + phase + " " + this.percent + "%...", "text/flasm"));
                }
            }

            public void progressReading(long pos, long total) {
                this.progress(AppStrings.translate("disassemblingProgress.reading"), pos, total);
            }

            public void progressToString(long pos, long total) {
                this.progress(AppStrings.translate("disassemblingProgress.toString"), pos, total);
            }

            public void progressDeobfuscating(long pos, long total) {
                this.progress(AppStrings.translate("disassemblingProgress.deobfuscating"), pos, total);
            }
        };
        return listener;
    }

    public void setSource(ASMSource src, boolean useCache) {
        boolean decompileNeeded;
        boolean decompile;
        View.checkAccess();
        if (this.setSourceWorker != null) {
            this.setSourceWorker.cancel(true);
            this.setSourceWorker = null;
        }
        this.clearSource();
        this.src = src;
        final ASMSource asm = src;
        if (!useCache) {
            SWF.uncache((ASMSource)asm);
        }
        HighlightedText decompiledText = !(decompile = ((Boolean)Configuration.decompile.get()).booleanValue()) ? new HighlightedText(Helper.getDecompilationSkippedComment()) : SWF.getFromCache((ASMSource)asm);
        this.setDecompiledEditMode(false);
        this.setEditMode(false);
        final ActionList actions = SWF.getActionListFromCache((ASMSource)asm);
        final boolean disassemblingNeeded = actions == null;
        boolean bl = decompileNeeded = decompiledText == null;
        if (disassemblingNeeded || decompileNeeded) {
            CancellableWorker worker = new CancellableWorker(){

                protected Void doInBackground() throws Exception {
                    ActionList innerActions = actions;
                    if (disassemblingNeeded) {
                        View.execInEventDispatch(() -> {
                            ActionPanel.this.setEditorText(asm.getScriptName(), "; " + AppStrings.translate("work.disassembling") + "...", "text/flasm");
                            if (decompileNeeded) {
                                ActionPanel.this.setDecompiledText("-", "// " + AppStrings.translate("work.waitingfordissasembly") + "...");
                            }
                        });
                        DisassemblyListener listener = ActionPanel.this.getDisassemblyListener();
                        asm.addDisassemblyListener(listener);
                        innerActions = asm.getActions();
                        asm.removeDisassemblyListener(listener);
                    }
                    if (decompileNeeded) {
                        View.execInEventDispatch(() -> ActionPanel.this.setDecompiledText("-", "// " + AppStrings.translate("work.decompiling") + "..."));
                        HighlightedText htext = SWF.getCached((ASMSource)asm, (ActionList)innerActions);
                        ActionList finalActions = innerActions;
                        View.execInEventDispatch(() -> ActionPanel.this.setSourceCompleted(asm, htext, finalActions));
                    }
                    return null;
                }

                protected void done() {
                    View.execInEventDispatch(() -> {
                        ActionPanel.this.setSourceWorker = null;
                        if (!Main.isDebugging()) {
                            Main.stopWork();
                        }
                        try {
                            this.get();
                        }
                        catch (CancellationException ex) {
                            ActionPanel.this.setEditorText("-", "; " + AppStrings.translate("work.canceled"), "text/flasm");
                        }
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Error", ex);
                            ActionPanel.this.setDecompiledText("-", "// " + AppStrings.translate("decompilationError") + ": " + ex);
                        }
                    });
                }
            };
            worker.execute();
            this.setSourceWorker = worker;
            if (!Main.isDebugging()) {
                Main.startWork(AppStrings.translate("work.decompiling") + "...", worker);
            }
        } else {
            this.setSourceCompleted(asm, decompiledText, actions);
        }
    }

    private void setSourceCompleted(ASMSource asm, HighlightedText decompiledText, ActionList actions) {
        View.checkAccess();
        if (decompiledText == null) {
            decompiledText = HighlightedText.EMPTY;
        }
        this.lastASM = asm;
        this.lastCode = actions;
        this.lastDecompiled = decompiledText;
        this.setHex(this.getExportMode(), asm.getScriptName(), actions);
        this.setDecompiledText(asm.getScriptName(), decompiledText.text);
        this.fireScript();
    }

    public void hilightOffset(long offset) {
        View.checkAccess();
    }

    public int getLocalDeclarationOfPos(int pos) {
        View.checkAccess();
        Highlighting sh = Highlighting.searchPos((List)this.lastDecompiled.getSpecialHighlights(), (long)pos);
        Highlighting h = Highlighting.searchPos((List)this.lastDecompiled.getInstructionHighlights(), (long)pos);
        if (h == null) {
            return -1;
        }
        List tms = Highlighting.searchAllPos((List)this.lastDecompiled.getMethodHighlights(), (long)pos);
        if (tms.isEmpty()) {
            return -1;
        }
        for (Highlighting tm : tms) {
            List tm_tms = Highlighting.searchAllLocalNames((List)this.lastDecompiled.getMethodHighlights(), (String)tm.getProperties().localName);
            if (h.getProperties().declaration || sh != null && sh.getProperties().declaration) {
                return -1;
            }
            String lname = h.getProperties().localName;
            if ("this".equals(lname)) {
                Highlighting ch = Highlighting.searchPos((List)this.lastDecompiled.getClassHighlights(), (long)pos);
                return ch.startPos;
            }
            HighlightData hData = h.getProperties();
            HighlightData search = new HighlightData();
            search.declaration = hData.declaration;
            search.localName = hData.localName;
            if (search.isEmpty()) {
                return -1;
            }
            search.declaration = true;
            for (Highlighting tm1 : tm_tms) {
                Highlighting rh = Highlighting.search((List)this.lastDecompiled.getInstructionHighlights(), (HighlightData)search, (long)tm1.startPos, (long)(tm1.startPos + tm1.len));
                if (rh == null) continue;
                return rh.startPos;
            }
        }
        return -1;
    }

    public ActionPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.editor = new DebuggableEditorPane();
        this.editor.setEditable(false);
        this.decompiledEditor = new DebuggableEditorPane();
        this.decompiledEditor.setEditable(false);
        this.decompiledEditor.setLinkHandler(new LinkHandler(){

            @Override
            public boolean isLink(Token token) {
                int pos = token.start;
                Highlighting h = Highlighting.searchPos((List)ActionPanel.this.lastDecompiled.getInstructionHighlights(), (long)pos);
                if (h != null && h.getProperties().localName != null && !h.getProperties().declaration) {
                    return ActionPanel.this.getLocalDeclarationOfPos(pos) != -1;
                }
                return false;
            }

            @Override
            public void handleLink(Token token) {
                int pos = token.start;
                int tpos = ActionPanel.this.getLocalDeclarationOfPos(pos);
                if (tpos > -1) {
                    ActionPanel.this.decompiledEditor.setCaretPosition(tpos);
                }
            }

            @Override
            public Highlighter.HighlightPainter linkPainter() {
                return ActionPanel.this.decompiledEditor.linkPainter();
            }
        });
        this.searchPanel = new SearchPanel<ScriptSearchResult>((LayoutManager)new FlowLayout(), this);
        JButton graphButton = new JButton(View.getIcon("graph16"));
        graphButton.addActionListener(this::graphButtonActionPerformed);
        graphButton.setToolTipText(AppStrings.translate("button.viewgraph"));
        graphButton.setMargin(new Insets(3, 3, 3, 3));
        this.hexButton = new JToggleButton(View.getIcon("hexas16"));
        this.hexButton.addActionListener(this::hexButtonActionPerformed);
        this.hexButton.setToolTipText(AppStrings.translate("button.viewhexpcode"));
        this.hexButton.setMargin(new Insets(3, 3, 3, 3));
        this.hexOnlyButton = new JToggleButton(View.getIcon("hex16"));
        this.hexOnlyButton.addActionListener(this::hexOnlyButtonActionPerformed);
        this.hexOnlyButton.setToolTipText(AppStrings.translate("button.viewhex"));
        this.hexOnlyButton.setMargin(new Insets(3, 3, 3, 3));
        this.constantsViewButton = new JToggleButton(View.getIcon("constantpool16"));
        this.constantsViewButton.addActionListener(this::constantsViewButtonActionPerformed);
        this.constantsViewButton.setToolTipText(AppStrings.translate("button.viewConstants"));
        this.constantsViewButton.setMargin(new Insets(3, 3, 3, 3));
        NoneSelectedButtonGroup exportModeButtonGroup = new NoneSelectedButtonGroup();
        exportModeButtonGroup.add(this.hexButton);
        exportModeButtonGroup.add(this.hexOnlyButton);
        exportModeButtonGroup.add(this.constantsViewButton);
        this.resolveConstantsButton = new JToggleButton(View.getIcon("resolveconst16"));
        this.resolveConstantsButton.addActionListener(this::resolveConstantsButtonActionPerformed);
        this.resolveConstantsButton.setToolTipText(AppStrings.translate("button.resolveConstants"));
        this.resolveConstantsButton.setMargin(new Insets(3, 3, 3, 3));
        this.resolveConstantsButton.setSelected((Boolean)Configuration.resolveConstants.get());
        this.showFileOffsetInPcodeHexButton = new JToggleButton(View.getIcon("fileoffset16"));
        this.showFileOffsetInPcodeHexButton.addActionListener(this::showFileOffsetInPcodeHexButtonActionPerformed);
        this.showFileOffsetInPcodeHexButton.setToolTipText(AppStrings.translate("button.showFileOffsetInPcodeHex"));
        this.showFileOffsetInPcodeHexButton.setMargin(new Insets(3, 3, 3, 3));
        this.showFileOffsetInPcodeHexButton.setSelected((Boolean)Configuration.showFileOffsetInPcodeHex.get());
        this.showOriginalBytesInPcodeHexButton = new JToggleButton(View.getIcon("originalbytes16"));
        this.showOriginalBytesInPcodeHexButton.addActionListener(this::showOriginalBytesInPcodeHexButtonActionPerformed);
        this.showOriginalBytesInPcodeHexButton.setToolTipText(AppStrings.translate("button.showOriginalBytesInPcodeHex"));
        this.showOriginalBytesInPcodeHexButton.setMargin(new Insets(3, 3, 3, 3));
        this.showOriginalBytesInPcodeHexButton.setSelected((Boolean)Configuration.showOriginalBytesInPcodeHex.get());
        this.topButtonsPan = new JPanel();
        this.topButtonsPan.setLayout(new BoxLayout(this.topButtonsPan, 0));
        this.topButtonsPan.add(graphButton);
        this.topButtonsPan.add(Box.createRigidArea(new Dimension(10, 0)));
        this.topButtonsPan.add(this.hexButton);
        this.topButtonsPan.add(this.hexOnlyButton);
        this.topButtonsPan.add(this.constantsViewButton);
        this.topButtonsPan.add(Box.createRigidArea(new Dimension(10, 0)));
        this.topButtonsPan.add(this.resolveConstantsButton);
        this.topButtonsPan.add(Box.createRigidArea(new Dimension(10, 0)));
        this.topButtonsPan.add(this.showFileOffsetInPcodeHexButton);
        this.topButtonsPan.add(this.showOriginalBytesInPcodeHexButton);
        if (this.hexOnlyButton.isSelected()) {
            this.updateHexButtons(ScriptExportMode.HEX);
        } else if (this.constantsViewButton.isSelected()) {
            this.updateHexButtons(ScriptExportMode.CONSTANTS);
        } else {
            this.updateHexButtons(ScriptExportMode.PCODE);
        }
        JPanel panCode = new JPanel(new BorderLayout());
        panCode.add((Component)new FasterScrollPane(this.editor), "Center");
        panCode.add((Component)this.topButtonsPan, "North");
        JPanel panB = new JPanel();
        panB.setLayout(new BorderLayout());
        this.asmLabel.setHorizontalAlignment(0);
        panB.add((Component)this.asmLabel, "North");
        panB.add((Component)panCode, "Center");
        JPanel buttonsPan = new JPanel();
        buttonsPan.setLayout(new FlowLayout());
        buttonsPan.add(this.editButton);
        buttonsPan.add(this.saveButton);
        buttonsPan.add(this.cancelButton);
        this.editButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveButton.setMargin(new Insets(3, 3, 3, 10));
        this.cancelButton.setMargin(new Insets(3, 3, 3, 10));
        final JPanel decButtonsPan = new JPanel(new FlowLayout());
        decButtonsPan.add(this.editDecompiledButton);
        decButtonsPan.add(this.saveDecompiledButton);
        decButtonsPan.add(this.cancelDecompiledButton);
        this.editDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.saveDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        this.cancelDecompiledButton.setMargin(new Insets(3, 3, 3, 10));
        panB.add((Component)buttonsPan, "South");
        this.saveButton.addActionListener(this::saveActionButtonActionPerformed);
        this.editButton.addActionListener(this::editActionButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelActionButtonActionPerformed);
        this.saveButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.saveDecompiledButton.addActionListener(this::saveDecompiledButtonActionPerformed);
        this.editDecompiledButton.addActionListener(this::editDecompiledButtonActionPerformed);
        this.cancelDecompiledButton.addActionListener(this::cancelDecompiledButtonActionPerformed);
        this.saveDecompiledButton.setVisible(false);
        this.cancelDecompiledButton.setVisible(false);
        JPanel panA = new JPanel(new BorderLayout());
        panA.add((Component)this.decLabel, "North");
        DebugPanel debugPanel = new DebugPanel();
        JPanel panelWithHint = new JPanel(new BorderLayout());
        this.brokenHintPanel = new JPanel(new BorderLayout(10, 10));
        this.brokenHintPanel.add((Component)new JLabel("<html>" + AppStrings.translate("script.seemsBroken") + "</html>"), "Center");
        this.brokenHintPanel.setBackground(new Color(253, 205, 137));
        this.brokenHintPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(5, 5, 5, 5)));
        panelWithHint.add((Component)this.brokenHintPanel, "North");
        panelWithHint.add((Component)new FasterScrollPane(this.decompiledEditor), "Center");
        this.brokenHintPanel.setVisible(false);
        panA.add((Component)new JPersistentSplitPane(0, panelWithHint, (Component)debugPanel, (ConfigurationItem<Double>)Configuration.guiActionVarsSplitPaneDividerLocationPercent), "Center");
        panA.add((Component)decButtonsPan, "South");
        Main.getDebugHandler().addConnectionListener(new DebuggerHandler.ConnectionListener(){

            @Override
            public void connected() {
                decButtonsPan.setVisible(false);
            }

            @Override
            public void disconnected() {
                decButtonsPan.setVisible(true);
            }
        });
        debugPanel.setVisible(false);
        this.decLabel.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        this.splitPane = new JPersistentSplitPane(1, panA, (Component)panB, (ConfigurationItem<Double>)Configuration.guiActionSplitPaneDividerLocationPercent);
        this.add((Component)this.splitPane, "Center");
        this.editor.setFont(Configuration.getSourceFont());
        this.decompiledEditor.setFont(Configuration.getSourceFont());
        this.decompiledEditor.changeContentType("text/actionscript");
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (ActionPanel.this.ignoreCarret) {
                    return;
                }
                if (ActionPanel.this.editMode || ActionPanel.this.editDecompiledMode) {
                    return;
                }
                ActionPanel.this.editor.getCaret().setVisible(true);
                int pos = ActionPanel.this.editor.getCaretPosition();
                Highlighting lastH = null;
                for (Highlighting h : ActionPanel.this.disassembledText.getInstructionHighlights()) {
                    if (pos < h.startPos) break;
                    lastH = h;
                }
                Long ofs = lastH == null ? 0L : lastH.getProperties().offset;
                Highlighting h2 = Highlighting.searchOffset((List)ActionPanel.this.lastDecompiled.getInstructionHighlights(), (long)ofs);
                if (h2 != null) {
                    ActionPanel.this.ignoreCarret = true;
                    if (h2.startPos <= ActionPanel.this.decompiledEditor.getDocument().getLength()) {
                        ActionPanel.this.decompiledEditor.setCaretPosition(h2.startPos);
                    }
                    ActionPanel.this.decompiledEditor.getCaret().setVisible(true);
                    ActionPanel.this.ignoreCarret = false;
                }
            }
        });
        this.decompiledEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                Highlighting h2;
                if (ActionPanel.this.ignoreCarret) {
                    return;
                }
                if (ActionPanel.this.editMode || ActionPanel.this.editDecompiledMode) {
                    return;
                }
                ActionPanel.this.decompiledEditor.getCaret().setVisible(true);
                int pos = ActionPanel.this.decompiledEditor.getCaretPosition();
                Highlighting h = Highlighting.searchPos((List)ActionPanel.this.lastDecompiled.getInstructionHighlights(), (long)pos);
                if (h != null && (h2 = Highlighting.searchOffset((List)ActionPanel.this.disassembledText.getInstructionHighlights(), (long)h.getProperties().offset)) != null) {
                    ActionPanel.this.ignoreCarret = true;
                    if (h2.startPos > 0 && h2.startPos < ActionPanel.this.editor.getText().length()) {
                        ActionPanel.this.editor.setCaretPosition(h2.startPos);
                    }
                    ActionPanel.this.editor.getCaret().setVisible(true);
                    ActionPanel.this.ignoreCarret = false;
                }
            }
        });
        this.editor.addTextChangedListener(this::editorTextChanged);
        this.decompiledEditor.addTextChangedListener(this::decompiledEditorTextChanged);
    }

    private void editorTextChanged() {
        this.setModified(true);
    }

    private void decompiledEditorTextChanged() {
        this.setDecompiledModified(true);
    }

    private boolean isModified() {
        View.checkAccess();
        return this.saveButton.isVisible() && this.saveButton.isEnabled();
    }

    private void setModified(boolean value) {
        View.checkAccess();
        this.saveButton.setEnabled(value);
        this.cancelButton.setEnabled(value);
    }

    private boolean isDecompiledModified() {
        View.checkAccess();
        return this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }

    private void setDecompiledModified(boolean value) {
        View.checkAccess();
        this.saveDecompiledButton.setEnabled(value);
        this.cancelDecompiledButton.setEnabled(value);
    }

    public void setEditMode(boolean val) {
        View.checkAccess();
        if (val) {
            if (this.hexOnlyButton.isSelected()) {
                this.setHex(ScriptExportMode.HEX, this.src.getScriptName(), this.lastCode);
            } else if (this.constantsViewButton.isSelected()) {
                this.setHex(ScriptExportMode.CONSTANTS, this.src.getScriptName(), this.lastCode);
            } else {
                this.setHex(ScriptExportMode.PCODE, this.src.getScriptName(), this.lastCode);
            }
        }
        this.editor.setEditable(val);
        this.saveButton.setVisible(val);
        this.saveButton.setEnabled(false);
        this.editButton.setVisible(!val);
        this.cancelButton.setVisible(val);
        this.editor.getCaret().setVisible(true);
        this.asmLabel.setIcon(val ? View.getIcon("editing16") : null);
        this.topButtonsPan.setVisible(!val);
        this.editMode = val;
        if (val) {
            this.editor.requestFocusInWindow();
        }
    }

    public void setDecompiledEditMode(boolean val) {
        View.checkAccess();
        if (this.src != null) {
            if (val) {
                this.setDecompiledText(this.src.getScriptName(), this.lastDecompiled.text);
            } else {
                this.setDecompiledText(this.src.getScriptName(), this.lastDecompiled.text);
            }
        }
        this.decompiledEditor.setEditable(val);
        this.saveDecompiledButton.setVisible(val);
        this.saveDecompiledButton.setEnabled(false);
        this.editDecompiledButton.setVisible(!val);
        this.cancelDecompiledButton.setVisible(val);
        this.decompiledEditor.getCaret().setVisible(true);
        this.decLabel.setIcon(val ? View.getIcon("editing16") : null);
        this.editDecompiledMode = val;
        if (val) {
            this.decompiledEditor.requestFocusInWindow();
        }
    }

    private void graphButtonActionPerformed(ActionEvent evt) {
        if (this.lastCode != null) {
            try {
                boolean insideDoInitAction = this.src instanceof DoInitActionTag;
                GraphDialog gf = new GraphDialog(this.mainPanel.getMainFrame().getWindow(), (Graph)new ActionGraph(this.src.getScriptName(), insideDoInitAction, false, (List)this.lastCode, new HashMap(), new HashMap(), new HashMap(), 10), "");
                gf.setVisible(true);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void editActionButtonActionPerformed(ActionEvent evt) {
        this.setEditMode(true);
    }

    private void hexButtonActionPerformed(ActionEvent evt) {
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void hexOnlyButtonActionPerformed(ActionEvent evt) {
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void constantsViewButtonActionPerformed(ActionEvent evt) {
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void resolveConstantsButtonActionPerformed(ActionEvent evt) {
        boolean resolve = this.resolveConstantsButton.isSelected();
        Configuration.resolveConstants.set((Object)resolve);
        this.srcWithHex = null;
        this.srcNoHex = null;
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void showFileOffsetInPcodeHexButtonActionPerformed(ActionEvent evt) {
        boolean resolve = this.showFileOffsetInPcodeHexButton.isSelected();
        Configuration.showFileOffsetInPcodeHex.set((Object)resolve);
        this.srcWithHex = null;
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void showOriginalBytesInPcodeHexButtonActionPerformed(ActionEvent evt) {
        boolean resolve = this.showOriginalBytesInPcodeHexButton.isSelected();
        Configuration.showOriginalBytesInPcodeHex.set((Object)resolve);
        this.srcWithHex = null;
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void cancelActionButtonActionPerformed(ActionEvent evt) {
        this.setEditMode(false);
        this.setHex(this.getExportMode(), this.src.getScriptName(), this.lastCode);
    }

    private void saveActionButtonActionPerformed(ActionEvent evt) {
        try {
            String text = this.editor.getText();
            String trimmed = text.trim();
            if (trimmed.startsWith(Helper.hexData)) {
                this.src.setActionBytes(Helper.getBytesFromHexaText((String)text));
            } else if (trimmed.startsWith(Helper.constants)) {
                List constantPools = Helper.getConstantPoolsFromText((String)text);
                try {
                    Action.setConstantPools((ASMSource)this.src, (List)constantPools, (boolean)true);
                }
                catch (ConstantPoolTooBigException ex) {
                    ViewMessages.showMessageDialog(this, AppStrings.translate("error.constantPoolTooBig").replace("%index%", Integer.toString(ex.index)).replace("%size%", Integer.toString(ex.size)), AppStrings.translate("error"), 0);
                }
            } else {
                this.src.setActions((List)ASMParser.parse((long)0L, (boolean)true, (String)text, (int)this.src.getSwf().version, (boolean)false));
            }
            SWF.uncache((ASMSource)this.src);
            this.src.setModified();
            this.setSource(this.src, false);
            ViewMessages.showMessageDialog(this, AppStrings.translate("message.action.saved"), AppStrings.translate("dialog.message.title"), 1, (ConfigurationItem<Boolean>)Configuration.showCodeSavedMessage);
            this.saveButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.editButton.setVisible(true);
            this.editor.setEditable(false);
            this.editMode = false;
            this.mainPanel.refreshTree(this.src.getSwf());
        }
        catch (IOException text) {
        }
        catch (ActionParseException ex) {
            this.editor.gotoLine((int)ex.line);
            this.editor.markError();
            ViewMessages.showMessageDialog(this, AppStrings.translate("error.action.save").replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)), AppStrings.translate("error"), 0);
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void editDecompiledButtonActionPerformed(ActionEvent evt) {
        this.setDecompiledEditMode(true);
    }

    private void cancelDecompiledButtonActionPerformed(ActionEvent evt) {
        this.setDecompiledEditMode(false);
    }

    private void saveDecompiledButtonActionPerformed(ActionEvent evt) {
        try {
            ActionScript2Parser par = new ActionScript2Parser(this.mainPanel.getCurrentSwf(), this.src);
            this.src.setActions(par.actionsFromString(this.decompiledEditor.getText()));
            SWF.uncache((ASMSource)this.src);
            this.src.setModified();
            this.setSource(this.src, false);
            ViewMessages.showMessageDialog(this, AppStrings.translate("message.action.saved"), AppStrings.translate("dialog.message.title"), 1, (ConfigurationItem<Boolean>)Configuration.showCodeSavedMessage);
            this.setDecompiledEditMode(false);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOException during action compiling", ex);
        }
        catch (ActionParseException ex) {
            this.decompiledEditor.gotoLine((int)ex.line);
            this.decompiledEditor.markError();
            ViewMessages.showMessageDialog(this, AppStrings.translate("error.action.save").replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)), AppStrings.translate("error"), 0);
        }
        catch (CompilationException ex) {
            this.decompiledEditor.gotoLine(ex.line);
            this.decompiledEditor.markError();
            ViewMessages.showMessageDialog(this, AppStrings.translate("error.action.save").replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)), AppStrings.translate("error"), 0);
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private ScriptExportMode getExportMode() {
        ScriptExportMode exportMode = this.hexOnlyButton.isSelected() ? ScriptExportMode.HEX : (this.hexButton.isSelected() ? ScriptExportMode.PCODE_HEX : (this.constantsViewButton.isSelected() ? ScriptExportMode.CONSTANTS : ScriptExportMode.PCODE));
        return exportMode;
    }

    @Override
    public void updateSearchPos(String searchedText, boolean ignoreCase, boolean regExp, ScriptSearchResult item) {
        View.checkAccess();
        if (!(item instanceof ActionSearchResult)) {
            return;
        }
        final ActionSearchResult result = (ActionSearchResult)item;
        this.searchPanel.setOptions(ignoreCase, regExp);
        this.searchPanel.setSearchText(searchedText);
        Runnable onScriptComplete = new Runnable(){

            @Override
            public void run() {
                ActionPanel.this.decompiledEditor.setCaretPosition(0);
                if (result.isPcode()) {
                    ActionPanel.this.searchPanel.showQuickFindDialog(ActionPanel.this.editor);
                } else {
                    ActionPanel.this.searchPanel.showQuickFindDialog(ActionPanel.this.decompiledEditor);
                }
                ActionPanel.this.removeScriptListener(this);
            }
        };
        this.addScriptListener(onScriptComplete);
        TagTreeModel ttm = this.mainPanel.tagTree.getModel();
        TreePath tp = ttm.getTreePath((TreeItem)result.getSrc());
        this.mainPanel.tagTree.setSelectionPath(tp);
        this.mainPanel.tagTree.scrollPathToVisible(tp);
    }

    @Override
    public boolean tryAutoSave() {
        View.checkAccess();
        return false;
    }

    @Override
    public boolean isEditing() {
        View.checkAccess();
        return this.saveButton.isVisible() && this.saveButton.isEnabled() || this.saveDecompiledButton.isVisible() && this.saveDecompiledButton.isEnabled();
    }
}

